
@extends('layout.master')

@section('content')

<div class="main-mobile-header doc-mobile-header">
      <a id="menuLink" href="#" class="menu-link"><i class="ri-menu-line"></i></a>
    </div>

   

    



     <div class="main main-app p-3 p-lg-4">
        
        <div class="mb-4">
          <ol class="breadcrumb fs-sm mb-1">
            <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
            <li class="breadcrumb-item active" aria-current="page">Edit Vehicle</li>
          </ol>
        </div>

      

      <div class="">
        
        <div class="row">

          <div class="col-lg-8">
            <h2 class="main-title">Edit Vehicle</h2>
            
          </div>
          <div style="text-align: right;" class="col-lg-4 text-right">
           <!--  <button type="button" class="btn btn-primary">Add Taxmaster</button> -->
            <!-- <a href="/form" class="btn btn-primary">Add Taxmaster</a>
 -->
          </div>

        </div>

        <hr class="main-separator">        
    
            
       <div class="card card-shadow-apply">
    <div class="card-body">
        <form action="{{ route('vehicle.update') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <input type="hidden" name="id" value="{{ $vehicle->id }}">
            <div class="row">
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Vehicle ID</label>
                        <input type="text" name="vehicle_id" class="form-control" value="{{ $vehicle->vehicle_id }}" readonly />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Make</label>
                        <span class="required-field">*</span>
                        <!--<input type="text" name="make" class="form-control" value="{{ $vehicle->make }}" required />-->
                        
                        <select class="form-select" name="make" required>
                            <option vlaue="">Select</option>
                            @foreach ($vehicle_brand as $key => $service)
                              <option {{ $vehicle->make === $service->name ? 'selected' : '' }}>{{ $service->name }}</option>
                             @endforeach
                        </select>
                        
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Model</label>
                        <input type="text" name="model" class="form-control" value="{{ $vehicle->model }}" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Year</label>
                        <select name="year" class="form-select">
                          @for ($year = 2010; $year <= 2023; $year++)
                             <option value="{{ $year }}" {{ $vehicle->year === $service->name ? 'selected' : '' }}>{{ $year }}</option>
                          @endfor
                        </select>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">VIN Number</label>
                        <input type="text" name="vin_number" class="form-control" value="{{ $vehicle->vin_number }}" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Registration Number</label>
                        <input type="text" name="registration_number" class="form-control" value="{{ $vehicle->registration_number }}" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Title Status</label>
                        <input type="text" name="title_status" class="form-control" value="{{ $vehicle->title_status }}" />
                    </div>
                </div>
                <div class="col-lg-4">
    <div class="mb-3">
        <label class="form-label">Fuel Type</label>
        <select name="fuel_type" class="form-select">
            <option value="Gasoline" {{ $vehicle->fuel_type === 'Gasoline' ? 'selected' : '' }}>Gasoline (Petrol)</option>
            <option value="Diesel" {{ $vehicle->fuel_type === 'Diesel' ? 'selected' : '' }}>Diesel</option>
            <option value="NaturalGas" {{ $vehicle->fuel_type === 'NaturalGas' ? 'selected' : '' }}>Natural Gas</option>
            <option value="Propane" {{ $vehicle->fuel_type === 'Propane' ? 'selected' : '' }}>Propane</option>
            <option value="Electric" {{ $vehicle->fuel_type === 'Electric' ? 'selected' : '' }}>Electric</option>
            <option value="Hybrid" {{ $vehicle->fuel_type === 'Hybrid' ? 'selected' : '' }}>Hybrid (Gasoline-Electric)</option>
            <option value="Hydrogen" {{ $vehicle->fuel_type === 'Hydrogen' ? 'selected' : '' }}>Hydrogen</option>
            <option value="Biodiesel" {{ $vehicle->fuel_type === 'Biodiesel' ? 'selected' : '' }}>Biodiesel</option>
            <option value="E85" {{ $vehicle->fuel_type === 'E85' ? 'selected' : '' }}>E85 (Ethanol)</option>
            <option value="FlexFuel" {{ $vehicle->fuel_type === 'FlexFuel' ? 'selected' : '' }}>Flex Fuel (FFV - Flexible Fuel Vehicle)</option>
        </select>
    </div>
</div>

                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Engine Type</label>
                        <input type="text" name="engine_type" class="form-control" value="{{ $vehicle->engine_type }}" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Transmission Type</label>
                        <input type="text" name="transmission_type" class="form-control" value="{{ $vehicle->transmission_type }}" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Color</label>
                        <input type="text" name="color" class="form-control" value="{{ $vehicle->color }}" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Mileage</label>
                        <input type="number" name="mileage" class="form-control" value="{{ $vehicle->mileage }}" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Purchase Date</label>
                        <input type="date" name="purchase_date" class="form-control" value="{{ $vehicle->purchase_date }}" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Purchase Price</label>
                        <input type="number" name="purchase_price" class="form-control" step="0.01" value="{{ $vehicle->purchase_price }}" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Owner Name</label>
                        <input type="text" name="owner_name" class="form-control" value="{{ $vehicle->owner_name }}" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Owner Contact</label>
                        <input type="text" name="owner_contact" class="form-control" value="{{ $vehicle->owner_contact }}" />
                    </div>
                </div>
                
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">GPS Device ID</label>
                        <input type="text" name="gps_device_id" class="form-control" value="{{ $vehicle->gps_device_id }}" />
                    </div>
                </div>
                
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Vehicle Type</label>
                        <span class="required-field">*</span>
                          <select class="form-select" name="vehicle_type" required>
                            <option vlaue="">Select</option>
                            @foreach ($vehicle_type as $key => $service)
                              <option {{ $vehicle->vehicle_type === $service->name ? 'selected' : '' }}>{{ $service->name }}</option>
                             @endforeach
                        </select>
                        <!--<input type="text" name="vehicle_type" class="form-control" value="{{ $vehicle->vehicle_type }}" />-->
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Vehicle Class</label>
                        <input type="text" name="vehicle_class" class="form-control" value="{{ $vehicle->vehicle_class }}" />
                    </div>
                </div>
                <!--<div class="col-sm-4">-->
                <!--    <div class="mb-3">-->
                <!--        <label class="form-label">License Renewal Date</label>-->
                <!--        <input type="date" name="license_renewal_date" class="form-control" value="{{ $vehicle->license_renewal_date }}" required />-->
                <!--    </div>-->
                <!--</div>-->
                <!--<div class="col-sm-4">-->
                <!--    <div class="mb-3">-->
                <!--        <label class="form-label">Emissions Testing Date</label>-->
                <!--        <input type="date" name="emissions_testing_date" class="form-control" value="{{ $vehicle->emissions_testing_date }}" required />-->
                <!--    </div>-->
                <!--</div>-->
                <!--<div class="col-sm-4">-->
                <!--    <div class="mb-3">-->
                <!--        <label class="form-label">Emissions Compliance</label>-->
                <!--        <input type="text" name="emissions_compliance" class="form-control" value="{{ $vehicle->emissions_compliance }}" required />-->
                <!--    </div>-->
                <!--</div>-->
                
                <div class="col-sm-12">
                    <div class="mb-3">
                        <label class="form-label">Notes/Comments</label>
                        <textarea name="notes_comments" class="form-control" rows="3">{{ $vehicle->notes_comments }}</textarea>
                    </div>
                </div>
            </div>
            <div class="buttons-alignment mt-4">
                <div>
                    <button type="submit" class="btn btn-primary submit-button-alignment">Update</button>
                </div>
            </div>
        </form>
    </div>
</div>











        <br><br><br>

        

      </div><!-- container -->

     
    <style>
    tbody tr:hover {background-color: #F5F5F5;}
    .card-example>.card-body::before {
    content: ""
    }
    </style>


<script>

</script>


<script>
    $(document).ready(function() {
        $("#tour_package").validate({
            rules: {
                package_name: {
                    required: true,
                    maxlength: 20,
                },
                destination: {
                    required: true,
                    maxlength: 20,
                },
                days: {
                    required: true,
                    maxlength: 20,
                },
                hotel_type: {
                    required: true,
                    maxlength: 20,
                },
                meal: {
                    required: true,
                    maxlength: 20,
                },
                currency: {
                    required: true,
                    maxlength: 20,
                },
                price_per_person: {
                    required: true,
                    maxlength: 20,
                },
            },
            messages: {
                package_name: {
                    required: "Package Name is required",
                    maxlength: "Package Name cannot be more than 20 characters"
                },

                destination: {
                    required: "Destination  is required",
                    maxlength: "Destination  cannot be more than 20 characters",
                },

                days: {
                    required: "Day is required",
                    maxlength: "Day cannot be more than 20 characters",
                },

                hotel_type: {
                    required: "Hotel is required",
                    maxlength: "Hotel cannot be more than 20 characters",
                },

                meal: {
                    required: "Meal Price is required",
                    maxlength: "Meal Price cannot be more than 20 characters",
                },

                currency: {
                    required: "Currency is required",
                    maxlength: "Currency cannot be more than 20 characters",
                },

                price_per_person: {
                    required: "Price is required",
                    maxlength: "Price cannot be more than 20 characters",
                },

            }
        });
    });

    $('.select2').select2();
</script>

@endsection

