
@extends('layout.master')

@section('content')

<div class="main-mobile-header doc-mobile-header">
      <a id="menuLink" href="#" class="menu-link"><i class="ri-menu-line"></i></a>
    </div>

   

    



     <div class="main main-app p-3 p-lg-4">
     	
        <div class="mb-4">
          <ol class="breadcrumb fs-sm mb-1">
            <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
            <li class="breadcrumb-item active" aria-current="page">Install Tyre</li>
          </ol>
        </div>

      

      <div class="">
        
        <div class="row">

          <div class="col-lg-8">
            <h2 class="main-title">Install Tyre to {{ $position }} Position</h2>
            
          </div>
          <div style="text-align: right;" class="col-lg-4 text-right">
           <!--  <button type="button" class="btn btn-primary">Add Taxmaster</button> -->
            <!-- <a href="/form" class="btn btn-primary">Add Taxmaster</a> -->
          </div>

        </div>

        <hr class="main-separator">        
    
            
 <div class="card card-shadow-apply">
    <div class="card-body">
        <form action="{{ route('vehicle.install_tyre') }}" method="POST" enctype="multipart/form-data">
            @csrf
            
            <input type="hidden" name="vehicle_id" value="{{ $id }}">
            <input type="hidden" name="tire_position" value="{{ $position }}">
            <div class="row">
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Tire ID</label>
                        <select class="form-select select_tyre" name="tire_id" required>
                            <option value="">Select</option>
                            @foreach($tyres as $data)
                            <option>{{ $data->tire_id }}</option>
                            @endforeach
                        </select>
                        <!--<input type="text" name="tire_id" class="form-control" required />-->
                    </div>
                </div>

               
            </div>
            <div class="buttons-alignment mt-4">
                <div>
                    <button type="submit" class="btn btn-primary submit-button-alignment">Submit</button>
                </div>
            </div>
        </form>
        
<div style="margin-top: 20px;" id="data">
            <div class="row">
    <div class="col-sm-4">
        <div class="mb-3">
            <label class="form-label" for="brand">Brand</label>
            <input type="text" id="brand" name="brand" placeholder="Brand" class="form-control" readonly />
        </div>
    </div>
    <div class="col-sm-4">
        <div class="mb-3">
            <label class="form-label" for="model">Model</label>
            <input type="text" id="model" name="model" placeholder="Model" class="form-control" readonly />
        </div>
    </div>
    <div class="col-sm-4">
        <div class="mb-3">
            <label class="form-label" for="size">Size</label>
            <input type="text" id="size" name="size" placeholder="Size" class="form-control" readonly />
        </div>
    </div>
    <div class="col-sm-4">
        <div class="mb-3">
            <label class="form-label" for="purchase_date">Purchase Date</label>
            <input type="date" id="purchase_date" name="purchase_date" class="form-control" readonly />
        </div>
    </div>
    <div class="col-sm-4">
        <div class="mb-3">
            <label class="form-label" for="purchase_cost">Purchase Cost</label>
            <input type="number" id="purchase_cost" name="purchase_cost" placeholder="Purchase Cost" class="form-control" step="0.01" readonly />
        </div>
    </div>
    
    <div class="col-sm-4">
        <div class="mb-3">
            <label class="form-label" for="load_rating">Load Rating</label>
            <input type="text" id="load_rating" name="load_rating" placeholder="Load Rating" class="form-control" readonly />
        </div>
    </div>
    <div class="col-sm-4">
        <div class="mb-3">
            <label class="form-label" for="speed_rating">Speed Rating</label>
            <input type="text" id="speed_rating" name="speed_rating" placeholder="Speed Rating" class="form-control" readonly />
        </div>
    </div>
    <!--<div class="col-sm-4">-->
    <!--    <div class="mb-3">-->
    <!--        <label class="form-label" for="dot_number">DOT Number</label>-->
    <!--        <input type="text" id="dot_number" name="dot_number" placeholder="DOT Number" class="form-control" readonly />-->
    <!--    </div>-->
    <!--</div>-->
    
    <div class="col-sm-4">
        <div class="mb-3">
            <label class="form-label" for="warranty_type">Warranty Type</label>
            <input type="text" id="warranty_type" name="warranty_type" placeholder="Warranty Type" class="form-control" />
        </div>
    </div>
    <div class="col-sm-4">
        <div class="mb-3">
            <label class="form-label" for="warranty_start_date">Warranty Start Date</label>
            <input type="date" id="warranty_start_date" name="warranty_start_date" class="form-control" />
        </div>
    </div>
    <div class="col-sm-4">
        <div class="mb-3">
            <label class="form-label" for="warranty_end_date">Warranty End Date</label>
            <input type="date" id="warranty_end_date" name="warranty_end_date" class="form-control" />
        </div>
    </div>
    
    <div class="col-sm-4">
        <div class="mb-3">
            <label class="form-label" for="commercial_name">Commercial Name</label>
            <input type="text" id="commercial_name" name="commercial_name" placeholder="Commercial Name" class="form-control" />
        </div>
    </div>
    <div class="col-sm-4">
        <div class="mb-3">
            <label class="form-label" for="identity">Identity</label>
            <input type="text" id="identity" name="identity" placeholder="Identity" class="form-control" />
        </div>
    </div>
    <div class="col-sm-4">
        <div class="mb-3">
            <label class="form-label" for="load_pressure_information">Load Pressure Information</label>
            <input type="text" id="load_pressure_information" name="load_pressure_information" placeholder="Load Pressure Information" class="form-control" value="" />
        </div>
    </div>
    <div class="col-sm-4">
        <div class="mb-3">
            <label class="form-label" for="indicated_exterior">Indicated Exterior</label>
            <input type="text" id="indicated_exterior" name="indicated_exterior" placeholder="Indicated Exterior" class="form-control" />
        </div>
    </div>
    <div class="col-sm-4">
        <div class="mb-3">
            <label class="form-label" for="type_of_construction">Type of Construction</label>
            <input type="text" id="type_of_construction" name="type_of_construction" placeholder="Type of Construction" class="form-control" />
        </div>
    </div>
    <div class="col-sm-4">
        <div class="mb-3">
            <label class="form-label" for="tyre_sections_width_mm">Tyre Sections Width (mm)</label>
            <input type="number" id="tyre_sections_width_mm" name="tyre_sections_width_mm" placeholder="Tyre Sections Width (mm)" class="form-control" step="0.01" />
        </div>
    </div>
    <div class="col-sm-4">
        <div class="mb-3">
            <label class="form-label" for="section_height_to_section_width_ratio">Section Height to Section Width Ratio</label>
            <input type="number" id="section_height_to_section_width_ratio" name="section_height_to_section_width_ratio" placeholder="Section Height to Section Width Ratio" class="form-control" step="0.01" />
        </div>
    </div>
    <div class="col-sm-4">
        <div class="mb-3">
            <label class="form-label" for="rim_diameter_inches">Rim Diameter (inches)</label>
            <input type="number" id="rim_diameter_inches" name="rim_diameter_inches" placeholder="Rim Diameter (inches)" class="form-control" step="0.01" />
        </div>
    </div>
    <div class="col-sm-4">
        <div class="mb-3">
            <label class="form-label" for="load_capacity_index">Load Capacity Index</label>
            <input type="text" id="load_capacity_index" name="load_capacity_index" placeholder="Load Capacity Index" class="form-control" />
        </div>
    </div>
    <div class="col-sm-4">
        <div class="mb-3">
            <label class="form-label" for="tyre_type">Tyre Type</label>
            <select id="tyre_type" name="tyre_type" class="form-control">
                <option value="Tubeless">Tubeless</option>
                <option value="Tube">Tube</option>
            </select>
        </div>
    </div>
    <div class="col-sm-4">
        <div class="mb-3">
            <label class="form-label" for="remarks">Remarks</label>
            <textarea id="remarks" name="remarks" placeholder="Remarks" class="form-control"></textarea>
        </div>
    </div>
</div>

        </div>
    </div>
</div>







        <br><br><br>

        

      </div><!-- container -->

     
    <style>
    tbody tr:hover {background-color: #F5F5F5;}
    .card-example>.card-body::before {
    content: ""
    }
    </style>



<script>
  $(document).ready(function() {
    $(document).on('change', '.select_tyre', function() {
      var tire_id = $(this).val();
    //   alert(tire_id);
        console.log(tire_id)


    var initialData = {!! json_encode($tyres->toArray()) !!};
    console.log(initialData)

   var filteredData = initialData.filter(function(data) {
       return data.tire_id == tire_id;
      });

       console.log(filteredData)
      
$('#data #brand').val(filteredData[0].brand);
$('#data #model').val(filteredData[0].model);
$('#data #size').val(filteredData[0].size);
$('#data #purchase_date').val(filteredData[0].purchase_date);
$('#data #purchase_cost').val(filteredData[0].purchase_cost);
$('#data #installation_date').val(filteredData[0].installation_date);
$('#data #vehicle_id').val(filteredData[0].vehicle_id);
$('#data #position_on_vehicle').val(filteredData[0].position_on_vehicle);
$('#data #temperature').val(filteredData[0].temperature);
$('#data #load_rating').val(filteredData[0].load_rating);
$('#data #speed_rating').val(filteredData[0].speed_rating);
$('#data #dot_number').val(filteredData[0].dot_number);
$('#data #status').val(filteredData[0].status);
$('#data #warranty_provider').val(filteredData[0].warranty_provider);
$('#data #warranty_type').val(filteredData[0].warranty_type);
$('#data #warranty_start_date').val(filteredData[0].warranty_start_date);
$('#data #warranty_end_date').val(filteredData[0].warranty_end_date);
$('#data #notes_comments').val(filteredData[0].notes_comments);
$('#data #barcode_qr_code').val(filteredData[0].barcode_qr_code);
$('#data #commercial_name').val(filteredData[0].commercial_name);
$('#data #identity').val(filteredData[0].identity);
$('#data #load_pressure_information').val(filteredData[0].load_pressure_information);
$('#data #indicated_exterior').val(filteredData[0].indicated_exterior);
$('#data #type_of_construction').val(filteredData[0].type_of_construction);
$('#data #tyre_sections_width_mm').val(filteredData[0].tyre_sections_width_mm);
$('#data #section_height_to_section_width_ratio').val(filteredData[0].section_height_to_section_width_ratio);
$('#data #rim_diameter_inches').val(filteredData[0].rim_diameter_inches);
$('#data #load_capacity_index').val(filteredData[0].load_capacity_index);
$('#data #tyre_type').val(filteredData[0].tyre_type);
$('#data #remarks').val(filteredData[0].remarks);



    });
  });

</script>



@endsection

