
@extends('layout.master')

@section('content')

<div class="main-mobile-header doc-mobile-header">
      <a id="menuLink" href="#" class="menu-link"><i class="ri-menu-line"></i></a>
    </div>

   

    



     <div class="main main-app p-3 p-lg-4">
        
        <div class="mb-4">
          <ol class="breadcrumb fs-sm mb-1">
            <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
            <li class="breadcrumb-item active" aria-current="page">Edit Trailer</li>
          </ol>
        </div>

      

      <div class="">
        
        <div class="row">

          <div class="col-lg-8">
            <h2 class="main-title">Edit Trailer</h2>
            
          </div>
          <div style="text-align: right;" class="col-lg-4 text-right">
           <!--  <button type="button" class="btn btn-primary">Add Taxmaster</button> -->
            <!-- <a href="/form" class="btn btn-primary">Add Taxmaster</a>
 -->
          </div>

        </div>

        <hr class="main-separator">        
    
            
       <div class="card card-shadow-apply">
    <div class="card-body">
        <form action="{{ route('trailer.update') }}" method="POST">
            @csrf
            <input type="hidden" name="id" value="{{ $trailer->id }}">
            
            <div class="row">
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Trailer ID</label>
                        <input type="text" name="trailer_id" placeholder="Trailer ID" class="form-control" value="{{ $trailer->trailer_id }}" readonly />
                    </div>
                </div>
                
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Trailer Type</label>
                        <select class="form-select" name="trailer_type">
                            <option vlaue="">Select</option>
                            @foreach ($trailer_type as $key => $service)
                                      <option {{ $trailer->trailer_type === $service->name ? 'selected' : '' }}>{{ $service->name }}</option>
                             @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Manufacturer</label>
                        <select class="form-select" name="manufacturer">
                            <option vlaue="">Select</option>
                            @foreach ($trailer_brand as $key => $service)
                                      <option {{ $trailer->manufacturer === $service->name ? 'selected' : '' }}>{{ $service->name }}</option>
                             @endforeach
                        </select>
                    </div>
                </div>
                
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Model</label>
                        <span class="required-field">*</span>
                        <input type="text" name="model" placeholder="Model" class="form-control" value="{{ $trailer->model }}" required />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Year</label>
                        <input type="number" name="year" placeholder="Year" class="form-control" value="{{ $trailer->year }}" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">VIN No</label>
                        <input type="text" name="vin_no" class="form-control" value="{{ $trailer->vin_no }}" />
                    </div>
                </div>

                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Registration Number</label>
                        <input type="text" name="registration_number" class="form-control" value="{{ $trailer->registration_number }}" />
                    </div>
                </div>

                <div class="col-lg-4">
                 <div class="mb-3">
                  <label class="form-label">Engine Applicable</label>
                  <select id="engine_applicable" name="engine_applicable" class="form-select select2">
                      <option value="No" {{ $trailer->engine_applicable === 'No' ? 'selected' : '' }}>No</option>
                      <option value="Yes" {{ $trailer->engine_applicable === 'Yes' ? 'selected' : '' }}>Yes</option>
                  </select>
                 </div>
              </div>
                
                <div class="col-lg-4 engine_fields">
    <div class="mb-3">
        <label class="form-label">Fuel Type</label>
        <select name="fuel_type" class="form-select">
            <option value="Gasoline" {{ $trailer->fuel_type === 'Gasoline' ? 'selected' : '' }}>Gasoline (Petrol)</option>
            <option value="Diesel" {{ $trailer->fuel_type === 'Diesel' ? 'selected' : '' }}>Diesel</option>
            <option value="NaturalGas" {{ $trailer->fuel_type === 'NaturalGas' ? 'selected' : '' }}>Natural Gas</option>
            <option value="Propane" {{ $trailer->fuel_type === 'Propane' ? 'selected' : '' }}>Propane</option>
            <option value="Electric" {{ $trailer->fuel_type === 'Electric' ? 'selected' : '' }}>Electric</option>
            <option value="Hybrid" {{ $trailer->fuel_type === 'Hybrid' ? 'selected' : '' }}>Hybrid (Gasoline-Electric)</option>
            <option value="Hydrogen" {{ $trailer->fuel_type === 'Hydrogen' ? 'selected' : '' }}>Hydrogen</option>
            <option value="Biodiesel" {{ $trailer->fuel_type === 'Biodiesel' ? 'selected' : '' }}>Biodiesel</option>
            <option value="E85" {{ $trailer->fuel_type === 'E85' ? 'selected' : '' }}>E85 (Ethanol)</option>
            <option value="FlexFuel" {{ $trailer->fuel_type === 'FlexFuel' ? 'selected' : '' }}>Flex Fuel (FFV - Flexible Fuel Vehicle)</option>
        </select>
    </div>
</div>

                <div class="col-sm-4 engine_fields">
                    <div class="mb-3">
                        <label class="form-label">Engine Type</label>
                        <input type="text" name="engine_type" class="form-control" value="{{ $trailer->engine_type }}" />
                    </div>
                </div>
                <div class="col-sm-4 engine_fields">
                    <div class="mb-3">
                        <label class="form-label">Transmission Type</label>
                        <input type="text" name="transmission_type" class="form-control" value="{{ $trailer->transmission_type }}" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Color</label>
                        <input type="text" name="color" class="form-control" value="{{ $trailer->color }}" />
                    </div>
                </div>
                <div class="col-sm-4 engine_fields">
                    <div class="mb-3">
                        <label class="form-label">Mileage</label>
                        <input type="number" name="mileage" class="form-control" value="{{ $trailer->mileage }}" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Purchase Date</label>
                        <input type="date" name="purchase_date" class="form-control" value="{{ $trailer->purchase_date }}" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Purchase Price</label>
                        <input type="number" name="purchase_price" class="form-control" step="0.01" value="{{ $trailer->purchase_price }}" />
                    </div>
                </div>


                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Length (mm)</label>
                        <input type="number" name="length" placeholder="Length (mm)" class="form-control" value="{{ $trailer->length }}" />
                    </div>
                </div>
            
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Width (mm)</label>
                        <input type="number" name="width" placeholder="Width (mm)" class="form-control" value="{{ $trailer->width }}" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Height (mm)</label>
                        <input type="number" name="height" placeholder="Height (mm)" class="form-control" value="{{ $trailer->height }}" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">GVWR (kg)</label>
                        <input type="number" name="gvwr" placeholder="GVWR (kg)" class="form-control" value="{{ $trailer->gvwr }}" />
                    </div>
                </div>

                <!--<div class="col-sm-4">-->
                <!--    <div class="mb-3">-->
                <!--        <label class="form-label">Axle Configuration</label>-->
                <!--        <input type="text" name="axle_tyre_configuration" placeholder="Axle Configuration" class="form-control" value="{{ $trailer->axle_tyre_configuration }}" />-->
                <!--    </div>-->
                <!--</div>-->
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Tare Weight (kg)</label>
                        <input type="number" name="tare_weight" placeholder="Tare Weight (kg)" class="form-control" value="{{ $trailer->tare_weight }}" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Payload Capacity (kg)</label>
                        <input type="number" name="payload_capacity" placeholder="Payload Capacity (kg)" class="form-control" value="{{ $trailer->payload_capacity }}" />
                    </div>
                </div>
            
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Status</label>
                        <input type="text" name="status" placeholder="Status" class="form-control" value="{{ $trailer->status }}" />
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="mb-3">
                        <label class="form-label">Remarks</label>
                        <textarea name="remarks" placeholder="Remarks" class="form-control" rows="3">{{ $trailer->remarks }}</textarea>
                    </div>
                </div>
            </div>

            <div class="buttons-alignment mt-4">
                <div>
                    <button type="submit" class="btn btn-primary submit-button-alignment">Update</button>
                </div>
            </div>
        </form>
    </div>
</div>












        <br><br><br>

        

      </div><!-- container -->

     
    <style>
    tbody tr:hover {background-color: #F5F5F5;}
    .card-example>.card-body::before {
    content: ""
    }
    </style>


<script>
    function engine_fields(data){
        // alert(data);
        if(data =='No') {
          $(".engine_fields").hide();
        }
        else if(data=='Yes'){
          $(".engine_fields").show();
        }
    }

    var engine= $("#engine_applicable").val();
    engine_fields(engine);

 $(document).ready(function() {
        // Function to be called when the button is clicked
        $("#engine_applicable").change(function() {
            // alert("Button clicked!");
            var engine= $("#engine_applicable").val();
            engine_fields(engine);

        });

    });
</script>


<script>
    $(document).ready(function() {
        $("#tour_package").validate({
            rules: {
                package_name: {
                    required: true,
                    maxlength: 20,
                },
                destination: {
                    required: true,
                    maxlength: 20,
                },
                days: {
                    required: true,
                    maxlength: 20,
                },
                hotel_type: {
                    required: true,
                    maxlength: 20,
                },
                meal: {
                    required: true,
                    maxlength: 20,
                },
                currency: {
                    required: true,
                    maxlength: 20,
                },
                price_per_person: {
                    required: true,
                    maxlength: 20,
                },
            },
            messages: {
                package_name: {
                    required: "Package Name is required",
                    maxlength: "Package Name cannot be more than 20 characters"
                },

                destination: {
                    required: "Destination  is required",
                    maxlength: "Destination  cannot be more than 20 characters",
                },

                days: {
                    required: "Day is required",
                    maxlength: "Day cannot be more than 20 characters",
                },

                hotel_type: {
                    required: "Hotel is required",
                    maxlength: "Hotel cannot be more than 20 characters",
                },

                meal: {
                    required: "Meal Price is required",
                    maxlength: "Meal Price cannot be more than 20 characters",
                },

                currency: {
                    required: "Currency is required",
                    maxlength: "Currency cannot be more than 20 characters",
                },

                price_per_person: {
                    required: "Price is required",
                    maxlength: "Price cannot be more than 20 characters",
                },

            }
        });
    });

    $('.select2').select2();
</script>

@endsection

