@extends('layout.master')

@section('content')

<div class="main-mobile-header doc-mobile-header">
    <a id="menuLink" href="#" class="menu-link"><i class="ri-menu-line"></i></a>
</div>

   

    



     <div class="main main-app p-3 p-lg-4">
     	
        <div class="mb-4">
          <ol class="breadcrumb fs-sm mb-1">
            <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
            <li class="breadcrumb-item active" aria-current="page">View Tour Package</li>
          </ol>
        </div>




      <div class="">
        
        <div class="row">

          <div class="col-lg-8">
          <h3>View Tour Package &nbsp;&nbsp;&nbsp;&nbsp;</h3>

          </div>
          <div style="text-align: right;" class="col-lg-4 text-right">
           <!--  <button type="button" class="btn btn-primary">Add Employee</button> -->
            <!-- <a href="/form" class="btn btn-primary">Add Employee</a>
 -->
          </div>

        </div>

    

<div class="row mt-3">
<form action="{{route('tour_package.update',$tourPack->id)}}" method="POST" id="quickForm" enctype='multipart/form-data'>
                @csrf
                @method('PUT')
            
    <div class="col-md-12 stretch-card">
        <div class="card card-shadow-apply">
            <div class="" style="height:20px;padding:20px;background-color:white;">
                <label class="form-label float-end">
                    Active
                </label>
                <div class="form-check form-switch mb-5 float-end">
                    <input name="status" type="checkbox" class="form-check-input" id="formSwitch1" {{ $tourPack->status == 'Active' ? 'checked' : '' }}>
                </div>
                <label class="form-label float-end">
                    Inactive&nbsp;&nbsp;
                </label>
            </div>
            <div class="card-body">
                <h6 class="card-title" style="font-size:1.2em;font-weight:550;letter-spacing:1px">View
                    Tour Package</h6>
                    
                <div>
    <div class="row">
        <!-- Package Name -->
        <div class="col-sm-6">
            <div class="mb-3">
                <label class="form-label">Package Name
                    <span class="required-field">*</span>
                </label>
                <input type="text" name="package_name" id="package_name" placeholder="Package Name" class="form-control" value="{{$tourPack->package_name}}" disabled>
            </div>
        </div><!-- Col -->

        <!-- Destination -->
        <div class="col-sm-6">
            <div class="mb-3">
                <label class="form-label">Destination
                    <span class="required-field">*</span>
                </label>
                <input type="text" name="destination" id="destination" placeholder="Destination" class="form-control" value="{{$tourPack->destination}}" disabled>
            </div>
        </div><!-- Col -->
    </div><!-- Row -->

    <div class="row">
        <!-- Continent -->
        <div class="col-sm-6">
            <div class="mb-3">
                <label class="form-label">Continent
                    <span class="required-field">*</span>
                </label>
                <select name="continent" id="continent" class="js-example-basic-single form-select select2" disabled>
                    <option value="" selected>Select</option>
                    <option value="Asia" {{$tourPack->continent === 'Asia' ? 'selected' : ''}}>Asia</option>
                </select>
            </div>
        </div>

        <!-- Region -->
        <div class="col-sm-6">
            <div class="mb-3">
                <label class="form-label">Region
                    <span class="required-field">*</span>
                </label>
                <select name="region" id="region" class="js-example-basic-single form-select select2" disabled>
                    <option value="" selected>Select</option>
                    <option value="India" {{$tourPack->region === 'India' ? 'selected' : ''}}>India</option>
                </select>
            </div>
        </div>
    </div><!-- Row -->

    <div class="row">
        <!-- Days -->
        <div class="col-sm-6">
            <div class="mb-3">
                <label class="form-label">Days
                    <span class="required-field">*</span>
                </label>
                <input type="text" name="days" id="days" placeholder="Days" class="form-control" value="{{$tourPack->days}}" disabled>
            </div>
        </div><!-- Col -->

        <!-- Accommodation -->
        <div class="col-sm-6">
            <div class="mb-3">
                <label class="form-label">Accommodation
                    <span class="required-field">*</span>
                </label>
                <input type="text" name="accommodation" id="accommodation" placeholder="Accommodation" class="form-control" value="{{$tourPack->accomodation}}" disabled>
            </div>
        </div>
    </div><!-- Row -->

    <div class="row">
        <!-- Group Size -->
        <div class="col-sm-6">
            <div class="mb-3">
                <label class="form-label">Group Size
                    <span class="required-field">*</span>
                </label>
                <input type="text" name="group_size" id="group_size" placeholder="Group Size" class="form-control" value="{{$tourPack->group_size}}" disabled>
            </div>
        </div><!-- Col -->

        <!-- Meal -->
        <div class="col-sm-6">
            <div class="mb-3">
                <label class="form-label">Meal
                    <span class="required-field">*</span>
                </label>
                <input type="text" name="meal" id="meal" placeholder="Meal" class="form-control" value="{{$tourPack->meal}}" disabled>
            </div>
        </div>
    </div><!-- Row -->

    <div class="row">
        <!-- Price Per Person -->
        <div class="col-sm-6">
            <div class="mb-3">
                <label class="form-label">Price Per Person
                    <span class="required-field">*</span>
                </label>
                <input name="price_per_person" id="price_per_person" placeholder="Price" type="text" class="form-control" value="{{$tourPack->price}}" disabled>
            </div>
        </div><!-- Col -->

        <!-- Discounted Price -->
        <div class="col-sm-6">
            <div class="mb-3">
                <label class="form-label">Discounted Price
                    <span class="required-field">*</span>
                </label>
                <input name="discounted_price" id="discounted_price" placeholder="Discounted Price" type="text" class="form-control" value="{{$tourPack->discounted_price}}" disabled>
            </div>
        </div><!-- Col -->
    </div><!-- Row -->

    <div class="row">
        <!-- Images -->
        <!--<div class="col-sm-6">-->
        <!--    <div class="mb-3">-->
        <!--        <label class="form-label">Images-->
        <!--            <small class="optional-color">(optional)</small>-->
        <!--        </label>-->
        <!--        <input type="file" name="images[]" placeholder="file" class="form-control" multiple>-->
        <!--    </div>-->
        <!--</div>-->
        <!-- Col -->

        <!-- Description -->
        <div class="col-sm-6">
            <div class="mb-3">
                <label class="form-label">Description
                    <small class="optional-color">(optional)</small>
                </label>
                <textarea name="description" class="form-control" disabled>{{$tourPack->description}}</textarea>
            </div>
        </div><!-- Col -->
    </div><!-- Row -->
</div>



                <div class="buttons-alignment mt-4">
                    <!--<button type="submit" class="btn btn-primary submit-button-alignment">Update</button>-->
                </div>
            </form>
            </div>
        </div>

    </div>
</div>


@if ($message = Session::get('success'))
@endif
<br><br>
<h4 class="" style="font-weight:550;letter-spacing:1px">Itinerary List</h4>
<div class=""><br>
    <!--<button type="button" class="btn btn-primary btn-icon-text mb-2 mb-md-0 additinerary" >-->
    <!--    <i class="btn-icon-prepend" data-feather="plus-circle"></i>-->
    <!--    Add Itinerary-->
    <!--</button>-->
</div>

<div class="card card-example">
          <div class="card-body" style="background-color:white;">
            <div class="table-responsive ">
                <div class="active_status">
                    <table id="tableGrid1" class="table table-hover">
                        <thead>
                        <tr>
                            <th>No</th>
                            <th>Day</th>
                            <th>Day Plan</th>
                            <th>Description</th>
                            <th>Action</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach ($itinerary as $key => $itineraryeach)
                                <tr class="fw-bold fs-5">
                                    <td>{{ $key+1 }}</td>
                                    <td>{{ $itineraryeach->day}}</td>
                                    <td>{{ $itineraryeach->day_plan }}</td>
                                    <td>{{ $itineraryeach->description }}</td>
                
                                    <td>
                                        <button value="{{$itineraryeach->id}}" style="padding:0;background-color: transparent;background-repeat: no-repeat;border: none;cursor: pointer;overflow: hidden;outline: none;" class=" btn btn-white viewbtn"><span style="color:#506fd9;"><i style="font-size: 20px;" class="ri-eye-line"></i></span></button>
                                        <button value="{{$itineraryeach->id}}" style="padding:0;background-color: transparent;background-repeat: no-repeat;border: none;cursor: pointer;overflow: hidden;outline: none;" class=" btn btn-white editbtn"><span style="color:#506fd9;"><i style="font-size: 20px;" class="ri-share-box-line"></i></span></button>
                                        <button style="padding:0;background-color: transparent;  background-repeat: no-repeat;  border: none;    cursor: pointer;    overflow: hidden;    outline: none;"  value="/itinerary/{{$itineraryeach->id}}/delete/" class="btn btn-white  deletebtnpopup"><span style="color:#506fd9;"><i style="font-size: 20px;" class="ri-delete-bin-6-line"></i></span></button>
                
                                    </td>
                                </tr>
                            @endforeach
                        
                        
                        </tbody>
                    </table>
                </div>
                

                <!-- NOT USING THIS BELOW TABLE  -->
                <div class="inactive_status" style="display:none;">
                    <table id="tableGrid2" class="table table-hover">
                        <thead>
                        <tr>
                            <th>No</th>
                            <th>Day</th>
                            <th>Day Plan</th>
                            <th>Description</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                        </thead>
                        <tbody>
                            <?php $i=0;?>
                        @foreach ($itinerary->where('status','Inactive') as $key => $itineraryeach)
                                <tr class="fw-bold fs-5">
                                    <td>{{ $key+1 }}</td>
                                    <td>{{ $itineraryeach->day}}</td>
                                    <td>{{ $itineraryeach->day_plan }}</td>
                                    <td>{{ $itineraryeach->description }}</td>
                                    <td>
                                        <?php if ($itineraryeach->status == 'Active') { ?>

                                            <a href="{{url('/status-update',$itineraryeach->id)}}" class="btn btn-success btn-sm">Active</a>

                                        <?php } else { ?>

                                            <a href="{{url('/status-update',$itineraryeach->id)}}" class="btn btn-danger btn-sm">Inactive</a>

                                        <?php } ?>
                                    </td>

                                    <td>
                                        <button value="{{$itineraryeach->id}}" style="padding:0;background-color: transparent;background-repeat: no-repeat;border: none;cursor: pointer;overflow: hidden;outline: none;" class=" btn btn-white viewbtn"><span style="color:#506fd9;"><i style="font-size: 20px;" class="ri-eye-line"></i></span></button>
                                        <button value="{{$itineraryeach->id}}" style="padding:0;background-color: transparent;background-repeat: no-repeat;border: none;cursor: pointer;overflow: hidden;outline: none;" class=" btn btn-white editbtn"><span style="color:#506fd9;"><i style="font-size: 20px;" class="ri-share-box-line"></i></span></button>
                                        <button style="padding:0;background-color: transparent;  background-repeat: no-repeat;  border: none;    cursor: pointer;    overflow: hidden;    outline: none;"  value="/itinerary/{{$itineraryeach->id}}/delete/" class="btn btn-white  deletebtnpopup"><span style="color:#506fd9;"><i style="font-size: 20px;" class="ri-delete-bin-6-line"></i></span></button>
                
                                        
                                    </td>
                                </tr>
                            @endforeach
                        
                        
                        </tbody>
                    </table>
                </div>
                <!-- NOT USING THIS ABOVE  TABLE  -->


            </div><!-- table-responsive -->
          </div><!-- card-body -->
          
        </div><!-- card -->

<!-- Add Ininerary Modal -->
<div class="modal" id="AddItinerary">
    <div class="modal-dialog modal-md">
        <div class="modal-content">

            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Add Itinerary</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <!-- Modal body -->
            <div class="modal-body">
                <div class="card-body">
                    
                    <form action="{{route('itinerary.store')}}"method ="POST" id="quickForm" enctype="multipart/form-data">
                        @csrf

                        <input type="hidden" name="tour_package_id" class="form-control" value="{{ $tourPack->id }}">
                        <div class="row">

                        </div><!-- Row -->
                        <div class="row">

                            <!--<div class="col-sm-6">-->
                            <!--    <div class="mb-3">-->

                            <!--        <label class="form-label">Day-->
                            <!--            <span class="required-field">*</span>-->
                            <!--        </label>-->
                            <!--        <input type="text" name="day" class="form-control">-->
                            <!--    </div>-->
                            <!--</div>-->
                            <div class="col-sm-6">
                                <div class="mb-3">

                                    <label class="form-label">Itinerary Plan
                                        <span class="required-field">*</span>
                                    </label>
                                    <input type="text" name="day_plan" class="form-control">
                                </div>
                            </div><!-- Col -->
                            
                             <div class="col-sm-6">
                                <div class="mb-3">

                                    <label class="form-label">Photo Upload

                                        <small class="optional-color">(optional)</small>
                                    </label>
                                    <input class="form-control" name="photos[]" type="file" multiple id="formFile">
                                </div>
                            </div>



                        </div><!-- Row -->


                        <div class="row">
                           <!-- Col -->

                        </div>

                        <div class="row">

                            <div class="col-sm-12">
                                <div class="mb-3">
                                    <label class="form-label">Discription
                                        <small class="optional-color">(optional)</small>
                                    </label>
                                    <textarea class="form-control" name="description" id="exampleFormControlTextarea1" rows="3"></textarea>
                                </div>
                            </div>




                            <div class="buttons-alignment mt-4">
                                <button type="submit" class="btn btn-primary submit-button-alignment">Submit</button>
                            </div>
                        </div>
                        
                                </form>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- Edit Ininerary Modal -->
<div class="modal" id="ViewItinerary">
    <div class="modal-dialog modal-md">
        <div class="modal-content">

            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">View Itinerary</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <!-- Modal body -->
            <div class="modal-body">
                <div class="card-body">
                    <form method="POST"  id="quickForm" enctype="multipart/form-data">
                        

                        <input type="hidden" name="itinerary_id" id="itinerary_id3" diabled class="form-control">

                        <div class="row">
                            <h3 class="heading">Basic Details</h3>

                        </div><!-- Row -->
                        <div class="row">

                            <!--<div class="col-sm-6">-->
                            <!--    <div class="mb-3">-->

                            <!--        <label class="form-label">Day-->
                            <!--            <span class="required-field">*</span>-->
                            <!--        </label>-->
                            <!--        <input type="text" name="day" disabled id="day3" class="form-control">-->
                            <!--    </div>-->
                            <!--</div>-->
                            <!-- Col -->
                            <div class="col-sm-6">
                                <div class="mb-3">

                                    <label class="form-label">Itinerary Plan
                                        <span class="required-field">*</span>
                                    </label>
                                    <input type="text" name="day_plan" id="day_plan3" class="form-control" disabled>
                                </div>
                            </div><!-- Col -->
                            
                            <div class="col-sm-6">
                                <div class="mb-3">

                                    <label class="form-label">Photo Upload

                                        <small class="optional-color">(optional)</small>
                                    </label>
                                    <input class="form-control" name="photo" id="photo3" type="file" id="formFile" disabled>
                                </div>
                            </div><!-- Col -->
                            
                        </div><!-- Row -->



                        <div class="row">
                            

                            <div class="col-sm-6">
                            <label class="form-label">Previous Photo Uploaded

                                </label>
                                <div class="mb-3">
                                    <img class="img-fluid" id="photo_preview3" style="width: 80px;">
                                </div>
                            </div><!-- Col -->
                        </div>

                        <div class="row">

                            <div class="col-sm-12">
                                <div class="mb-3">
                                    <label class="form-label">Discription
                                        <small class="optional-color">(optional)</small>
                                    </label>
                                    <textarea class="form-control" id="description3" name="description" id="exampleFormControlTextarea1" rows="3" disabled></textarea>
                                </div>
                            </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
</div>                   
<!-- Edit Ininerary Modal -->
<div class="modal" id="EditItinerary">
    <div class="modal-dialog modal-md">
        <div class="modal-content">

            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Edit/Update Itinerary</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <!-- Modal body -->
            <div class="modal-body">
                <div class="card-body">
                    <form action="{{url('itinerary_sevice_update')}}" method="POST"  id="quickForm" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')

                        <input type="hidden" name="itinerary_id" id="itinerary_id2" class="form-control">

                        <div class="row">
                            <h3 class="heading">Basic Details</h3>

                        </div><!-- Row -->
                        <div class="row">

                            <!--<div class="col-sm-6">-->
                            <!--    <div class="mb-3">-->

                            <!--        <label class="form-label">Day-->
                            <!--            <span class="required-field">*</span>-->
                            <!--        </label>-->
                            <!--        <input type="text" name="day" id="day2" class="form-control">-->
                            <!--    </div>-->
                            <!--</div>-->
                            <!-- Col -->
                            <div class="col-sm-6">
                                <div class="mb-3">

                                    <label class="form-label">Day Plan
                                        <span class="required-field">*</span>
                                    </label>
                                    <input type="text" name="day_plan" id="day_plan2" class="form-control">
                                </div>
                            </div><!-- Col -->
                            
                            <div class="col-sm-6">
                                <div class="mb-3">

                                    <label class="form-label">Photo Upload

                                        <small class="optional-color">(optional)</small>
                                    </label>
                                    <input class="form-control" name="photo" id="photo2" type="file" id="formFile">
                                </div>
                            </div><!-- Col -->

                            
                        </div><!-- Row -->



                        <div class="row">

                            <div class="col-sm-6">
                                <label class="form-label">Previous Photo Uploaded

                                </label>
                                <div class="mb-3">
                                    <img class="img-fluid" id="photo_preview2" style="width: 80px;">
                                </div>
                                    
                            </div><!-- Col -->
                        </div>

                        <div class="row">

                            <div class="col-sm-12">
                                <div class="mb-3">
                                    <label class="form-label">Discription
                                        <small class="optional-color">(optional)</small>
                                    </label>
                                    <textarea class="form-control" id="description2" name="description" id="exampleFormControlTextarea1" rows="3"></textarea>
                                </div>
                            </div>

                            <div class="buttons-alignment mt-4">
                                <button type="submit" class="btn btn-primary submit-button-alignment">Update</button>
                            </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
</div>



<!--Add Plan-->

<br><br>
<h4 class="" style="font-weight:550;letter-spacing:1px">Category List</h4>
<div class=""><br>
    <!--<button type="button" class="btn btn-primary btn-icon-text mb-2 mb-md-0 addcategory" >-->
    <!--    <i class="btn-icon-prepend" data-feather="plus-circle"></i>-->
    <!--    Add Category-->
    <!--</button>-->
</div>

<div class="card card-example">
          <div class="card-body" style="background-color:white;">
            <div class="table-responsive ">
                <div class="active_status">
                    <table id="tableGrid1" class="table table-hover">
                        <thead>
                        <tr>
                            <th>No</th>
                            <th>Name</th>
                            <th>2PX</th>
                            <th>4PX</th>
                            <th>6PX</th>
                            <th>8PX</th>
                            <th>10PX</th>
                            <th>Action</th>
                        </tr>
                        </thead>
                        <tbody>
                            
                        @foreach ($category as $key => $data)
                                <tr>
                                    <td>{{ $key+1 }}</td>
                                    <td>{{ $data->category}}</td>
                                    <td>{{ $data->px_2 }}</td>
                                    <td>{{ $data->px_4 }}</td>
                                    <td>{{ $data->px_6 }}</td>
                                    <td>{{ $data->px_8 }}</td>
                                    <td>{{ $data->px_10 }}</td>
                
                                    <td>
                                        <!--<button value="{{$itineraryeach->id}}" style="padding:0;background-color: transparent;background-repeat: no-repeat;border: none;cursor: pointer;overflow: hidden;outline: none;" class=" btn btn-white viewbtn"><span style="color:#506fd9;"><i style="font-size: 20px;" class="ri-eye-line"></i></span></button>-->
                                        <!--<button value="{{$itineraryeach->id}}" style="padding:0;background-color: transparent;background-repeat: no-repeat;border: none;cursor: pointer;overflow: hidden;outline: none;" class=" btn btn-white editbtn"><span style="color:#506fd9;"><i style="font-size: 20px;" class="ri-share-box-line"></i></span></button>-->
                                        <!--<button style="padding:0;background-color: transparent;  background-repeat: no-repeat;  border: none;    cursor: pointer;    overflow: hidden;    outline: none;"  value="/itinerary/{{$itineraryeach->id}}/delete/" class="btn btn-white  deletebtnpopup"><span style="color:#506fd9;"><i style="font-size: 20px;" class="ri-delete-bin-6-line"></i></span></button>-->
                
                                    </td>
                                </tr>
                            @endforeach
                        
                        
                        </tbody>
                    </table>
                </div>
                

            


            </div><!-- table-responsive -->
          </div><!-- card-body -->
          
        </div><!-- card -->

<!-- Add Ininerary Modal -->
<div class="modal" id="AddCategory">
    <div class="modal-dialog modal-md">
        <div class="modal-content">

            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Add Category</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <!-- Modal body -->
            <div class="modal-body">
                <div class="card-body">
                    
                    <form action="{{route('category.store')}}"method ="POST" id="quickForm" enctype="multipart/form-data">
                        @csrf

                        <input type="hidden" name="tour_package_id" class="form-control" value="{{ $tourPack->id }}">
                        <div class="row">

                        </div><!-- Row -->
                        <div class="row">

                            <!--<div class="col-sm-6">-->
                            <!--    <div class="mb-3">-->

                            <!--        <label class="form-label">Day-->
                            <!--            <span class="required-field">*</span>-->
                            <!--        </label>-->
                            <!--        <input type="text" name="day" class="form-control">-->
                            <!--    </div>-->
                            <!--</div>-->
                            <div class="col-sm-6">
                                <div class="mb-3">

                                    <label class="form-label">Category
                                        <span class="required-field">*</span>
                                    </label>
                                    <input type="text" name="category" class="form-control">
                                </div>
                            </div>
                            <!-- Col -->
                            
                            <div class="col-sm-6">
                                <div class="mb-3">

                                    <label class="form-label">2PX Price
                                        <span class="required-field">*</span>
                                    </label>
                                    <input type="text" name="px_2" class="form-control">
                                </div>
                            </div>
                            <!-- Col -->
                            
                            <div class="col-sm-6">
                                <div class="mb-3">

                                    <label class="form-label">4PX Price
                                        <span class="required-field">*</span>
                                    </label>
                                    <input type="text" name="px_4" class="form-control">
                                </div>
                            </div>
                            <!-- Col -->
                            
                            <div class="col-sm-6">
                                <div class="mb-3">

                                    <label class="form-label">6PX Price
                                        <span class="required-field">*</span>
                                    </label>
                                    <input type="text" name="px_6" class="form-control">
                                </div>
                            </div>
                            <!-- Col -->
                            
                            <div class="col-sm-6">
                                <div class="mb-3">

                                    <label class="form-label">8PX Price
                                        <span class="required-field">*</span>
                                    </label>
                                    <input type="text" name="px_8" class="form-control">
                                </div>
                            </div>
                            <!-- Col -->
                            
                            <div class="col-sm-6">
                                <div class="mb-3">

                                    <label class="form-label">10PX Price
                                        <span class="required-field">*</span>
                                    </label>
                                    <input type="text" name="px_10" class="form-control">
                                </div>
                            </div>
                            <!-- Col -->
                            


                        </div><!-- Row -->


                        

                        <div class="row">

                            <div class="buttons-alignment mt-4">
                                <button type="submit" class="btn btn-primary submit-button-alignment">Submit</button>
                            </div>
                        </div>
                        
                                </form>
                </div>
            </div>
        </div>
    </div>
</div>





@if($tourPack->type=='Group')
<div style="display:block; margin-top: 20px;">
    
    @php
      $count=[];
    @endphp
    
             <div class="row">
  <div class="col-lg-12 margin-tb">
<h4 class="" style="font-weight:550;letter-spacing:1px; margin-bottom: 10px;">Tour Information</h4>
    
    <div class=" mb-3">
      <a data-id="hotelservicelist" href="javascript:void();" class="display-btn btn btn-primary btn-icon-text mb-2 mb-md-0">
        Inclusions
    </a>
    <a data-id="flightservicelist" href="javascript:void();" class="display-btn btn btn-primary btn-icon-text mb-2 mb-md-0">
        Exclusions 
    </a>
    <!-- <a data-id="tourservicelist" href="javascript:void();" class="display-btn btn btn-success btn-icon-text mb-2 mb-md-0">
        Tour Package
      </a> -->
    <a data-id="visaservicelist" href="javascript:void();" class="display-btn btn btn-primary btn-icon-text mb-2 mb-md-0">
        Need to know 
    </a>
    <a data-id="insuranceservicelist" href="javascript:void();" class="display-btn btn btn-primary btn-icon-text mb-2 mb-md-0">
        Advance preparation for the tour 
    </a>
    <a data-id="carhireservicelist" href="javascript:void();" class="display-btn btn btn-primary btn-icon-text mb-2 mb-md-0">
        Client Review 
    </a>
    
    </div>
  </div>
</div>

<script>

$(document).ready(function() {
  $('.display-btn').click(function() {
    const data = $(this).data('id');
    console.log(data);
    // do something with attributeValue
    if(data== "hotelservicelist"){
        $('#hotel').show();
        $('#flight').hide();
        $('#other').hide();
        $('#visa').hide();
        $('#insurance').hide();
        $('#carhire').hide();
    }
    else if(data== "flightservicelist"){
        $('#flight').show();
        $('#hotel').hide();
        $('#other').hide();
        $('#visa').hide();
        $('#insurance').hide();
        $('#carhire').hide();
        $('#assist').hide();
    }
    else if(data== "otherservicelist"){
        $('#other').show();
        $('#hotel').hide();
        $('#flight').hide();
        $('#visa').hide();
        $('#insurance').hide();
        $('#carhire').hide();
        $('#assist').hide();
    }
    else if(data== "visaservicelist"){
        $('#visa').show();
        $('#hotel').hide();
        $('#other').hide();
        $('#flight').hide();
        $('#insurance').hide();
        $('#carhire').hide();
        $('#assist').hide();
    }
    else if(data== "insuranceservicelist"){
        $('#insurance').show();
        $('#hotel').hide();
        $('#other').hide();
        $('#visa').hide();
        $('#flight').hide();
        $('#carhire').hide();
        $('#assist').hide();
    }
    else if(data== "carhireservicelist"){
        $('#carhire').show();
        $('#hotel').hide();
        $('#other').hide();
        $('#visa').hide();
        $('#flight').hide();
        $('#insurance').hide();
        $('#assist').hide();
    }
    else if(data== "assistservicelist"){
        $('#assist').show();
        $('#hotel').hide();
        $('#other').hide();
        $('#visa').hide();
        $('#flight').hide();
        $('#carhire').hide();
        $('#insurance').hide();
    }
  });
});

   
 </script>

<div class="modal" id="AddInclusions">
    <div class="modal-dialog modal-md">
        <div class="modal-content">

            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Add Inclusions</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <!-- Modal body -->
            <div class="modal-body">
                <div class="card-body">
                    
                    <form action="{{route('inclusion.add')}}"method ="POST" id="quickForm" enctype="multipart/form-data">
                        @csrf

                        <input type="hidden" name="package_id" class="form-control" value="{{ $tourPack->id }}">
                        
                        <div class="row">

                            <div class="col-sm-12">
                                <div class="mb-3">
                                    <!--<label class="form-label">Description-->
                                    <!--</label>-->
                                    <textarea id="inc" class="form-control" name="inclusions" placeholder="Discription" id="exampleFormControlTextarea8" rows="3"></textarea>
                                    <script type="text/javascript">
                              CKEDITOR.replace( 'inc' );
                            </script>
                                </div>
                            </div>

                            


                        </div><!-- Row -->


                        

                        <div class="row">

                            <div class="buttons-alignment mt-4">
                                <button type="submit" class="btn btn-primary submit-button-alignment">Submit</button>
                            </div>
                        </div>
                        
                   </form>
                </div>
            </div>
        </div>
    </div>
</div>


<div id="hotel" class="col-md-12 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <div class="card-header">
        <div class="row">
            <div class="col-lg-6">
              <h1>Inclusion</h1>
            </div>
            <div style="text-align: right;" class="col-lg-6 text-right">
               <button type="button" class="btn btn-primary addinclusion">Add</button>

            </div>
        </div>
      </div>
      <div class="content">
          {!! $tour_information->inclusions !!}
      </div>

    </div>
  </div>
</div>


<div class="modal" id="AddExclusion">
    <div class="modal-dialog modal-md">
        <div class="modal-content">

            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Add Exclusion</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <!-- Modal body -->
            <div class="modal-body">
                <div class="card-body">
                    
                    <form action="{{route('exclusion.add')}}"method ="POST" id="quickForm" enctype="multipart/form-data">
                        @csrf

                        <input type="hidden" name="package_id" class="form-control" value="{{ $tourPack->id }}">
                        
                        <div class="row">

                            <div class="col-sm-12">
                                <div class="mb-3">
                                    <!--<label class="form-label">Description-->
                                    <!--</label>-->
                                    <textarea id="exclusions" class="form-control" name="exclusions" placeholder="Discription" id="exampleFormControlTextarea1" rows="3"></textarea>
                                    <script type="text/javascript">
                              CKEDITOR.replace( 'exclusions' );
                            </script>
                                </div>
                            </div>

                            


                        </div><!-- Row -->


                        

                        <div class="row">

                            <div class="buttons-alignment mt-4">
                                <button type="submit" class="btn btn-primary submit-button-alignment">Submit</button>
                            </div>
                        </div>
                        
                   </form>
                </div>
            </div>
        </div>
    </div>
</div>

<div style="display:none;" id="flight" class="col-md-12 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <div class="card-header">
        <div class="row">
            <div class="col-lg-6">
              <h1>Exclusions</h1>
            </div>
            <div style="text-align: right;" class="col-lg-6 text-right">
               <button type="button" class="btn btn-primary addexclusion">Add</button>

            </div>
        </div>
      </div>
      <div class="content">
          {!! $tour_information->exclusions !!}
      </div>

    </div>
  </div>
</div>

<div class="modal" id="AddNeedKnow">
    <div class="modal-dialog modal-md">
        <div class="modal-content">

            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Add Need to know</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <!-- Modal body -->
            <div class="modal-body">
                <div class="card-body">
                    
                    <form action="{{route('need_know.add')}}"method ="POST" id="quickForm" enctype="multipart/form-data">
                        @csrf

                        <input type="hidden" name="package_id" class="form-control" value="{{ $tourPack->id }}">
                        
                        <div class="row">

                            <div class="col-sm-12">
                                <div class="mb-3">
                                    <!--<label class="form-label">Description-->
                                    <!--</label>-->
                                    <textarea id="konw" class="form-control" name="content" placeholder="Description" id="exampleFormControlTextarea1" rows="3"></textarea>
                                    <script type="text/javascript">
                              CKEDITOR.replace( 'know' );
                            </script>
                                </div>
                            </div>

                            


                        </div><!-- Row -->


                        

                        <div class="row">

                            <div class="buttons-alignment mt-4">
                                <button type="submit" class="btn btn-primary submit-button-alignment">Submit</button>
                            </div>
                        </div>
                        
                   </form>
                </div>
            </div>
        </div>
    </div>
</div>


<div style="display:none;" id="tour" class="col-md-12 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <div class="card-header">
        <h1>Need To Know</h1>
      </div>

    </div>
  </div>
</div>



<div style="display:none;" id="visa" class="col-md-12 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <div class="card-header">
        <div class="row">
            <div class="col-lg-6">
              <h1>Need to know</h1>
            </div>
            <div style="text-align: right;" class="col-lg-6 text-right">
               <button type="button" class="btn btn-primary addneedknow">Add</button>

            </div>
        </div>
      </div>
      <div class="content">
          {!! $tour_information->need_to_know !!}
      </div>

    </div>
  </div>
</div>

<div class="modal" id="AddTourPreparation">
    <div class="modal-dialog modal-md">
        <div class="modal-content">

            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Add Tour Preparation</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <!-- Modal body -->
            <div class="modal-body">
                <div class="card-body">
                    
                    <form action="{{route('tour_preparation.add')}}"method ="POST" id="quickForm" enctype="multipart/form-data">
                        @csrf

                        <input type="hidden" name="package_id" class="form-control" value="{{ $tourPack->id }}">
                        
                        <div class="row">

                            <div class="col-sm-12">
                                <div class="mb-3">
                                    <!--<label class="form-label">Description-->
                                    <!--</label>-->
                                    <textarea id="content" class="form-control" name="content" placeholder="Description" id="exampleFormControlTextarea1" rows="3"></textarea>
                                    <script type="text/javascript">
                              CKEDITOR.replace( 'content' );
                            </script>
                                </div>
                            </div>

                            


                        </div><!-- Row -->


                        

                        <div class="row">

                            <div class="buttons-alignment mt-4">
                                <button type="submit" class="btn btn-primary submit-button-alignment">Submit</button>
                            </div>
                        </div>
                        
                   </form>
                </div>
            </div>
        </div>
    </div>
</div>


<div style="display:none;" id="insurance" class="col-md-12 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <div class="card-header">
        <div class="row">
            <div class="col-lg-6">
              <h1>Tour Preparation</h1>
            </div>
            <div style="text-align: right;" class="col-lg-6 text-right">
               <button type="button" class="btn btn-primary addtourpreparation">Add</button>

            </div>
        </div>
      </div>
      <div class="content">
          {!! $tour_information->tour_preparation !!}
      </div>

    </div>
  </div>
</div>


<div class="modal" id="AddClientReview">
    <div class="modal-dialog modal-md">
        <div class="modal-content">

            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Add Client Review</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <!-- Modal body -->
            <div class="modal-body">
                <div class="card-body">
                    
                    <form action="{{route('client_review.add')}}"method ="POST" id="quickForm" enctype="multipart/form-data">
                        @csrf

                        <input type="hidden" name="package_id" class="form-control" value="{{ $tourPack->id }}">
                        
                        <div class="row">

                            <div class="col-sm-12">
                                <div class="mb-3">
                                    <!--<label class="form-label">Description-->
                                    <!--</label>-->
                                    <textarea id="content" class="form-control" name="content" placeholder="Description" id="exampleFormControlTextarea1" rows="3"></textarea>
                                    <script type="text/javascript">
                              CKEDITOR.replace( 'content' );
                            </script>
                                </div>
                            </div>

                            


                        </div><!-- Row -->


                        

                        <div class="row">

                            <div class="buttons-alignment mt-4">
                                <button type="submit" class="btn btn-primary submit-button-alignment">Submit</button>
                            </div>
                        </div>
                        
                   </form>
                </div>
            </div>
        </div>
    </div>
</div>


<div style="display:none;" id="carhire" class="col-md-12 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <div class="card-header">
        <div class="row">
            <div class="col-lg-6">
              <h1>Exclusions</h1>
            </div>
            <div style="text-align: right;" class="col-lg-6 text-right">
               <button type="button" class="btn btn-primary addclientreview">Add</button>

            </div>
        </div>
      </div>
      <div class="content">
          {!! $tour_information->client_review !!}
      </div>
      
    </div>
  </div>
</div>


    
</div>
@endif


<script>
    $(document).ready(function() {
        
        $(document).on('click', '.editbtn', function() {
            var itinerary_id = $(this).val();
            //alert(service_id);
            $('#EditItinerary').modal('show');

            $.ajax({
                type: "GET",
                url: "/itinerary/" + itinerary_id + "/edit",

                success: function(response) {
                    console.log(response.itinerary.photo);
                    $('#itinerary_id2').val(itinerary_id);
                    $('#day2').val(response.itinerary.day);
                    $('#day_plan2').val(response.itinerary.day_plan);
                    $('#description2').val(response.itinerary.description);
                    $('#photo_preview2').attr("src", "/uploads/" + response.itinerary.photo);
                }
            });
        });

        $(document).on('click', '.viewbtn', function() {
            var itinerary_id = $(this).val();
            //alert(service_id);
            $('#ViewItinerary').modal('show');

            $.ajax({
                type: "GET",
                url: "/itinerary/" + itinerary_id + "/edit",

                success: function(response) {
                    console.log(response.itinerary.photo);
                    $('#itinerary_id3').val(itinerary_id);
                    $('#day3').val(response.itinerary.day);
                    $('#day_plan3').val(response.itinerary.day_plan);
                    $('#description3').val(response.itinerary.description);
                    $('#photo_preview3').attr("src", "/uploads/" + response.itinerary.photo);
                }
            });
        });
        
        $(document).on('click', '.additinerary', function() {
            var itinerary_id = $(this).val();
            //alert(service_id);
            $('#AddItinerary').modal('show');

            
        });
        $(document).on('click', '.addcategory', function() {
            var itinerary_id = $(this).val();
            //alert(service_id);
            $('#AddCategory').modal('show');

            
        });
        $(document).on('click', '.addinclusion', function() {
            var itinerary_id = $(this).val();
            //alert(service_id);
            $('#AddInclusions').modal('show');
        });
        
        $(document).on('click', '.addexclusion', function() {
            var itinerary_id = $(this).val();
            //alert(service_id);
            $('#AddExclusion').modal('show');
        });
        
        $(document).on('click', '.addneedknow', function() {
            var itinerary_id = $(this).val();
            //alert(service_id);
            $('#AddNeedKnow').modal('show');
        });
        
        $(document).on('click', '.addtourpreparation', function() {
            var itinerary_id = $(this).val();
            //alert(service_id);
            $('#AddTourPreparation').modal('show');
        });
        
        $(document).on('click', '.addclientreview', function() {
            var itinerary_id = $(this).val();
            //alert(service_id);
            $('#AddClientReview').modal('show');
        });
    });
</script>

<script type="text/javascript">
      $("#tableGrid1").Grid({
        className: {
          table: 'table table-bordered mb-0'
        },
        search: true
      });
    </script>
     
     <style>
    tbody tr:hover {background-color: #F5F5F5;}
    .card-example>.card-body::before {
    content: ""
    }
    .gridjs-head{
      display: flex;
    }
    .gridjs-search{
      width: 50%;
    }
    .filter{
      margin-left: auto;
      width: 200px;
    }
    </style>

   <script>
// $('.filter').change(function() {
//   console.log("here is my on change");
//     var value = $(this).val();
//     if (value=='Active') {
//     $('.active_status').show();
//     $('.inactive_status').hide();
//     }
//     else if (value=='Inactive') {
//     $('.inactive_status').show();
//     $('.active_status').hide();
//     }
// });
</script>


    <script type="text/javascript">

      $("#tableGrid1").Grid({
  className: {
    table: 'table table-bordered mb-0'
  },
  search: true
});

 //       $('#filter').change(function() {
 //   console.log('Button clicked!');
 //   var value = $(this).val();
 //   alert(value)

 // });


    </script>


@endsection