<?php

namespace App\Models\Inventory;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TyreInventory extends Model
{
    use HasFactory;
    protected $table = 'tyre_inventory';

    protected $fillable = [
        // Basic Information
        'brand_name',
        'commercial_name',
        'model',
        'identity', // Might be serial number or SKU depending on tracking
        'tread_depth',
        'maximum_tread_depth',
        'pressure',
        'rolling_km',
        'maximum_rolling_km',
        'load_pressure_information',
    
        // Technical Specifications
        'indicated_exterior',
        'type_of_construction',
        'tire_sections_width',
        'section_height_to_width_ratio',
        'rim_diameter',
        'load_capacity_index',
        'speed_rating',
        'load_rating',
        'tire_type', // Consider enum options for common types like summer, winter, all-season
    
        // Inventory Management
        'tubeless',
        'quantity',
        'unit_price',
        'total_price',
        'currency',
        'date', // Consider using Carbon's date_format
    
        // Additional
        'warranty_type',
        'warranty_start_date', // Consider using Carbon's date_format
        'warranty_end_date', // Consider using Carbon's date_format
        'preferred_vehicles',
        'remarks',
    ];
    
}
