<?php

namespace App\Imports;

use App\Models\Inventory\TyreInventory;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class TyreInventoryImport implements ToModel
{
    public function model(array $row)
    {
        return new TyreInventory([
            'date' => Carbon::parse($row[0]), // Date
            'brand_name' => $row[1], // Brand Name
            'commercial_name' => $row[2], // Commercial Name
            'model' => $row[3], // Model
            'identity' => $row[4], // Identity
            'tread_depth' => $row[5], // Tread Depth
            'maximum_tread_depth' => $row[6], // Maximum Tread Depth
            'pressure' => $row[7], // Pressure
            'rolling_km' => $row[8], // Rolling KM
            'maximum_rolling_km' => $row[9], // Maximum Rolling KM
            'load_pressure_information' => $row[10], // Load Pressure Information
            'indicated_exterior' => $row[11], // Indicated Exterior
            'type_of_construction' => $row[12], // Type of Construction
            'tire_sections_width' => $row[13], // Tire Sections Width (mm)
            'section_height_to_section_width_ratio' => $row[14], // Section Height to Section Width Ratio
            'rim_diameter' => $row[15], // Rim Diameter (inches)
            'load_capacity_index' => $row[16], // Load Capacity Index
            'speed_rating' => $row[17], // Speed Rating
            'load_rating' => $row[18], // Load Rating
            'tire_type' => $row[19], // Tire Type
            'tubeless' => $row[20], // Tubeless
            'quantity' => $row[21], // Quantity
            'unit_price' => $row[22], // Unit Price
            'total_price' => $row[23], // Total Price
            'currency' => $row[24], // Currency
            'warranty_type' => $row[25], // Warranty Type
            'warranty_start_date' => Carbon::parse($row[26]), // Warranty Start Date
            'warranty_end_date' => Carbon::parse($row[27]), // Warranty End Date
            'preferred_vehicles' => $row[28], // Preferred Vehicles
            'attachment' => $row[29], // Attachment (file path or upload form)
            'remarks' => $row[30], // Remarks
        ]);

    }
}
