<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Support\Facades\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\Masters\TrailerType;
use App\Models\Masters\TrailerBrands;
use App\Models\Masters\ActionType;
use App\Models\Masters\ServiceType;
use App\Models\Masters\RimServiceType;
use App\Models\Masters\BatteryServiceType;

use App\Models\Masters\DocumentType;
use App\Models\Masters\InspectionFaq;

use App\Models\Trailers\Trailers;
use App\Models\Trailers\TrailerDocuments;
use App\Models\Trailers\TrailerInspection;
use App\Models\Trailers\TrailerHistory;
use App\Models\Vehicles\VehicleTrailers;
use App\Models\Inventory\Inventory;

use App\Models\Tires\Tires;
use App\Models\Tires\TireHistory;
use App\Models\Tires\TireServiceHistory;
use App\Models\Tires\TireInspectionHistory;
use App\Models\Rims\Rims;
use App\Models\Rims\RimServiceHistory;
use App\Models\Rims\RimInspectionHistory;
use App\Models\Battery\Batteries;

use App\Models\Trailers\TrailerTyres;
use App\Models\Trailers\TrailerRims;
use App\Models\Trailers\TrailerBatteries;
use App\Models\Trailers\TrailerStepneyTyres;
use App\Models\Trailers\TrailerStepneyRims;

use App\Models\User\UserHistory;


use Illuminate\Support\Facades\Redirect;

class trailerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index(Request $request)
    {
        $trailers = Trailers::orderBy('id', 'DESC')->get();
        return view('trailer.index', compact('trailers'));
    }


    public function create()
    {
        $trailer_type = TrailerType::all();
        $trailer_brand = TrailerBrands::all();
        return view('trailer.create', compact('trailer_type', 'trailer_brand'));
        
    }
    
    
    public function view($id)
    {
        $trailer = Trailers::find($id);
        
        // $vehicle = Vehicles::find($id);
        $image= $trailer->axle_tyre_configuration;
        $data = json_decode($image, true);
        
        // $vehicle_trailers =  VehicleTrailers::where('vehicle_id', $id)->get();
        


        return view('trailer.view', compact('id','data', 'trailer'));
    }
    
    
    
      
     public function add_battery($id ,$position)
    {
        $tyres = Batteries::where('location_status', 'Store')->get();
        $vehicle_tyres = TrailerBatteries::where('trailer_id', $id)->where('battery_position', $position)->first();
        
        if($vehicle_tyres){
          $tire_id= $vehicle_tyres->battery_id;
        $tire = Batteries::where('battery_id', $tire_id)->first();
        $service_type = ServiceType::all();
        $action_type = ActionType::all();
        
        $faq = BatteryInspection::all();
        
        $vehicle_tire = TrailerBatteries::where('battery_id', $tire_id)->first();
        if($vehicle_tire){
          $position=$vehicle_tire->battery_position;
        }
        else{
          $position='';
            
        }
        

        $battery_history = BatteryHistory::where('battery_id', $tire_id)->take(2)->get();
        $service_history = BatteryServiceHistory::where('battery_id', $tire->id)->take(2)->get();
        $inspection_history = BatteryInspectionHistory::where('battery_id', $tire->id)->take(2)->get();
        $inspection = BatteryInspectionHistory::where('battery_id', $tire->id)
                             ->latest('created_at') 
                             ->first();      
        if($inspection){
            $action_needed= $inspection->action_type;
        }
        else{
          $action_needed='';
            
        }

     
        return view('battery.view', compact('tire', 'faq', 'action_type', 'service_type', 'battery_history', 'service_history', 'inspection_history', 'position', 'action_needed'));
            

          

          return view('battery.view', compact('tire', 'id', 'position', 'service_type', 'action_type'));
            
        }
        else{
          return view('trailer.add_battery', compact('tyres', 'id', 'position'));
            
        }
        
    }
    
       public function install_battery(Request $request){
           
        
        $date = date('Y-m-d');
        $time = date('H:i:s');  
        $user = Auth::user();
        $battery_id = $request->input('battery_id');
        $trailer_id = $request->input('trailer_id');
        $ve = Trailers::find($trailer_id);
        $v_id=$ve->trailer_id;
           
        $vehicle = new TrailerBatteries();
        $vehicle->trailer_id = $request->input('trailer_id');
        $vehicle->battery_id = $request->input('battery_id');
        $vehicle->battery_position = $request->input('battery_position');
       
        // Save the vehicle tyre record
        $vehicle->save();
        
        $tire = Batteries::where('battery_id', $battery_id)->first();
        $tire->installation_date = $date;
        $tire->trailer_id = $request->input('trailer_id');
        $tire->location_status = 'Vehicle';
        $tire->save();
        
        $UserHistory = new UserHistory();
        $UserHistory->user_id = $user->id;
        $UserHistory->module = 'Battery';
        $UserHistory->action_type = 'Added Battery to vehicle (' . $v_id . ')';
        $UserHistory->item_id = $request->input('battery_id');
        $UserHistory->date = $date;
        $UserHistory->time = $time;
        $UserHistory->save();
        
        $type = new BatteryHistory;
        $type->battery_id = $tire->id;
        $type->date = $date;
        $type->moved_from = 'Store';
        $type->moved_to = 'Vehicle';
        $type->trailer_id= $request->input('trailer_id');
        $type->attachment = $request->input("attachment");
        $type->remark = $request->input("remark");
        $type->save();
        
         // Redirect to the vehicle's details page or the index page
       session()->flash('success', 'Battery Added to vehicle Successfully');

       return redirect()->back();
    //   return redirect()->route('vehicles');
           
       }
       
       
        public function view_battery($id ,$position)
    {
        $tyres = Batteries::where('location_status', 'Store')->get();
        $vehicle_tyres = TrailerBatteries::where('trailer_id', $id)->where('battery_position', $position)->first();
        
        if($vehicle_tyres){
          $tire_id= $vehicle_tyres->battery_id;
        $tire = Batteries::where('battery_id', $tire_id)->first();
        $service_type = BatteryServiceType::all();
        $action_type = ActionType::all();
        
        $faq = BatteryInspection::all();
        
        $vehicle_tire = TrailerBatteries::where('battery_id', $tire_id)->first();
        if($vehicle_tire){
          $position=$vehicle_tire->battery_position;
        }
        else{
          $position='';
            
        }
        

        $battery_history = BatteryHistory::where('battery_id', $tire_id)->take(2)->get();
        $service_history = BatteryServiceHistory::where('battery_id', $tire->id)->take(2)->get();
        $inspection_history = BatteryInspectionHistory::where('battery_id', $tire->id)->take(2)->get();
        $inspection = BatteryInspectionHistory::where('battery_id', $tire->id)
                             ->latest('created_at') 
                             ->first();      
        if($inspection){
            $action_needed= $inspection->action_type;
        }
        else{
          $action_needed='';
            
        }

     
        return view('battery.view', compact('tire', 'faq', 'action_type', 'service_type', 'battery_history', 'service_history', 'inspection_history', 'position', 'action_needed'));
            

          

          return view('battery.view', compact('tire', 'id', 'position', 'service_type', 'action_type'));
            
        }
        else{
          session()->flash('error', 'Battery has not installed yet');
       return redirect()->back();
            
        }
        
    }
    
    public function add_stepney_tyre($id ,$position)
    {
        $tyres = Tires::where('location_status', 'Store')->get();
        $vehicle_tyres = TrailerStepneyTyres::where('trailer_id', $id)->where('tyre_position', $position)->first();
        
        if($vehicle_tyres){
          $tire_id= $vehicle_tyres->tyre_id;
        $tire = Tires::where('tire_id', $tire_id)->first();
        $service_type = ServiceType::all();
        $action_type = ActionType::all();

        $faq = InspectionFaq::all();

        

        $tire_history = TireHistory::where('tire_id', $id)->take(2)->get();
        $service_history = TireServiceHistory::where('tire_id', $id)->take(2)->get();
        $inspection_history = TireInspectionHistory::where('tire_id', $id)->take(2)->get();

          

        return view('tyre.view', compact('tire', 'id', 'position', 'service_type', 'action_type', 'tire_history', 'service_history', 'inspection_history', 'faq'));
            
        }
        else{
          return view('trailer.add_stepney_tyre', compact('tyres', 'id', 'position'));
            
        }
        
    }
    
    public function install_stepney_tyre(Request $request){
           
        $date = date('Y-m-d');
        $time = date('H:i:s');  
        $user = Auth::user();
        $tire_id = $request->input('tire_id');
        $trailer_id = $request->input('trailer_id');
        $ve = Trailers::find($trailer_id);
        $v_id=$ve->trailer_id;


           
        $vehicle = new TrailerStepneyTyres();
        $vehicle->trailer_id = $request->input('trailer_id');
        $vehicle->tyre_id = $request->input('tire_id');
        $vehicle->tyre_position = $request->input('tire_position');
       
        // Save the vehicle tyre record
        $vehicle->save();
        
        $tire = Tires::where('tire_id', $tire_id)->first();
        $tire->installation_date = $date;
        $tire->vehicle_id = $request->input('trailer_id');
        $tire->position_on_vehicle = $request->input('tire_position');
        $tire->location_status = 'Trailer';
        $tire->save();
        
        $UserHistory = new UserHistory();
        $UserHistory->user_id = $user->id;
        $UserHistory->module = 'Tyre';
        $UserHistory->action_type = 'Added Stepney Tyre to Trailer (' . $v_id . ')';
        $UserHistory->item_id = $request->input('tire_id');
        $UserHistory->date = $date;
        $UserHistory->time = $time;
        $UserHistory->save();
        
        $type = new TireHistory;
        $type->tire_id = $tire->id;
        $type->date = $date;
        $type->moved_from = 'Store';
        $type->moved_to = 'Trailer';
        $type->vehicle_id= $request->input('trailer_id');
        $type->attachment = $request->input("attachment");
        $type->remark = $request->input("remark");
        $type->save();
        
         // Redirect to the vehicle's details page or the index page
       session()->flash('success', 'Stepney Tyre Added to vehicle Successfully');
       return redirect()->back();
    //   return redirect()->route('vehicles');
           
       }
       
       
    public function view_stepney_tyre($id ,$position)
    {
        $tyres = Tires::where('location_status', 'Store')->get();
        $vehicle_tyres = TrailerStepneyTyres::where('trailer_id', $id)->where('tyre_position', $position)->first();
        
        if($vehicle_tyres){
          $tire_id= $vehicle_tyres->tyre_id;
        $tire = Tires::where('tire_id', $tire_id)->first();
        $service_type = ServiceType::all();
        $action_type = ActionType::all();

        $faq = InspectionFaq::all();

        

        $tire_history = TireHistory::where('tire_id', $id)->take(2)->get();
        $service_history = TireServiceHistory::where('tire_id', $id)->take(2)->get();
        $inspection_history = TireInspectionHistory::where('tire_id', $id)->take(2)->get();

          

        return view('tyre.view', compact('tire', 'id', 'position', 'service_type', 'action_type', 'tire_history', 'service_history', 'inspection_history', 'faq'));
            
        }
        else{
          session()->flash('error', 'Stepney tyre has not installed yet');
       return redirect()->back();
            
        }
        
    }
    
    public function add_stepney_rim($id ,$position)
    {
        $tyres = Rims::where('location_status', 'Store')->get();
        $vehicle_tyres = TrailerStepneyRims::where('trailer_id', $id)->where('rim_position', $position)->first();
        
        if($vehicle_tyres){
          $tire_id= $vehicle_tyres->rim_id;
        $tire = Rims::where('rim_id', $tire_id)->first();
        $service_type = ServiceType::all();
        $action_type = ActionType::all();

        $faq = InspectionFaq::all();
        

        $tire_history = RimHistory::where('rim_id', $id)->take(2)->get();
        $service_history = RimServiceHistory::where('rim_id', $id)->take(2)->get();
        $inspection_history = RimInspectionHistory::where('rim_id', $id)->take(2)->get();

          

        return view('rim.view', compact('tire', 'id', 'position', 'service_type', 'action_type', 'tire_history', 'service_history', 'inspection_history', 'faq'));
            
        }
        else{
          return view('trailer.add_stepney_rim', compact('tyres', 'id', 'position'));
            
        }
        
    }
    
    public function install_stepney_rim(Request $request){
           
        
        
        $date = date('Y-m-d');
        $time = date('H:i:s');  
        $user = Auth::user();
        $rim_id = $request->input('rim_id');
        $trailer_id = $request->input('trailer_id');
        $ve = Trailers::find($trailer_id);
        $v_id=$ve->trailer_id;
           
        $vehicle = new TrailerStepneyRims();
        $vehicle->trailer_id = $request->input('trailer_id');
        $vehicle->rim_id = $request->input('rim_id');
        $vehicle->rim_position = $request->input('rim_position');
       
        // Save the vehicle tyre record
        $vehicle->save();
        
        $tire = Rims::where('rim_id', $rim_id)->first();
        $tire->installation_date = $date;
        $tire->vehicle_id = $request->input('trailer_id');
        $tire->position_on_vehicle = $request->input('rim_position');
        $tire->location_status = 'Trailer';
        $tire->save();
        
        $UserHistory = new UserHistory();
        $UserHistory->user_id = $user->id;
        $UserHistory->module = 'Rim';
        $UserHistory->action_type = 'Added Stepney Rim to Trailer (' . $v_id . ')';
        $UserHistory->item_id = $request->input('rim_id');
        $UserHistory->date = $date;
        $UserHistory->time = $time;
        $UserHistory->save();
        
        $type = new RimHistory;
        $type->rim_id = $tire->id;
        $type->date = $date;
        $type->moved_from = 'Store';
        $type->moved_to = 'Trailer';
        $type->vehicle_id= $request->input('trailer_id');
        $type->attachment = $request->input("attachment");
        $type->remark = $request->input("remark");
        $type->save();
        
         // Redirect to the vehicle's details page or the index page
       session()->flash('success', 'Stepney Tyre Added to Trailer Successfully');

       return redirect()->back();
    //   return redirect()->route('vehicles');
           
       }
       
       
    public function view_stepney_rim($id ,$position)
    {
        $tyres = Rims::where('location_status', 'Store')->get();
        $vehicle_tyres = TrailerStepneyRims::where('trailer_id', $id)->where('rim_position', $position)->first();
        
        if($vehicle_tyres){
          $tire_id= $vehicle_tyres->rim_id;
        $tire = Rims::where('rim_id', $tire_id)->first();
        $service_type = RimServiceType::all();
        $action_type = ActionType::all();

        $faq = InspectionFaq::all();
        

        $tire_history = RimHistory::where('rim_id', $id)->take(2)->get();
        $service_history = RimServiceHistory::where('rim_id', $id)->take(2)->get();
        $inspection_history = RimInspectionHistory::where('rim_id', $id)->take(2)->get();

          

        return view('rim.view', compact('tire', 'id', 'position', 'service_type', 'action_type', 'tire_history', 'service_history', 'inspection_history', 'faq'));
            
        }
        else{
          session()->flash('error', 'Stepney rim has not installed yet');
       return redirect()->back();
            
        }
        
    }
    
    public function viewTyre($id ,$position)
    {
        $tyres = Tires::where('location_status', 'Store')->get();
        $vehicle_tyres = TrailerTyres::where('trailer_id', $id)->where('tyre_position', $position)->first();
        
        if($vehicle_tyres){
          $tire_id= $vehicle_tyres->tyre_id;
        $tire = Tires::where('tire_id', $tire_id)->first();
        $service_type = ServiceType::all();
        $action_type = ActionType::all();
        $faq = InspectionFaq::all();

        

        $tire_history = TireHistory::where('tire_id', $tire->id)->take(2)->get();
        $service_history = TireServiceHistory::where('tire_id', $tire->id)->take(2)->get();
        $inspection_history = TireInspectionHistory::where('tire_id', $tire->id)->take(2)->get();
        $inspection = TireInspectionHistory::where('tire_id', $tire->id)
                             ->latest('created_at') 
                             ->first();      
        if($inspection){
            $action_needed= $inspection->action_type;
        }
        else{
          $action_needed='';
            
        }

          

        return view('tyre.view', compact('tire', 'id', 'position', 'service_type', 'action_type', 'tire_history', 'service_history', 'inspection_history', 'faq', 'action_needed'));
            
        }
        else{
          session()->flash('error', 'Tyre has not installed yet');
       return redirect()->back();
            
        }
        
    }    
    
     public function addTyre($id ,$position)
    {
        $tyres = Tires::where('location_status', 'Store')->get();
        $vehicle_tyres = TrailerTyres::where('trailer_id', $id)->where('tyre_position', $position)->first();
        
        if($vehicle_tyres){
          $tire_id= $vehicle_tyres->tyre_id;
        $tire = Tires::where('tire_id', $tire_id)->first();
        $service_type = ServiceType::all();
        $action_type = ActionType::all();
        $faq = InspectionFaq::all();

        

        $tire_history = TireHistory::orderBy('id', 'DESC')->where('tire_id', $tire->id)->take(2)->get();
        $service_history = TireServiceHistory::orderBy('id', 'DESC')->where('tire_id', $tire->id)->take(2)->get();
        $inspection_history = TireInspectionHistory::where('tire_id', $tire->id)->take(2)->get();
        $inspection = TireInspectionHistory::where('tire_id', $tire->id)
                             ->latest('created_at') 
                             ->first();      
        if($inspection){
            $action_needed= $inspection->action_type;
        }
        else{
          $action_needed='';
            
        }

           

        return view('tyre.view', compact('tire', 'id', 'position', 'service_type', 'action_type', 'tire_history', 'service_history', 'inspection_history', 'faq', 'action_needed'));
            
        }
        else{
          return view('trailer.add_tyre', compact('tyres', 'id', 'position'));
            
        }
        
    }
    
       public function install_tyre(Request $request){
           
        $date = date('Y-m-d');
        $time = date('H:i:s');  
        $user = Auth::user();
        $tire_id = $request->input('tire_id');
        $trailer_id = $request->input('trailer_id');
        $ve = Trailers::find($trailer_id);
        $v_id=$ve->trailer_id;


           
        $vehicle = new TrailerTyres();
        $vehicle->trailer_id = $request->input('trailer_id');
        $vehicle->tyre_id = $request->input('tire_id');
        $vehicle->tyre_position = $request->input('tire_position');
       
        // Save the vehicle tyre record
        $vehicle->save();
        
        $tire = Tires::where('tire_id', $tire_id)->first();
        $tire->installation_date = $date;
        $tire->vehicle_id = $request->input('trailer_id');
        $tire->position_on_vehicle = $request->input('tire_position');
        $tire->location_status = 'Trailer';
        $tire->save();
        
        $UserHistory = new UserHistory();
        $UserHistory->user_id = $user->id;
        $UserHistory->module = 'Tyre';
        $UserHistory->action_type = 'Added Tyre to vehicle (' . $v_id . ')';
        $UserHistory->item_id = $request->input('tire_id');
        $UserHistory->date = $date;
        $UserHistory->time = $time;
        $UserHistory->save();
        
        $type = new TireHistory;
        $type->tire_id = $tire->id;
        $type->date = $date;
        $type->moved_from = 'Store';
        $type->moved_to = 'Trailer';
        $type->vehicle_id= $vehicle->id;
        $type->attachment = $request->input("attachment");
        $type->remark = $request->input("remark");
        $type->save();
        
        
        
         // Redirect to the vehicle's details page or the index page
       session()->flash('success', 'Tyre Added to vehicle Successfully');

       return redirect()->back();
    //   return redirect()->route('vehicles');
           
       }
       
       
        public function viewRim($id ,$position)
    {
        $tyres = Rims::where('location_status', 'Store')->get();
        $vehicle_tyres = TrailerRims::where('trailer_id', $id)->where('rim_position', $position)->first();
        
        if($vehicle_tyres){
          $tire_id= $vehicle_tyres->rim_id;
        $tire = Rims::where('rim_id', $tire_id)->first();
        $service_type = RimServiceType::all();
        $action_type = ActionType::all();
        
        $faq = RimInspection::all();
        
        $vehicle_tire = TrailerRims::where('rim_id', $tire_id)->first();
        if($vehicle_tire){
          $position=$vehicle_tire->rim_position;
        }
        else{
          $position='';
            
        }
        
        $rim_history = RimHistory::where('rim_id', $tire->id)->take(2)->get();
        $service_history = RimServiceHistory::where('rim_id', $tire->id)->take(2)->get();
        $inspection_history = RimInspectionHistory::where('rim_id', $tire->id)->take(2)->get();
        $inspection = RimInspectionHistory::where('rim_id', $tire->id)
                             ->latest('created_at') 
                             ->first();      
        if($inspection){
            $action_needed= $inspection->action_type;
        }
        else{
          $action_needed='';
            
        }

     
        return view('rim.view', compact('tire', 'faq', 'action_type', 'service_type', 'rim_history', 'service_history', 'inspection_history', 'position', 'action_needed'));
    

          

          return view('rim.view', compact('tire', 'id', 'position', 'service_type', 'action_type'));
            
        }
        else{
          session()->flash('error', 'Rim has not installed yet');
       return redirect()->back();
            
        }
        
    }
    
        public function addRim($id ,$position)
    {
        $tyres = Rims::where('location_status', 'Store')->get();
        $vehicle_tyres = TrailerRims::where('trailer_id', $id)->where('rim_position', $position)->first();
        
        if($vehicle_tyres){
          $tire_id= $vehicle_tyres->rim_id;
        $tire = Rims::where('rim_id', $tire_id)->first();
        $service_type = ServiceType::all();
        $action_type = ActionType::all();
        
        $faq = RimInspection::all();
        
        $vehicle_tire = TrailerRims::where('rim_id', $tire_id)->first();
        if($vehicle_tire){
          $position=$vehicle_tire->rim_position;
        }
        else{
          $position='';
            
        }
        
        $rim_history = RimHistory::where('rim_id', $tire->id)->take(2)->get();
        $service_history = RimServiceHistory::where('rim_id', $tire->id)->take(2)->get();
        $inspection_history = RimInspectionHistory::where('rim_id', $tire->id)->take(2)->get();
        $inspection = RimInspectionHistory::where('rim_id', $tire->id)
                             ->latest('created_at') 
                             ->first();      
        if($inspection){
            $action_needed= $inspection->action_type;
        }
        else{
          $action_needed='';
            
        }

     
        return view('rim.view', compact('tire', 'faq', 'action_type', 'service_type', 'rim_history', 'service_history', 'inspection_history', 'position', 'action_needed'));
    

          return view('rim.view', compact('tire', 'id', 'position', 'service_type', 'action_type'));
            
        }
        else{
          return view('trailer.add_rim', compact('tyres', 'id', 'position'));
            
        }
        
    }
    
       public function install_rim(Request $request){
           
        $date = date('Y-m-d');
        $time = date('H:i:s');  
        $user = Auth::user();
        $rim_id = $request->input('rim_id');
        $trailer_id = $request->input('trailer_id');
        $ve = Trailers::find($trailer_id);
        $v_id=$ve->trailer_id;
           
        $vehicle = new TrailerRims();
        $vehicle->trailer_id = $request->input('trailer_id');
        $vehicle->rim_id = $request->input('rim_id');
        $vehicle->rim_position = $request->input('rim_position');
       
        // Save the vehicle tyre record
        $vehicle->save();
        
        $tire = Rims::where('rim_id', $rim_id)->first();
        $tire->installation_date = $date;
        $tire->trailer_id = $request->input('trailer_id');
        $tire->position_on_vehicle = $request->input('rim_position');
        $tire->location_status = 'Vehicle';
        $tire->save();
        
        $UserHistory = new UserHistory();
        $UserHistory->user_id = $user->id;
        $UserHistory->module = 'Rim';
        $UserHistory->action_type = 'Added Rim to vehicle (' . $v_id . ')';
        $UserHistory->item_id = $request->input('rim_id');
        $UserHistory->date = $date;
        $UserHistory->time = $time;
        $UserHistory->save();
        
        $type = new RimHistory;
        $type->rim_id = $tire->id;
        $type->date = $date;
        $type->moved_from = 'Store';
        $type->moved_to = 'Trailer';
        $type->vehicle_id= $request->input('trailer_id');
        $type->attachment = $request->input("attachment");
        $type->remark = $request->input("remark");
        $type->save();
        
         // Redirect to the vehicle's details page or the index page
       session()->flash('success', 'Rim Added to vehicle Successfully');

       return redirect()->back();
    //   return redirect()->route('vehicles');
           
       }
            
                  
        
    
    
    public function store(Request $request)
{
    // Create a new trailer instance and populate it with request data
    // Validate the request data if needed
    // $this->validate($request, [
    //     // Add validation rules here
    // ]);
    
     $config = [
    [
        "axle" => "Front Axle",
        "no_tyre" => 2,
        "position" => "F",
        "battery_labels" => [
         "Battery1",
         "Battery2"
         ],
        "tire_labels_left" => ["FL0"],
        "tire_labels_right" => ["FR0"],
        "rim_labels_left" => ["RL0"],
        "rim_labels_right" => ["RR0"],
    ],
    [
        "axle" => "Rear Axle",
        "no_tyre" => 2,
        "position" => "R",
        "stepney_labels" => [
         "Stepney1",
         "Stepney2"
         ],
        "tire_labels_left" => ["RL0"],
        "tire_labels_right" => ["RR0"],
        "rim_labels_left" => ["RL0"],
        "rim_labels_right" => ["RR0"],
    ],
];


    // Create a new instance of the Trailer model
    $trailer = new Trailers();

    // Assign values from the request to the model fields
    $trailer->trailer_id = $request->input('trailer_id');
    $trailer->trailer_type = $request->input('trailer_type');
    $trailer->manufacturer = $request->input('manufacturer');
    $trailer->model = $request->input('model');
    $trailer->year = $request->input('year');
    $trailer->vin_no = $request->input('vin_no');
    $trailer->registration_number = $request->input('registration_number');
    $trailer->engine_applicable = $request->input('engine_applicable');
    $trailer->fuel_type = $request->input('fuel_type');
    $trailer->engine_type = $request->input('engine_type');
    $trailer->transmission_type = $request->input('transmission_type');
    $trailer->color = $request->input('color');
    $trailer->mileage = $request->input('mileage');
    $trailer->purchase_date = $request->input('purchase_date');
    $trailer->purchase_price = $request->input('purchase_price');
    $trailer->length = $request->input('length');
    $trailer->width = $request->input('width');
    $trailer->height = $request->input('height');
    $trailer->gvwr = $request->input('gvwr');
    $trailer->tare_weight = $request->input('tare_weight');
    $trailer->payload_capacity = $request->input('payload_capacity');
    $trailer->status = $request->input('status');
    $trailer->remarks = $request->input('remarks');
    $jsonData = json_encode($config);

    $trailer->axle_tyre_configuration = $jsonData;

    // Save the trailer to the database
    $trailer->save();
    
            // if ($request->file('photo')) {
        //     $photo = $request->file('image');
        //     $filename = time() . '.' . $photo->getClientOriginalExtension();
        //     $path = public_path('uploads');
        //     $photo->move($path, $filename);
        //     $trailer->image = $filename;
        // }

        $date = date('Y-m-d');
        $time = date('H:i:s'); 
        $user = Auth::user();
        $UserHistory = new UserHistory();
        $UserHistory->user_id = $user->id;
        $UserHistory->module = 'Trailer';
        $UserHistory->action_type = 'New Trailer Added';
        $UserHistory->item_id = $trailer->id;
        $UserHistory->date = $date;
        $UserHistory->time = $time;
        $UserHistory->save();
        


    // Redirect to the trailer's details page or the index page
    session()->flash('success', 'Trailer Added Successfully');
    return redirect()->route('trailer.configuration', $trailer->id);
}

    public function documents($id)
    {
        $document_type = DocumentType::all();
        $documents = TrailerDocuments::where('trailer_id', $id)->get();

        return view('trailer.trailer_documents', compact('id','documents', 'document_type'));
    }

    public function store_documents(Request $request)
    {

        $type = new TrailerDocuments;
        $type->trailer_id = $request->input("trailer_id");
        $type->document_type = $request->input("document_type");
        $type->id_number = $request->input("id_number");
        $type->issue_date = $request->input("issue_date");
        $type->expiry_date = $request->input("expiry_date");
        $type->renewal_date = $request->input("renewal_date");
        $type->remarks = $request->input("remarks");
        
        if ($request->file('attachment_file')) {
            $photo = $request->file('attachment_file');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $type->attachment_file = $filename;
        }

        $type->save();
        
        $date = date('Y-m-d');
        $time = date('H:i:s'); 
        $user = Auth::user();
        $UserHistory = new UserHistory();
        $UserHistory->user_id = $user->id;
        $UserHistory->module = 'Trailer';
        $UserHistory->action_type = 'Added Documents';
        $UserHistory->item_id = $type->id;
        $UserHistory->date = $date;
        $UserHistory->time = $time;
        $UserHistory->save();
        
        session()->flash('success', 'Trailer Documents added successfully.');
        return Redirect::back();
    }
    
    public function update_documents(Request $request)
    {
        $id = $request->input("trailer_id");

        $type = TrailerDocuments::find($id);
        $type->document_type = $request->input("document_type");
        $type->id_number = $request->input("id_number");
        $type->issue_date = $request->input("issue_date");
        $type->expiry_date = $request->input("expiry_date");
        $type->renewal_date = $request->input("renewal_date");
        $type->remarks = $request->input("remarks");
        
        if ($request->file('attachment_file')) {
            $photo = $request->file('attachment_file');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $type->attachment_file = $filename;
        }

        $type->save();
        
        $date = date('Y-m-d');
        $time = date('H:i:s'); 
        $user = Auth::user();
        $UserHistory = new UserHistory();
        $UserHistory->user_id = $user->id;
        $UserHistory->module = 'Trailer';
        $UserHistory->action_type = 'Updated Trailer Documents';
        $UserHistory->item_id = $type->id;
        $UserHistory->date = $date;
        $UserHistory->time = $time;
        $UserHistory->save();
        
        session()->flash('success', 'Trailer Documents updated successfully.');
        return Redirect::back();
    }


    
   
    public function image($id)
    {
        $trailer = Trailers::find($id);
        $image= $trailer->axle_tyre_configuration;
        $data = json_decode($image, true);


        return view('trailer.trailer_image', compact('id','data'));
    }
    
    public function configuration($id)
    {
        $trailer = Trailers::find($id);
        $image= $trailer->axle_tyre_configuration;
        $data = json_decode($image, true);


        return view('trailer.edit_configuration', compact('id','data', 'trailer'));
    }
    
    public function configuration_save(Request $request)
    {
      $axle_tyre_configuration=  $request->input('axle_tyre_configuration');
      $id=  $request->input('trailer_id');
        
        $trailer = Trailers::find($id);
        $trailer->axle_tyre_configuration = $axle_tyre_configuration;
        $trailer->save();
        // $data = json_decode($image, true);

        return Redirect::back();

        // return view('trailer.trailer_image', compact('data'));
    }

    public function show($id)
    {
        $trailer = Trailers::find($id);
        //dd($emp);
        return view('trailer.show', compact('trailer'));
    }
    
    public function history($id)
    {
        $history = TrailerHistory::where('trailer_id', $id)->get();
        //dd($emp);
        return view('trailer.history', compact('history'));
    }


    public function edit($id, Request $request)
    {
        $trailer = Trailers::find($id);
        $trailer_type = TrailerType::all();
        $trailer_brand = TrailerBrands::all();
        return view('trailer.edit', compact('trailer', 'trailer_type', 'trailer_brand'));

    }


    public function update(Request $request)
    {
       $id = $request->input('id');
    
        $trailer = Trailers::find($id);

    // Assign values from the request to the model fields
    $trailer->trailer_id = $request->input('trailer_id');
    $trailer->trailer_type = $request->input('trailer_type');
    $trailer->manufacturer = $request->input('manufacturer');
    $trailer->model = $request->input('model');
    $trailer->year = $request->input('year');
    $trailer->vin_no = $request->input('vin_no');
    $trailer->registration_number = $request->input('registration_number');
    $trailer->engine_applicable = $request->input('engine_applicable');
    $trailer->fuel_type = $request->input('fuel_type');
    $trailer->engine_type = $request->input('engine_type');
    $trailer->transmission_type = $request->input('transmission_type');
    $trailer->color = $request->input('color');
    $trailer->mileage = $request->input('mileage');
    $trailer->purchase_date = $request->input('purchase_date');
    $trailer->purchase_price = $request->input('purchase_price');
    $trailer->length = $request->input('length');
    $trailer->width = $request->input('width');
    $trailer->height = $request->input('height');
    $trailer->gvwr = $request->input('gvwr');
    $trailer->tare_weight = $request->input('tare_weight');
    $trailer->payload_capacity = $request->input('payload_capacity');
    $trailer->status = $request->input('status');
    $trailer->remarks = $request->input('remarks');

    // Save the trailer to the database
    $trailer->save();

    $date = date('Y-m-d');
        $time = date('H:i:s'); 
        $user = Auth::user();
        $UserHistory = new UserHistory();
        $UserHistory->user_id = $user->id;
        $UserHistory->module = 'Trailer';
        $UserHistory->action_type = 'Updated Trailer Details';
        $UserHistory->item_id = $trailer->id;
        $UserHistory->date = $date;
        $UserHistory->time = $time;
        $UserHistory->save();
        
     session()->flash('success', 'Trailer Updated Successfully');

      return Redirect::back();
    }

    public function destroy($id)
    {
        $tourPack = TourPackage::find($id);
        $tourPack->delete();
        session()->flash('success', 'You\'ve Deleted Tour Package Successfully');

        return Redirect::back();
    }
}
