<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\Rims\Rims;
use App\Models\Rims\RimHistory;
use App\Models\Inventory\RimInventory;
use App\Models\Inventory\InventoryHistory;
use Illuminate\Support\Facades\Redirect;

class RimController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index(Request $request)
    {
        $rims = Rims::orderBy('id', 'DESC')->get();
        return view('rim.index', compact('rims'));
    }


    public function create()
    {
         $tyres = RimInventory::all();
        return view('rim.create', compact('tyres'));
    }
    
    
    
    public function store(Request $request)
{
    
    $rim_id = $request->input('item_id');
    $inventory = RimInventory::find($rim_id);

    // Create a new tyre instance and populate it with request data
        // Validate the incoming request data
        // $request->validate([
        //     'rim_id' => 'required|string|max:255',
        //     'brand' => 'required|string|max:255',
        //     'model' => 'required|string|max:255',
        //     'size' => 'required|string|max:20',
        //     'bolt_pattern' => 'required|string|max:20',
        //     'offset' => 'required|string|max:20',
        //     'material' => 'required|string|max:255',
        //     'color_finish' => 'required|string|max:255',
        //     'purchase_date' => 'required|date',
        //     'purchase_price' => 'required|numeric',
        //     'installation_date' => 'required|date',
        //     'vehicle_id' => 'required|integer',
        //     'tire_id' => 'required|integer',
        //     'current_tire' => 'required|string|max:255',
        //     'mileage_at_installation' => 'required|integer',
        //     'current_mileage' => 'required|integer',
        //     'rim_condition' => 'required|string|max:50',
        //     'warranty_provider' => 'required|string|max:255',
        //     'warranty_start_date' => 'required|date',
        //     'warranty_end_date' => 'required|date',
        //     'notes_comments' => 'nullable|string',
        //     'status' => 'required|string|max:50',
        // ]);

        // Create a new rim record
$rim = new Rims();
$rim->rim_id = $request->input('rim_id');
$rim->brand = $inventory->brand;
$rim->model = $inventory->model;
$rim->size = $inventory->size;
$rim->bolt_pattern = $inventory->bolt_pattern;
$rim->offset = $inventory->offset;
$rim->material = $inventory->material;
$rim->color_finish = $inventory->color_finish;
$rim->purchase_date = $inventory->purchase_date;
$rim->purchase_price = $inventory->purchase_price;
$rim->installation_date = $inventory->installation_date;
$rim->vehicle_id = $inventory->vehicle_id;
$rim->tire_id = $inventory->tire_id;
$rim->current_tire = $inventory->current_tire;
$rim->mileage_at_installation = $inventory->mileage_at_installation;
$rim->rim_condition = $inventory->rim_condition;
$rim->warranty_provider = $inventory->warranty_provider;
$rim->warranty_start_date = $inventory->warranty_start_date;
$rim->warranty_end_date = $inventory->warranty_end_date;
$rim->notes_comments = $inventory->notes_comments;
$rim->status = $inventory->status;
// Save the rim record
$rim->save();
    
    $date = date('Y-m-d');
    
    $inventoryHistory = new InventoryHistory;
    $inventoryHistory->date = $date;
    $inventoryHistory->inventory_id = $request->input('item_id');
    $inventoryHistory->item_code = $request->input('tire_id');
    $inventoryHistory->save();

    


    // Redirect to the tyre's details page or the index page
    session()->flash('success', 'Rim Added Successfully');
    return redirect()->route('rim');
}

    
   

    public function show($id)
    {
        $tire = Rims::find($id);
        //dd($emp);
        return view('rim.view', compact('tire'));
    }


    public function edit($id, Request $request)
    {
        $rim = Rims::find($id);

        return view('rim.edit', compact('rim'));
    }


    public function update($id, Request $request)
    {
        $tyre = Rims::find($id);
       
        $tyre->status = $request->input("status") ? "Active" : "Inactive";
        $tyre->save();
        session()->flash('success', 'Rim Updated Successfully');

        return Redirect::back();
    }

    public function destroy($id)
    {
        $tyre = Rims::find($id);
        $tyre->delete();
        session()->flash('success', 'Rim Deleted Successfully');

        return Redirect::back();
    }
}
