<!DOCTYPE html>
<html lang="en">
<head>

  <meta charset="utf-8">
  <title>TMS | Inspect Vehicles</title>

  <!-- Mobile Specific Metas
  ================================================== -->
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=5.0">
  <meta name="description" content="Create your ecommerce store">
  <meta name="author" content="TMS">

  <!-- Favicon -->
  <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('public/user/images/favicon.png')); ?>" />
    <!--<link rel="stylesheet" href="https://tms.vokks.in/assets/css/style.css">-->
  <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">
  
  <!-- PLUGINS CSS STYLE -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.2/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.css" integrity="sha512-wR4oNhLBHf7smjy0K4oqzdWumd+r5/+6QO/vDda76MW5iug4PT7v86FoEkySIJft3XA0Ae6axhIvHrqwm793Nw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.css" integrity="sha512-6lLUdeQ5uheMFbWm3CP271l14RsX1xtx+J5x2yeIDkkiBpeVTNhTqijME7GgRKKi6hCqovwCoBTlRBEC20M8Mg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<!--   <link rel="stylesheet" href="plugins/aos/aos.css">
 -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css" integrity="sha512-xh6O/CkQoPOWDdYTDqeRdPCVd1SpvCA9XXcUnZS2FmJNp1coAFzvtCN9BmamE+4aHK8yyUHUSCcJHgXloTyT2A==" crossorigin="anonymous" referrerpolicy="no-referrer" />

  <link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Alata&family=Outfit&display=swap" rel="stylesheet">

  <!-- CUSTOM CSS -->
  <link href="<?php echo e(asset('public/user/css/styles.css')); ?>" rel="stylesheet">

<style>
    .btn-black{
     background-color: #000!important;
 }
 a {
     text-decoration: none!important;
 }
</style>

 <style>
        /* Vehicle Container */
        .front {
            display: flex;
            align-items: center;
        }

        /* Left Wheel */
        .wheel {
            width: 25px;
            height: 60px;
            background: radial-gradient(#b5aeae, #312e2e);
            border-radius: 20px;
            margin: 0 5px;
        }
        .wheel-danger{
            background: radial-gradient(#f7f7f7, #ed1010)!important;
        }
        .wheel-zero{
            background: radial-gradient(#f7f7f7, #d1b9b9)!important;
        }
        .wheel-green{
            background: radial-gradient(#f7f7f7, #27a511)!important;
        }
        
        .rim {
            width: 10px;
    height: 30px;
    background: radial-gradient(#b5aeae, #a19999);
    border-radius: 20px;
    margin: 0 5px;
        }

        /* Vehicle Body */
        .body {
            width: 100px;
            height: 40px;
            background-color: #333;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        /* Middle Bar */
        .bar {
            width: 10px;
            height: 40px;
            background-color: #333;
        }
        .vehicle{
            display: flex;
    flex-direction: column;
    align-items: center;
        }
        .space{
            width: 0px;
            margin: 30px auto;
        }
        .rod{
            width: 20px;
    height: 100px;
    background: darkgray;
    border: 2px solid #c1a1a1;
        }
    </style>


<style>
    label.card-title {
    font-family: "Inter", sans-serif;
    color: #000;
    font-size: 20px;
  }
</style>

</head>

<body style="background: aliceblue;" class="body-wrapper" data-spy="scroll" data-target=".privacy-nav">


<nav style="padding: 15px 0px!important;" class="navbar navbar-expand-lg sticky-top bg-white shadow-sm">
  <div class="container">
    <a class="navbar-brand m-auto" href="#"><img style="width:150px!important;" src="https://tab-tms.codesquarry.online/assets/images/logo.png"   alt="logo"></a>
    <!--<button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">-->
    <!--  <span class="navbar-toggler-icon"></span>-->
    <!--</button>-->
    <!--<div class="collapse navbar-collapse" id="navbarNav">-->
    <!--  <ul style="margin-left: auto;" class="navbar-nav ml-auto">-->
    <!--    <li class="nav-item">-->
    <!--      <a class="nav-link active" aria-current="page" href="#">Home</a>-->
    <!--    </li>-->
        
    <!--    <li class="nav-item">-->
    <!--      <a class="nav-link" href="#about">About</a>-->
    <!--    </li>-->
    <!--    <li class="nav-item">-->
    <!--      <a class="nav-link" href="#contact">Contact</a>-->
    <!--    </li>-->
        
    <!--  </ul>-->
    <!--</div>-->
  </div>
</nav>

<!--====================================
=            Hero Section            =
=====================================-->

<section style="margin-top: 0px!important; background: teal;" class="booking-section py-5 text-white" id="book_now">
                <h1 class="text-center">Tyre ID: <?php echo e($tire->tire_id); ?></h1>
                <div class="container-fluid">

<div class="row g-3" id="assigned">

<div class="row g-3">

      <div class="col-6 col-xl-3">
        <div class="card card-one">
          <div class="card-body">
            <label class="card-title fs-sm fw-medium mb-1">Tread Depth</label>
            <h3 class="card-value mb-1"><i class="ri-tire-line"></i> <?php echo e($tire->tread_depth); ?></h3>
            <!--<small><span class="d-inline-flex text-danger">0.7% <i class="ri-arrow-down-line"></i></span> than last week</small>-->
          </div><!-- card-body -->
        </div><!-- card-one -->
      </div><!-- col -->
      <div class="col-6 col-xl-3">
        <div class="card card-one">
          <div class="card-body">
            <label class="card-title fs-sm fw-medium mb-1">Pressure</label>
            <h3 class="card-value mb-1"><i class="ri-psi-line"></i> <span></span> <?php echo e($tire->inflation_pressure); ?></h3>
            <!--<small><span class="d-inline-flex text-success">2.1% <i class="ri-arrow-up-line"></i></span> than last week</small>-->
          </div><!-- card-body -->
        </div><!-- card-one -->
      </div><!-- col -->
      <div class="col-6 col-xl-3">
        <div class="card card-one">
          <div class="card-body">
            <label class="card-title fs-sm fw-medium mb-1">Condition</label>
            <h3 class="card-value mb-1"><i class="ri-file-list-3-line"></i> <?php echo e($tire->tire_condition); ?></h3>
            <!--<small><span class="d-inline-flex text-danger">0.3% <i class="ri-arrow-down-line"></i></span> than last week</small>-->
          </div><!-- card-body -->
        </div><!-- card-one -->
      </div><!-- col -->
      <div class="col-6 col-xl-3">
        <div class="card card-one">
          <div class="card-body">
            <label class="card-title fs-sm fw-medium mb-1">Rolling Kilomenter</label>
            <h3 class="card-value mb-1"><i class="ri-road-map-line"></i>Current: <?php echo e($tire->current_mileage); ?> Max: 10000 <span></span></h3>
            <!--<small><span class="d-inline-flex text-success">1.2% <i class="ri-arrow-up-line"></i></span> than last week</small>-->
          </div><!-- card-body -->
        </div><!-- card-one -->
      </div><!-- col -->
      <div class="col-6 col-xl-3">
        <div class="card card-one">
          <div class="card-body">
            <label class="card-title fs-sm fw-medium mb-1">Status</label>
            <h3 class="card-value mb-1"><i class="ri-road-map-line"></i> In <?php echo e($tire->location_status); ?> <span></span></h3>
            <!--<small><span class="d-inline-flex text-success">1.2% <i class="ri-arrow-up-line"></i></span> than last week</small>-->
          </div><!-- card-body -->
        </div><!-- card-one -->
      </div><!-- col -->
      <div class="col-6 col-xl-3">
        <div class="card card-one">
          <div class="card-body">
            <label class="card-title fs-sm fw-medium mb-1">Action</label>
            <h3 class="card-value mb-1"><i class="ri-road-map-line"></i>
            <?php if($action_needed==''): ?>
             No action required
            <?php else: ?>
            <?php echo e($action_needed); ?>

            <?php endif; ?>
            <span></span></h3>
            <!--<small><span class="d-inline-flex text-success">1.2% <i class="ri-arrow-up-line"></i></span> than last week</small>-->
          </div><!-- card-body -->
        </div><!-- card-one -->
      </div><!-- col -->
      
      <?php if($tire->location_status=='Vehicle'): ?>
      <div class="col-6 col-xl-3">
          <a style="color: none;" href="/tyre/position/<?php echo e($tire->id); ?>/<?php echo e($tire->position_on_vehicle); ?>">
        <div class="card card-one">
          <div class="card-body">
            <label class="card-title fs-sm fw-medium mb-1">Tyre Position</label>
            <h3 class="card-value mb-1">Position: <?php echo e($tire->position_on_vehicle); ?> <span></span></h3>
            <!--<small><span class="d-inline-flex text-success">1.2% <i class="ri-arrow-up-line"></i></span> than last week</small>-->
          </div><!-- card-body -->
        </div><!-- card-one -->
        </a>
      </div><!-- col -->
      
      <div class="col-6 col-xl-3">
          <a style="color: none;" href="/vehicle/image/<?php echo e($tire->vehicle_id); ?>">
        <div class="card card-one">
          <div class="card-body">
            <label class="card-title fs-sm fw-medium mb-1">Vehicle ID</label>
            <h3 class="card-value mb-1">Position: <?php echo e($tire->vehicle_id); ?> <span></span></h3>
            <!--<small><span class="d-inline-flex text-success">1.2% <i class="ri-arrow-up-line"></i></span> than last week</small>-->
          </div><!-- card-body -->
        </div><!-- card-one -->
        </a>
      </div><!-- col -->

      <?php endif; ?>
      
      </div>
      
      <div class="col-md-6 col-xl-4">
        <div class="card card-one">
          <div class="card-header">
            <h6 class="card-title">Tyre History</h6>
            <nav class="nav nav-icon nav-icon-sm ms-auto">
              <!--<a href="" class="nav-link"><i class="ri-refresh-line"></i></a>-->
              <!--<a href="" class="nav-link"><i class="ri-more-2-fill"></i></a>-->
              <!--<a class="btn btn-primary btn-black" data-bs-toggle="modal" data-bs-target="#actionBtn">Action</a>-->
            </nav>
          </div><!-- card-header -->
          <div class="card-body p-0">
            <ul class="people-group">
              <?php $__currentLoopData = $tire_history; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data1): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              
              <?php
                $createdDate = \Carbon\Carbon::parse($data1->created_at);
              ?>

              <li class="people-item">
                <div class="avatar"><span class="avatar-initial bg-primary fs-20"><i class="ri-truck-line"></i></span></div>
                <div class="people-body">
                  <h6><a href="">Moved to <?php echo e($data1->moved_to); ?> from <?php echo e($data1->moved_from); ?></a></h6>
                  <span><?php echo e($createdDate->format('M d, Y, g:ia')); ?></span>

                </div><!-- people-body -->
                <div class="text-end">
                  <div class="fs-sm"> <?php echo e($data1->cost); ?></div>
                  <!--<span class="d-block fs-xs text-success">Completed</span>-->
                </div>
              </li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
          </div><!-- card-body -->
          <div class="card-footer d-flex justify-content-center">
            <a href="/dashboard/tyre/history/<?php echo e($tire->id); ?>" class="fs-sm">View all</a>
          </div><!-- card-footer -->
        </div><!-- card -->
      </div><!-- col -->
      <div class="col-md-6 col-xl-4">
        <div class="card card-one">
          <div class="card-header">
            <h6 class="card-title">Service History</h6>
            <nav class="nav nav-icon nav-icon-sm ms-auto">
              <!--<a href="" class="nav-link"><i class="ri-refresh-line"></i></a>-->
              <!--<a href="" class="nav-link"><i class="ri-more-2-fill"></i></a>-->
              <a class="btn btn-primary btn-black btn-black" data-bs-toggle="modal" data-bs-target="#addService">Add</a>
            </nav>
          </div><!-- card-header -->
          <div class="card-body p-0">
            <ul class="people-group">
             
              <?php $__currentLoopData = $service_history; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              
              <?php
                $createdDate = \Carbon\Carbon::parse($data->created_at);
              ?>

              <li class="people-item">
                <div class="avatar"><span class="avatar-initial bg-primary fs-20"><i class="ri-truck-line"></i></span></div>
                <div class="people-body">
                  <h6><a href=""><?php echo e($data->service_type); ?></a></h6>
                  <span><?php echo e($createdDate->format('M d, Y, g:ia')); ?></span>

                </div><!-- people-body -->
                <div class="text-end">
                  <div class="fs-sm"> <?php echo e($data->cost); ?></div>
                  <!--<span class="d-block fs-xs text-success">Completed</span>-->
                </div>
              </li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
          </div><!-- card-body -->
          <div class="card-footer d-flex justify-content-center">
            <a href="/dashboard/tyre/service/history/<?php echo e($tire->id); ?>" class="fs-sm">View all</a>
          </div><!-- card-footer -->
        </div><!-- card -->
      </div><!-- col -->
      <div class="col-md-6 col-xl-4">
        <div class="card card-one">
          <div class="card-header">
            <h6 class="card-title">Inspection History</h6>
            <nav class="nav nav-icon nav-icon-sm ms-auto">
              <!--<a href="" class="nav-link"><i class="ri-refresh-line"></i></a>-->
              <!--<a href="" class="nav-link"><i class="ri-more-2-fill"></i></a>-->
              <a class="btn btn-primary btn-black" data-bs-toggle="modal" data-bs-target="#inspectionBtn">Add</a>
            </nav>
          </div><!-- card-header -->
          <div class="card-body p-0">
            <ul class="people-group">
              <?php $__currentLoopData = $inspection_history; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              
              <?php
                $createdDate = \Carbon\Carbon::parse($data->created_at);
              ?>

              <li class="people-item">
                <div class="avatar"><span class="avatar-initial bg-primary fs-20"><i class="ri-truck-line"></i></span></div>
                <div class="people-body">
                  <h6><a href="">Condition: <?php echo e($data->tire_condition); ?></a></h6>
                  <span><?php echo e($createdDate->format('M d, Y, g:ia')); ?></span>

                </div><!-- people-body -->
                <div class="text-end">
                  <div class="fs-sm"> <?php echo e($data->cost); ?></div>
                  <!--<span class="d-block fs-xs text-success">Completed</span>-->
                </div>
              </li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
          </div><!-- card-body -->
          <div class="card-footer d-flex justify-content-center">
            <a href="/dashboard/tyre/inspection/history/<?php echo e($tire->id); ?>" class="fs-sm">View all</a>
          </div><!-- card-footer -->
        </div><!-- card -->
      </div><!-- col -->

      <div class="col-md-6 col-xl-12">
        <div class="card card-one">
          <div class="card-header">
            <h6 class="card-title">Basic Details</h6>
            <!--<nav class="nav nav-icon nav-icon-sm ms-auto">-->
            <!--  <a href="" class="nav-link"><i class="ri-refresh-line"></i></a>-->
            <!--  <a href="" class="nav-link"><i class="ri-more-2-fill"></i></a>-->
            <!--</nav>-->
          </div><!-- card-header -->
          <div class="card-body">
            
                      <form action="<?php echo e(route('tyres', ['id' => $tire->id])); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Brand</label>
                        <input type="text" name="brand" placeholder="Brand" class="form-control" value="<?php echo e($tire->brand); ?>" readonly />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Model</label>
                        <input type="text" name="model" placeholder="Model" class="form-control" value="<?php echo e($tire->model); ?>" readonly />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Size</label>
                        <input type="text" name="size" placeholder="Size" class="form-control" value="<?php echo e($tire->size); ?>" readonly />
                    </div>
                </div>
              
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Purchase Date</label>
                        <input type="date" name="purchase_date" class="form-control" value="<?php echo e($tire->purchase_date); ?>" readonly />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Purchase Cost</label>
                        <input type="number" name="purchase_cost" placeholder="Purchase Cost" class="form-control" step="0.01" value="<?php echo e($tire->purchase_cost); ?>" readonly />
                    </div>
                </div>
                <!--<div class="col-sm-4">-->
                <!--    <div class="mb-3">-->
                <!--        <label class="form-label">Installation Date</label>-->
                <!--        <input type="date" name="installation_date" class="form-control" value="<?php echo e($tire->installation_date); ?>" readonly />-->
                <!--    </div>-->
                <!--</div>-->
                <!--<div class="col-sm-4">-->
                <!--    <div class="mb-3">-->
                <!--        <label class="form-label">Vehicle ID</label>-->
                <!--        <input type="number" name="vehicle_id" placeholder="Vehicle ID" class="form-control" value="<?php echo e($tire->vehicle_id); ?>" readonly />-->
                <!--    </div>-->
                <!--</div>-->
                <!--<div class="col-sm-4">-->
                <!--    <div class="mb-3">-->
                <!--        <label class="form-label">Position on Vehicle</label>-->
                <!--        <input type="text" name="position_on_vehicle" placeholder="Position on Vehicle" class="form-control" value="<?php echo e($tire->position_on_vehicle); ?>" readonly />-->
                <!--    </div>-->
                <!--</div>-->
                
                <!--<div class="col-sm-4">-->
                <!--    <div class="mb-3">-->
                <!--        <label class="form-label">Temperature</label>-->
                <!--        <input type="number" name="temperature" placeholder="Temperature" class="form-control" step="0.1" value="<?php echo e($tire->temperature); ?>" readonly />-->
                <!--    </div>-->
                <!--</div>-->
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Load Rating</label>
                        <input type="text" name="load_rating" placeholder="Load Rating" class="form-control" value="<?php echo e($tire->load_rating); ?>" readonly />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Speed Rating</label>
                        <input type="text" name="speed_rating" placeholder="Speed Rating" class="form-control" value="<?php echo e($tire->speed_rating); ?>" readonly />
                    </div>
                </div>
                <!--<div class="col-sm-4">-->
                <!--    <div class="mb-3">-->
                <!--        <label class="form-label">DOT Number</label>-->
                <!--        <input type="text" name="dot_number" placeholder="DOT Number" class="form-control" value="<?php echo e($tire->dot_number); ?>" readonly />-->
                <!--    </div>-->
                <!--</div>-->
                <!-- <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Status</label>
                        <input type="text" name="status" placeholder="Status" class="form-control" value="<?php echo e($tire->status); ?>" readonly />
                    </div>
                </div> -->
                
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Warranty Type</label>
                        <input type="text" name="warranty_type" placeholder="Warranty Type" class="form-control" value="<?php echo e($tire->warranty_type); ?>" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Warranty Start Date</label>
                        <input type="date" name="warranty_start_date" class="form-control" value="<?php echo e($tire->warranty_start_date); ?>" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Warranty End Date</label>
                        <input type="date" name="warranty_end_date" class="form-control" value="<?php echo e($tire->warranty_end_date); ?>" />
                    </div>
                </div>
                
                
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Commercial Name</label>
                        <input type="text" name="commercial_name" placeholder="Commercial Name" class="form-control" value="<?php echo e($tire->commercial_name); ?>" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Identity</label>
                        <input type="text" name="identity" placeholder="Identity" class="form-control" value="<?php echo e($tire->identity); ?>" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Load Pressure Information</label>
                        <input type="text" name="load_pressure_information" placeholder="Load Pressure Information" class="form-control" value="<?php echo e($tire->load_pressure_information); ?>" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Indicated Exterior</label>
                        <input type="text" name="indicated_exterior" placeholder="Indicated Exterior" class="form-control" value="<?php echo e($tire->indicated_exterior); ?>" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Type of Construction</label>
                        <input type="text" name="type_of_construction" placeholder="Type of Construction" class="form-control" value="<?php echo e($tire->type_of_construction); ?>" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Tyre Sections Width (mm)</label>
                        <input type="number" name="tyre_sections_width_mm" placeholder="Tyre Sections Width (mm)" class="form-control" step="0.01" value="<?php echo e($tire->tyre_sections_width_mm); ?>" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Section Height to Section Width Ratio</label>
                        <input type="number" name="section_height_to_section_width_ratio" placeholder="Section Height to Section Width Ratio" class="form-control" step="0.01" value="<?php echo e($tire->section_height_to_section_width_ratio); ?>" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Rim Diameter (inches)</label>
                        <input type="number" name="rim_diameter_inches" placeholder="Rim Diameter (inches)" class="form-control" step="0.01" value="<?php echo e($tire->rim_diameter_inches); ?>" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Load Capacity Index</label>
                        <input type="text" name="load_capacity_index" placeholder="Load Capacity Index" class="form-control" value="<?php echo e($tire->load_capacity_index); ?>" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Tyre Type</label>
                        <select name="tyre_type" class="form-control">
                            <option value="Tubeless" <?php if($tire->tyre_type == 'Tubeless'): ?> selected <?php endif; ?>>Tubeless</option>
                            <option value="Tube" <?php if($tire->tyre_type == 'Tube'): ?> selected <?php endif; ?>>Tube</option>
                        </select>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="mb-3">
                        <label class="form-label">Remarks</label>
                        <textarea name="remarks" placeholder="Remarks" class="form-control"><?php echo e($tire->remarks); ?></textarea>
                    </div>
                </div>
            </div>
            <!--<div class="text-center mt-4">-->
            <!--    <button type="submit" class="btn btn-primary btn-black">Update Tire</button>-->
            <!--</div>-->
        </form>

            
          </div><!-- card-body -->
        </div><!-- card -->
      </div><!-- col -->
      <div style="display:none;" class="col-md-6 col-xl-5">
        <div class="card card-one">
          <div class="card-header">
            <h6 class="card-title">Tyre Position</h6>
            <nav class="nav nav-icon nav-icon-sm ms-auto">
              <!--<a href="" class="nav-link"><i class="ri-refresh-line"></i></a>-->
              <!--<a href="" class="nav-link"><i class="ri-more-2-fill"></i></a>-->
            </nav>
          </div><!-- card-header -->
          <div class="card-body">
            
          <!-- image tyre start-->

          

    <div class="col-lg-7">
        <div style="text-align: center;"><h4>Position Code: <?php echo e($position); ?></h4></div>
        <div class="space">
        
    <!-- <label for="noTireInput">Enter Number of Tires: </label>
    <input type="number" id="noTireInput" placeholder="Number of Tires"> -->
    
    

    <div class="vehicle" style="float: left;">
        
        <!-- JavaScript code to generate the axle sections -->

        <script>
            var vehicleData = [
            {
                axle: 'Front Axle',
                no_tyre: 2,
                position: 'F',
                tire_labels_left: ['FL0', 'FL1'],
                tire_labels_right: ['FR0', 'FR1'],
            },
            {
                axle: 'Middle Axle',
                no_tyre: 2,
                position: 'M',
                tire_labels_left: ['ML0', 'ML1'],
                tire_labels_right: ['MR0', 'MR1'],
            },
            {
                axle: 'Rear Axle',
                no_tyre: 2,
                position: 'R',
                tire_labels_left: ['RL0', 'RL1'],
                tire_labels_right: ['RR0', 'RR1'],
            }
        ];
        
        var position= '<?php echo e($position); ?>';
        console.log('po', position)

        function installVehicle(position) {

            // Function to generate the HTML structure for the front axle
            function generateFrontAxleHTML(data) {
                var frontAxleDiv = document.createElement('div');
                frontAxleDiv.className = 'front';

                data.tire_labels_left.forEach(function (label) {
                    var leftTireDiv = document.createElement('div');
                    leftTireDiv.style.display = 'flex';
                    leftTireDiv.style.flexDirection = 'column';
                    leftTireDiv.textContent = label;

                    var leftTireLink = document.createElement('a');
                    leftTireLink.href = '/wheeles/1';

 var leftWheelDiv = document.createElement('div');
                    leftWheelDiv.className = 'wheel';
                    

                    if(label==position){
                        var leftWheelDiv = document.createElement('div');
                    leftWheelDiv.className = 'wheel wheel-danger';
                        
                        var wheelMarker = document.createElement('div');
                        wheelMarker.className = 'wheel-marker';

                        leftWheelDiv.appendChild(wheelMarker); 
                    }
                    
                    leftTireLink.appendChild(leftWheelDiv);
                    leftTireDiv.appendChild(leftTireLink);
                    frontAxleDiv.appendChild(leftTireDiv);

                    var leftTireDiv = document.createElement('div');
                    leftTireDiv.style.display = 'flex';
                    leftTireDiv.style.alignItems = 'center';
                    leftTireDiv.style.flexDirection = 'column';
                    leftTireDiv.textContent = label;

                    var leftTireLink = document.createElement('a');
                    leftTireLink.href = '/wheeles/1';

                    var leftWheelDiv = document.createElement('div');
                    leftWheelDiv.className = 'rim';

                    // leftTireLink.appendChild(leftWheelDiv);
                    leftTireDiv.appendChild(leftWheelDiv);
                    frontAxleDiv.appendChild(leftTireDiv);

                });

                var middleDiv = document.createElement('div');
                middleDiv.style.width = '100px';
                middleDiv.style.background = 'darkgray';
                middleDiv.style.height = '10px';
                middleDiv.style.borderRadius = '10px';
                middleDiv.style.border = '1px solid #c1a1a1';
                middleDiv.style.marginTop = '16px';

                var middleInnerDiv = document.createElement('div');
                middleInnerDiv.style.width = '20px';
                middleInnerDiv.style.background = 'darkgray';
                middleInnerDiv.style.height = '50px';
                middleInnerDiv.style.border = '2px solid #c1a1a1';
                middleInnerDiv.style.margin = 'auto';

                var middleInnerDiv1 = document.createElement('div');
                middleInnerDiv1.className = 'tyre_btn';
                middleInnerDiv1.setAttribute('data-position', data.position);
                middleInnerDiv1.style.width = '40px';
                middleInnerDiv1.style.background = 'black';
                middleInnerDiv1.style.height = '40px';
                middleInnerDiv1.style.border = '2px solid #c1a1a1';
                middleInnerDiv1.style.margin = 'auto';
                middleInnerDiv1.style.position = 'relative';
                middleInnerDiv1.style.top = '-20px';
                middleInnerDiv1.style.right = '12px';
                middleInnerDiv1.style.borderRadius = '30px';
                middleInnerDiv1.style.display = 'flex';
                middleInnerDiv1.style.color = '#fff';
                middleInnerDiv1.style.justifyContent = 'center';
                middleInnerDiv1.style.alignItems = 'center';
                middleInnerDiv1.style.fontSize = '40px';
                if(data.no_tyre==2){
                  middleInnerDiv1.textContent='+';                    
                }
                else{
                  middleInnerDiv1.textContent='-';                    

                }
                
                // Create the <i> element
            //     var addElement = document.createElement('i');
            //     addElement.className = 'ri-add-line';
            //     addElement.style.fontSize = '40px';
                
            //      var removeElement = document.createElement('i');
            //     removeElement.className = 'ri-subtract-line';
            //     removeElement.style.fontSize = '40px';

            //   // Append the <i> element under the first rod

            //     if(data.no_tyre==2){
            //     //   middleInnerDiv1.textContent='+';                    
            //          middleInnerDiv1.appendChild(addElement);
            //     }
            //     else{
            //     //   middleInnerDiv1.textContent='-';                    
            //          middleInnerDiv1.appendChild(removeElement);

            //     }
                

                middleInnerDiv.appendChild(middleInnerDiv1);

                middleDiv.appendChild(middleInnerDiv);
                frontAxleDiv.appendChild(middleDiv);

                data.tire_labels_right.forEach(function (label) {

                    var rightTireDiv = document.createElement('div');
                    rightTireDiv.style.display = 'flex';
                    rightTireDiv.style.alignItems = 'center';
                    rightTireDiv.style.flexDirection = 'column';
                    rightTireDiv.textContent = label;

                    var rightTireLink = document.createElement('a');
                    rightTireLink.href = '/wheeles/1';

                    var rightWheelDiv = document.createElement('div');
                    rightWheelDiv.className = 'rim';

                    // rightTireLink.appendChild(rightWheelDiv);
                    rightTireDiv.appendChild(rightWheelDiv);
                    frontAxleDiv.appendChild(rightTireDiv);


                    var rightTireDiv = document.createElement('div');
                    rightTireDiv.style.display = 'flex';
                    rightTireDiv.style.flexDirection = 'column';
                    rightTireDiv.textContent = label;

                    var rightTireLink = document.createElement('a');
                    rightTireLink.href = '/wheeles/1';

                    var rightWheelDiv = document.createElement('div');
                    rightWheelDiv.className = 'wheel';

                    rightTireLink.appendChild(rightWheelDiv);
                    rightTireDiv.appendChild(rightTireLink);
                    frontAxleDiv.appendChild(rightTireDiv);
                });

                var rodDiv = document.createElement('div');
                rodDiv.className = 'rod';

                var vehicleContainer = document.querySelector('.vehicle');
                vehicleContainer.appendChild(frontAxleDiv);
                vehicleContainer.appendChild(rodDiv);
            }

            // Function to generate the HTML structure for the middle axle
            function generateMiddleAxleHTML(data) {
                var middleAxleDiv = document.createElement('div');
                middleAxleDiv.className = 'front';

                data.tire_labels_left.forEach(function (label) {
                    var leftTireDiv = document.createElement('div');
                    leftTireDiv.style.display = 'flex';
                    leftTireDiv.style.flexDirection = 'column';
                    leftTireDiv.textContent = label;

                    var leftTireLink = document.createElement('a');
                    leftTireLink.href = '/wheeles/1';

                    var leftWheelDiv = document.createElement('div');
                    leftWheelDiv.className = 'wheel';

                    leftTireLink.appendChild(leftWheelDiv);
                    leftTireDiv.appendChild(leftTireLink);
                    middleAxleDiv.appendChild(leftTireDiv);

                    var leftTireDiv = document.createElement('div');
                    leftTireDiv.style.display = 'flex';
                    leftTireDiv.style.alignItems = 'center';
                    leftTireDiv.style.flexDirection = 'column';
                    leftTireDiv.textContent = label;

                    var leftTireLink = document.createElement('a');
                    leftTireLink.href = '/wheeles/1';

                    var leftWheelDiv = document.createElement('div');
                    leftWheelDiv.className = 'rim';

                    leftTireLink.appendChild(leftWheelDiv);
                    leftTireDiv.appendChild(leftTireLink);
                    middleAxleDiv.appendChild(leftTireDiv);
                });
                

                var middleDiv = document.createElement('div');
                middleDiv.style.width = '100px';
                middleDiv.style.background = 'darkgray';
                middleDiv.style.height = '10px';
                middleDiv.style.borderRadius = '10px';
                middleDiv.style.border = '1px solid #c1a1a1';
                middleDiv.style.marginTop = '16px';

                var middleInnerDiv = document.createElement('div');
                middleInnerDiv.style.width = '20px';
                middleInnerDiv.style.background = 'darkgray';
                middleInnerDiv.style.height = '100px';
                middleInnerDiv.style.border = '2px solid #c1a1a1';
                middleInnerDiv.style.margin = 'auto';
                middleInnerDiv.style.position = 'relative';
                middleInnerDiv.style.bottom = '50px';

                var middleInnerDiv1 = document.createElement('div');
                middleInnerDiv1.className = 'tyre_btn';
                middleInnerDiv1.setAttribute('data-position', data.position);
                middleInnerDiv1.style.width = '40px';
                middleInnerDiv1.style.background = 'black';
                middleInnerDiv1.style.height = '40px';
                middleInnerDiv1.style.border = '2px solid #c1a1a1';
                middleInnerDiv1.style.margin = 'auto';
                middleInnerDiv1.style.position = 'relative';
                middleInnerDiv1.style.top = '30px';
                middleInnerDiv1.style.right = '12px';
                middleInnerDiv1.style.borderRadius = '30px';
                middleInnerDiv1.style.display = 'flex';
                middleInnerDiv1.style.color = '#fff';
                middleInnerDiv1.style.justifyContent = 'center';
                middleInnerDiv1.style.alignItems = 'center';
                middleInnerDiv1.style.fontSize = '40px';
                if(data.no_tyre==2){
                  middleInnerDiv1.textContent='+';                    
                }
                else{
                  middleInnerDiv1.textContent='-';                    

                }

                middleInnerDiv.appendChild(middleInnerDiv1);

                middleDiv.appendChild(middleInnerDiv);
                middleAxleDiv.appendChild(middleDiv);

                data.tire_labels_right.forEach(function (label) {
                    var rightTireDiv = document.createElement('div');
                    rightTireDiv.style.display = 'flex';
                    rightTireDiv.style.alignItems = 'center';
                    rightTireDiv.style.flexDirection = 'column';
                    rightTireDiv.textContent = label;

                    var rightTireLink = document.createElement('a');
                    rightTireLink.href = '/wheeles/1';

                    var rightWheelDiv = document.createElement('div');
                    rightWheelDiv.className = 'rim';

                    rightTireLink.appendChild(rightWheelDiv);
                    rightTireDiv.appendChild(rightTireLink);
                    middleAxleDiv.appendChild(rightTireDiv);


                    var rightTireDiv = document.createElement('div');
                    rightTireDiv.style.display = 'flex';
                    rightTireDiv.style.flexDirection = 'column';
                    rightTireDiv.textContent = label;

                    var rightTireLink = document.createElement('a');
                    rightTireLink.href = '/wheeles/1';

                    var rightWheelDiv = document.createElement('div');
                    rightWheelDiv.className = 'wheel';

                    rightTireLink.appendChild(rightWheelDiv);
                    rightTireDiv.appendChild(rightTireLink);
                    middleAxleDiv.appendChild(rightTireDiv);
                });

                var rodDiv = document.createElement('div');
                rodDiv.className = 'rod';

                var vehicleContainer = document.querySelector('.vehicle');
                vehicleContainer.appendChild(middleAxleDiv);
                vehicleContainer.appendChild(rodDiv);
            }

            // Function to generate the HTML structure for the rear axle
            function generateRearAxleHTML(data) {
                var rearAxleDiv = document.createElement('div');
                rearAxleDiv.className = 'front';

                data.tire_labels_left.forEach(function (label) {
                    var leftTireDiv = document.createElement('div');
                    leftTireDiv.style.display = 'flex';
                    leftTireDiv.style.flexDirection = 'column';
                    leftTireDiv.textContent = label;

                    var leftTireLink = document.createElement('a');
                    leftTireLink.href = '/wheeles/1';

                    var leftWheelDiv = document.createElement('div');
                    leftWheelDiv.className = 'wheel';

                    leftTireLink.appendChild(leftWheelDiv);
                    leftTireDiv.appendChild(leftTireLink);
                    rearAxleDiv.appendChild(leftTireDiv);


                    var leftTireDiv = document.createElement('div');
                    leftTireDiv.style.display = 'flex';
                    leftTireDiv.style.alignItems = 'center';
                    leftTireDiv.style.flexDirection = 'column';
                    leftTireDiv.textContent = label;

                    var leftTireLink = document.createElement('a');
                    leftTireLink.href = '/wheeles/1';

                    var leftWheelDiv = document.createElement('div');
                    leftWheelDiv.className = 'rim';

                    leftTireLink.appendChild(leftWheelDiv);
                    leftTireDiv.appendChild(leftTireLink);
                    rearAxleDiv.appendChild(leftTireDiv);
                });

                var middleDiv = document.createElement('div');
                middleDiv.style.width = '100px';
                middleDiv.style.background = 'darkgray';
                middleDiv.style.height = '10px';
                middleDiv.style.borderRadius = '10px';
                middleDiv.style.border = '1px solid #c1a1a1';
                middleDiv.style.marginTop = '16px';

                var middleInnerDiv = document.createElement('div');
                middleInnerDiv.style.width = '20px';
                middleInnerDiv.style.background = 'darkgray';
                middleInnerDiv.style.height = '50px';
                middleInnerDiv.style.border = '2px solid #c1a1a1';
                middleInnerDiv.style.margin = 'auto';
                middleInnerDiv.style.position = 'relative';
                middleInnerDiv.style.bottom = '50px';

                var middleInnerDiv1 = document.createElement('div');
                middleInnerDiv1.className = 'tyre_btn';
                middleInnerDiv1.setAttribute('data-position', data.position);
                middleInnerDiv1.style.width = '40px';
                middleInnerDiv1.style.background = 'black';
                middleInnerDiv1.style.height = '40px';
                middleInnerDiv1.style.border = '2px solid #c1a1a1';
                middleInnerDiv1.style.margin = 'auto';
                middleInnerDiv1.style.position = 'relative';
                middleInnerDiv1.style.top = '30px';
                middleInnerDiv1.style.right = '12px';
                middleInnerDiv1.style.borderRadius = '30px';
                middleInnerDiv1.style.display = 'flex';
                middleInnerDiv1.style.color = '#fff';
                middleInnerDiv1.style.justifyContent = 'center';
                middleInnerDiv1.style.alignItems = 'center';
                middleInnerDiv1.style.fontSize = '40px';
                if(data.no_tyre==2){
                  middleInnerDiv1.textContent='+';                    
                }
                else{
                  middleInnerDiv1.textContent='-';                    

                }

                middleInnerDiv.appendChild(middleInnerDiv1);

                middleDiv.appendChild(middleInnerDiv);
                rearAxleDiv.appendChild(middleDiv);

                data.tire_labels_right.forEach(function (label) {
                    var rightTireDiv = document.createElement('div');
                    rightTireDiv.style.display = 'flex';
                    rightTireDiv.style.alignItems = 'center';
                    rightTireDiv.style.flexDirection = 'column';
                    rightTireDiv.textContent = label;

                    var rightTireLink = document.createElement('a');
                    rightTireLink.href = '/wheeles/1';

                    var rightWheelDiv = document.createElement('div');
                    rightWheelDiv.className = 'rim';

                    rightTireLink.appendChild(rightWheelDiv);
                    rightTireDiv.appendChild(rightTireLink);
                    rearAxleDiv.appendChild(rightTireDiv);


                    var rightTireDiv = document.createElement('div');
                    rightTireDiv.style.display = 'flex';
                    rightTireDiv.style.flexDirection = 'column';
                    rightTireDiv.textContent = label;

                    var rightTireLink = document.createElement('a');
                    rightTireLink.href = '/wheeles/1';

                    var rightWheelDiv = document.createElement('div');
                    rightWheelDiv.className = 'wheel';

                    rightTireLink.appendChild(rightWheelDiv);
                    rightTireDiv.appendChild(rightTireLink);
                    rearAxleDiv.appendChild(rightTireDiv);
                });

                var vehicleContainer = document.querySelector('.vehicle');
                vehicleContainer.appendChild(rearAxleDiv);
            }

            // Loop through vehicle data and generate HTML based on axle type
            vehicleData.forEach(item => {
                if (item.axle === 'Front Axle') {
                    generateFrontAxleHTML(item);
                } 
            });

            vehicleData.forEach(item => {
                if (item.axle === 'Middle Axle') {
                    generateMiddleAxleHTML(item);
                } 
            });

            vehicleData.forEach(item => {
                if (item.axle === 'Rear Axle') {
                    generateRearAxleHTML(item);
                }
            });

        }
    
    

    function installTrailers() {
        // Function to install trailers
        trailerData.forEach(function (trailer) {
            installTrailer(trailer.config, trailer.id);
        });
    }

    // Call installVehicle followed by installTrailers
    installVehicle(position);
    installTrailers();
</script>


    </div>
</div>
        
  
    
    </div>
    
    </div>


    </div>
</div>

          <!-- end-->
          </div><!-- card-body -->


                </div>
            </section>



<div class="modal" id="actionBtn">
  <div class="modal-dialog modal-md">
    <div class="modal-content">
      <!-- Modal Header -->
      <div class="modal-header" >
        <h4 class="modal-title">Move Tyre</h4>
        <button type="button" class="btn-close" data-bs-dismiss="modal" style="margin-top: 1px;"></button>
      </div>
      <!-- Modal body -->
      <div class="modal-body" style="margin-top: -15px;">
        <div class="card-body">
          <form action="/tyre/history/store" method="POST" id="cat" enctype="multipart/form-data">
          <?php echo csrf_field(); ?>
          <input type="hidden" name="tire_id" id="tire_id" value="<?php echo e($tire->id); ?>">
          <br>
          <div class="row">
              
            <div class="col-sm-6">
                <div class="mb-3">
                    <label class="form-label">Date
                <span class="required-field">*</span>
              </label>
                <input type="date" name="date" id="date" class="form-control" required>
                </div>
            </div>
            
            </div>
            
            <div class="row">

                       
            <div class="col-sm-6">
                <div class="mb-3">
                    <label class="form-label">Move Tyre
                <span class="required-field">*</span>
              </label>
                <!--<input type="text" name="type" id="type" class="form-control" required>-->
                <select class="form-select" name="moved_to">
                    <?php if($tire->location_status=="Store"): ?>
                    <option value="Service">In Service</option>
                    <option value="Scrap">In Scrap</option>
                    <?php else: ?>
                    <option value="Store">In Store</option>
                    <?php endif; ?>
                    
                </select>
                </div>
            </div>
            
           
            
            <div class="col-sm-6">
                <div class="mb-3">
                    <label class="form-label">Attachment
                <span class="required-field">*</span>
              </label>
                <input type="file" name="attachment" id="attachment" class="form-control">
                </div>
            </div>
            
            <div class="col-sm-12">
                <div class="mb-3">
                    <label class="form-label">Remark
                <span class="required-field">*</span>
              </label>
                <!--<input type="text" name="description" id="description" class="form-control" required>-->
                <textarea name="remark" id="remark" class="form-control"></textarea>
                </div>
            </div>
            
                                        
          </div><!-- Row -->
          <div class="buttons-alignment mt-4 ml-auto">
            <button type="submit" class="btn btn-primary">Submit</button>
          </div>
                </form>
        </div>
      </div>
    </div>
  </div>
</div>


<div class="modal" id="addService">
  <div class="modal-dialog modal-md">
    <div class="modal-content">
      <!-- Modal Header -->
      <div class="modal-header" >
        <h4 class="modal-title">Add Service</h4>
        <button type="button" class="btn-close" data-bs-dismiss="modal" style="margin-top: 1px;"></button>
      </div>
      <!-- Modal body -->
      <div class="modal-body" style="margin-top: -15px;">
        <div class="card-body">
          <form action="/tyre/service/history/store" method="POST" id="cat" enctype="multipart/form-data">
          <?php echo csrf_field(); ?>
          <input type="hidden" name="tire_id" id="tire_id" value="<?php echo e($tire->id); ?>">

          <br>
          <div class="row">
            
              
            <div class="col-sm-6">
                <div class="mb-3">
                    <label class="form-label">Date
                <span class="required-field">*</span>
              </label>
                <input type="date" name="date" id="date" class="form-control" required>
                </div>
            </div>
                       
            <div class="col-sm-6">
                <div class="mb-3">
                    <label class="form-label">Service Type
                <span class="required-field">*</span>
              </label>
                <!--<input type="text" name="type" id="type" class="form-control" required>-->
                <select class="form-select" name="service_type" id="service_type" required>
                <option value="">Select</option>
                <?php $__currentLoopData = $service_type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option><?php echo e($service->name); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                </div>
            </div>
            
            <div class="col-sm-6">
                <div class="mb-3">
                    <label class="form-label">Cost
                <span class="required-field">*</span>
              </label>
                <input type="number" name="cost" id="cost" class="form-control" required>
                </div>
            </div>
            
            <div class="col-sm-6">
                <div class="mb-3">
                    <label class="form-label">Attachment
                <span class="required-field">*</span>
              </label>
                <input type="file" name="attachment" id="attachment" class="form-control">
                </div>
            </div>
            
            <div class="col-sm-12">
                <div class="mb-3">
                    <label class="form-label">Description
                <span class="required-field">*</span>
              </label>
                <!--<input type="text" name="description" id="description" class="form-control" required>-->
                <textarea name="description" id="description" class="form-control"></textarea>
                </div>
            </div>
            
                                        
          </div><!-- Row -->
          <div class="buttons-alignment mt-4 ml-auto">
            <button type="submit" class="btn btn-primary">Submit</button>
          </div>
                </form>
        </div>
      </div>
    </div>
  </div>
</div>
        

<div class="modal" id="inspectionBtn">
  <div class="modal-dialog modal-md">
    <div class="modal-content">
      <!-- Modal Header -->
      <div class="modal-header" >
        <h4 class="modal-title">Inspection Report for (Tyre: <?php echo e($tire->tire_id); ?>)</h4>
        <button type="button" class="btn-close" data-bs-dismiss="modal" style="margin-top: 1px;"></button>
      </div>
      <!-- Modal body -->
      <div class="modal-body" style="margin-top: -15px;">
        <div class="card-body">
          <form action="/tyre/inspection/history/store" method="POST" id="cat" enctype="multipart/form-data">
          <?php echo csrf_field(); ?>

          <input type="hidden" name="tire_id" id="tire_id" value="<?php echo e($tire->id); ?>">

          <br>
          <div class="row">
              
          
          <div class="col-lg-4">
            <div class="mb-3">
            <label class="form-label">Date</label>
            <input type="date" name="inspection_date" class="form-control" required>
          </div>
          </div>
          
        <div class="col-lg-4">
          <div class="mb-3">
            <label class="form-label">Tread depth (in mm)</label>
            <input type="number" name="tread_depth_mm" class="form-control" step="0.01" required>
          </div>
        </div>
        
        <div class="col-lg-4">
          <div class="mb-3">
            <label class="form-label">Pressure</label>
            <input type="number" name="pressure" class="form-control"  required>
          </div>
        </div>
        
        <div class="col-lg-4">
          <div class="mb-3">
            <label class="form-label">Condition</label>
            <select name="tire_condition" class="form-select" required>
            <option value="Yes">Good</option>
            <option value="No">Bad</option>
            </select>
            <!--<input type="number" name="tire_condition" class="form-control" step="0.01" required>-->
          </div>
        </div>
        
        <div class="col-lg-4">
          <div class="mb-3">
            <label class="form-label">Current Rolling (KM)</label>
            <input type="number" name="current_rolling_km" class="form-control" step="0.01" required>
          </div>
        </div>

        <?php $__currentLoopData = $faq; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <input type="hidden" name="faq_question[]" class="form-control" value="<?php echo e($question->name); ?>">
        
        <div class="col-lg-12">
         <div class="mb-3">
            <label class="form-label"><?php echo e($question->name); ?></label>
            <select name="faq_answer[]" class="form-control" required>
                <option value="Yes">Yes</option>
                <option value="No">No</option>
            </select>
        </div>
       </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      
        
        <div class="col-lg-6">
        <div class="mb-3">
            <label class="form-label">Action</label>
            <select name="action_type" class="form-control" required>
            <?php $__currentLoopData = $action_type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($data->name); ?>"><?php echo e($data->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
          </div>
          
        </div>
        
        <div class="col-lg-6">
          <div class="mb-3">
            <label class="form-label">Attachment</label>
            <input type="file" multiple name="attachment" class="form-control">
          </div>
        </div>
        </div>
        
        
        
       
            
            <div class="col-sm-12">
                <div class="mb-3">
                    <label class="form-label">Remark
                <span class="required-field">*</span>
              </label>
                <!--<input type="text" name="description" id="description" class="form-control" required>-->
                <textarea name="description" id="description" class="form-control"></textarea>
                </div>
            </div>
            
                                        
          </div><!-- Row -->
          <div class="buttons-alignment mt-4 ml-auto">
            <button type="submit" class="btn btn-primary">Submit</button>
          </div>
                </form>
        </div>
      </div>
    </div>
  </div>
</div>


<!--============================
=            Footer            =
=============================-->
<footer style="background: black;">
  
  <div class="text-center py-4">
    <small class="text-white">Tms &copy; <script>document.write(new Date().getFullYear())</script>. All rights reserved</small class="text-secondary">
  </div>

    <div class="text-center py-1">
     <!-- <small class="text-white"> <p>Designed By <a href="https://tms.com/">TMS</a></p></small> -->  
    </div>
</footer>


  <!-- To Top -->
  <!-- <div class="scroll-top">
    <i class="ti-angle-up"></i>
  </div> -->
  
  <!-- JAVASCRIPTS -->
  <script src="https://code.jquery.com/jquery-3.6.1.js" integrity="sha256-3zlB5s2uwoUzrXK3BT7AX3FyvojsraNFxCc2vC/7pNI=" crossorigin="anonymous"></script>
<!--<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-ka7Sk0Gln4gmtz2MlQnikT1wXgYsOg+OMhuP+IlRH9sENBO0LRn5q+8nbTov4+1p" crossorigin="anonymous"></script>-->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.2/dist/js/bootstrap.min.js" integrity="sha384-IDwe1+LCz02ROU9k972gdyvl+AESN10+x7tBKgc9I5HFtuNz0wWnPclzo6p9vxnk" crossorigin="anonymous"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.js" integrity="sha512-XtmMtDEcNz2j7ekrtHvOVR4iwwaD6o/FUJe6+Zq+HgcCsk3kj4uSQQR8weQ2QVj1o0Pk6PwYLohm206ZzNfubg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.js" integrity="sha512-A7AYk1fGKX6S2SsHywmPkrnzTZHrgiVT7GcQkLGDe2ev0aWb8zejytzS8wjo7PGEXKqJOrjQ4oORtnimIRZBtw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
  <!-- google map -->
<!--   <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAgeuuDfRlweIs7D6uo4wdIHVvJ0LonQ6g"></script>
 -->  
  <script src="<?php echo e(asset('public/user/js/script.js')); ?>"></script>
</body>

</html><?php /**PATH /home/megamarket/public_html/tms/resources/views/dashboard/tyre.blade.php ENDPATH**/ ?>