<?php

namespace App\Http\Controllers\Userend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Blog\Blog;
use Illuminate\Support\Facades\Redirect;

class UserendController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    
    public function blogsView(Request $request)
    {
        $blogs = Blog::all();
        return view('userend.blogs', compact('blogs'));
    }

    public function blogView($id)
    {
        $blog = Blog::where('id', $id)->first();
        return view('userend.blog', compact('blog'));
    } 
    
    
    public function store(Request $request)
    {
        $blog = new Blog;
         if ($request->file('feature_image')) {
            $feature_img = $request->file('feature_image');
            $feature_filename ='Img-' . time() . '.' . $feature_img->getClientOriginalExtension();
            $path = public_path('uploads');
            $feature_img->move($path, $feature_filename);
            $blog->feature_img = $feature_filename;
        }
        $blog->title = $request->input("title");
        if ($request->file('blog_image')) {
            $image = $request->file('blog_image');
            $filename = time() . '.' . $image->getClientOriginalExtension();
            $path = public_path('uploads');
            $image->move($path, $filename);
            $blog->image = $filename;
        }
        $blog->description = $request->input("description");
        $blog->save();
        Alert::success('Congrats', 'You\'ve Added Blog Successfully');
        return redirect()->route('blogs.index');
    }


    
}
