<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\DailyDeals\DailyDeals;
use Illuminate\Support\Facades\Redirect;

class DailyDealsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
        $deals = DailyDeals::orderBy('id', 'DESC')->get();

        return view('deals.index', compact('deals'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $category = new DailyDeals;
        $category->title = $request->input("title");
        $category->amount = $request->input("amount");
        $category->description = $request->input("description");
        if ($request->file('photo')) {
            $photo = $request->file('photo');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $category->image = $filename;
        }
        $category->save();
        session()->flash('success', 'You\'ve Added Daily Deals successfully.');
        
        return Redirect::back();
    }
    
    public function update(Request $request)
    {
        $id = $request->input("expense_id");
         $category = DailyDeals::find($id);
        $category->name = $request->input("name");
        $category->save();
        
        session()->flash('success', 'You\'ve Updated Expense Account successfully.');

        return Redirect::back();
    }
   

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $cat = DailyDeals::find($id);
        $cat->delete();
        session()->flash('success', 'You\'ve Deleted Expense Account successfully.');
        
        return Redirect::back();
    }

}
