<?php

namespace App\Http\Controllers\Admin\Masters;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Masters\BatteryInspection;
use Illuminate\Support\Facades\Redirect;

class BatteryInspectionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
        $type = BatteryInspection::orderBy('id', 'DESC')->get();

        return view('masters.battery_inspection', compact('type'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $type = new BatteryInspection;
        $type->name = $request->input("name");
        $type->save();
        
        session()->flash('success', 'Inspection Faq added successfully.');
        return Redirect::back();
    }
    
    public function update(Request $request)
    {
        $id = $request->input("brand_id");
        $type = BatteryInspection::find($id);
        $type->name = $request->input("name");
        $type->save();
        
        session()->flash('success', 'Inspection Faq updated successfully.');

        return Redirect::back();
    }
   

    public function destroy($id)
    {
        //
        $type = BatteryInspection::find($id);
        $type->delete();
        session()->flash('success', 'Inspection Faq deleted successfully.');
        
        return Redirect::back();
    }

}
