<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Support\Facades\Auth;
use App\Models\User\UserHistory;

use App\Models\Masters\VehicleType;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\Inventory\Inventory;
use App\Models\Inventory\TyreInventory;
use App\Models\Inventory\RimInventory;
use App\Models\Inventory\BatteryInventory;
use App\Models\Inventory\InventoryHistory;
use Illuminate\Support\Facades\Redirect;

class InventoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    // public function tyre(Request $request)
    // {
    //     $vehicle_type = VehicleType::all();
    //     $inventory = TyreInventory::orderBy('id', 'DESC')->get();
    //     return view('inventory.tyre.index', compact('inventory', 'vehicle_type'));
    // }
    
    public function tyre(Request $request)
{
    // Get all branches
    $vehicle_type = VehicleType::all();
    
    // Retrieve the search query and branch ID from the request
    $searchQuery = $request->input('query');
    $filter = $request->input('brand');

    // Query bills based on the search query and branch ID
    $tyreQuery = TyreInventory::query();
    
    if ($searchQuery) {
        $tyreQuery->where(function($query) use ($searchQuery) {
            $query->where('brand', 'like', '%' . $searchQuery . '%')
                  ->orWhere('date', 'like', '%' . $searchQuery . '%');
        });
    }
    
    if ($filter) {
        $tyreQuery->where('brand', $brand);
    }
    // else{
    //     $branchId ='';
    // }

    // Paginate bills
    $inventory = $tyreQuery->orderBy('id', 'DESC')->paginate(10);

    // Pass paginated data, filter, and search query to the view
    return view('inventory.tyre.index', compact('inventory', 'vehicle_type'));
}




    public function create_tyre()
    {
        $vehicle_type = VehicleType::all();
        return view('inventory.tyre.create', compact('vehicle_type'));
    }
    
    public function inventory_history($type, $id)
    {
        $history = InventoryHistory::orderBy('id', 'DESC')->where('type', $type)->where('inventory_id', $id)->get();
        return view('inventory.history', compact('history'));
    }
    
    
    
    public function store_tyre(Request $request)
{
    // Validate the incoming request data (you can add validation rules as needed)
    // $validatedData = $request->validate([
    //     'warranty_type' => 'nullable|string|max:255',
    //     'warranty_start_date' => 'nullable|date',
    //     'warranty_end_date' => 'nullable|date',
    //     'commercial_name' => 'nullable|string|max:255',
    //     'identity' => 'nullable|string|max:255',
    //     'load_pressure_information' => 'nullable|string',
    //     'indicated_exterior' => 'nullable|string|max:50',
    //     'type_of_construction' => 'nullable|string|max:50',
    //     'tyre_sections_width_mm' => 'nullable|numeric|between:0,9999.99',
    //     'section_height_to_section_width_ratio' => 'nullable|numeric|between:0,9999.99',
    //     'rim_diameter_inches' => 'nullable|numeric|between:0,999.99',
    //     'load_capacity_index' => 'nullable|string|max:10',
    //     'speed_rating' => 'nullable|string|max:10',
    //     'tyre_type' => 'nullable|in:Tubeless,Tube',
    //     'brand_name' => 'nullable|string|max:255',
    //     'remarks' => 'nullable|string',
    // ]);

    $tireInventory = new TyreInventory();

    // Create a new TyreInventory instance and assign values from the request
    // Assign values from the request to the model fields
    $tireInventory->warranty_type = $request->input('warranty_type');
    $tireInventory->warranty_start_date = $request->input('warranty_start_date');
    $tireInventory->warranty_end_date = $request->input('warranty_end_date');
    $tireInventory->commercial_name = $request->input('commercial_name');
    $tireInventory->identity = $request->input('identity');
    $tireInventory->tread_depth = $request->input('tread_depth');
    $tireInventory->maximum_tread_depth = $request->input('maximum_tread_depth');
    $tireInventory->rolling_km = $request->input('rolling_km');
    $tireInventory->maximum_rolling_km = $request->input('maximum_rolling_km');
    $tireInventory->pressure = $request->input('pressure');
    $tireInventory->load_pressure_information = $request->input('load_pressure_information');
    $tireInventory->indicated_exterior = $request->input('indicated_exterior');
    $tireInventory->type_of_construction = $request->input('type_of_construction');
    $tireInventory->tyre_sections_width_mm = $request->input('tyre_sections_width_mm');
    $tireInventory->section_height_to_section_width_ratio = $request->input('section_height_to_section_width_ratio');
    $tireInventory->rim_diameter_inches = $request->input('rim_diameter_inches');
    $tireInventory->load_capacity_index = $request->input('load_capacity_index');
    $tireInventory->speed_rating = $request->input('speed_rating');
    $tireInventory->load_rating = $request->input('load_rating');
    $tireInventory->tyre_type = $request->input('tyre_type');
    $tireInventory->brand_name = $request->input('brand_name');
    $tireInventory->model = $request->input('model');
    $tireInventory->quantity = $request->input('quantity');
    $tireInventory->unit_price = $request->input('unit_price');
    $tireInventory->total_price = $request->input('total_price');
    $tireInventory->date = $request->input('date');
    $tireInventory->remarks = $request->input('remarks');
    $tireInventory->currency = $request->input('currency');
    $tireInventory->preferred_vehicles = json_encode($request->input('preferred_vehicles'));
    
    if ($request->file('attachment')) {
            $photo = $request->file('attachment');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $tireInventory->attachment = $filename;
    }

    // Save the tire inventory to the database
    $tireInventory->save();
    
        $date = date('Y-m-d');
        $time = date('H:i:s');  
        $user = Auth::user();
        
        $UserHistory = new UserHistory();
        $UserHistory->user_id = $user->id;
        $UserHistory->module = 'Inventory';
        $UserHistory->action_type = 'Tyre added to inventory';
        $UserHistory->item_id = $tireInventory->id;
        $UserHistory->date = $date;
        $UserHistory->time = $time;
        $UserHistory->save();

    // Redirect to the inventory's details page or the index page
    session()->flash('success', 'Inventory Added Successfully');
    return redirect()->route('inventory.tyre');
}

    
   

    public function show_tyre($id)
    {
         $tyreInventory = TyreInventory::find($id);

         return view('inventory.tyre.show', compact('tyreInventory'));
    }


    public function edit_tyre($id, Request $request)
    {
        $vehicle_type = VehicleType::all();
        $tyreInventory = TyreInventory::find($id);

        return view('inventory.tyre.edit', compact('tyreInventory', 'vehicle_type'));
    }


    public function update_tyre(Request $request)
    {
        $id = $request->input("id");
        $tireInventory = TyreInventory::find($id);
        
        $tireInventory->warranty_type = $request->input('warranty_type');
    $tireInventory->warranty_start_date = $request->input('warranty_start_date');
    $tireInventory->warranty_end_date = $request->input('warranty_end_date');
    $tireInventory->commercial_name = $request->input('commercial_name');
    $tireInventory->identity = $request->input('identity');
    $tireInventory->tread_depth = $request->input('tread_depth');
    $tireInventory->maximum_tread_depth = $request->input('maximum_tread_depth');
    $tireInventory->rolling_km = $request->input('rolling_km');
    $tireInventory->maximum_rolling_km = $request->input('maximum_rolling_km');
    $tireInventory->pressure = $request->input('pressure');
    $tireInventory->load_pressure_information = $request->input('load_pressure_information');
    $tireInventory->indicated_exterior = $request->input('indicated_exterior');
    $tireInventory->type_of_construction = $request->input('type_of_construction');
    $tireInventory->tyre_sections_width_mm = $request->input('tyre_sections_width_mm');
    $tireInventory->section_height_to_section_width_ratio = $request->input('section_height_to_section_width_ratio');
    $tireInventory->rim_diameter_inches = $request->input('rim_diameter_inches');
    $tireInventory->load_capacity_index = $request->input('load_capacity_index');
    $tireInventory->speed_rating = $request->input('speed_rating');
    $tireInventory->load_rating = $request->input('load_rating');
    $tireInventory->tyre_type = $request->input('tyre_type');
    $tireInventory->brand_name = $request->input('brand_name');
    $tireInventory->model = $request->input('model');
    $tireInventory->currency = $request->input('currency');
    $tireInventory->quantity = $request->input('quantity');
    $tireInventory->unit_price = $request->input('unit_price');
    $tireInventory->total_price = $request->input('total_price');
    $tireInventory->date = $request->input('date');
    $tireInventory->remarks = $request->input('remarks');
    $tireInventory->currency = $request->input('currency');
    $tireInventory->preferred_vehicles = json_encode($request->input('preferred_vehicles'));
    
    if ($request->file('attachment')) {
            $photo = $request->file('attachment');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $tireInventory->attachment = $filename;
    }
       
        // $inventory->status = $request->input("status") ? "Active" : "Inactive";
    $tireInventory->save();
    
    $date = date('Y-m-d');
        $time = date('H:i:s');  
        $user = Auth::user();
        
        $UserHistory = new UserHistory();
        $UserHistory->user_id = $user->id;
        $UserHistory->module = 'Inventory';
        $UserHistory->action_type = 'Tyre updated in inventory';
        $UserHistory->item_id = $tireInventory->id;
        $UserHistory->date = $date;
        $UserHistory->time = $time;
        $UserHistory->save();
        
        session()->flash('success', 'Tyre Inventory updated Successfully');

        return Redirect::back();
    }

    public function destroy_tyre($id)
    {
        $inventory = Inventory::find($id);
        $inventory->delete();
        session()->flash('success', 'You\'ve Deleted Tour Package Successfully');

        return Redirect::back();
    }
    
    
    public function rim(Request $request)
    // {
    //     $rimInventory = RimInventory::orderBy('id', 'DESC')->get();
    //     return view('inventory.rim.index', compact('rimInventory'));
    // }
{
    // Get all branches
    $vehicle_type = VehicleType::all();
    
    // Retrieve the search query and branch ID from the request
    $searchQuery = $request->input('query');
    $filter = $request->input('brand');

    // Query bills based on the search query and branch ID
    $rimQuery = RimInventory::query();
    
    if ($searchQuery) {
        $rimQuery->where(function($query) use ($searchQuery) {
            $query->where('brand', 'like', '%' . $searchQuery . '%')
                  ->orWhere('date', 'like', '%' . $searchQuery . '%');
        });
    }
    
    if ($filter) {
        $rimQuery->where('brand', $brand);
    }
    // else{
    //     $branchId ='';
    // }

    // Paginate bills
    $rimInventory = $rimQuery->orderBy('id', 'DESC')->paginate(10);

    // Pass paginated data, filter, and search query to the view
    return view('inventory.rim.index', compact('rimInventory'));
}


    public function create_rim()
    {
        return view('inventory.rim.create');
    }
    
    
    
    public function store_rim(Request $request)
{
   // Validate the request data if needed
    // $this->validate($request, [
    //     // Add validation rules here
    // ]);

    // Create a new instance of the RimInventory model
    $rimInventory = new RimInventory();

    // Assign values from the request to the model fields
    $rimInventory->brand_name = $request->input('brand_name');
    $rimInventory->model = $request->input('model');
    $rimInventory->wheel_offset = $request->input('wheel_offset');
    $rimInventory->bolt_pattern = $request->input('bolt_pattern');
    $rimInventory->diameter = $request->input('diameter');
    $rimInventory->width = $request->input('width');
    $rimInventory->center_bore = $request->input('center_bore');
    $rimInventory->finish = $request->input('finish');
    $rimInventory->material = $request->input('material');
    $rimInventory->spoke_design = $request->input('spoke_design');
    $rimInventory->weight_rating = $request->input('weight_rating');
    $rimInventory->warranty_type = $request->input('warranty_type');
    $rimInventory->warranty_start_date = $request->input('warranty_start_date');
    $rimInventory->warranty_end_date = $request->input('warranty_end_date');
    $rimInventory->currency = $request->input('currency');
    $rimInventory->quantity = $request->input('quantity');
    $rimInventory->unit_price = $request->input('unit_price');
    $rimInventory->total_price = $request->input('total_price');
    $rimInventory->date = $request->input('date');
    $rimInventory->remarks = $request->input('remarks');
    
    if ($request->file('attachment')) {
            $photo = $request->file('attachment');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $rimInventory->attachment = $filename;
    }

    // Save the rim inventory to the database
    $rimInventory->save();
    
       $date = date('Y-m-d');
        $time = date('H:i:s');  
        $user = Auth::user();
        
        $UserHistory = new UserHistory();
        $UserHistory->user_id = $user->id;
        $UserHistory->module = 'Inventory';
        $UserHistory->action_type = 'Rim added in inventory';
        $UserHistory->item_id = $rimInventory->id;
        $UserHistory->date = $date;
        $UserHistory->time = $time;
        $UserHistory->save();

    // Redirect to the inventory's details page or the index page
    session()->flash('success', 'Rim Added Successfully');
    return redirect()->route('inventory.rim');
}

    
   

    public function show_rim($id)
    {
         $rimInventory = RimInventory::find($id);

        return view('inventory.rim.show', compact('rimInventory'));
    }


    public function edit_rim($id, Request $request)
    {
        $rimInventory = RimInventory::find($id);

        return view('inventory.rim.edit', compact('rimInventory'));
    }


    public function update_rim(Request $request)
    {
        $id = $request->input("id");
        $rimInventory = RimInventory::find($id);
       
        $rimInventory->brand_name = $request->input('brand_name');
        $rimInventory->model = $request->input('model');
        $rimInventory->material = $request->input('material');
    $rimInventory->wheel_offset = $request->input('wheel_offset');
    $rimInventory->bolt_pattern = $request->input('bolt_pattern');
    $rimInventory->diameter = $request->input('diameter');
    $rimInventory->width = $request->input('width');
    $rimInventory->center_bore = $request->input('center_bore');
    $rimInventory->finish = $request->input('finish');
    $rimInventory->spoke_design = $request->input('spoke_design');
    $rimInventory->weight_rating = $request->input('weight_rating');
    $rimInventory->warranty_type = $request->input('warranty_type');
    $rimInventory->warranty_start_date = $request->input('warranty_start_date');
    $rimInventory->warranty_end_date = $request->input('warranty_end_date');
    $rimInventory->currency = $request->input('currency');
    $rimInventory->quantity = $request->input('quantity');
    $rimInventory->unit_price = $request->input('unit_price');
    $rimInventory->total_price = $request->input('total_price');
    $rimInventory->date = $request->input('date');
    $rimInventory->remarks = $request->input('remarks');
    
    if ($request->file('attachment')) {
            $photo = $request->file('attachment');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $rimInventory->attachment = $filename;
    }

    // Save the rim inventory to the database
    $rimInventory->save();
    
    $date = date('Y-m-d');
        $time = date('H:i:s');  
        $user = Auth::user();
        
        $UserHistory = new UserHistory();
        $UserHistory->user_id = $user->id;
        $UserHistory->module = 'Inventory';
        $UserHistory->action_type = 'Rim updated in inventory';
        $UserHistory->item_id = $rimInventory->id;
        $UserHistory->date = $date;
        $UserHistory->time = $time;
        $UserHistory->save();
        
        session()->flash('success', 'Rim Inventory updated Successfully');

        return Redirect::back();
    }

    public function destroy_rim($id)
    {
        $inventory = Inventory::find($id);
        $inventory->delete();
        session()->flash('success', 'You\'ve Deleted Tour Package Successfully');

        return Redirect::back();
    }
    
    
    public function battery(Request $request)
    // {
    //     $batteryInventory = BatteryInventory::orderBy('id', 'DESC')->get();
    //     return view('inventory.battery.index', compact('batteryInventory'));
    // }
    
    {
    // Get all branches
    $vehicle_type = VehicleType::all();
    
    // Retrieve the search query and branch ID from the request
    $searchQuery = $request->input('query');
    $filter = $request->input('brand');

    // Query bills based on the search query and branch ID
    $batteryQuery = BatteryInventory::query();
    
    if ($searchQuery) {
        $batteryQuery->where(function($query) use ($searchQuery) {
            $query->where('brand', 'like', '%' . $searchQuery . '%')
                  ->orWhere('date', 'like', '%' . $searchQuery . '%');
        });
    }
    
    if ($filter) {
        $batteryQuery->where('brand', $brand);
    }
    // else{
    //     $branchId ='';
    // }

    // Paginate bills
    $batteryInventory = $batteryQuery->orderBy('id', 'DESC')->paginate(10);

    // Pass paginated data, filter, and search query to the view
    return view('inventory.battery.index', compact('batteryInventory'));
}



    public function create_battery()
    {
        return view('inventory.battery.create');
    }
    
    
    
    public function store_battery(Request $request)
{
    // Validate the request data if needed
    // $this->validate($request, [
    //     // Add validation rules here
    // ]);

    // Create a new instance of the BatteryInventory model
    $batteryInventory = new BatteryInventory();

    // Assign values from the request to the model fields
    $batteryInventory->warranty_type = $request->input('warranty_type');
    $batteryInventory->warranty_start_date = $request->input('warranty_start_date');
    $batteryInventory->warranty_end_date = $request->input('warranty_end_date');
    $batteryInventory->brand = $request->input('brand');
    $batteryInventory->capacity_ah = $request->input('capacity_ah');
    $batteryInventory->battery_type = $request->input('battery_type');
    $batteryInventory->voltage = $request->input('voltage');
    $batteryInventory->dry_weight = $request->input('dry_weight');
    $batteryInventory->model_number = $request->input('model_number');
    $batteryInventory->cold_cranking_amps = $request->input('cold_cranking_amps');
    $batteryInventory->reserve_capacity_minutes = $request->input('reserve_capacity_minutes');
    $batteryInventory->currency = $request->input('currency');
    $batteryInventory->quantity = $request->input('quantity');
    $batteryInventory->unit_price = $request->input('unit_price');
    $batteryInventory->total_price = $request->input('total_price');
    $batteryInventory->date = $request->input('date');
    $batteryInventory->remarks = $request->input('remarks');
    
    if ($request->file('attachment')) {
            $photo = $request->file('attachment');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $batteryInventory->attachment = $filename;
    }

    // Save the battery inventory to the database
    $batteryInventory->save();
    
    $date = date('Y-m-d');
        $time = date('H:i:s');  
        $user = Auth::user();
        
        $UserHistory = new UserHistory();
        $UserHistory->user_id = $user->id;
        $UserHistory->module = 'Inventory';
        $UserHistory->action_type = 'Battery added in inventory';
        $UserHistory->item_id = $batteryInventory->id;
        $UserHistory->date = $date;
        $UserHistory->time = $time;
        $UserHistory->save();

    // Redirect to the inventory's details page or the index page
    session()->flash('success', 'Battery Added Successfully');
    return redirect()->route('inventory.battery');
}

    
   

    public function show_battery($id)
    {
        $batteryInventory = BatteryInventory::find($id);

        return view('inventory.battery.show', compact('batteryInventory'));
    }


    public function edit_battery($id, Request $request)
    {
        $batteryInventory = BatteryInventory::find($id);

        return view('inventory.battery.edit', compact('batteryInventory'));
    }


    public function update_battery(Request $request)
    {
        $id = $request->input("id");
        $batteryInventory = BatteryInventory::find($id);
       
        $batteryInventory->warranty_type = $request->input('warranty_type');
    $batteryInventory->warranty_start_date = $request->input('warranty_start_date');
    $batteryInventory->warranty_end_date = $request->input('warranty_end_date');
    $batteryInventory->brand = $request->input('brand');
    $batteryInventory->capacity_ah = $request->input('capacity_ah');
    $batteryInventory->battery_type = $request->input('battery_type');
    $batteryInventory->voltage = $request->input('voltage');
    $batteryInventory->dry_weight = $request->input('dry_weight');
    $batteryInventory->model_number = $request->input('model_number');
    $batteryInventory->cold_cranking_amps = $request->input('cold_cranking_amps');
    $batteryInventory->reserve_capacity_minutes = $request->input('reserve_capacity_minutes');
    $batteryInventory->currency = $request->input('currency');
    $batteryInventory->quantity = $request->input('quantity');
    $batteryInventory->unit_price = $request->input('unit_price');
    $batteryInventory->total_price = $request->input('total_price');
    $batteryInventory->date = $request->input('date');
    $batteryInventory->remarks = $request->input('remarks');
    
    if ($request->file('attachment')) {
            $photo = $request->file('attachment');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $batteryInventory->attachment = $filename;
    }
    
    $batteryInventory->save();
    
    $date = date('Y-m-d');
        $time = date('H:i:s');  
        $user = Auth::user();
        
        $UserHistory = new UserHistory();
        $UserHistory->user_id = $user->id;
        $UserHistory->module = 'Inventory';
        $UserHistory->action_type = 'Battery updated in inventory';
        $UserHistory->item_id = $batteryInventory->id;
        $UserHistory->date = $date;
        $UserHistory->time = $time;
        $UserHistory->save();
    
        session()->flash('success', 'Battery Inventory updated Successfully');

        return Redirect::back();
    }

    public function destroy_battery($id)
    {
        $inventory = BatteryInventory::find($id);
        $inventory->delete();
        session()->flash('success', 'You\'ve Deleted Tour Package Successfully');

        return Redirect::back();
    }
}
