<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\Battery\Batteries;
use App\Models\Battery\BatteryHistory;
use App\Models\Inventory\BatteryInventory;
use App\Models\Inventory\InventoryHistory;
use Illuminate\Support\Facades\Redirect;

class BatteryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index(Request $request)
    {
        $batteries = Batteries::orderBy('id', 'DESC')->get();
        return view('battery.index', compact('batteries'));
    }


    public function create()
    {
         $tyres = BatteryInventory::all();
        return view('battery.create', compact('tyres'));
    }
    
    
    
    public function store(Request $request)
{
    
    $tire_id = $request->input('item_id');
    $inventory = BatteryInventory::find($tire_id);

    // Create a new tyre instance and populate it with request data
    $battery = new Batteries;

    // Assign all request fields to the corresponding model fields
    $battery->battery_id = $request->input('battery_id');
    // Assuming you have $inventory and $tire objects
   // Set all the fields from the inventory model to the battery model
$battery->brand = $inventory->brand;
$battery->model = $inventory->model;
$battery->voltage = $inventory->voltage;
$battery->cca = $inventory->cca;
$battery->reserve_capacity = $inventory->reserve_capacity;
$battery->purchase_date = $inventory->purchase_date;
$battery->purchase_cost = $inventory->purchase_cost;
$battery->installation_date = $inventory->installation_date;
$battery->vehicle_id = $inventory->vehicle_id;
$battery->current_vehicle = $inventory->current_vehicle;
$battery->mileage_at_installation = $inventory->mileage_at_installation;
$battery->battery_condition = $inventory->battery_condition;
$battery->warranty_provider = $inventory->warranty_provider;
$battery->warranty_start_date = $inventory->warranty_start_date;
$battery->warranty_end_date = $inventory->warranty_end_date;
$battery->notes_comments = $inventory->notes_comments;
$battery->status = $inventory->status;

    // Save the tire to the database
    $battery->save();
    
    $date = date('Y-m-d');
    
    $inventoryHistory = new InventoryHistory;
    $inventoryHistory->date = $date;
    $inventoryHistory->inventory_id = $request->input('item_id');
    $inventoryHistory->item_code = $request->input('tire_id');
    $inventoryHistory->save();

    


    // Redirect to the tyre's details page or the index page
    session()->flash('success', 'Battery Added Successfully');
    return redirect()->route('battery');
}

    
   

    public function show($id)
    {
        $tire = Batteries::find($id);
        //dd($emp);
        return view('battery.view', compact('tire'));
    }


    public function edit($id, Request $request)
    {
        $battery = Batteries::find($id);

        return view('battery.edit', compact('battery'));
    }


    public function update($id, Request $request)
    {
        $tyre = Batteries::find($id);
       
        $tyre->status = $request->input("status") ? "Active" : "Inactive";
        $tyre->save();
        session()->flash('success', 'Tyre Updated Successfully');

        return Redirect::back();
    }

    public function destroy($id)
    {
        $tyre = Batteries::find($id);
        $tyre->delete();
        session()->flash('success', 'Tyre Deleted Successfully');

        return Redirect::back();
    }
}
