<!DOCTYPE html>
<html lang="en">
  <head>

    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Meta -->
    <meta name="description" content="">
    <meta name="author" content="Themepixels">

    <!-- Favicon -->
    <link rel="shortcut icon" type="image/x-icon" href="../assets/img/favicon.png">

    <title>DashByte - Premium Dashboard Template</title>

    <!-- Vendor CSS -->
    <link rel="stylesheet" href="../lib/remixicon/fonts/remixicon.css">
    <link rel="stylesheet" href="../lib/prismjs/themes/prism.min.css">

    <!-- Template CSS -->
    <link rel="stylesheet" href="../assets/css/style.min.css">
  </head>
  <body data-bs-spy="scroll" data-bs-target="#navDocs" data-bs-offset="40">

    <div class="sidebar">
      <div class="sidebar-header">
        <a href="../" class="sidebar-logo">dashbyte</a>
      </div><!-- sidebar-header -->
      <div id="sidebarMenu" class="sidebar-body">
        <div class="nav-group">
          <a href="#" class="nav-label">Dashboard</a>
          <ul class="nav nav-sidebar">
            <li class="nav-item">
              <a href="../dashboard/finance.html" class="nav-link"><i class="ri-pie-chart-2-line"></i> <span>Finance Monitoring</span></a>
            </li>
            <li class="nav-item">
              <a href="../dashboard/events.html" class="nav-link"><i class="ri-calendar-todo-line"></i> <span>Events Management</span></a>
            </li>
            <li class="nav-item">
              <a href="../dashboard/sales.html" class="nav-link"><i class="ri-shopping-bag-3-line"></i> <span>Sales Monitoring</span></a>
            </li>
            <li class="nav-item">
              <a href="../dashboard/analytics.html" class="nav-link"><i class="ri-bar-chart-2-line"></i> <span>Website Analytics</span></a>
            </li>
            <li class="nav-item">
              <a href="../dashboard/crypto.html" class="nav-link"><i class="ri-coin-line"></i> <span>Cryptocurrency</span></a>
            </li>
            <li class="nav-item">
              <a href="../dashboard/helpdesk.html" class="nav-link"><i class="ri-service-line"></i> <span>Helpdesk Service</span></a>
            </li>
            <li class="nav-item">
              <a href="../dashboard/storage.html" class="nav-link"><i class="ri-hard-drive-2-line"></i> <span>Storage Management</span></a>
            </li>
            <li class="nav-item">
              <a href="../dashboard/product.html" class="nav-link"><i class="ri-suitcase-2-line"></i> <span>Product Management</span></a>
            </li>
          </ul>
        </div><!-- nav-group -->
        <div class="nav-group">
          <a href="#" class="nav-label">Applications</a>
          <ul class="nav nav-sidebar">
            <li class="nav-item">
              <a href="../apps/file-manager.html" class="nav-link"><i class="ri-folder-2-line"></i> <span>File Manager</span></a>
            </li>
            <li class="nav-item">
              <a href="../apps/email.html" class="nav-link"><i class="ri-mail-send-line"></i> <span>Email</span></a>
            </li>
            <li class="nav-item">
              <a href="../apps/calendar.html" class="nav-link"><i class="ri-calendar-line"></i> <span>Calendar</span></a>
            </li>
            <li class="nav-item">
              <a href="../apps/chat.html" class="nav-link"><i class="ri-question-answer-line"></i> <span>Chat</span></a>
            </li>
            <li class="nav-item">
              <a href="../apps/contact.html" class="nav-link"><i class="ri-contacts-book-line"></i> <span>Contacts</span></a>
            </li>
            <li class="nav-item">
              <a href="../apps/tasks.html" class="nav-link"><i class="ri-checkbox-multiple-line"></i> <span>Task Manager</span></a>
            </li>
            <li class="nav-item">
              <a href="" class="nav-link has-sub"><i class="ri-gallery-line"></i> <span>Media Gallery</span></a>
              <nav class="nav nav-sub">
                <a href="../apps/gallery-music.html" class="nav-sub-link">Music Stream</a>
                <a href="../apps/gallery-video.html" class="nav-sub-link">Video Stream</a>
              </nav>
            </li>
          </ul>
        </div><!-- nav-group -->
        <div class="nav-group">
          <a href="#" class="nav-label">Pages</a>
          <ul class="nav nav-sidebar">
            <li class="nav-item">
              <a href="" class="nav-link has-sub"><i class="ri-account-circle-line"></i> <span>User Pages</span></a>
              <nav class="nav nav-sub">
                <a href="../pages/profile.html" class="nav-sub-link">User Profile</a>
                <a href="../pages/people.html" class="nav-sub-link">People &amp; Groups</a>
                <a href="../pages/activity.html" class="nav-sub-link">Activity Log</a>
                <a href="../pages/events.html" class="nav-sub-link">Events</a>
                <a href="../pages/settings.html" class="nav-sub-link">Settings</a>
              </nav>
            </li>
            <li class="nav-item">
              <a href="" class="nav-link has-sub"><i class="ri-lock-2-line"></i> <span>Authentication</span></a>
              <nav class="nav nav-sub">
                <a href="../pages/sign-in.html" class="nav-sub-link">Sign In Basic</a>
                <a href="../pages/sign-in-2.html" class="nav-sub-link">Sign In Cover</a>
                <a href="../pages/sign-up.html" class="nav-sub-link">Sign Up Basic</a>
                <a href="../pages/sign-up-2.html" class="nav-sub-link">Sign Up Cover</a>
                <a href="../pages/verify-account.html" class="nav-sub-link">Verify Account</a>
                <a href="../pages/forgot-password.html" class="nav-sub-link">Forgot Password</a>
                <a href="../pages/lock-screen.html" class="nav-sub-link">Lock Screen</a>
              </nav>
            </li>
            <li class="nav-item">
              <a href="" class="nav-link has-sub"><i class="ri-error-warning-line"></i> <span>Error Pages</span></a>
              <nav class="nav nav-sub">
                <a href="../pages/error-404.html" class="nav-sub-link">Page Not Found</a>
                <a href="../pages/error-500.html" class="nav-sub-link">Internal Server Error</a>
                <a href="../pages/error-503.html" class="nav-sub-link">Service Unavailable</a>
                <a href="../pages/error-505.html" class="nav-sub-link">Forbidden</a>
              </nav>
            </li>
            <li class="nav-item">
              <a href="" class="nav-link has-sub"><i class="ri-file-text-line"></i> <span>Other Pages</span></a>
              <nav class="nav nav-sub">
                <a href="../pages/pricing.html" class="nav-sub-link">Pricing</a>
                <a href="../pages/faq.html" class="nav-sub-link">FAQ</a>
              </nav>
            </li>
          </ul>
        </div><!-- nav-group -->
        <div class="nav-group mb-3 show">
          <a href="#" class="nav-label">UI Elements</a>
          <ul class="nav nav-sidebar">
            <li class="nav-item">
              <a href="" class="nav-link has-sub"><i class="ri-pencil-ruler-2-line"></i> <span>Getting Started</span></a>
              <nav class="nav nav-sub">
                <a href="layout-grid.html" class="nav-sub-link">Grid System</a>
                <a href="layout-columns.html" class="nav-sub-link">Columns</a>
                <a href="layout-gutters.html" class="nav-sub-link">Gutters</a>
              </nav>
            </li>
            <li class="nav-item show">
              <a href="" class="nav-link has-sub active"><i class="ri-suitcase-fill"></i> <span>Components</span></a>
              <nav class="nav nav-sub">
                <a href="com-accordion.html" class="nav-sub-link">Accordion</a>
                <a href="com-alerts.html" class="nav-sub-link">Alerts</a>
                <a href="com-avatars.html" class="nav-sub-link">Avatars</a>
                <a href="com-badge.html" class="nav-sub-link">Badge</a>
                <a href="com-breadcrumbs.html" class="nav-sub-link">Breadcrumbs</a>
                <a href="com-buttons.html" class="nav-sub-link">Buttons</a>
                <a href="com-cards.html" class="nav-sub-link">Cards</a>
                <a href="com-carousel.html" class="nav-sub-link">Carousel</a>
                <a href="com-collapse.html" class="nav-sub-link">Collapse</a>
                <a href="com-dropdown.html" class="nav-sub-link">Dropdown</a>
                <a href="com-images.html" class="nav-sub-link">Images</a>
                <a href="com-listgroup.html" class="nav-sub-link">List Group</a>
                <a href="com-markers.html" class="nav-sub-link">Markers</a>
                <a href="com-modal.html" class="nav-sub-link">Modal</a>
                <a href="com-navtabs.html" class="nav-sub-link">Navs &amp; Tabs</a>
                <a href="com-offcanvas.html" class="nav-sub-link">Offcanvas</a>
                <a href="com-pagination.html" class="nav-sub-link">Pagination</a>
                <a href="com-placeholders.html" class="nav-sub-link">Placeholders</a>
                <a href="com-popovers.html" class="nav-sub-link">Popovers</a>
                <a href="com-progress.html" class="nav-sub-link">Progress</a>
                <a href="com-scrollspy.html" class="nav-sub-link">Scrollspy</a>
                <a href="com-spinners.html" class="nav-sub-link">Spinners</a>
                <a href="com-toasts.html" class="nav-sub-link">Toasts</a>
                <a href="com-tooltips.html" class="nav-sub-link">Tooltips</a>
                <a href="com-tables.html" class="nav-sub-link active">Tables</a>
              </nav>
            </li>
            <li class="nav-item">
              <a href="" class="nav-link has-sub"><i class="ri-list-check-2"></i> <span>Forms</span></a>
              <nav class="nav nav-sub">
                <a href="form-elements.html" class="nav-sub-link">Text Elements</a>
                <a href="form-selects.html" class="nav-sub-link">Selects</a>
                <a href="form-checksradios.html" class="nav-sub-link">Checks &amp; Radios</a>
                <a href="form-tagsmasks.html" class="nav-sub-link">Tags &amp; Masks</a>
                <a href="form-range.html" class="nav-sub-link">Range</a>
                <a href="form-pickers.html" class="nav-sub-link">Pickers</a>
                <a href="form-wizards.html" class="nav-sub-link">Wizards</a>
                <a href="form-layouts.html" class="nav-sub-link">Layouts</a>
                <a href="form-validation.html" class="nav-sub-link">Validation</a>
                <a href="form-editors.html" class="nav-sub-link">Editors</a>
              </nav>
            </li>
            <li class="nav-item">
              <a href="" class="nav-link has-sub"><i class="ri-bar-chart-2-line"></i> <span>Charts &amp; Graphs</span></a>
              <nav class="nav nav-sub">
                <a href="chart-flot.html" class="nav-sub-link">Flot</a>
                <a href="chart-apex.html" class="nav-sub-link">Apexcharts</a>
                <a href="chart-chartjs.html" class="nav-sub-link">Chartjs</a>
                <a href="chart-peity.html" class="nav-sub-link">Peity</a>
                <a href="chart-morris.html" class="nav-sub-link">Morris</a>
              </nav>
            </li>
            <li class="nav-item">
              <a href="" class="nav-link has-sub"><i class="ri-stack-line"></i> <span>Maps &amp; Icons</span></a>
              <nav class="nav nav-sub">
                <a href="map-leaflet.html" class="nav-sub-link">Leaflet Maps</a>
                <a href="map-vector.html" class="nav-sub-link">Vector Maps</a>
                <a href="icon-remix.html" class="nav-sub-link">Remixicon</a>
                <a href="icon-feather.html" class="nav-sub-link">Feathericons</a>
              </nav>
            </li>
            <li class="nav-item">
              <a href="" class="nav-link has-sub"><i class="ri-briefcase-4-line"></i> <span>Utilities</span></a>
              <nav class="nav nav-sub">
                <a href="util-animation.html" class="nav-sub-link">Animation</a>
                <a href="util-background.html" class="nav-sub-link">Background</a>
                <a href="util-border.html" class="nav-sub-link">Border</a>
                <a href="util-colors.html" class="nav-sub-link">Colors</a>
                <a href="util-divider.html" class="nav-sub-link">Divider</a>
                <a href="util-flex.html" class="nav-sub-link">Flex</a>
                <a href="util-sizing.html" class="nav-sub-link">Sizing</a>
                <a href="util-spacing.html" class="nav-sub-link">Spacing</a>
                <a href="util-opacity.html" class="nav-sub-link">Opacity</a>
                <a href="util-position.html" class="nav-sub-link">Position</a>
                <a href="util-typography.html" class="nav-sub-link">Typography</a>
                <a href="util-shadows.html" class="nav-sub-link">Shadows</a>
                <a href="util-extras.html" class="nav-sub-link">Extras</a>
              </nav>
            </li>
          </ul>
        </div><!-- nav-group -->

      </div><!-- sidebar-body -->
      <div class="sidebar-footer">
        <div class="sidebar-footer-top">
          <div class="sidebar-footer-thumb">
            <img src="../assets/img/img1.jpg" alt="">
          </div><!-- sidebar-footer-thumb -->
          <div class="sidebar-footer-body">
            <h6><a href="../pages/profile.html">Shaira Diaz</a></h6>
            <p>Premium Member</p>
          </div><!-- sidebar-footer-body -->
          <a id="sidebarFooterMenu" href="" class="dropdown-link"><i class="ri-arrow-down-s-line"></i></a>
        </div><!-- sidebar-footer-top -->
        <div class="sidebar-footer-menu">
          <nav class="nav">
            <a href=""><i class="ri-edit-2-line"></i> Edit Profile</a>
            <a href=""><i class="ri-profile-line"></i> View Profile</a>
          </nav>
          <hr>
          <nav class="nav">
            <a href=""><i class="ri-question-line"></i> Help Center</a>
            <a href=""><i class="ri-lock-line"></i> Privacy Settings</a>
            <a href=""><i class="ri-user-settings-line"></i> Account Settings</a>
            <a href=""><i class="ri-logout-box-r-line"></i> Log Out</a>
          </nav>
        </div><!-- sidebar-footer-menu -->
      </div><!-- sidebar-footer -->
    </div><!-- sidebar -->

    <div class="main-mobile-header doc-mobile-header">
      <a id="menuLink" href="#" class="menu-link"><i class="ri-menu-line"></i></a>
    </div><!-- main-mobile-header -->

    <div class="main main-docs">
      <div class="container">
        <label class="main-title-label">Components</label>
        <h2 class="main-title">Tables</h2>
        <p class="main-title-text">Documentation and examples for opt-in styling of tables (given their prevalent use in JavaScript plugins) with Bootstrap. Read the <a href="https://getbootstrap.com/docs/5.1/content/tables/" target="_blank">Official Bootstrap Documentation</a> for a full list of instructions and other options.</p>

        <hr class="main-separator">

        <h5 id="section1" class="main-subtitle">Basic Example</h5>
        <p>Using the most basic table markup, here’s how .table based tables look in Bootstrap. All table styles are inherited in Bootstrap 5, meaning any nested tables will be styled in the same manner as the parent.</p>

        <div class="card card-example">
          <div class="card-body">
            <div class="table-responsive">
              <table class="table mb-0">
                <thead>
                  <tr>
                    <th scope="col">ID</th>
                    <th scope="col">Name</th>
                    <th scope="col">Job Title</th>
                    <th scope="col">Degree</th>
                    <th scope="col">Salary</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <th scope="row">1</th>
                    <td>Adrian Monino</td>
                    <td>Front-End Engineer</td>
                    <td>Computer Science</td>
                    <td>$120,000</td>
                  </tr>
                  <tr>
                    <th scope="row">2</th>
                    <td>Socrates Itumay</td>
                    <td>Software Engineer</td>
                    <td>Computer Engineering</td>
                    <td>$150,000</td>
                  </tr>
                  <tr>
                    <th scope="row">3</th>
                    <td>Reynante Labares</td>
                    <td>Product Manager</td>
                    <td>Business Management</td>
                    <td>$250,000</td>
                  </tr>
                </tbody>
              </table>
            </div><!-- table-responsive -->
          </div><!-- card-body -->
          <div class="card-footer">
            <pre><code class="language-html">&lt;table class=&quot;table&quot;&gt;
  &lt;thead&gt;
    &lt;tr&gt;
      &lt;th scope=&quot;col&quot;&gt;ID&lt;/th&gt;
      &lt;th scope=&quot;col&quot;&gt;Name&lt;/th&gt;
      &lt;th scope=&quot;col&quot;&gt;Job Title&lt;/th&gt;
      &lt;th scope=&quot;col&quot;&gt;Degree&lt;/th&gt;
      &lt;th scope=&quot;col&quot;&gt;Salary&lt;/th&gt;
    &lt;/tr&gt;
  &lt;/thead&gt;
  &lt;tbody&gt;
    &lt;tr&gt;
      &lt;th scope=&quot;row&quot;&gt;1&lt;/th&gt;
      &lt;td&gt;Adrian Monino&lt;/td&gt;
      &lt;td&gt;Front-End Engineer&lt;/td&gt;
      &lt;td&gt;Computer Science&lt;/td&gt;
      &lt;td&gt;$120,000&lt;/td&gt;
    &lt;/tr&gt;
    &lt;tr&gt;
      &lt;th scope=&quot;row&quot;&gt;2&lt;/th&gt;
      &lt;td&gt;Socrates Itumay&lt;/td&gt;
      &lt;td&gt;Software Engineer&lt;/td&gt;
      &lt;td&gt;Computer Engineering&lt;/td&gt;
      &lt;td&gt;$150,000&lt;/td&gt;
    &lt;/tr&gt;
    &lt;tr&gt;
      &lt;th scope=&quot;row&quot;&gt;3&lt;/th&gt;
      &lt;td&gt;Reynante Labares&lt;/td&gt;
      &lt;td&gt;Product Manager&lt;/td&gt;
      &lt;td&gt;Business Management&lt;/td&gt;
      &lt;td&gt;$250,000&lt;/td&gt;
    &lt;/tr&gt;
  &lt;/tbody&gt;
&lt;/table&gt;</code></pre>
          </div><!-- card-footer -->
        </div><!-- card -->

        <br><br><br>

        <h5 id="section2" class="main-subtitle">Striped Rows</h5>
        <p>Use <code>.table-striped</code> to add zebra-striping to any table row within the tbody.</p>

        <div class="card card-example">
          <div class="card-body">
            <div class="table-responsive">
              <table class="table table-striped mb-0">
                <thead>
                  <tr>
                    <th scope="col">ID</th>
                    <th scope="col">Name</th>
                    <th scope="col">Job Title</th>
                    <th scope="col">Degree</th>
                    <th scope="col">Salary</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <th scope="row">1</th>
                    <td>Adrian Monino</td>
                    <td>Front-End Engineer</td>
                    <td>Computer Science</td>
                    <td>$120,000</td>
                  </tr>
                  <tr>
                    <th scope="row">2</th>
                    <td>Socrates Itumay</td>
                    <td>Software Engineer</td>
                    <td>Computer Engineering</td>
                    <td>$150,000</td>
                  </tr>
                  <tr>
                    <th scope="row">3</th>
                    <td>Reynante Labares</td>
                    <td>Product Manager</td>
                    <td>Business Management</td>
                    <td>$250,000</td>
                  </tr>
                </tbody>
              </table>
            </div><!-- table-responsive -->
          </div><!-- card-body -->
          <div class="card-footer">
            <pre><code class="language-html">&lt;table class=&quot;table table-striped&quot;&gt;...&lt;/table&gt;</code></pre>
          </div><!-- card-footer -->
        </div><!-- card -->

        <br><br><br>

        <h5 id="section3" class="main-subtitle">Hoverable Rows</h5>
        <p>Add <code>.table-hover</code> to enable a hover state on table rows within a tbody.</p>

        <div class="card card-example">
          <div class="card-body">
            <div class="table-responsive">
              <table class="table table-hover mb-0">
                <thead>
                  <tr>
                    <th scope="col">ID</th>
                    <th scope="col">Name</th>
                    <th scope="col">Job Title</th>
                    <th scope="col">Degree</th>
                    <th scope="col">Salary</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <th scope="row">1</th>
                    <td>Adrian Monino</td>
                    <td>Front-End Engineer</td>
                    <td>Computer Science</td>
                    <td>$120,000</td>
                  </tr>
                  <tr>
                    <th scope="row">2</th>
                    <td>Socrates Itumay</td>
                    <td>Software Engineer</td>
                    <td>Computer Engineering</td>
                    <td>$150,000</td>
                  </tr>
                  <tr>
                    <th scope="row">3</th>
                    <td>Reynante Labares</td>
                    <td>Product Manager</td>
                    <td>Business Management</td>
                    <td>$250,000</td>
                  </tr>
                </tbody>
              </table>
            </div><!-- table-responsive -->
          </div><!-- card-body -->
          <div class="card-footer">
            <pre><code class="language-html">&lt;table class=&quot;table table-hover&quot;&gt;...&lt;/table&gt;</code></pre>
          </div><!-- card-footer -->
        </div><!-- card -->

        <br><br><br>

        <h5 id="section4" class="main-subtitle">Active Rows</h5>
        <p>Highlight a table row or cell by adding a <code>.table-active</code> class.</p>

        <div class="card card-example">
          <div class="card-body">
            <div class="table-responsive">
              <table class="table mb-0">
                <thead>
                  <tr>
                    <th scope="col">ID</th>
                    <th scope="col">Name</th>
                    <th scope="col">Job Title</th>
                    <th scope="col">Degree</th>
                    <th scope="col">Salary</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <th scope="row">1</th>
                    <td>Adrian Monino</td>
                    <td>Front-End Engineer</td>
                    <td>Computer Science</td>
                    <td>$120,000</td>
                  </tr>
                  <tr class="table-active">
                    <th scope="row">2</th>
                    <td>Socrates Itumay</td>
                    <td>Software Engineer</td>
                    <td>Computer Engineering</td>
                    <td>$150,000</td>
                  </tr>
                  <tr>
                    <th scope="row">3</th>
                    <td>Reynante Labares</td>
                    <td>Product Manager</td>
                    <td>Business Management</td>
                    <td>$250,000</td>
                  </tr>
                </tbody>
              </table>
            </div><!-- table-responsive -->
          </div><!-- card-body -->
          <div class="card-footer">
            <pre><code class="language-html">&lt;tr class=&quot;table-active&quot;&gt;
  &lt;th scope=&quot;row&quot;&gt;2&lt;/th&gt;
  &lt;td&gt;Socrates Itumay&lt;/td&gt;
  &lt;td&gt;Software Engineer&lt;/td&gt;
  &lt;td&gt;Computer Engineering&lt;/td&gt;
  &lt;td&gt;$150,000&lt;/td&gt;
&lt;/tr&gt;</code></pre>
          </div><!-- card-footer -->
        </div><!-- card -->

        <br><br><br>

        <h5 id="section5" class="main-subtitle">Color Variants</h5>
        <p>Use contextual classes to color tables, table rows or individual cells.</p>

        <div class="card card-example">
          <div class="card-body">
            <div class="table-responsive">
              <table class="table table-primary mb-0">
                <thead>
                  <tr>
                    <th scope="col">ID</th>
                    <th scope="col">Name</th>
                    <th scope="col">Job Title</th>
                    <th scope="col">Degree</th>
                    <th scope="col">Salary</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <th scope="row">1</th>
                    <td>Adrian Monino</td>
                    <td>Front-End Engineer</td>
                    <td>Computer Science</td>
                    <td>$120,000</td>
                  </tr>
                  <tr>
                    <th scope="row">2</th>
                    <td>Socrates Itumay</td>
                    <td>Software Engineer</td>
                    <td>Computer Engineering</td>
                    <td>$150,000</td>
                  </tr>
                  <tr>
                    <th scope="row">3</th>
                    <td>Reynante Labares</td>
                    <td>Product Manager</td>
                    <td>Business Management</td>
                    <td>$250,000</td>
                  </tr>
                </tbody>
              </table>
            </div><!-- table-responsive -->
          </div><!-- card-body -->
          <div class="card-footer">
            <pre><code class="language-html">&lt;table class=&quot;table table-primary&quot;&gt;...&lt;/table&gt;</code></pre>
          </div><!-- card-footer -->
        </div><!-- card -->

        <br><br><br>

        <h5 id="section6" class="main-subtitle">Table Borders</h5>
        <p>Add <code>.table-bordered</code> for borders on all sides of the table and cells. Add <code>.table-borderless</code> for a table without borders.</p>

        <div class="card card-example">
          <div class="card-body">
            <div class="table-responsive">
              <table class="table table-bordered mb-0">
                <thead>
                  <tr>
                    <th scope="col">ID</th>
                    <th scope="col">Name</th>
                    <th scope="col">Job Title</th>
                    <th scope="col">Degree</th>
                    <th scope="col">Salary</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <th scope="row">1</th>
                    <td>Adrian Monino</td>
                    <td>Front-End Engineer</td>
                    <td>Computer Science</td>
                    <td>$120,000</td>
                  </tr>
                  <tr>
                    <th scope="row">2</th>
                    <td>Socrates Itumay</td>
                    <td>Software Engineer</td>
                    <td>Computer Engineering</td>
                    <td>$150,000</td>
                  </tr>
                  <tr>
                    <th scope="row">3</th>
                    <td>Reynante Labares</td>
                    <td>Product Manager</td>
                    <td>Business Management</td>
                    <td>$250,000</td>
                  </tr>
                </tbody>
              </table>
            </div><!-- table-responsive -->
          </div><!-- card-body -->
          <div class="card-footer">
            <pre><code class="language-html">&lt;table class=&quot;table table-bordered&quot;&gt;...&lt;/table&gt;</code></pre>
          </div><!-- card-footer -->
        </div><!-- card -->

        <div class="card card-example">
          <div class="card-body">
            <div class="table-responsive">
              <table class="table table-borderless mb-0">
                <thead>
                  <tr>
                    <th scope="col">ID</th>
                    <th scope="col">Name</th>
                    <th scope="col">Job Title</th>
                    <th scope="col">Degree</th>
                    <th scope="col">Salary</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <th scope="row">1</th>
                    <td>Adrian Monino</td>
                    <td>Front-End Engineer</td>
                    <td>Computer Science</td>
                    <td>$120,000</td>
                  </tr>
                  <tr>
                    <th scope="row">2</th>
                    <td>Socrates Itumay</td>
                    <td>Software Engineer</td>
                    <td>Computer Engineering</td>
                    <td>$150,000</td>
                  </tr>
                  <tr>
                    <th scope="row">3</th>
                    <td>Reynante Labares</td>
                    <td>Product Manager</td>
                    <td>Business Management</td>
                    <td>$250,000</td>
                  </tr>
                </tbody>
              </table>
            </div><!-- table-responsive -->
          </div><!-- card-body -->
          <div class="card-footer">
            <pre><code class="language-html">&lt;table class=&quot;table table-borderless&quot;&gt;...&lt;/table&gt;</code></pre>
          </div><!-- card-footer -->
        </div><!-- card -->

        <br><br><br>

        <h5 id="section7" class="main-subtitle">Small Table</h5>
        <p>Add <code>.table-sm</code> to make any table more compact by cutting all cell padding in half.</p>

        <div class="card card-example">
          <div class="card-body">
            <div class="table-responsive">
              <table class="table table-sm mb-0">
                <thead>
                  <tr>
                    <th scope="col">ID</th>
                    <th scope="col">Name</th>
                    <th scope="col">Job Title</th>
                    <th scope="col">Degree</th>
                    <th scope="col">Salary</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <th scope="row">1</th>
                    <td>Adrian Monino</td>
                    <td>Front-End Engineer</td>
                    <td>Computer Science</td>
                    <td>$120,000</td>
                  </tr>
                  <tr>
                    <th scope="row">2</th>
                    <td>Socrates Itumay</td>
                    <td>Software Engineer</td>
                    <td>Computer Engineering</td>
                    <td>$150,000</td>
                  </tr>
                  <tr>
                    <th scope="row">3</th>
                    <td>Reynante Labares</td>
                    <td>Product Manager</td>
                    <td>Business Management</td>
                    <td>$250,000</td>
                  </tr>
                </tbody>
              </table>
            </div><!-- table-responsive -->
          </div><!-- card-body -->
          <div class="card-footer">
            <pre><code class="language-html">&lt;table class=&quot;table table-sm&quot;&gt;...&lt;/table&gt;</code></pre>
          </div><!-- card-footer -->
        </div><!-- card -->

        <br><br><br>

        <h5 id="section8" class="main-subtitle">Responsive Table</h5>
        <p>Responsive tables allow tables to be scrolled horizontally with ease. Make any table responsive across all viewports by wrapping a table with <code>.table-responsive</code>.</p>

        <div class="card card-example">
          <div class="card-body">
            <div class="table-responsive">
              <table class="table mb-0">
                <thead>
                  <tr>
                    <th scope="col">#</th>
                    <th scope="col">Heading</th>
                    <th scope="col">Heading</th>
                    <th scope="col">Heading</th>
                    <th scope="col">Heading</th>
                    <th scope="col">Heading</th>
                    <th scope="col">Heading</th>
                    <th scope="col">Heading</th>
                    <th scope="col">Heading</th>
                    <th scope="col">Heading</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <th scope="row">1</th>
                    <td>Cell</td>
                    <td>Cell</td>
                    <td>Cell</td>
                    <td>Cell</td>
                    <td>Cell</td>
                    <td>Cell</td>
                    <td>Cell</td>
                    <td>Cell</td>
                    <td>Cell</td>
                  </tr>
                  <tr>
                    <th scope="row">2</th>
                    <td>Cell</td>
                    <td>Cell</td>
                    <td>Cell</td>
                    <td>Cell</td>
                    <td>Cell</td>
                    <td>Cell</td>
                    <td>Cell</td>
                    <td>Cell</td>
                    <td>Cell</td>
                  </tr>
                  <tr>
                    <th scope="row">3</th>
                    <td>Cell</td>
                    <td>Cell</td>
                    <td>Cell</td>
                    <td>Cell</td>
                    <td>Cell</td>
                    <td>Cell</td>
                    <td>Cell</td>
                    <td>Cell</td>
                    <td>Cell</td>
                  </tr>
                </tbody>
              </table>
            </div>

          </div><!-- card-body -->
          <div class="card-footer">
            <pre><code class="language-html">&lt;div class=&quot;table-responsive&quot;&gt;
  &lt;table class=&quot;table&quot;&gt;
    ...
  &lt;/table&gt;
&lt;/div&gt;</code></pre>
          </div><!-- card-footer -->
        </div><!-- card -->

        <br><br><br><hr><br><br><br>

        <h2 class="main-title">Grid.js</h2>
        <p class="main-title-text">Grid.js is a table plugin written in TypeScript. It is developed to be used with all popular JavaScript frameworks include React, Angular.js, Vue or without any frameworks! Read the <a href="https://gridjs.io/docs/index" target="_blank">Official Grid.js Documentation</a> for a full list of instructions and other options.</p>

        <br><br>

        <h5 id="section9" class="main-subtitle">Basic Example</h5>
        <p>In this examples, we load the data from an existing HTML table.</p>

        <div class="card card-example">
          <div class="card-body">
            <div class="table-responsive">
              <table id="tableGrid1">
                <thead>
                  <tr>
                    <th scope="col">ID</th>
                    <th scope="col">Name</th>
                    <th scope="col">Job Title</th>
                    <th scope="col">Degree</th>
                    <th scope="col">Salary</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <th scope="row">1</th>
                    <td>Adrian Monino</td>
                    <td>Front-End Engineer</td>
                    <td>Computer Science</td>
                    <td>$120,000</td>
                  </tr>
                  <tr>
                    <th scope="row">2</th>
                    <td>Socrates Itumay</td>
                    <td>Software Engineer</td>
                    <td>Computer Engineering</td>
                    <td>$150,000</td>
                  </tr>
                  <tr>
                    <th scope="row">3</th>
                    <td>Reynante Labares</td>
                    <td>Product Manager</td>
                    <td>Business Management</td>
                    <td>$250,000</td>
                  </tr>
                </tbody>
              </table>
            </div><!-- table-responsive -->
          </div><!-- card-body -->
          <div class="card-footer">
            <pre><code class="language-javascript">$("#tableGrid1").Grid({
  className: {
    table: 'table'
  }
});</code></pre>
          </div><!-- card-footer -->
        </div><!-- card -->

        <br><br><br>

        <h5 id="section10" class="main-subtitle">Pagination</h5>
        <p>Pagination can be enabled by setting <code>pagination: true</code>.</p>

        <div class="card card-example">
          <div class="card-body">
            <div class="table-responsive">
              <table id="tableGrid2">
                <thead>
                  <tr>
                    <th scope="col">ID</th>
                    <th scope="col">Name</th>
                    <th scope="col">Job Title</th>
                    <th scope="col">Degree</th>
                    <th scope="col">Salary</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <th scope="row">1</th>
                    <td>Adrian Monino</td>
                    <td>Front-End Engineer</td>
                    <td>Computer Science</td>
                    <td>$120,000</td>
                  </tr>
                  <tr>
                    <th scope="row">2</th>
                    <td>Socrates Itumay</td>
                    <td>Software Engineer</td>
                    <td>Computer Engineering</td>
                    <td>$150,000</td>
                  </tr>
                  <tr>
                    <th scope="row">3</th>
                    <td>Reynante Labares</td>
                    <td>Product Manager</td>
                    <td>Business Management</td>
                    <td>$250,000</td>
                  </tr>
                </tbody>
              </table>
            </div><!-- table-responsive -->
          </div><!-- card-body -->
          <div class="card-footer">
            <pre><code class="language-javascript">$("#tableGrid2").Grid({
  className: {
    table: 'table table-bordered mb-0'
  },
  pagination: true
});</code></pre>
          </div><!-- card-footer -->
        </div><!-- card -->

        <br><br><br>

        <h5 id="section11" class="main-subtitle">Search</h5>
        <p>Supports global search on all rows and columns. Set <code>search: true</code> to enable the search plugin.</p>

        <div class="card card-example">
          <div class="card-body">
            <div class="table-responsive">
              <table id="tableGrid3">
                <thead>
                  <tr>
                    <th scope="col">ID</th>
                    <th scope="col">Name</th>
                    <th scope="col">Job Title</th>
                    <th scope="col">Degree</th>
                    <th scope="col">Salary</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <th scope="row">1</th>
                    <td>Adrian Monino</td>
                    <td>Front-End Engineer</td>
                    <td>Computer Science</td>
                    <td>$120,000</td>
                  </tr>
                  <tr>
                    <th scope="row">2</th>
                    <td>Socrates Itumay</td>
                    <td>Software Engineer</td>
                    <td>Computer Engineering</td>
                    <td>$150,000</td>
                  </tr>
                  <tr>
                    <th scope="row">3</th>
                    <td>Reynante Labares</td>
                    <td>Product Manager</td>
                    <td>Business Management</td>
                    <td>$250,000</td>
                  </tr>
                </tbody>
              </table>
            </div><!-- table-responsive -->
          </div><!-- card-body -->
          <div class="card-footer">
            <pre><code class="language-javascript">$("#tableGrid3").Grid({
  className: {
    table: 'table table-bordered mb-0'
  },
  search: true
});</code></pre>
          </div><!-- card-footer -->
        </div><!-- card -->

        <br><br><br>

        <h5 id="section12" class="main-subtitle">Sorting</h5>
        <p>To enable sorting, simply add <code>sort: true</code> to your config.</p>

        <div class="card card-example">
          <div class="card-body">
            <div class="table-responsive">
              <table id="tableGrid4">
                <thead>
                  <tr>
                    <th scope="col">Name</th>
                    <th scope="col">Job Title</th>
                    <th scope="col">Degree</th>
                    <th scope="col">Salary</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <td>Adrian Monino</td>
                    <td>Front-End Engineer</td>
                    <td>Computer Science</td>
                    <td>$120,000</td>
                  </tr>
                  <tr>
                    <td>Socrates Itumay</td>
                    <td>Software Engineer</td>
                    <td>Computer Engineering</td>
                    <td>$150,000</td>
                  </tr>
                  <tr>
                    <td>Reynante Labares</td>
                    <td>Product Manager</td>
                    <td>Business Management</td>
                    <td>$250,000</td>
                  </tr>
                </tbody>
              </table>
            </div><!-- table-responsive -->
          </div><!-- card-body -->
          <div class="card-footer">
            <pre><code class="language-javascript">$("#tableGrid4").Grid({
  className: {
    table: 'table table-bordered mb-0'
  },
  sort: true
});</code></pre>
          </div><!-- card-footer -->
        </div><!-- card -->

        <br><br><br>

        <h5 id="section13" class="main-subtitle">Resizable Columns</h5>
        <p>Simply add <code>resizable: true</code> to your config to enable resizable columns.</p>

        <div class="card card-example">
          <div class="card-body">
            <div class="table-responsive">
              <table id="tableGrid5">
                <thead>
                  <tr>
                    <th scope="col">Name</th>
                    <th scope="col">Job Title</th>
                    <th scope="col">Degree</th>
                    <th scope="col">Salary</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <td>Adrian Monino</td>
                    <td>Front-End Engineer</td>
                    <td>Computer Science</td>
                    <td>$120,000</td>
                  </tr>
                  <tr>
                    <td>Socrates Itumay</td>
                    <td>Software Engineer</td>
                    <td>Computer Engineering</td>
                    <td>$150,000</td>
                  </tr>
                  <tr>
                    <td>Reynante Labares</td>
                    <td>Product Manager</td>
                    <td>Business Management</td>
                    <td>$250,000</td>
                  </tr>
                </tbody>
              </table>
            </div><!-- table-responsive -->
          </div><!-- card-body -->
          <div class="card-footer">
            <pre><code class="language-javascript">$("#tableGrid5").Grid({
  className: {
    table: 'table table-bordered mb-0'
  },
  sort: true,
  resizable: true
});</code></pre>
          </div><!-- card-footer -->
        </div><!-- card -->

        <br><br><br>

      </div><!-- container -->

      <nav id="navDocs" class="nav nav-docs">
        <label>Bootstrap Table</label>
        <a href="#section1" class="nav-link">Basic Example</a>
        <a href="#section2" class="nav-link">Striped Rows</a>
        <a href="#section3" class="nav-link">Hoverable Rows</a>
        <a href="#section4" class="nav-link">Active Rows</a>
        <a href="#section5" class="nav-link">Color Variants</a>
        <a href="#section6" class="nav-link">Table Borders</a>
        <a href="#section7" class="nav-link">Small Table</a>
        <a href="#section8" class="nav-link">Responsive Table</a>

        <hr>

        <label>Grid JS</label>
        <a href="#section9" class="nav-link">Basic Example</a>
        <a href="#section10" class="nav-link">Pagination</a>
        <a href="#section11" class="nav-link">Search</a>
        <a href="#section12" class="nav-link">Sorting</a>
        <a href="#section13" class="nav-link">Resizable Columns</a>
      </nav>
    </div><!-- main -->

    <div class="main-footer main-footer-docs">
      <span>&copy; 2023. Dashbyte. All Rights Reserved.</span>
      <span>Created by: <a href="http://themepixels.me" target="_blank">Themepixels</a></span>
    </div><!-- main-footer -->

    <script src="../lib/jquery/jquery.min.js"></script>
    <script src="../lib/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="../lib/prismjs/prism.js"></script>
    <script src="../lib/perfect-scrollbar/perfect-scrollbar.min.js"></script>
    <script src="../lib/gridjs-jquery/gridjs.production.min.js"></script>

    <script src="../assets/js/script.js"></script>
    <script>
      'use strict'

      // Basic Example
      $("#tableGrid1").Grid({
        className: {
          table: 'table table-bordered mb-0'
        }
      });

      // Pagination
      $("#tableGrid2").Grid({
        className: {
          table: 'table table-bordered mb-0'
        },
        pagination: true
      });

      // Search
      $("#tableGrid3").Grid({
        className: {
          table: 'table table-bordered mb-0'
        },
        search: true
      });

      // Sorting
      $("#tableGrid4").Grid({
        className: {
          table: 'table table-bordered mb-0'
        },
        sort: true
      });

      // Resizable
      $("#tableGrid5").Grid({
        className: {
          table: 'table table-bordered mb-0'
        },
        sort: true,
        resizable: true
      });
    </script>
  </body>
</html>
<?php /**PATH C:\xampp\htdocs\Naksha\resources\views/tables/all_tables.blade.php ENDPATH**/ ?>