<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\UserController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\Employee\EmployeeController;
use App\Http\Controllers\Customer\CustomerController;
use App\Http\Controllers\Individual\IndividualCustomerController;
use App\Http\Controllers\Approvals\ApprovalController;
use App\Http\Controllers\IndividualApproval\IndividualApprovalController;
use App\Http\Controllers\Supplier\SupplierController;
use App\Http\Controllers\Inventory\InventoryController;
use App\Http\Controllers\NonInventory\NonInventoryController;
use App\Http\Controllers\ProductSrvices\ProductServicesController;
use App\Http\Controllers\Hotel\HotelController;
use App\Http\Controllers\HotelServices\HotelServiceController;
use App\Http\Controllers\Flight\FlightController;
use App\Http\Controllers\TourPackage\TourPackageController;
use App\Http\Controllers\Itinerary\ItineraryController;
use App\Http\Controllers\Visa\VisaController;
use App\Http\Controllers\Carhire\CarhireController;
use App\Http\Controllers\Assist\AssistController;
use App\Http\Controllers\Insurance\InsuranceController;
use App\Http\Controllers\InsurancePlan\InsurancePlanController;
use App\Http\Controllers\Account\AccountController;
use App\Http\Controllers\Taxmaster\TaxmasterController;
use App\Http\Controllers\DSR\DsrController;
use App\Http\Controllers\Mice\MiceController;
use App\Http\Controllers\Invoice\InvoiceController;
use App\Http\Controllers\Quotation\QuotationController;
use App\Http\Controllers\Proforma\ProformaController;
use App\Http\Controllers\Creditnote\CreditnoteController;
use App\Http\Controllers\Debitnote\DebitnoteController;
use App\Http\Controllers\Payments\PaymentsController;
use App\Http\Controllers\Expense\ExpenseController;
use App\Http\Controllers\PurchaseOrder\PurchaseOrderController;
use App\Http\Controllers\Bills\BillsController;
use App\Http\Controllers\Payments\PaymentMadeController;
use App\Http\Controllers\Grn\GrnController;
use App\Http\Controllers\Grn\ServiceController;
use App\Http\Controllers\Item\ItemController;
use App\Http\Controllers\Category\CategoryController;
use App\Http\Controllers\User\UserManagementController;
use App\Http\Controllers\MpdfGenerator\MpdfGenerator;

use App\Models\Permission;



/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::view('/blank', 'blank');
// Route::view('/lists', 'table');
Route::view('/edit', 'edit');

    // Route::view('/test', 'non-inventory.create');
    // Route::view('/hotel', 'hotel.create');
    // Route::view('/tour', 'tourpackage.create');


Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::prefix('')->middleware('auth')->group(function(){
    
    Route::view('/', 'new');
    Route::get('document', [MpdfGenerator::class,'index']);
    Route::get('documents', [MpdfGenerator::class,'document']);

Route::middleware(['can:view-users'])->group(function () {
   Route::resource('/users', UserManagementController::class);
    Route::post('/users-new', [UserManagementController::class,'create']);
    Route::get('/users-edit/{id}', [UserManagementController::class,'edit']);
    Route::post('/users-update', [UserManagementController::class,'update']);
    Route::get('/users/{id}/delete', [UserManagementController::class, 'delete']);
});  
    
    // Route::resource('roles', RoleController::class);
    // Route::resource('users', UserController::class);
    
    

    Route::get('document', [MpdfGenerator::class,'index']);
    Route::get('document-download', [MpdfGenerator::class,'document']);
    Route::resource('category', CategoryController::class);
    Route::get('category/{id}/view', [CategoryController::class, 'show']);
    Route::get('category/{id}/delete', [CategoryController::class, 'destroy']);
    Route::get('/category/status-update/{id}',[CategoryController::class, 'status_update']);
    Route::get('category/{id}/edit', [CategoryController::class, 'edit']);
    Route::put('category_sevice_update', [CategoryController::class, 'update']);
    
    

Route::post('/set-data', [ItemController::class, 'setData'])->name('setData');
Route::get('/get-data', [ItemController::class, 'getData'])->name('getData');

Route::post('/set-purchaseorder', [ItemController::class, 'setPurchaseorder'])->name('setPurchaseorder');
Route::get('/get-purchaseorder', [ItemController::class, 'getPurchaseorder'])->name('getPurchaseorder');
    

    Route::post('/item/add', [ItemController::class, 'addHotel'])->name('item.addHotel');
    Route::get('item/remove/{id}', [ItemController::class, 'removeItem']);

    Route::post('/item/charges/add', [ItemController::class, 'addCharges']);
    Route::get('item/charges/remove/{id}', [ItemController::class, 'removeCharges']);

Route::middleware(['can:view-sales-data'])->group(function () {
        Route::get('dsr/voucher/{type}/{id}', [DsrController::class, 'voucher']);
  Route::get('dsr/service/edit/{type}/{id}', [DsrController::class, 'editService'])->name('editService');
  Route::get('dsr/service/delete/{type}/{id}', [DsrController::class, 'destroyDsrService'])->name('destroyDsrService');


    Route::resource('dsr', DsrController::class);
    Route::post('drs/passenger/store', [DsrController::class, 'storePassengers']);
    Route::post('dsr/hotelservice/add', [DsrController::class, 'addHotelService'])->name('addHotelService');
    Route::post('dsr/flightservice/add', [DsrController::class, 'addFlightService'])->name('addFlightService');
    Route::post('dsr/visaservice/add', [DsrController::class, 'addVisaService'])->name('addVisaService');
    Route::post('dsr/insuranceservice/add', [DsrController::class, 'addInsuranceService'])->name('addInsuranceService');
    Route::post('dsr/carhireservice/add', [DsrController::class, 'addCarhireService'])->name('addCarhireService');
    Route::post('dsr/assistservice/add', [DsrController::class, 'addAssistService'])->name('addAssistService');
    Route::post('dsr/otherservice/add', [DsrController::class, 'addOtherService'])->name('addOtherService');
    
    Route::post('dsr/hotelservice/update', [DsrController::class, 'editHotelService'])->name('editHotelService');
    Route::post('dsr/flightservice/update', [DsrController::class, 'editFlightService'])->name('editFlightService');
    Route::post('dsr/visaservice/update', [DsrController::class, 'editVisaService'])->name('editVisaService');
    Route::post('dsr/insuranceservice/update', [DsrController::class, 'editInsuranceService'])->name('editInsuranceService');
    Route::post('dsr/carhireservice/update', [DsrController::class, 'editCarhireService'])->name('editCarhireService');
    Route::post('dsr/assistservice/update', [DsrController::class, 'editAssistService'])->name('editAssistService');
    Route::post('dsr/otherservice/update', [DsrController::class, 'editOtherService'])->name('updateOtherService');
    
    Route::get('dsr/services/{id}', [DsrController::class, 'services'])->name('DsrService');
    Route::get('dsr/summary/{id}', [DsrController::class, 'summary'])->name('DsrSummery');
    // Route::get('dsr/services/delete/{id}', [DsrController::class, 'destroyService']);
    Route::get('dsr/passenger/delete/{id}', [DsrController::class, 'destroyService']);
    Route::get('dsr/passenger/summary/{id}', [DsrController::class, 'passenger_summary']);
    Route::get('dsr/hotels/{id}', [DsrController::class, 'hotelServices']);
    Route::get('dsr/flight/list', [DsrController::class, 'flightServices']);
    Route::get('dsr/tour/list', [DsrController::class, 'tourServices']);
    Route::get('dsr/{id}/view', [DsrController::class, 'show']);
    Route::get('dsr/{id}/passenger', [DsrController::class, 'Passenger'])->name('Passengers');
    Route::get('dsr/{id}/edit', [DsrController::class, 'edit']);
    Route::get('dsr/{id}/delete', [DsrController::class, 'destroy']);
    Route::get('passengers/{type}/{id}', [DsrController::class, 'guest']);

    // Route::resource('mice', MiceController::class);
    Route::get('/mice', [MiceController::class, 'index'])->name('Mice');
    Route::post('/mice/store', [MiceController::class, 'store'])->name('MiceStore');
    Route::get('/mice/create', [MiceController::class, 'create'])->name('MiceCreate');
    // Route::get('/mice/store/{id}', [MiceController::class, 'store'])->name('MiceService');
    // Route::get('/mice/store/{id}', [MiceController::class, 'store'])->name('MiceService');
    // Route::get('/mice/store/{id}', [MiceController::class, 'store'])->name('MiceService');

    Route::post('mice/passenger/store', [MiceController::class, 'storePassengers']);
    Route::get('mice/passenger/summary/{id}', [MiceController::class, 'passenger_summary']);

    Route::post('mice/hotelservice/add', [MiceController::class, 'addHotelService'])->name('addHotelService');
    Route::post('mice/flightservice/add', [MiceController::class, 'addFlightService'])->name('addFlightService');
    Route::post('mice/visaservice/add', [MiceController::class, 'addVisaService'])->name('addVisaService');
    Route::post('mice/insuranceservice/add', [MiceController::class, 'addInsuranceService'])->name('addInsuranceService');
    Route::post('mice/otherservice/add', [MiceController::class, 'addOtherService'])->name('addOtherService');
    Route::get('mice/services/{id}', [MiceController::class, 'services'])->name('miceService');
    Route::get('mice/family/{type}/{id}', [MiceController::class, 'family'])->name('miceFamily');
    Route::post('mice/family/add', [MiceController::class, 'addMiceFamily'])->name('addMiceFamily');
    Route::get('mice/delete/{id}', [MiceController::class, 'deleteMiceFamily'])->name('deleteMiceFamily');
    Route::get('mice/hotels/{id}', [MiceController::class, 'hotelServices']);
    Route::get('mice/flight/list', [MiceController::class, 'flightServices']);
    Route::get('mice/tour/list', [MiceController::class, 'tourServices']);
    Route::get('mice/{id}/view', [MiceController::class, 'show']);
    Route::get('mice/{id}/passenger', [MiceController::class, 'Passenger']);
    Route::get('mice/{id}/edit', [MiceController::class, 'edit']);
    Route::get('mice/{id}/delete', [MiceController::class, 'destroy']);
    Route::get('mice/summary/{id}', [MiceController::class, 'summary']);
    Route::get('mice/summaryd/{id}', [MiceController::class, 'summaryd']);
    Route::get('mice/summary/passenger/{id}', [MiceController::class, 'summary1d']);
    Route::get('passengers/{type}/{id}', [MiceController::class, 'guest']);


    
});

Route::middleware(['can:view-approval'])->group(function () {
    Route::resource('/approval', ApprovalController::class);
    Route::get('/invoice_approval', [ApprovalController::class, 'invoice'])->name('InvApproval');
    Route::get('/proforma/approval', [ApprovalController::class, 'proforma']);
    Route::get('/status_update/{id}',[ApprovalController::class, 'status_update']);
    Route::get('invoice_approval/{id}', [ApprovalController::class, 'invoice_approval']);
    Route::get('invoice_reject/{id}', [ApprovalController::class, 'invoice_reject']);
    Route::get('proforma_approval/{id}', [ApprovalController::class, 'proforma_approval']);
    Route::get('/grn/approval', [ApprovalController::class, 'grn']);
    Route::get('grn_approval/{id}', [ApprovalController::class, 'grn_approval']);

    Route::resource('ind_approval', IndividualApprovalController::class);
    Route::get('/ind_status-update/{id}',[IndividualApprovalController::class, 'status_update']);
});

Route::middleware(['can:view-customer'])->group(function () {
    Route::resource('customer', CustomerController::class);
    Route::get('customer/{id}/view', [CustomerController::class, 'show']);
    Route::get('customer/{id}/delete', [CustomerController::class, 'destroy']);
    Route::post('customer/bank/add', [CustomerController::class, 'add_bank']);
    Route::get('customer/bank/delete/{id}', [CustomerController::class, 'delete_bank']);
    
    Route::resource('ind_customer', IndividualCustomerController::class);
    Route::get('ind_customer/{id}/edit', [IndividualCustomerController::class, 'edit']);
    Route::get('ind_customer/{id}/view', [IndividualCustomerController::class, 'show']);
    Route::get('ind_customer/{id}/delete', [IndividualCustomerController::class, 'destroy']);
    Route::post('ind-customer/bank/add', [IndividualCustomerController::class, 'add_bank']);
    Route::get('ind-customer/bank/delete/{id}', [IndividualCustomerController::class, 'delete_bank']);
});

Route::middleware(['can:view-sales'])->group(function () {
    
     Route::get('/quotation', [QuotationController::class, 'index'])->name('Quotation');
    Route::post('/quotation/store', [QuotationController::class, 'store'])->name('QuotationStore');
    Route::post('/quotation/update', [QuotationController::class, 'update'])->name('QuotationUpdate');
    Route::get('/quotation/create', [QuotationController::class, 'CreateQ'])->name('QuotationCreate');
    Route::get('/quotation/{id}/edit', [QuotationController::class, 'edits']);
    Route::get('/quotation/{id}/delete', [QuotationController::class, 'destroy']);
    Route::get('/quotation/{id}/view', [QuotationController::class, 'view']);
    Route::get('/quotation/{id}/passenger', [QuotationController::class, 'Passenger']);
    Route::get('/quotation/{id}/download', [QuotationController::class, 'download']);
    Route::post('quotation/hotelservice/add', [QuotationController::class, 'addHotelService'])->name('addHotelService');
    Route::post('quotation/flightservice/add', [QuotationController::class, 'addFlightService'])->name('addFlightService');
    Route::post('quotation/visaservice/add', [QuotationController::class, 'addVisaService'])->name('addVisaService');
    Route::post('quotation/insuranceservice/add', [QuotationController::class, 'addInsuranceService'])->name('addInsuranceService');
    Route::post('quotation/otherservice/add', [QuotationController::class, 'addOtherService'])->name('addOtherService');
    Route::post('quotation/carhireservice/add', [QuotationController::class, 'addCarhireService'])->name('addCarhireService');
    Route::post('quotation/assistservice/add', [QuotationController::class, 'addAssistService'])->name('addAssistService');
    Route::get('quotation/services/{id}', [QuotationController::class, 'services'])->name('DsrService');
    Route::get('quotation/delete/{type}/{id}', [QuotationController::class, 'deleteItem'])->name('deleteItem');
    Route::get('/quotation/convert/invoice/{id}', [QuotationController::class, 'convertToInvoice']);
    Route::get('/quotation/convert/proforma/{id}', [QuotationController::class, 'convertToProforma']);

    Route::get('/creditnote', [CreditnoteController::class, 'index'])->name('Creditnote');
    Route::post('/creditnote/store', [CreditnoteController::class, 'store'])->name('CreditnoteStore');
    Route::post('/creditnote/refund', [CreditnoteController::class, 'refund'])->name('CreditnoteRefund');

    Route::get('/creditnote/create', [CreditnoteController::class, 'create'])->name('CreditnoteCreate');
    Route::get('/creditnote/create/{id}', [CreditnoteController::class, 'createn'])->name('CreditnoteCreaten');
    
    Route::get('invoice', [InvoiceController::class, 'index'])->name('Invoice');
    Route::get('/invoice/create', [InvoiceController::class, 'create'])->name('InvoiceCreate');
    Route::post('/invoice/store', [InvoiceController::class, 'store'])->name('InvoiceStore');
    Route::post('/invoice/update', [InvoiceController::class, 'update'])->name('InvoiceUpdate');
    Route::get('/invoice/{id}/view', [InvoiceController::class, 'view'])->name('InvoiceView');
    Route::get('/invoice/{id}/edit', [InvoiceController::class, 'edit'])->name('InvoiceEdit');
    Route::get('/invoice/generate/{id}/{type}', [InvoiceController::class, 'generate']);
    Route::get('/invoice/{id}/view', [InvoiceController::class, 'view']);
    Route::get('/invoice/{id}/download', [InvoiceController::class, 'download']);

    Route::get('/proforma', [ProformaController::class, 'index'])->name('Proforma');
    Route::get('/proforma/create', [ProformaController::class, 'create'])->name('ProformaCreate');
    Route::post('/proforma/store', [ProformaController::class, 'store'])->name('ProformaStore');
    Route::post('/proforma/update', [ProformaController::class, 'update'])->name('ProformaUpdate');
    Route::get('/proforma/{id}/view', [ProformaController::class, 'view'])->name('ProformaView');
    Route::get('/proforma/{id}/edit', [ProformaController::class, 'edit'])->name('ProformaEdit');
    Route::get('/proforma/{id}/download', [ProformaController::class, 'download'])->name('ProformaDownload');
    Route::get('/proforma/convert/invoice/{id}', [ProformaController::class, 'convertToInvoice']);
    
});

Route::middleware(['can:view-purchases'])->group(function () {
    
    Route::resource('supplier', SupplierController::class);
    Route::get('supplier/{id}/view', [SupplierController::class, 'show']);
    Route::get('supplier/{id}/delete', [SupplierController::class, 'destroy']);
    
    Route::get('/expense', [ExpenseController::class, 'index'])->name('Expense');
    Route::get('/expense/create', [ExpenseController::class, 'create'])->name('ExpenseCreate');
    Route::get('/expense/{id}/view', [ExpenseController::class, 'view'])->name('ExpenseView');
    Route::post('/expense/store', [ExpenseController::class, 'store'])->name('ExpenseStore');
    
});

Route::middleware(['can:view-grn'])->group(function () {
     Route::get('/grn', [GrnController::class, 'index'])->name('Grn');
    Route::get('/grn/create', [GrnController::class, 'create'])->name('GrnCreate');
    Route::get('/grn/{id}', [GrnController::class, 'grn'])->name('OpenGrn');
    Route::post('/grn/store', [GrnController::class, 'store'])->name('GrnStore');
    Route::post('/grn/save', [GrnController::class, 'saveGrn'])->name('GrnSave');
    Route::post('/grn/addservices', [GrnController::class, 'addServices'])->name('GrnAddServices');
    Route::post('/grn/addproducts', [GrnController::class, 'addProducts'])->name('GrnAddProducts');
    Route::post('/grn/updateservices', [GrnController::class, 'updateServices'])->name('GrnUpdateServices');
    Route::get('/grn/deleteservice/{id}', [GrnController::class, 'destroyService'])->name('GrnDeleteService');
    Route::post('/grn/updateproducts', [GrnController::class, 'updateProducts'])->name('GrnUpdateProducts');
    Route::get('/grn/deleteproduct/{id}', [GrnController::class, 'destroyProduct'])->name('GrnDeleteProduct');
    
    Route::get('servicemaster', [ServiceController::class, 'index']);
    Route::post('servicemaster/store', [ServiceController::class, 'store'])->name('ServiceStore');
    Route::get('servicemaster/{id}/delete', [ServiceController::class, 'destroy']);
});

Route::middleware(['can:view-products-services'])->group(function () {
    
    
    

    Route::resource('inventory', InventoryController::class);
    Route::get('inventory/{id}/view', [InventoryController::class, 'show']);
    Route::get('inventory/{id}/delete', [InventoryController::class, 'destroy']);
    
    Route::get('/gettablelistinv', [InventoryController::class, 'gettablelist']);


    Route::resource('non_inventory', NonInventoryController::class);
    Route::get('non_inventory/{id}/view', [NonInventoryController::class, 'show']);
    Route::get('non_inventory/{id}/delete', [NonInventoryController::class, 'destroy']);
    Route::get('/gettablelistnoninv', [NonInventoryController::class, 'gettablelist']);



    Route::resource('product_services', ProductServicesController::class);

    Route::resource('hotel', HotelController::class);
    Route::get('hotel/{id}/view', [HotelController::class, 'show']);
    Route::get('hotel/{id}/delete', [HotelController::class, 'destroy']);
    

    Route::resource('hotel_sevice', HotelServiceController::class);
    Route::get('hotel_sevice/{id}/view', [HotelServiceController::class, 'show']);
    Route::get('hotel_sevice/{id}/delete', [HotelServiceController::class, 'destroy']);
    Route::get('hotel_sevice/{id}/edit', [HotelServiceController::class, 'edit']);
    Route::put('hotel_sevice_update', [HotelServiceController::class, 'update']);
    Route::get('/status-update/{id}',[HotelServiceController::class, 'status_update']);

    Route::get('room_bed/{id}', [HotelServiceController::class, 'room_bed']);
    Route::get('room_meal/{id}', [HotelServiceController::class, 'room_meal']);
    Route::post('room/bed/add', [HotelServiceController::class, 'addBed']);
    Route::post('room/meal/add', [HotelServiceController::class, 'addMeal']);

    Route::get('room/meal/delete/{id}', [HotelServiceController::class, 'destroy_room_meal']);
    Route::get('room/bed/delete/{id}', [HotelServiceController::class, 'destroy_room_bed']);

    Route::resource('flight', FlightController::class);
    Route::get('flight/{id}/view', [FlightController::class, 'show']);
    Route::get('flight/{id}/delete', [FlightController::class, 'destroy']);
    Route::get('/flight/status-update/{id}',[FlightController::class, 'status_update']);
    Route::get('flight/{id}/edit', [FlightController::class, 'edit']);
    Route::put('flight_sevice_update', [FlightController::class, 'update']);

    Route::resource('tour_package', TourPackageController::class);
    Route::get('tour_package/{id}/view', [TourPackageController::class, 'show']);
    Route::get('tour_package/{id}/delete', [TourPackageController::class, 'destroy']);

    Route::resource('itinerary', ItineraryController::class);
    Route::get('itinerary/{id}/view', [ItineraryController::class, 'show']);
    Route::get('itinerary/{id}/delete', [ItineraryController::class, 'destroy']);
    Route::get('/status-update/{id}',[ItineraryController::class, 'status_update']);
    Route::get('itinerary/{id}/edit', [ItineraryController::class, 'edit']);
    Route::put('itinerary_sevice_update', [ItineraryController::class, 'update']);
    

    Route::resource('visa', VisaController::class);
    Route::get('visa/{id}/view', [VisaController::class, 'show']);
    Route::get('visa/{id}/delete', [VisaController::class, 'destroy']);
    Route::get('visa/{id}/edit', [VisaController::class, 'edit']);
    Route::put('visa_sevice_update', [VisaController::class, 'update']);
    Route::get('/status-update/{id}',[VisaController::class, 'status_update']);


    Route::resource('car', CarhireController::class);
    Route::get('car/{id}/view', [CarhireController::class, 'show']);
    Route::get('car/{id}/delete', [CarhireController::class, 'destroy']);
    Route::get('car/{id}/edit', [CarhireController::class, 'edit']);
    Route::put('car_service_update', [CarhireController::class, 'update']);
    Route::get('/status-update/{id}',[CarhireController::class, 'status_update']);


    Route::resource('assist', AssistController::class);
    Route::get('assist/{id}/view', [AssistController::class, 'show']);
    Route::get('assist/{id}/delete', [AssistController::class, 'destroy']);
    Route::get('assist/{id}/edit', [AssistController::class, 'edit']);
    Route::put('assist_service_update', [AssistController::class, 'update']);
    Route::get('/status-update/{id}',[AssistController::class, 'status_update']);
    
    Route::resource('insurance', InsuranceController::class);
    Route::get('insurance/{id}/view', [InsuranceController::class, 'show']);
    Route::get('insurance/{id}/delete', [InsuranceController::class, 'destroy']);
    Route::get('/status-update/{id}',[InsuranceController::class, 'status_update']);

    Route::resource('insplan', InsurancePlanController::class);
    Route::post('insplan/store', [InsurancePlanController::class, 'store']);
    Route::get('insplan/{id}/view', [InsurancePlanController::class, 'show']);
    Route::get('insplan/{id}/delete', [InsurancePlanController::class, 'destroy']);
    Route::get('insplan/{id}/edit', [InsurancePlanController::class, 'edit']);
    Route::put('insplan_service_update', [InsurancePlanController::class, 'update']);
    Route::get('/status-update/{id}',[InsurancePlanController::class, 'status_update']);

    
});

Route::middleware(['can:view-accounts'])->group(function () {
    Route::resource('account', AccountController::class);
    Route::get('account/{id}/view', [AccountController::class, 'show']);
    Route::get('account/{id}/edits', [AccountController::class, 'edits']);
    Route::post('account/search', [AccountController::class, 'search']);
    Route::post('account/file/store', [AccountController::class, 'file_store']);
    Route::get('account/{id}/delete', [AccountController::class, 'destroy']);
    Route::get('/account/status/{id}',[AccountController::class, 'status_update']);

    Route::resource('taxmaster', TaxmasterController::class);
    Route::get('taxmaster/{id}/view', [TaxmasterController::class, 'show']);
    Route::get('taxmaster/{id}/delete', [TaxmasterController::class, 'destroy']);
    Route::get('/status-update/{id}',[TaxmasterController::class, 'status_update']);
});

Route::middleware(['can:view-employee'])->group(function () {
    Route::resource('employee', EmployeeController::class);
    Route::get('employee/{id}/view', [EmployeeController::class, 'show']);
    Route::get('employee/{id}/delete', [EmployeeController::class, 'destroy']);
    Route::get('employee/entry/{id}/delete', [EmployeeController::class, 'destroyEntry']);
    Route::post('employee/medical/add', [EmployeeController::class, 'addMedical']);
    Route::get('employee/download/{id}/', [EmployeeController::class, 'downloadFile']);
});



   

    



   
    
    Route::get('/debitnote', [DebitnoteController::class, 'index'])->name('Debitnote');
    Route::get('/debitnote/create', [DebitnoteController::class, 'create'])->name('DebitnoteCreate');
    Route::post('/debitnote/store', [DebitnoteController::class, 'store'])->name('DebitnoteStore');
    
    Route::post('/set-debitData', [ItemController::class, 'setdebitData'])->name('setDebitnote');
    Route::get('/get-debitData', [ItemController::class, 'getdebitData'])->name('getDebitnote');
    Route::get('/get-purchaseData/{id}', [ItemController::class, 'getpurchaseData'])->name('getpurchaseData');


    Route::get('/purchaseorder', [PurchaseOrderController::class, 'index'])->name('PurchaseOrder');
    Route::get('/purchaseorder/create', [PurchaseOrderController::class, 'create'])->name('PurchaseOrderCreate');
    Route::post('/purchaseorder/store', [PurchaseOrderController::class, 'store'])->name('PurchaseOrderStore');

    Route::get('/bills', [BillsController::class, 'index'])->name('Bills');
    Route::get('/bills/create', [BillsController::class, 'create'])->name('BillsCreate');
    Route::post('/bills/store', [BillsController::class, 'store'])->name('BillsStore');

    Route::get('/paymentmade', [PaymentMadeController::class, 'index'])->name('PaymentMade');
    Route::get('/paymentmade/create', [PaymentMadeController::class, 'create'])->name('PaymentMadeCreate');
    Route::get('/paymentmade/create/{id}', [PaymentMadeController::class, 'createx'])->name('PaymentMadeCreatex');
    Route::post('/paymentmade/store', [PaymentMadeController::class, 'store'])->name('PaymentMadeStore');

    Route::get('/paymentsreceived', [PaymentsController::class, 'index'])->name('Paymentreceived');
    Route::get('/paymentreceived/create', [PaymentsController::class, 'create'])->name('PaymentsCreate');
    Route::get('/paymentreceived/create/{id}', [PaymentsController::class, 'createx'])->name('PaymentsCreatex');
    Route::post('/paymentsreceived/store', [PaymentsController::class, 'store'])->name('PaymentStore');

   




    Route::get('drop-data', [DsrController::class, 'drop_data']);
    Route::get('corporate-data', [DsrController::class, 'corporate_data']);
    Route::get('roomno-data', [DsrController::class, 'roomno_data']);
    Route::get('room-data', [DsrController::class, 'room_data']);
    Route::get('visa-data', [DsrController::class, 'visa_data']);
    Route::get('insurance-data', [DsrController::class, 'insurance_data']);

    
    // Define the `view` permission
    Gate::define('view-sales-data', function ($user) {

      $id= $user->id;
      $p= Permission::where('user_id', $id)->first();
      $cus_p= $p->sales_data;
      return $cus_p === 1;
    });
    
    Gate::define('view-approval', function ($user) {

      $id= $user->id;
      $p= Permission::where('user_id', $id)->first();
      $cus_p= $p->approval;
      return $cus_p === 1;
    });
    
    Gate::define('view-customer', function ($user) {

      $id= $user->id;
      $p= Permission::where('user_id', $id)->first();
      $cus_p= $p->customer;
      return $cus_p === 1;
    });
    
    Gate::define('view-sales', function ($user) {

      $id= $user->id;
      $p= Permission::where('user_id', $id)->first();
      $cus_p= $p->sales;
      return $cus_p === 1;
    });
    
    Gate::define('view-purchases', function ($user) {

      $id= $user->id;
      $p= Permission::where('user_id', $id)->first();
      $cus_p= $p->purchases;
      return $cus_p === 1;
    });
    
    Gate::define('view-grn', function ($user) {

      $id= $user->id;
      $p= Permission::where('user_id', $id)->first();
      $cus_p= $p->grn;
      return $cus_p === 1;
    });
    
    Gate::define('view-products-services', function ($user) {

      $id= $user->id;
      $p= Permission::where('user_id', $id)->first();
      $cus_p= $p->products_services;
      return $cus_p === 1;
    });
    
    Gate::define('view-accounts', function ($user) {

      $id= $user->id;
      $p= Permission::where('user_id', $id)->first();
      $cus_p= $p->accounts;
      return $cus_p === 1;
    });
    
    Gate::define('view-employee', function ($user) {

      $id= $user->id;
      $p= Permission::where('user_id', $id)->first();
      $cus_p= $p->employee;
      return $cus_p === 1;
    });
    
    Gate::define('view-users', function ($user) {

      $id= $user->id;
      $p= Permission::where('user_id', $id)->first();
      $cus_p= $p->user_management;
      return $cus_p === 2;
    });

   
    
});