@extends('layouts.master')


@section('content')
<div class="row">
    <div class="col-lg-12 margin-tb">
        <div class="pull-left">
            <h2>Role Management</h2>
        </div>
        <br>
        <div class="mt-5 mb-3">
            @can('role-create')
            <a type="button" href="{{ route('roles.create') }}" class="btn btn-success btn-icon-text mb-2 mb-md-0">
                <i class="btn-icon-prepend" data-feather="trello"></i>
                Create New Role
            </a>
            @endcan
        </div>
    </div>
</div>


@if ($message = Session::get('success'))
@include('sweetalert::alert')
@endif


<div class="col-md-12 grid-margin stretch-card">
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table id="dataTableExample" class="table">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Name</th>
                            <th width="280px">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($roles as $key => $role)
                        <tr>
                            <td>{{ ++$i }}</td>
                            <td>{{ $role->name }}</td>
                            <td>
                                <a class="btn btn-info" href="{{ route('roles.show',$role->id) }}"><i class="btn-icon-prepend" data-feather="eye"></i></a>
                                @can('role-edit')
                                <a class="btn btn-primary" href="{{ route('roles.edit',$role->id) }}"><i class="btn-icon-prepend" data-feather="edit"></i></a>
                                @endcan
                                @can('role-delete')
                                {!! Form::open(['method' => 'DELETE','route' => ['roles.destroy', $role->id],'style'=>'display:inline']) !!}
                                {{ Form::button('<i class="btn-icon-prepend" data-feather="trash"></i>', ['type' => 'submit', 'class' => 'btn btn-danger btn-lg'] )  }}
                                {!! Form::close() !!}
                                @endcan
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection