
@extends('includes.master')

@section('content')

<div class="main-mobile-header doc-mobile-header">
      <a id="menuLink" href="#" class="menu-link"><i class="ri-menu-line"></i></a>
    </div>

   

    



     <div class="main main-app p-3 p-lg-4">
     	
        <div class="mb-4">
          <ol class="breadcrumb fs-sm mb-1">
            <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
            <li class="breadcrumb-item active" aria-current="page">Edit Non Inventory</li>
          </ol>
        </div>




      <div class="">
        
        <div class="row">

          <div class="col-lg-8">
            <h2 class="main-title">Edit Non Inventory</h2>
            
          </div>
          <div style="text-align: right;" class="col-lg-4 text-right">
           <!--  <button type="button" class="btn btn-primary">Add Inventory</button> -->
            <!-- <a href="/form" class="btn btn-primary">Add Inventory</a>
 -->
          </div>

        </div>

        <hr class="main-separator">        
    
        
        <div class="card card-shadow-apply">
    <div class="card-body">
        <h5 class="card-title">Non Inventory Details</h5>
        <form method="POST" action="{{ route('non_inventory.update', $non_inv->id) }}">
        @csrf @method('PUT')
        <input type="hidden" name="id" value="{{ $non_inv->id }}" />

        <div class="row">
                    <h3 class="heading"></h3>
                    <div class="col-sm-4">
                        <div class="mb-3">

                            <label class="form-label">Item Name
                                <span class="required-field">*</span>
                            </label>
                            <input type="text" name="item_name" value="{{$non_inv->item_name}}" class="form-control">
                        </div>
                    </div><!-- Col -->
                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">SKU
                                <small>(optional)</small>
                            </label>
                            <input type="text" name="sku" value="{{$non_inv->sku}}" class="form-control">
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">HSN Code<small>(optional)</small></label>
                            <input type="text" name="hsn_code" value="{{$non_inv->hsn}}" class="form-control">
                        </div>
                    </div>

                    <!-- Col -->
                </div>

                <div class="row">

                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">Unit
                                <small>(optional)</small>

                            </label>
                            <select name="unit" class="form-select select2" data-width="100%">
                                <option value="{{$non_inv->unit}}" Selected>{{$non_inv->unit}}</option>
                                <option value="BAG">BAG - BAGS</option>
                                <option value="BAL">BAL - BALE</option>
                                <option value="BDL">BDL - BUNDLES</option>
                                <option value="BKL">BKL - BUCKLES</option>
                                <option value="BOU">BOU - BILLIONS OF UNIT</option>
                                <option value="BOX">BOX - BOX</option>
                                <option value="BTL">BTL - BOTTLES</option>
                                <option value="BUN">BUN - BUNCHES</option>
                                <option value="CAN">CAN - CANS</option>
                                <option value="CBM">CBM - CUBIC METER</option>
                                <option value="CCN">CCN - CUBIC CENTIMETER</option>
                                <option value="CMS">CMS - CENTIMETER</option>
                                <option value="CTN">CTN - CARTONS</option>
                                <option value="DOZ">DOZ - DOZEN</option>
                                <option value="BAG">BAG - BAGS</option>
                                <option value="DRM">DRM - DRUM</option>
                                <option value="GGR">GGR - GREAT GROSS</option>
                                <option value="GGM">GGM - GRAMS</option>
                                <option value="GRS">GRS - GROSS</option>
                                <option value="GYD">GYD - GROSS YARDS</option>
                                <option value="KGS">KGS - KILOGRAMS</option>
                                <option value="KLO">KLO - KILOLITER</option>
                                <option value="KME">KME - KILOMETRE</option>
                                <option value="MLT">MLT - MILLILITRE</option>
                                <option value="MTR">MTR - METERS</option>
                                <option value="NOS">NOS - NUMBERS</option>
                                <option value="PAC">PAC - PACKS</option>
                                <option value="PCS">PCS - PIECES</option>
                                <option value="PRS">PRS - PAIRS</option>
                                <option value="QTL">QTL - QUINTAL</option>
                                <option value="ROL">ROL - ROLLS</option>
                                <option value="SET">SET - SETS</option>
                                <option value="SQF">SQF - SQUARE FEET</option>
                                <option value="SQM">SQM - SQUARE METERS</option>
                                <option value="TBS">TBS - TABLETS</option>
                                <option value="TGM">TGM - TEN GROSS</option>
                                <option value="THD">THD - THOUSANDS</option>
                                <option value="TON">TON - TONNES</option>
                                <option value="TUB">TUB - TUBES</option>
                                <option value="UGS">UGS - US GALLONS</option>
                                <option value="YDS">YDS - YARDS</option>
                                <option value="OTH">OTH - OTHERS</option>

                            </select>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">Display Value
                                <small>(optional)</small>

                            </label>
                            <input type="number" class="form-control" value="{{$non_inv->display_value}}" name="display_value" placeholder="Display value in invoice/sales forms">
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">Category
                                <small>(optional)</small>

                            </label>
                            <select name="category" class="js-example-basic-single form-select select2" data-width="100%">
                                <option selected value="{{$non_inv->category}}">{{$non_inv->category}}</option>
                                @foreach($category as $key=>$eachcat)
                                        <option value="{{$eachcat->category_name}}">{{$eachcat->category_name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                </div><!-- Row -->

                <div class="row">

                    <div class="col-sm-4">
                        <div class="mb-3">

                            <label class="form-label">Initial quantity on hand
                                <span class="required-field">*</span>
                            </label>
                            <input type="number" value="{{$non_inv->initial_quantity}}" name="initial_quantity" class="form-control">
                        </div>
                    </div><!-- Col -->
                    <div class="col-sm-4">
                        <div class="mb-3"><label class="form-label" for="DateOfBirth" class="">As of
                                Date
                            </label><label class="" style="color: red;">*</label><input name="as_of_date" type="date" class="form-control" value="{{$non_inv->as_of_date}}"><small style="color: red;"></small>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">Inventory asset account
                                <small>(optional)</small>

                            </label>
                            @php
                      $selectedAccountTypes = ['Cash', 'Bank'];
                    @endphp

                    <select class="select2 form-select" name="inventory_asset_account" data-width="100%">
                     @foreach($account->unique('account_type') as $type)
                         <option style="color: #000;" disabled>{{$type->account_type}}</option>
                          @foreach ($account as $data)
                           @if ($type->account_type == $data->account_type)
                            <option value="{{$data->id}}" {{ $non_inv->inventory_asset_account == $data->id ? 'selected' : '' }}>{{$data->account_name}} @if($data->account_code!="") ({{$data->account_code}}) @endif</option>
                           @endif
                         @endforeach
                     @endforeach
                    </select>
                        </div>
                    </div>
                    <!-- Col -->
                </div>


                <div class="row">

                    

                    <div class="col-sm-4">
                        <div class="mb-3">

                            <label class="form-label">Sales price/rate
                                <span class="required-field">*</span>
                            </label>
                            <input type="number" value="{{$non_inv->sales_price}}" name="sales_price" class="form-control">
                        </div>
                    </div><!-- Col -->
                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label" style="margin-bottom: 1.9rem;"> </label>
                            <!-- <br /> -->
                            <div class="form-check">
                                <input name ="inclusive_of_tax" class="form-check-input" type="checkbox" value="inclusive_of_tax" id="flexCheckChecked" <?php echo ($non_inv->inclusive_of_tax=="inclusive_of_tax")?"checked":""; ?> />
                                <label class="form-check-label" for="flexCheckChecked"> Inclusive of Tax <small>(optional)</small> </label>
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">Income account
                                <small>(optional)</small>

                            </label>
                            @php
                      $selectedAccountTypes = ['Cash', 'Bank'];
                    @endphp

                    <select class="select2 form-select" name="income_account" data-width="100%">
                     

                     @foreach($account->unique('account_type') as $type)
                         <option style="color: #000;" disabled>{{$type->account_type}}</option>
                          @foreach ($account as $data)
                           @if ($type->account_type == $data->account_type)
                            <option value="{{$data->id}}" {{ $non_inv->income_account == $data->id ? 'selected' : '' }}>{{$data->account_name}} @if($data->account_code!="") ({{$data->account_code}}) @endif</option>
                           @endif
                         @endforeach
                     @endforeach
                    </select>
                        </div>
                    </div>

                </div>

                <div class="row">

                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">Tax
                                <small>(optional)</small>

                            </label>
                            <select name="tax" class="js-example-basic-single form-select select2" data-width="100%">
                                <option Selected>{{$non_inv->tax}}</option>
                                @foreach($taxmaster as $eachtaxmaster)
                                    <option value="{{$eachtaxmaster->sales_rate}}">{{$eachtaxmaster->tax_name}}  ( Sales Rate : {{$eachtaxmaster->sales_rate}}% )</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>

                <div class="col-sm-12">
                    <div class="mb-3">

                        <label class="form-label">Description
                            <small>(optional)</small>
                        </label>
                        <textarea class="form-control" name="description" id="exampleFormControlTextarea1" rows="3">{{$non_inv->description}}</textarea>
                    </div>
                </div><!-- Col -->

                <div class="buttons-alignment mt-4">
                    <div>
                        <button type="submit" class="btn btn-primary submit-button-alignment">Update</button>
                    </div>
                </div>


        </form>
    </div>
</div>



        <br><br><br>

        

      </div><!-- container -->

     
    <style>
    tbody tr:hover {background-color: #F5F5F5;}
    .card-example>.card-body::before {
    content: ""
    }
    </style>
@endsection 
