
@extends('includes.master')

@section('content')

<div class="main-mobile-header doc-mobile-header">
      <a id="menuLink" href="#" class="menu-link"><i class="ri-menu-line"></i></a>
    </div>

   

    



     <div class="main main-app p-3 p-lg-4">
     	
        <div class="mb-4">
          <ol class="breadcrumb fs-sm mb-1">
            <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
            <li class="breadcrumb-item active" aria-current="page">Add Employee</li>
          </ol>
        </div>


      


      <div class="">
        
        <div class="row">

          <div class="col-lg-8">
            <h2 class="main-title">Add Employee</h2>
            
          </div>
          <div style="text-align: right;" class="col-lg-4 text-right">

          </div>

        </div>

        <hr class="main-separator">        
    
        
         <div class="card">
      <div style="margin-left: 20px; margin-top: 10px;">
            <p>{{$account->account_type}}</p>
            <h4>{{$account->account_name}}&nbsp;({{$account->account_code}})</h4>
      </div>

      <div style="margin-top: 10px; background-color: #f4eeed;">
            <h4>&nbsp;&nbsp;&nbsp;&nbsp;Closing Balance</h4>
            <h3>&nbsp;&nbsp;&nbsp;&nbsp;<span>₹</span>&nbsp;0</h3>
            <h5>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Description: {{$account->description}}</h5>
      </div>

      <div class="card-body">
            <div class="table-responsive">
                  <table id="dataTableExample" class="table">
                        <thead class="text-center">
                              <tr>
                                    <th>No</th>
                                    <th>Date</th>
                                    <th>Transaction Details</th>
                                    <th>Type</th>
                                    <th>Debit</th>
                                    <th>Credit</th>
                              </tr>
                        </thead>
                        <tbody>
                              @foreach ($transactions as $key => $data)
                              <tr>
                                    <td>{{$key+1}}</td>
                                    <td>{{$data->date}}</td>
                                    <td>{{$data->transaction_id}}</td>
                                    <td>{{$data->transaction_type}}</td>
                                    <td>{{$data->debit}}</td>
                                    <td>{{$data->credit}}</td>
                              </tr>
                              @endforeach
                        </tbody>
                  </table>
            </div>
      </div>
</div>

<!-- The Modal -->
<div class="modal" id="myModal">
      <div class="modal-dialog modal-lg">
            <div class="modal-content">
                  <!-- Modal Header -->
                  <div class="modal-header">
                        <h4 class="modal-title">Edit/Update Account</h4>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                  </div>

                  <!-- Modal body -->
                  <div class="modal-body">
                        <div class="row mt-3">
                              <div class="col-md-12 stretch-card">
                                    <div class="card-shadow-apply">
                                          <div class="card-body">
                                                {!! Form::model($account, ['method' => 'PATCH','id'=>'quickForm','enctype'=>'multipart/form-data','route' => ['account.update', $account->id]]) !!}

                                                <div class="row">
                                                      <h3 class="heading">Basic Details</h3>

                                                      <div class="col-sm-6">
                                                            <div class="mb-3">
                                                                  <label class="form-label">
                                                                        Account Type
                                                                        <span class="required-field">*</span>
                                                                  </label>
                                                                  <select class="form-select" id="SelectA" name="account_type" onclick="display()" data-width="100%">
                                                                        <option selected>{{$account->account_type}}</option>
                                                                        <option disabled>ASSET</option>
                                                                        <option value="Current Asset">Current Asset</option>
                                                                        <option value="Other Current Asset">Other Current Asset</option>
                                                                        <option value="Cash">Cash</option>
                                                                        <option value="Bank">Bank</option>
                                                                        <option value="Fixed Asset">Fixed Asset</option>
                                                                        <option value="Stock">Stock</option>
                                                                        <option value="Payment Clearing">Payment Clearing</option>
                                                                        <option disabled>LIABILITY</option>
                                                                  </select>
                                                                  <script>
                                                                        function display() {
                                                                              var x = document.getElementById("SelectA").value;
                                                                              if (x == "aa") {
                                                                                    document.getElementById("a").style.display = "block";
                                                                                    document.getElementById("b").style.display = "none";
                                                                              }
                                                                              if (x == "bb") {
                                                                                    document.getElementById("a").style.display = "none";
                                                                                    document.getElementById("b").style.display = "block";
                                                                              }
                                                                        }
                                                                  </script>
                                                            </div>
                                                      </div>

                                                      <div class="col-sm-6">
                                                            <div class="mb-3">
                                                                  <label class="form-label">
                                                                        Account Name
                                                                        <span class="required-field">*</span>
                                                                  </label>
                                                                  <input type="text" name="account_name" value="{{$account->account_name}}" class="form-control" />
                                                            </div>
                                                      </div>
                                                      <!-- Col -->

                                                      <div id="a" style="display: block;">
                                                            <div class="row">
                                                                  <div class="mb-3">
                                                                        <label class="form-label">
                                                                              Parent Account
                                                                              <span class="required-field">*</span>
                                                                        </label>
                                                                        <select class="form-select" id="SelectA" name="account_id" data-width="100%">
                                                                              <option disabled>ASSET</option>
                                                                              <option value="">No Item</option>
                                                                              @foreach($parent as $par)
                                                                              <option value="{{$par->id}}">{{$par->account_name}}&nbsp;({{$par->account_code}})</option>
                                                                              @endforeach
                                                                        </select>
                                                                  </div>
                                                                  <div class="col-sm-6">
                                                                        <div class="mb-3">
                                                                              <label class="form-label">
                                                                                    Account Code
                                                                                    <small class="optional-color">(optional)</small>
                                                                              </label>
                                                                              <input type="number" name="account_code" value="{{$account->account_code}}" class="form-control" />
                                                                        </div>
                                                                  </div>
                                                                  <!-- Col -->
                                                                  <div class="col-sm-12">
                                                                        <div class="mb-3">
                                                                              <label class="form-label">
                                                                                    Discription
                                                                                    <small class="optional-color">(optional)</small>
                                                                              </label>
                                                                              <textarea name="description" class="form-control" id="exampleFormControlTextarea1" rows="3">{{$account->description}}</textarea>
                                                                        </div>
                                                                  </div>
                                                                  <!-- Col -->
                                                            </div>
                                                      </div>
                                                      <div class="buttons-alignment mt-4">
                                                            <button type="submit" class="btn btn-success submit-button-alignment">Update</button>
                                                      </div>
                                                      {!! Form::close() !!}
                                                </div>
                                          </div>
                                    </div>
                              </div>
                        </div>
                  </div>
            </div>
      </div>
</div>



        <br><br><br>

        

      </div><!-- container -->

     
    <style>
    tbody tr:hover {background-color: #F5F5F5;}
    .card-example>.card-body::before {
    content: ""
    }
    </style>
@endsection 
