<?php

namespace App\Http\Controllers\Taxmaster;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Taxmaster\Taxmaster;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Facades\Redirect;

class TaxmasterController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $taxmaster = Taxmaster::orderBy('id', 'DESC')->get();
        return view('taxmaster.index', compact('taxmaster'));
    }


    function status_update($id)
    {
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('taxmaster.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $type = $request->input("type");
        
        $tax = new Taxmaster;
        $tax->tax_agency = $request->input("tax_agency");
        $tax->type = $request->input("type");
        $tax->discription = $request->input("discription");
        if($type=="Sales"){
        $tax->sales_rate = $request->input("tax_rate");
        }
        elseif($type=="Purchase"){
        $tax->purchase_rate = $request->input("tax_rate");
        }
        $tax->save();
        session()->flash('success', 'You\'ve created Taxmaster successfully.');
        return redirect()->route('taxmaster.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function show()
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $tax = Taxmaster::find($id);
        //dd($emp);
        return view('taxmaster.edit', compact('tax'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function update($id, Request $request)
    {
        $type = $request->input("type");
        
        $tax = Taxmaster::find($id);
        $tax->tax_agency = $request->input("tax_agency");
        $tax->type = $request->input("type");
        $tax->discription = $request->input("discription");
        if($type=="Sales"){
        $tax->sales_rate = $request->input("tax_rate");
        }
        elseif($type=="Purchase"){
        $tax->purchase_rate = $request->input("tax_rate");
        }
        $tax->save();
        session()->flash('success', 'You\'ve Updated  Taxmaster successfully.');
        return Redirect::back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $tax = Taxmaster::find($id);
        $tax->delete();
        session()->flash('success', 'You\'ve Deleted Taxmaster successfully.');
        return Redirect::back();
    }
}
