<?php

namespace App\Http\Controllers\Supplier;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Supplier\Supplier;
use Illuminate\Support\Facades\Redirect;

class SupplierController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $supplier = Supplier::orderBy('id', 'DESC')->get();
        return view('supplier.index', compact('supplier'));
    }
    
    public function transaction(Request $request)
    {
        $supplier = Supplier::all();
        $transaction = SupplierTransaction::orderBy('id', 'DESC')->get();
        
        foreach($transaction as $data){
            $type= $data->service_type;
            $id= $data->service_type;
            
            if($type=='Hotel'){
              $service = DsrHotelService::find($id);
            }
            if($type=='Flight'){
              $service = DsrFlightService::find($id);
            }
            if($type=='Visa'){
              $service = DsrVisaService::find($id);
            }
            if($type=='Insurance'){
              $service = DsrInsuranceService::find($id);
            }
            if($type=='Carhire'){
              $service = DsrCarhireService::find($id);
            }
            if($type=='Assist'){
              $service = DsrAssistService::find($id);
            }
            if($type=='Other'){
              $service = DsrOtherService::find($id);
            }
        }
        
    
        return view('supplier.index', compact('supplier', 'transaction', 'service'));
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('supplier.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $supplier = new Supplier;
        $supplier->company_name = $request->input("company_name");
        $supplier->alias_name = $request->input("alias_name");
        $supplier->email = $request->input("email");
        $supplier->phone = $request->input("phone");
        $supplier->mobile = $request->input("mobile");
        $supplier->website = $request->input("website");
        $supplier->registration_type = $request->input("registration_type");
        $supplier->registration_number = $request->input("registration_number");

        $supplier->billing_address_line_1 = $request->input("billing_address_line_1");
        $supplier->billing_address_line_2 = $request->input("billing_address_line_2");
        $supplier->billing_city_town = $request->input("billing_city_town");
        $supplier->billing_state_province = $request->input("billing_state_province");
        $supplier->billing_country = $request->input("billing_country");
        $supplier->billing_pincode = $request->input("billing_pincode");

        $supplier->payment_method = $request->input("payment_method");
        $supplier->terms = $request->input("terms");
        $supplier->credit_limit = $request->input("credit_limit");
        $supplier->payment_currency = $request->input("payment_currency");

        $supplier->bank_name = $request->input("bank_name");
        $supplier->account_number = $request->input("account_number");
        $supplier->bank_code = $request->input("bank_code");
        $supplier->swift_code = $request->input("swift_code");
        $supplier->currency = $request->input("currency");
        $supplier->iban_number = $request->input("iban_number");


        $supplier->tax_pan_kra_number = $request->input("tax_pan_kra_number");
        $supplier->tax_issue_date = $request->input("tax_issue_date");
        $supplier->tax_expiry_date = $request->input("tax_expiry_date");

        if ($request->file('tax_kra_file')) {
            $tax_kra_file = $request->file('tax_kra_file');
            $filename = time() . '.' . $tax_kra_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $tax_kra_file->move($path, $filename);
            $supplier->tax_kra_file = $filename;
        }

        $supplier->tax_registration_number = $request->input("tax_registration_number");
        $supplier->registration_issue_date = $request->input("registration_issue_date");
        $supplier->registration_expiry_date = $request->input("registration_expiry_date");

        if ($request->file('registration_file')) {
            $registration_file = $request->file('registration_file');
            $filename = time() . '.' . $registration_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $registration_file->move($path, $filename);
            $supplier->registration_file = $filename;
        }

        $supplier->other_doc_number = $request->input("other_doc_number");

        if ($request->file('other_doc_file')) {
            $other_doc_file = $request->file('other_doc_file');
            $filename = time() . '.' . $other_doc_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $other_doc_file->move($path, $filename);
            $supplier->other_doc_file = $filename;
        }

        $supplier->notes = $request->input("notes");
        $status= $request->input("status");
        if($status="ON"){
        $supplier->status = "Active";
        }
        else{
        $supplier->status = "Inactive";
        }

        $supplier->save();
        
        session()->flash('success', 'You\'ve Created Supplier successfully.');
        return redirect()->route('supplier.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $sup = Supplier::find($id);
        //dd($emp);
        return view('supplier.show', compact('sup'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $sup = Supplier::find($id);
        //dd($emp);
        return view('supplier.edit', compact('sup'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function update($id, Request $request)
    {
        $supplier = Supplier::find($id);
        $supplier->company_name = $request->input("company_name");
        $supplier->alias_name = $request->input("alias_name");
        $supplier->email = $request->input("email");
        $supplier->phone = $request->input("phone");
        $supplier->mobile = $request->input("mobile");
        $supplier->website = $request->input("website");
        $supplier->registration_type = $request->input("registration_type");
        $supplier->registration_number = $request->input("registration_number");

        $supplier->billing_address_line_1 = $request->input("billing_address_line_1");
        $supplier->billing_address_line_2 = $request->input("billing_address_line_2");
        $supplier->billing_city_town = $request->input("billing_city_town");
        $supplier->billing_state_province = $request->input("billing_state_province");
        $supplier->billing_country = $request->input("billing_country");
        $supplier->billing_pincode = $request->input("billing_pincode");

        $supplier->payment_method = $request->input("payment_method");
        $supplier->terms = $request->input("terms");
        $supplier->credit_limit = $request->input("credit_limit");
        $supplier->payment_currency = $request->input("payment_currency");

        $supplier->bank_name = $request->input("bank_name");
        $supplier->account_number = $request->input("account_number");
        $supplier->bank_code = $request->input("bank_code");
        $supplier->swift_code = $request->input("swift_code");
        $supplier->currency = $request->input("currency");
        $supplier->iban_number = $request->input("iban_number");


        $supplier->tax_pan_kra_number = $request->input("tax_pan_kra_number");
        $supplier->tax_issue_date = $request->input("tax_issue_date");
        $supplier->tax_expiry_date = $request->input("tax_expiry_date");

        if ($request->file('tax_kra_file')) {
            $tax_kra_file = $request->file('tax_kra_file');
            $filename = time() . '.' . $tax_kra_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $tax_kra_file->move($path, $filename);
            $supplier->tax_kra_file = $filename;
        }

        $supplier->tax_registration_number = $request->input("tax_registration_number");
        $supplier->registration_issue_date = $request->input("registration_issue_date");
        $supplier->registration_expiry_date = $request->input("registration_expiry_date");

        if ($request->file('registration_file')) {
            $registration_file = $request->file('registration_file');
            $filename = time() . '.' . $registration_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $registration_file->move($path, $filename);
            $supplier->registration_file = $filename;
        }

        $supplier->other_doc_number = $request->input("other_doc_number");

        if ($request->file('other_doc_file')) {
            $other_doc_file = $request->file('other_doc_file');
            $filename = time() . '.' . $other_doc_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $other_doc_file->move($path, $filename);
            $supplier->other_doc_file = $filename;
        }

        $supplier->notes = $request->input("notes");

        $supplier->status = $request->input("status") ? "Active":"Inactive";

        $supplier->save();
        session()->flash('success', 'You\'ve Updated Supplier successfully.');
        return Redirect::back()->withErrors(['msg' => 'The Message']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $Supplier = Supplier::find($id);
        $Supplier->delete();
        return Redirect::back()->withErrors(['msg' => 'The Message']);
    }
}
