<?php

namespace App\Http\Controllers\NonInventory;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\NonInventory\Non_inventory;
use Illuminate\Support\Facades\Redirect;
use App\Models\Taxmaster\Taxmaster;
use App\Models\Account\Account;
use App\Models\Category\Category;

class NonInventoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if(session('inventoryfilter'))
        {
            $non_inv = Non_inventory::orderBy('id', 'DESC')->where('category','=',session('inventoryfilter'))->get();
            
            $category = Category::select('*')->get();
            return view('non-inventory.index', compact('non_inv','category'));
        }
        else{
            $non_inv = Non_inventory::orderBy('id', 'DESC')->get();
            $category = Category::select('*')->get();
            return view('non-inventory.index', compact('non_inv','category'));
        }
    }
    function gettablelist(Request $request){

        $field=$request->input('filtervalue');
        
        session()->flash('inventoryfilter', $field);
        
        return "success";
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $taxmaster = Taxmaster::select('*')->get();
        $parent = Account::select('*')->get();
        //dd($parent);
        $account = Account::all();
        $acc = Account::whereNull('account_id')->get();
        $category = Category::select('*')->get();
        return view('non-inventory.create',compact('taxmaster','account','parent', 'acc','category'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $non_inv = new Non_inventory;
        $non_inv->item_name = $request->input("item_name");
        $non_inv->sku = $request->input("sku");
        $non_inv->hsn = $request->input("hsn_code");
        $non_inv->unit = $request->input("unit");
        $non_inv->display_value = $request->input("display_value");
        $non_inv->category = $request->input("category");
        $non_inv->initial_quantity = $request->input("initial_quantity");
        $non_inv->as_of_date = $request->input("as_of_date");
        $non_inv->inventory_asset_account    = $request->input("inventory_asset_account");
        $non_inv->description    = $request->input("description");
        $non_inv->sales_price = $request->input("sales_price");
        $non_inv->income_account = $request->input("income_account");
        $non_inv->inclusive_of_tax = $request->input("inclusive_of_tax");
        $non_inv->tax = $request->input("tax");
        $non_inv->save();
        session()->flash('success', 'You\'ve added Non Inventory successfully.');
        
        return redirect()->route('non_inventory.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $non_inv = Non_inventory::find($id);
        //dd($emp);
        $taxmaster = Taxmaster::select('*')->get();
        $parent = Account::select('*')->get();
        //dd($parent);
        $account = Account::all();
        $acc = Account::whereNull('account_id')->get();
        $category = Category::select('*')->get();
        return view('non-inventory.show', compact('non_inv','taxmaster','account','parent', 'acc','category'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $non_inv = Non_inventory::find($id);
        //dd($emp);
        $taxmaster = Taxmaster::select('*')->get();
        $parent = Account::select('*')->get();
        //dd($parent);
        $account = Account::all();
        $acc = Account::whereNull('account_id')->get();
        $category = Category::select('*')->get();;

        return view('non-inventory.edit', compact('non_inv','taxmaster','account','parent', 'acc','category'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function update($id, Request $request)
    {
        $non_inv = Non_inventory::find($id);
        $non_inv->item_name = $request->input("item_name");
        $non_inv->sku = $request->input("sku");
        $non_inv->hsn = $request->input("hsn_code");
        $non_inv->unit = $request->input("unit");
        $non_inv->display_value = $request->input("display_value");
        $non_inv->category = $request->input("category");
        $non_inv->initial_quantity = $request->input("initial_quantity");
        $non_inv->as_of_date = $request->input("as_of_date");
        $non_inv->inventory_asset_account    = $request->input("inventory_asset_account");
        $non_inv->description    = $request->input("description");
        $non_inv->sales_price = $request->input("sales_price");
        $non_inv->income_account = $request->input("income_account");
        $non_inv->inclusive_of_tax = $request->input("inclusive_of_tax");
        $non_inv->tax = $request->input("tax");
        $non_inv->save();
        session()->flash('success', 'You\'ve updated Non Inventory successfully.');
        
        return Redirect::back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $non_inv = Non_inventory::find($id);
        $non_inv->delete();
        return Redirect::back()->withErrors(['msg' => 'The Message']);
    }
}
