<?php

namespace App\Http\Controllers\Mice;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\View;
use PDF;
use App\Models\DSR\DSR;
use App\Models\Supplier\Supplier;
use App\Models\DSR\DsrHotelService;
use App\Models\DSR\DsrTourService;
use App\Models\DSR\DsrFlightService;
use App\Models\DSR\DsrVisaService;
use App\Models\DSR\DsrServicePassenger;
use App\Models\DSR\DsrInsuranceService;
use App\Models\DSR\DsrOtherService;
use App\Models\DSR\DsrCarhireService;
use App\Models\DSR\DsrAssistService;
use App\Models\Passengers\Passengers;
use App\Models\Hotel\Hotel;
use App\Models\Flight\Flight;
use App\Models\Visa\Visa;
use App\Models\Insurance\Insurance;
use App\Models\InsurancePlan\InsurancePlan;
use App\Models\Inventory\Inventory;
use App\Models\Carhire\Carhire;
use App\Models\Assist\Assist;
use App\Models\HotelService\HotelService;
use App\Models\TourPackage\TourPackage;
use App\Models\HotelServices\RoomBed;
use App\Models\HotelServices\RoomMeal;
use App\Models\Customer\Customer;
use App\Models\Taxmaster\Taxmaster;
use App\Models\Individual\IndividualCustome;
use Illuminate\Support\Facades\Redirect;

use App\Models\Mice\Mice;
use App\Models\Mice\MiceFamily;


class MiceController extends Controller
{
    public function index(Request $request)
    {
        $dsr = Mice::all();
        return view('mice.index', compact('dsr'));
    }

    public function test(Request $request)
    {
        $dsr = Mice::all();
        return view('mice.index', compact('dsr'));
    }

    public function create()
    {
        $corporate = Customer::where('approval', '=', 1)->select('*')->get();
        $cdata = Customer::where('approval', '=', 1)->get();
        $individual = IndividualCustome::where('approval', '=', 1)->get();
        $idata = IndividualCustome::where('approval', '=', 1)->get();
        //dd($corporate);
        return view('mice.create', compact('corporate','individual', 'idata', 'cdata'));
    }


    public function store(Request $request)
    {
          // Get the current maximum order number from the database
        $maxDsrNumber = Mice::max('mice_id');

        // Parse the Dsr number to get the numeric part
        $lastDsrNumber = (int) substr($maxDsrNumber, -6);

        // Increment the Dsr number
        $newDsrNumber = $lastDsrNumber + 1;

        // Pad the Dsr number with leading zeros to get the final Dsr number
        $paddedDsrNumber = str_pad($newDsrNumber, 6, '0', STR_PAD_LEFT);

        // Build the final Dsr ID with the series
        $series = 'NMICE';
        $dsr_number = $series . '-' . $paddedDsrNumber;

        $type=$request->input("customer_type");
        if ($type=="Corporate") {
            $customer_id = $request->input("corporate_id");
            $customer_name = $request->input("select_company_name");

        }
        else {
            $customer_id = $request->input("individual_id");
            $customer_name = $request->input("select_individual_name");
        }

        $dsr = new Mice;
        $dsr->customer_type = $request->input("customer_type");
        $dsr->customer_id = $customer_id;
        $dsr->customer_name = $customer_name;
        $dsr->mice_name = $request->input("mice_name");
        $dsr->mice_description = $request->input("mice_description");
        $dsr->mice_id = $dsr_number;
        $dsr->currency = $request->input("currency");
        $dsr->save();
        
        session()->flash('success', 'You\'ve Added Mice successfully.');        
        return redirect()->route('Mice');
    }

    public function guest($type, $id)
    {
        $data = DsrServicePassenger::where('dsr_service_id', $id)->get();
        //dd($corporate);
        return view('dsr.guest', compact('data'));
    }


    public function storePassengers(Request $request)
    {
        

        do {
           
            $user_id=rand(100000,999999);

            $records=DB::table('passengers')
                   ->where('user_id',$user_id)
                   ->exists();     
                   
            // $user_id=rand(100000,999999);
            // $records= Passengers::where('user_id', $user_id)->get();
           
         } while ($records ==1);
        

        $passengers = new Passengers;
        $passengers->customer_id = $request->input("customer_id");
        $passengers->user_id = $user_id;
        $passengers->dsr_number = $request->input("dsr_number");
        $passengers->name = $request->input("customer_name");
        $passengers->email = $request->input("email");
        $passengers->phone = $request->input("phone");
        $passengers->save();
        
        session()->flash('success', 'You\'ve Added Passenger successfully.');        
        return Redirect::back();
    }

    public function addHotelService(Request $request)
    {
        
        $HotelService = new DsrHotelService;

        if ($request->file('hotel_details')) {
            $photo = $request->file('hotel_details');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $HotelService->hotel_details = $filename;
        }

        $HotelService->user_id = $request->input("user_id");
        $HotelService->dsr_number = $request->input("dsr_number");
        $HotelService->hotel_name = $request->input("hotel_name");
        $HotelService->room_name_number = $request->input("room_name_number");
        $HotelService->occupancy = $request->input("occupancy");
        $HotelService->meal = $request->input("meal");
        $HotelService->bed = $request->input("bed");
        $HotelService->booking_date = $request->input("booking_date");
        $HotelService->start_date = $request->input("start_date");
        $HotelService->end_date = $request->input("end_date");
        $HotelService->total_days = $request->input("total_days");
        $HotelService->total_night = $request->input("total_night");
        $HotelService->supplier = $request->input("supplier");
        $HotelService->supplier_service_charge = $request->input("supplier_service_charge");
        $HotelService->hotel_price = $request->input("hotel_price");
        $HotelService->tax_amount = $request->input("tax_amount");
        $HotelService->retain = $request->input("retain");
        $HotelService->total_amount = $request->input("total_amount");
        $HotelService->remark = $request->input("remark");
        $HotelService->save();

        $user_id = $request->input("user_id");
        $values = $request->input('guest');
        foreach ($values as $value) {
            $model = new DsrServicePassenger();
            $model->dsr_service_id = $user_id;
            $model->dsr_service_type = "Hotel";
            $model->passengers = $value;
            $model->save();
        }
        
        session()->flash('success', 'You\'ve Added Service successfully.');
        return Redirect::back();
    }

    public function addTourService(Request $request)
    {
        
        $TourService = new DsrTourService;

        if ($request->file('tour_details')) {
            $photo = $request->file('tour_details');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $TourService->tour_details = $filename;
        }

        $TourService->user_id = $request->input("user_id");
        $TourService->dsr_number = $request->input("dsr_number");
        $TourService->hotel_name = $request->input("hotel_name");
        $TourService->room_name_number = $request->input("room_name_number");
        $TourService->occupancy = $request->input("occupancy");
        $TourService->meal = $request->input("meal");
        $TourService->bed = $request->input("bed");
        $TourService->booking_date = $request->input("booking_date");
        $TourService->start_date = $request->input("start_date");
        $TourService->end_date = $request->input("end_date");
        $TourService->total_days = $request->input("total_days");
        $TourService->total_night = $request->input("total_night");
        $TourService->supplier = $request->input("supplier");
        $TourService->supplier_service_charge = $request->input("supplier_service_charge");
        $TourService->hotel_price = $request->input("hotel_price");
        $TourService->tax_amount = $request->input("tax_amount");
        $TourService->retain = $request->input("retain");
        $TourService->total_amount = $request->input("total_amount");
        $TourService->remark = $request->input("remark");
        $TourService->save();

        $user_id = $request->input("user_id");
        $values = $request->input('guest');
        foreach ($values as $value) {
            $model = new DsrServicePassenger();
            $model->dsr_service_id = $user_id;
            $model->dsr_service_type = "Tour";
            $model->passengers = $value;
            $model->save();
        }
        
        session()->flash('success', 'You\'ve Added Service successfully.');
        return Redirect::back();
    }

    public function addFlightService(Request $request)
    {
        
        $FlightService = new DsrFlightService;
        $FlightService->user_id = $request->input("user_id");
        $FlightService->dsr_number = $request->input("dsr_number");
        $FlightService->airline_name = $request->input("airline_name");
        $FlightService->trip_type = $request->input("trip_type");
        $FlightService->gds_portal = $request->input("gds_portal");
        $FlightService->ticket_number = $request->input("ticket_number");
        $FlightService->pnr_number = $request->input("pnr_number");
        $FlightService->travel_date = $request->input("travel_date");
        $FlightService->route = $request->input("route");
        $FlightService->supplier = $request->input("supplier");
        $FlightService->supplier_service_charge = $request->input("supplier_service_charge");
        $FlightService->fare_price = $request->input("fare_price");
        $FlightService->ipp = $request->input("ipp");
        $FlightService->tax_amount = $request->input("tax_amount");
        $FlightService->retain = $request->input("retain");
        $FlightService->supplier_total = $request->input("supplier_total");
        $FlightService->total_amount = $request->input("total_amount");
        if ($request->file('flight_details')) {
            $photo = $request->file('flight_details');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $FlightService->flight_details = $filename;
        }
        $FlightService->remark = $request->input("remark");
        $FlightService->save();

        $user_id = $request->input("user_id");
        $values = $request->input('passenger_name');
        foreach ($values as $value) {
            $model = new DsrServicePassenger();
            $model->dsr_service_id = $user_id;
            $model->dsr_service_type = "Flight";
            $model->passengers = $value;
            $model->save();
        }


        session()->flash('success', 'You\'ve Added Service successfully.');
        return Redirect::back();
    }

    public function addVisaService(Request $request)
    {
        
        $VisaService = new DsrVisaService;
        $VisaService->user_id = $request->input("user_id");
        $VisaService->dsr_number = $request->input("dsr_number");
        $VisaService->passenger_name = $request->input("passenger_name");
        $VisaService->passport_number = $request->input("passport_number");
        $VisaService->dob = $request->input("dob");
        $VisaService->email = $request->input("email");
        $VisaService->visa_number = $request->input("visa_number");
        $VisaService->visa_type = $request->input("visa_type");
        $VisaService->country = $request->input("country");
        $VisaService->issue_date = $request->input("issue_date");
        $VisaService->expiry_date = $request->input("expiry_date");
        $VisaService->supplier = $request->input("supplier");
        $VisaService->supplier_service_charge = $request->input("supplier_service_charge");
        $VisaService->visa_price = $request->input("visa_price");
        $VisaService->tax_amount = $request->input("tax_amount");
        $VisaService->retain = $request->input("retain");
        $VisaService->total_amount = $request->input("total_amount");
        if ($request->file('visa_details')) {
            $photo = $request->file('visa_details');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $VisaService->visa_details = $filename;
        }
        $VisaService->remark = $request->input("remark");
        $VisaService->save();

        session()->flash('success', 'You\'ve Added Service successfully.');
        return Redirect::back();
    }

    public function addInsuranceService(Request $request)
    {
        
        $InsuranceService = new DsrInsuranceService;
        $InsuranceService->user_id = $request->input("user_id");
        $InsuranceService->dsr_number = $request->input("dsr_number");
        $InsuranceService->passenger_name = $request->input("passenger_name");
        $InsuranceService->company_name = $request->input("company_name");
        $InsuranceService->policy_number = $request->input("policy_number");
        $InsuranceService->issue_date = $request->input("issue_date");
        $InsuranceService->expiry_date = $request->input("expiry_date");
        $InsuranceService->supplier_service_charge = $request->input("supplier_service_charge");
        $InsuranceService->insurance_price = $request->input("insurance_price");
        $InsuranceService->tax_amount = $request->input("tax_amount");
        $InsuranceService->retain = $request->input("retain");
        $InsuranceService->total_amount = $request->input("total_amount");
        if ($request->file('insurance_details')) {
            $photo = $request->file('insurance_details');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $InsuranceService->insurance_details = $filename;
        }
        $InsuranceService->remark = $request->input("remark");
        $InsuranceService->save();
        
        session()->flash('success', 'You\'ve Added Service successfully.');
        return Redirect::back();
    }

    public function addOtherService(Request $request)
    {
        
        $OtherService = new DsrOtherService;
        $OtherService->user_id = $request->input("user_id");
        $OtherService->dsr_number = $request->input("dsr_number");
        $OtherService->item_details = $request->input("item_details");
        $OtherService->quantity = $request->input("quantity");
        $OtherService->price = $request->input("price");
        $OtherService->amount = $request->input("amount");
        $OtherService->supplier_service_charge = $request->input("supplier_service_charge");
        $OtherService->tax_amount = $request->input("tax_amount");
        $OtherService->retain = $request->input("retain");
        $OtherService->total_amount = $request->input("total_amount");
        if ($request->file('other_details')) {
            $photo = $request->file('other_details');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $OtherService->other_details = $filename;
        }        
        $OtherService->remark = $request->input("remark");
        $OtherService->save();
        
        session()->flash('success', 'You\'ve Added Service successfully.');
        return Redirect::back();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        
    }


    public function Passenger($id)
    {

        $pass = Mice::find($id);
        $customer_type= $pass->customer_type;
        $customer_id= $pass->customer_id;

        if($customer_type=="Corporate"){

            $users = Customer::where('id', $customer_id)->first();


            // $users = Mice::join('customers', 'mice.customer_name', '=', 'customers.company_name')
            // ->select('mice.*', 'customers.phone', 'customers.email')
            // ->where('mice.id', $id)
            // ->first();
        }
        elseif($customer_type=="Individual") {

            $users = IndividualCustome::where('id', $customer_id)->first();

            // $users = Mice::join('individual_customer', 'mice.customer_name', '=', 'individual_customer.first_name')
            // ->select('mice.*', 'individual_customer.phone', 'individual_customer.email')
            // ->where('mice.id', $id)
            // ->first();

        }        

        $dsrno= $pass->mice_id;

        $individual = IndividualCustome::where('approval', '=', 1)->select('*')->get();
        $corporate = Customer::where('approval', 1)->get();
        $passengers = Passengers::where('dsr_number', $dsrno)->get();
        $hotels = Hotel::all();
        $tour = TourPackage::all();
        $room = HotelService::all();
        $flight = Flight::all();
        $visa = Visa::all();
        $insurance = Insurance::all();
        $insuranceplan = InsurancePlan::all();
        $other = Inventory::all();
        $taxmaster = Taxmaster::all();
        $bed = RoomBed::all();
        $meal = RoomMeal::all();
        //dd($emp);
        return view('mice.passenger', compact('corporate','tour','bed','meal','room','taxmaster','pass','individual','passengers','users','hotels', 'flight', 'visa', 'insurance', 'insuranceplan', 'other'));
    }

    public function services($id)
{
    $services['hotel'] = DsrHotelService::where('user_id', $id)->get();
    $services['flight'] = DsrFlightService::where('user_id', $id)->get();
    $services['visa'] = DsrVisaService::where('user_id', $id)->get();
    $services['insurance'] = DsrInsuranceService::where('user_id', $id)->get();
    $services['carhire'] = DsrCarhireService::where('user_id', $id)->get();
    $services['assist'] = DsrAssistService::where('user_id', $id)->get();
    $services['other'] = DsrOtherService::where('user_id', $id)->get();
    
    $count['hotel'] = DsrHotelService::where('user_id', $id)->count();
    $count['flight'] = DsrFlightService::where('user_id', $id)->count();
    $count['visa'] = DsrVisaService::where('user_id', $id)->count();
    $count['insurance'] = DsrInsuranceService::where('user_id', $id)->count();
    $count['carhire'] = DsrCarhireService::where('user_id', $id)->count();
    $count['assist'] = DsrAssistService::where('user_id', $id)->count();    $count['other'] = DsrOtherService::where('user_id', $id)->count();


    $pass=Passengers::where('user_id', $id)->first();
    $dsrno= $pass->dsr_number;

        $individual = IndividualCustome::where('approval', '=', 1)->select('*')->get();
        $corporate = Customer::where('approval', 1)->get();
        $passengers = Passengers::where('dsr_number', $dsrno)->get();
        $family = MiceFamily::where('user_id', $id)->get();
        $hotels = Hotel::all();
        $tour = TourPackage::all();
        $room = HotelService::all();
        $flight = Flight::all();
        $visa = Visa::all();
        $insurance = Insurance::all();
        $insuranceplan = InsurancePlan::all();
        $other = Inventory::all();
        $carhire = Carhire::all();
        $assist = Assist::all();
        $taxmaster = Taxmaster::where('type', 'Sales')->get();
        $bed = RoomBed::all();
        $meal = RoomMeal::all();
        $supplier = Supplier::all();
        //dd($emp);
        return view('mice.services', compact('family','count','services', 'corporate','tour','bed','meal','room','taxmaster','pass','individual','passengers','hotels', 'flight', 'visa', 'insurance', 'insuranceplan', 'other', 'carhire', 'assist', 'supplier'));


    // return view('mice.services', ['services' => $services], 'corporate','tour','bed','meal','room','taxmaster','pass','individual','passengers','users','hotels', 'flight', 'visa', 'insurance', 'insuranceplan', 'other');
}


public function family($type, $id)
{

    $passenger = Passengers::where('user_id', $id)->first();
    $mice_id= $passenger->dsr_number;

    $user['user_id']=$id;
    $user['type']=$type;
    $user['mice_id']=$mice_id;
    

    // if ($type=="Individual") {
    //     $users = IndividualCustome::where('approval', 1)->get();
    // }
    // else{
    //     $users = Customer::where('approval', 1)->get();
    // }
            $users = IndividualCustome::where('approval', 1)->get();

    $family = MiceFamily::where('user_id', $id)->get();
    $micefamily = MiceFamily::where('mice_id', $mice_id)->get();

    return view('mice.family', compact('family', 'micefamily', 'users', 'user'));
}

 public function addMiceFamily(Request $request){

        $family = new MiceFamily;
        $family->mice_id = $request->input("mice_id");
        $family->user_id = $request->input("user_id");
        $family->type = $request->input("type");
        $family->name = $request->input("name");
        $family->email = $request->input("email");
        $family->phone = $request->input("phone");
        $family->save();
        
        session()->flash('success', 'You\'ve Added Family successfully.');
        return Redirect::back();
        // return redirect()->route('miceFamily', ['type' => $type, 'id' => $id]);


 }

 public function deleteMiceFamily($id){

    $customer = MiceFamily::find($id);
        $customer->delete();
        return Redirect::back();


}

public function summary($id){

    $mice = Mice::where('mice_id', $id)->first();
    $passengers = Passengers::where('dsr_number', $id)->get();
    $guests = MiceFamily::all();
    $hotels = DsrHotelService::all();
    $tours = DsrTourService::all();
    $flights = DsrFlightService::all();
    $visas = DsrVisaService::all();
    $insurances = DsrInsuranceService::all();
    $others = DsrOtherService::all();
    
        //  $pdf = PDF::loadView('dsr.summary', compact('id','passengers','services'));
         $pdf = PDF::loadView('mice.summary', compact('id','mice', 'passengers', 'guests','hotels', 'tours', 'flights', 'visas', 'insurances', 'others'));

       return $pdf->stream('Summary.pdf');

}

public function passenger_summary($id)
    {
    
    $passengers = Passengers::where('user_id', $id)->first();
    $dsr_no=$passengers->dsr_number;
    $mice = Mice::where('mice_id', $dsr_no)->first();
    
    $hotels = DsrHotelService::all();
    $tours = DsrTourService::all();
    $flights = DsrFlightService::all();
    $visas = DsrVisaService::all();
    $insurances = DsrInsuranceService::all();
    $others = DsrOtherService::all();
    
        //  $pdf = PDF::loadView('dsr.summary', compact('id','passengers','services'));
         $pdf = PDF::loadView('mice.pass_summary', compact('id', 'mice', 'passengers','hotels', 'tours', 'flights', 'visas', 'insurances', 'others'));

       return $pdf->stream('Passenger_Summary.pdf');
    }

public function summaryd($id){

    // $data="MICE-0000001";
    $passengers = Passengers::where('dsr_number', $id)->get();
    $guests = MiceFamily::all();
    $hotels = DsrHotelService::all();
    $tours = DsrTourService::all();
    $flights = DsrFlightService::all();
    $visas = DsrVisaService::all();
    $insurances = DsrInsuranceService::all();
    $others = DsrOtherService::all();
    
    
    $view = View::make('mice.summ', compact('id', 'passengers', 'guests', 'hotels', 'flights', 'visas', 'insurances', 'others'));
    $html = $view->render();

    // $options = new \Dompdf\Options();
    // $options->set('isRemoteEnabled', true);
    $dompdf = new \Dompdf\Dompdf();

    // Set base path for images
    $base_path = public_path(); // Replace with your base path
    $dompdf->set_base_path($base_path);

    
    // Create PDF
    // $dompdf = new Dompdf();
    $dompdf->loadHtml($html);
    $dompdf->setPaper('A4', 'portrait');
    $dompdf->render();
    // Output PDF to browser
    $dompdf->stream('invoice.pdf');
    // $dompdf->output();

}

public function summary1d($id){

    $passengers = Passengers::where('user_id', $id)->first();
    $guests = MiceFamily::where('user_id', $id)->get();
    $hotels = DsrHotelService::all();
    $tours = DsrTourService::all();
    $flights = DsrFlightService::all();
    $visas = DsrVisaService::all();
    $insurances = DsrInsuranceService::all();
    $others = DsrOtherService::all();
    
    
    $view = View::make('mice.summary1', compact('id','passengers', 'guests', 'hotels', 'flights', 'visas', 'insurances', 'others'));
    $html = $view->render();

    // $options = new \Dompdf\Options();
    // $options->set('isRemoteEnabled', true);
    $dompdf = new \Dompdf\Dompdf();

    // Set base path for images
    $base_path = public_path(); // Replace with your base path
    $dompdf->set_base_path($base_path);

    
    // Create PDF
    // $dompdf = new Dompdf();
    $dompdf->loadHtml($html);
    $dompdf->setPaper('A4', 'portrait');
    $dompdf->render();
    // Output PDF to browser
    $dompdf->stream('invoice.pdf');
    // $dompdf->output();

}


    public function hotelServices($id)
    {

        $services = DsrHotelService::where('user_id', $id)->get();
        return view('dsr.hotelservice', compact('services'));
    }



    public function drop_data(Request $request)
    {
        // Get the selected dropdown value from the request
        $selectedValue = $request->input('selected_value');

        // Query the database to get the data based on the selected value
        $data = IndividualCustome::where('id', $selectedValue)->get();

        // Return the data as a JSON response
        return response()->json(['data' => $data]);
    }

    public function corporate_data(Request $request)
    {
        // Get the selected dropdown value from the request
        $selectedValue = $request->input('selected_value');

        // Query the database to get the data based on the selected value
        $data = Customer::where('id', $selectedValue)->get();

        // Return the data as a JSON response
        return response()->json(['data' => $data]);
    }

    public function roomno_data(Request $request)
    {
        // Get the selected dropdown value from the request
        $selectedValue = $request->input('selected_value');
        $hotel = Hotel::where('hotel_name', $selectedValue)->first();
        $hotel_id=$hotel->id;

        // Query the database to get the data based on the selected value
        $data = HotelService::where('hotel_id', $hotel_id)->get();

        // Return the data as a JSON response
        return response()->json(['data' => $data]);
    }

    public function insurance_data(Request $request)
    {
        // Get the selected dropdown value from the request
        $selectedValue = $request->input('selected_value');
        $insurance = Insurance::where('company_name', $selectedValue)->first();
        $insurance_id=$insurance->id;

        // Query the database to get the data based on the selected value
        $data = InsurancePlan::where('insurance_id', $insurance_id)->get();

        // Return the data as a JSON response
        return response()->json(['data' => $data]);
    }

    public function room_data(Request $request)
    {
        // Get the selected dropdown value from the request
        $selectedValue = $request->input('selected_value');
        $data = HotelService::where('room_name_number', $selectedValue)->first();

        // Return the data as a JSON response
        return response()->json(['data' => $data]);
    }

    public function visa_data(Request $request)
    {
        // Get the selected dropdown value from the request
        $selectedValue = $request->input('selected_value');

        // Query the database to get the data based on the selected value
        $data = IndividualCustome::where('first_name', $selectedValue)->first();

        // Return the data as a JSON response
        return response()->json(['data' => $data]);
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function edit()
    {
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
   
    
    public function destroy($id)
{
    $Dsr = Mice::find($id);
    $status = $Dsr->invoice_status;
    if ($status == 0) {
        $dsr_number = $Dsr->mice_id;

        $Passengers = Passengers::where('dsr_number', $dsr_number)->get();
        foreach ($Passengers as $Passenger) {
            $user_id = $Passenger->user_id;

            $Hotel = DsrHotelService::where('user_id', $user_id)->get();
            foreach ($Hotel as $hotelService) {
                $dsr_service_id = $hotelService->id;
                $ServicePassenger = DsrServicePassenger::where('dsr_service_id', $dsr_service_id)->get();
                foreach ($ServicePassenger as $servicePassenger) {
                    $servicePassenger->delete();
                }
                $hotelService->delete();
            }

            $Flight = DsrFlightService::where('user_id', $user_id)->get();
            foreach ($Flight as $flightService) {
                $dsr_service_id = $flightService->id;
                $ServicePassenger = DsrServicePassenger::where('dsr_service_id', $dsr_service_id)->get();
                foreach ($ServicePassenger as $servicePassenger) {
                    $servicePassenger->delete();
                }
                $flightService->delete();
            }

            $Visa = DsrVisaService::where('user_id', $user_id)->get();
            foreach ($Visa as $visaService) {
                $visaService->delete();
            }

            $Insurance = DsrInsuranceService::where('user_id', $user_id)->get();
            foreach ($Insurance as $insuranceService) {
                $insuranceService->delete();
            }

            $Carhire = DsrCarhireService::where('user_id', $user_id)->get();
            foreach ($Carhire as $carhireService) {
                $carhireService->delete();
            }

            $Assist = DsrAssistService::where('user_id', $user_id)->get();
            foreach ($Assist as $assistService) {
                $assistService->delete();
            }

            $Other = DsrOtherService::where('user_id', $user_id)->get();
            foreach ($Other as $otherService) {
                $otherService->delete();
            }

            $Passenger->delete();
        }
        
         $MiceFamily = MiceFamily::where('mice_id', $dsr_number)->get();
        foreach ($MiceFamily as $MiceFamily) {
            $MiceFamily->delete();
        }

        $Dsr->delete();
        return Redirect::back();
    } else {
        return Redirect::back();
    }
}


}
