<?php

namespace App\Http\Controllers\Master;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Master\Shift;
use Illuminate\Support\Facades\Redirect;

class ShiftController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
        $shift = Shift::orderBy('id', 'DESC')->get();
        //dd($hotel);
        return view('master.shift.index', compact('shift'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $cat = new Shift;
        $cat->name = $request->input("shift");
        $cat->checkin_time = $request->input("checkin_time");
        $cat->checkout_time = $request->input("checkout_time");
        $cat->save();
        session()->flash('success', 'You\'ve Added Shift successfully.');
        
        return Redirect::back();
    }
  

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $cat = Shift::find($id);
        $cat->delete();
        session()->flash('success', 'You\'ve Deleted Shift successfully.');
        
        return Redirect::back();
    }

}
