<?php

namespace App\Http\Controllers\Invoice;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\View;
use PDF; 

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Invoice\Invoice;
use App\Models\Invoice\InvoiceServices;
use Illuminate\Support\Str;
use App\Models\DSR\DSR;
use App\Models\Mice\Mice;
use App\Models\DSR\DsrHotelService;
use App\Models\DSR\DsrTourService;
use App\Models\DSR\DsrFlightService;
use App\Models\DSR\DsrVisaService;
use App\Models\DSR\DsrCarhireService;
use App\Models\DSR\DsrAssistService;
use App\Models\DSR\DsrServicePassenger;
use App\Models\DSR\DsrInsuranceService;
use App\Models\DSR\DsrOtherService;
use App\Models\Passengers\Passengers;
use App\Models\Hotel\Hotel;
use App\Models\Flight\Flight;
use App\Models\Visa\Visa;
use App\Models\Insurance\Insurance;
use App\Models\InsurancePlan\InsurancePlan;
use App\Models\Inventory\Inventory;
use App\Models\HotelService\HotelService;
use App\Models\TourPackage\TourPackage;
use App\Models\HotelServices\RoomBed;
use App\Models\HotelServices\RoomMeal;
use App\Models\Customer\Customer;
use App\Models\Assist\Assist;
use App\Models\Carhire\Carhire;
use App\Models\Taxmaster\Taxmaster;
use App\Models\Individual\IndividualCustome;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Facades\Redirect;


class InvoiceController extends Controller
{

    public function index(Request $request)
    {
        $dsr = Invoice::where('status', '=', 1)->orderBy('invoice_id')->get();
        return view('invoice.index', compact('dsr'));
    }

    public function view($id){
        $invoice = Invoice::where('invoice_no', $id)->first();
        $customer_type= $invoice->customer_id;
        $customer_type= $invoice->customer_type;
        $customer = Customer::where('id', $id)->first();
        $customer = Customer::where('id', $id)->first();
        
        $type= $invoice->type;
        $type_id= $invoice->type_id;
        
        if($type=="Regular"){
            
          $invoiceServices = InvoiceServices::where('invoice_id', $id)->get();
        return view('invoice.view', compact('invoice', 'invoiceServices'));
        }
        
        else{
            
        
        $HotelServices = DsrHotelService::where('dsr_number', $type_id)->get();
        $count = $HotelServices->count();
        $amount = $HotelServices->sum('hotel_price');
        $taxAmount = $HotelServices->sum('tax_rate');
        $taxAmount= $amount * (18/100);
        $totalAmount= $amount + $taxAmount;
        
        $hoteldata = [
          'count' => $count,
          'amount' => $amount,
          'taxAmount' => $taxAmount,
          'totalAmount' => $totalAmount
        ];
        
        $FlightServices = DsrFlightService::where('dsr_number', $type_id)->get();
        $count = $FlightServices->count();
        $amount = $FlightServices->sum('fare_price');
        $taxAmount = $FlightServices->sum('tax_rate');
        $taxAmount= $amount * (18/100);
        $totalAmount= $amount + $taxAmount;
        
        $flightdata = [
          'count' => $count,
          'amount' => $amount,
          'taxAmount' => $taxAmount,
          'totalAmount' => $totalAmount
        ];
        
        $VisaServices = DsrVisaService::where('dsr_number', $type_id)->get();
        $count = $VisaServices->count();
        $amount = $VisaServices->sum('visa_price');
        $taxAmount = $VisaServices->sum('tax_rate');
        $taxAmount= $amount * (18/100);
        $totalAmount= $amount + $taxAmount;
        
        $visadata = [
          'count' => $count,
          'amount' => $amount,
          'taxAmount' => $taxAmount,
          'totalAmount' => $totalAmount
        ];
        
        $InsuranceServices = DsrInsuranceService::where('dsr_number', $type_id)->get();
        $count = $InsuranceServices->count();
        $amount = $InsuranceServices->sum('insurance_price');
        $taxAmount = $InsuranceServices->sum('tax_rate');
        $taxAmount= $amount * (18/100);
        $totalAmount= $amount + $taxAmount;
        
        $insurancedata = [
          'count' => $count,
          'amount' => $amount,
          'taxAmount' => $taxAmount,
          'totalAmount' => $totalAmount
        ];
        
        $CarhireServices = DsrCarhireService::where('dsr_number', $type_id)->get();
        $count = $CarhireServices->count();
        $amount = $CarhireServices->sum('price');
        $taxAmount = $CarhireServices->sum('tax_rate');
        $taxAmount= $amount * (18/100);
        $totalAmount= $amount + $taxAmount;
        
        $carhiredata = [
          'count' => $count,
          'amount' => $amount,
          'taxAmount' => $taxAmount,
          'totalAmount' => $totalAmount
        ];
        
        $AssistServices = DsrAssistService::where('dsr_number', $type_id)->get();
        $count = $AssistServices->count();
        $amount = $AssistServices->sum('price');
        $taxAmount = $AssistServices->sum('tax_rate');
        $taxAmount= $amount * (18/100);
        $totalAmount= $amount + $taxAmount;
        
        $assistdata = [
          'count' => $count,
          'amount' => $amount,
          'taxAmount' => $taxAmount,
          'totalAmount' => $totalAmount
        ];
        
        $OtherServices = DsrOtherService::where('dsr_number', $type_id)->get();
        $count = $OtherServices->count();
        $amount = $OtherServices->sum('price');
        $taxAmount = $OtherServices->sum('tax_rate');
        $taxAmount= $amount * (18/100);
        $totalAmount= $amount + $taxAmount;
        
        $otherdata = [
          'count' => $count,
          'amount' => $amount,
          'taxAmount' => $taxAmount,
          'totalAmount' => $totalAmount
        ];
        
        $TourServices = DsrTourService::where('dsr_number', $type_id)->get();
        $count = $TourServices->count();
        $amount = $TourServices->sum('price');
        $taxAmount = $TourServices->sum('tax_rate');
        $taxAmount= $amount * (18/100);
        $totalAmount= $amount + $taxAmount;
        
        $tourdata = [
          'count' => $count,
          'amount' => $amount,
          'taxAmount' => $taxAmount,
          'totalAmount' => $totalAmount
        ];

          $invoiceServices = InvoiceServices::where('invoice_id', $id)->get();

        return view('invoice.invoice', compact('invoice', 'invoiceServices', 'hoteldata', 'flightdata', 'visadata', 'insurancedata', 'carhiredata', 'assistdata', 'otherdata', 'tourdata'));
        }
        
    }
    
    public function regular($id){
        $invoice = Invoice::where('invoice_no', $id)->first();
        $invoiceServices = InvoiceServices::where('invoice_id', $id)->get();
        return view('invoice.view', compact('invoice', 'invoiceServices'));
        
    }
    
    public function Create()
    {
        
        session()->forget('cart');

        $corporate = Customer::where('approval', '=', 1)->select('*')->get();
        $cdata = Customer::where('approval', '=', 1)->get();
        $individual = IndividualCustome::where('approval', '=', 1)->get();
        $idata = IndividualCustome::where('approval', '=', 1)->get();

        

        $individual = IndividualCustome::where('approval', '=', 1)->select('*')->get();
        $corporate = Customer::where('approval', 1)->get();
        $passengers = Passengers::all();
        $hotels = Hotel::all();
        $tour = TourPackage::all();
        $room = HotelService::all();
        $flight = Flight::all();
        $visa = Visa::all();
        $insurance = Insurance::all();
        $carhire = Carhire::all();
        $assist = Assist::all();
        $insuranceplan = InsurancePlan::all();
        $other = Inventory::all();
        $taxmaster = Taxmaster::where('type', 'Sales')->get();
        $bed = RoomBed::all();
        $meal = RoomMeal::all();
        $id="4567";


        
        return view('invoice.create', compact('id','cdata','idata','corporate','tour','bed','meal','room','taxmaster','individual','passengers','hotels', 'flight', 'visa', 'insurance', 'insuranceplan', 'other', 'carhire', 'assist'));
    }
    
   public function store(Request $request){
       
       do {
           
            $invoice_no=rand(100000,999999);

            $records=DB::table('invoice')
                   ->where('invoice_no',$invoice_no)
                   ->exists();     
                   
           
         } while ($records ==1);

    //   // Get the current maximum order number from the database
    //     $maxDsrNumber = Invoice::max('invoice_id');
    //     // Parse the Dsr number to get the numeric part
    //     $lastDsrNumber = (int) substr($maxDsrNumber, -7);
    //     // Increment the Dsr number
    //     $newDsrNumber = $lastDsrNumber + 1;
    //     // Pad the Dsr number with leading zeros to get the final Dsr number
    //     $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);
    //     // Build the final Dsr ID with the series
    //     $series = 'INV';
    //     $dsr_number = $series . '-' . $paddedDsrNumber;
    
       $type=$request->input("customer_type");
        if ($type=="Corporate") {
            $customer_id = $request->input("corporate_id");
            $customer_name = $request->input("select_company_name");

        }
        elseif ($type=="Individual") {
            $customer_id = $request->input("individual_id");
            $customer_name = $request->input("select_individual_name");
        }
        elseif ($type=="New") {
            $customer_id = 0;
            $customer_name = $request->input("customer_name");
            $email = $request->input("email");
            $phone = $request->input("mobile");
            $address = $request->input("address");

            
        }
        
        $Quotation = new Invoice;

        if ($request->file('quotation_file')) {
            $photo = $request->file('quotation_file');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $Quotation->file = $filename;
        }

        $Quotation->invoice_no = $invoice_no;
        $Quotation->customer_type = $request->input("customer_type");
        $Quotation->customer_id = $customer_id;
        $Quotation->invoice_to = $customer_name;
        // $Quotation->invoice_id = $dsr_number;
        $Quotation->currency = $request->input("currency");
        $Quotation->date = $request->input("date");
        $Quotation->order_no = $request->input("order_no");
        $Quotation->customer_note = $request->input("customer_note");
        $Quotation->terms = $request->input("terms");
        $Quotation->subtotal = $request->input("subtotal");
        $Quotation->shipping_charge = $request->input("shipping_charge");
        $Quotation->adjustment_charge = $request->input("adjustment_charge");
        $Quotation->total = $request->input("quotation_total");
        $Quotation->status = 0;
        $Quotation->type = "Regular";
        $Quotation->save();

        $quantity = $request->input("quantity");

        foreach($quantity as $key => $value) {
            
            $InvoiceServices = new InvoiceServices();
            $InvoiceServices->invoice_id = $invoice_no;
            $InvoiceServices->description = $request->input("item_details")[$key];
            $InvoiceServices->quantity = $request->input("quantity")[$key];
            $InvoiceServices->tax_rate = $request->input("tax_rate")[$key];
            $InvoiceServices->tax_amount = $request->input("tax_amount")[$key];
            $InvoiceServices->price = $request->input("rate")[$key];
            $InvoiceServices->amount = $request->input("total")[$key];
            $InvoiceServices->save();
        } 
     

        session()->flash('success', 'You\'ve Added Invoice Successfully');
        return redirect()->route('InvApproval');
        
    
  } 
  
   public function update(Request $request){
       
       
    
       $type=$request->input("customer_type");
        if ($type=="Corporate") {
            $customer_id = $request->input("corporate_id");
            $customer_name = $request->input("select_company_name");

        }
        elseif ($type=="Individual") {
            $customer_id = $request->input("individual_id");
            $customer_name = $request->input("select_individual_name");
        }
        elseif ($type=="New") {
            $customer_id = 0;
            $customer_name = $request->input("customer_name");
            $email = $request->input("email");
            $phone = $request->input("mobile");
            $address = $request->input("address");

            
        }
            $id = $request->input("id");
        
        $Quotation = Invoice::find($id);

        if ($request->file('quotation_file')) {
            $photo = $request->file('quotation_file');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $Quotation->file = $filename;
        }

        $Quotation->customer_type = $request->input("customer_type");
        $Quotation->customer_id = $customer_id;
        $Quotation->invoice_to = $customer_name;
        // $Quotation->invoice_id = $dsr_number;
        $Quotation->currency = $request->input("currency");
        $Quotation->date = $request->input("date");
        $Quotation->order_no = $request->input("order_no");
        $Quotation->customer_note = $request->input("customer_note");
        $Quotation->terms = $request->input("terms");
        $Quotation->subtotal = $request->input("subtotal");
        $Quotation->shipping_charge = $request->input("shipping_charge");
        $Quotation->adjustment_charge = $request->input("adjustment_charge");
        $Quotation->total = $request->input("quotation_total");
        $Quotation->save();

        $quantity = $request->input("quantity");

        foreach($quantity as $key => $value) {
            $id= $request->input("itm-id")[$key];
            $InvoiceServices = InvoiceServices::find($id);
            $InvoiceServices->description = $request->input("item_details")[$key];
            $InvoiceServices->quantity = $request->input("quantity")[$key];
            $InvoiceServices->tax_rate = $request->input("tax_rate")[$key];
            $InvoiceServices->tax_amount = $request->input("tax_amount")[$key];
            $InvoiceServices->price = $request->input("rate")[$key];
            $InvoiceServices->amount = $request->input("total")[$key];
            $InvoiceServices->save();
        } 
     

        session()->flash('success', 'You\'ve Updated Invoice Successfully');
        return redirect()->route('InvApproval');
        
    
  } 
  
   public function edit($id)
    {
          
        $quotation = Invoice::where('invoice_no', $id)->first();
        $invoice_no =$quotation->invoice_no;

        $corporate = Customer::where('approval', '=', 1)->select('*')->get();
        $cdata = Customer::where('approval', '=', 1)->get();
        $individual = IndividualCustome::where('approval', '=', 1)->get();
        $idata = IndividualCustome::where('approval', '=', 1)->get();

        

        $individual = IndividualCustome::where('approval', '=', 1)->select('*')->get();
        $corporate = Customer::where('approval', 1)->get();
        $passengers = Passengers::all();
        $hotels = Hotel::all();
        $tour = TourPackage::all();
        $room = HotelService::all();
        $flight = Flight::all();
        $visa = Visa::all();
        $insurance = Insurance::all();
        $carhire = Carhire::all();
        $assist = Assist::all();
        $insuranceplan = InsurancePlan::all();
        $other = Inventory::all();
        $taxmaster = Taxmaster::where('type', 'Sales')->get();
        $bed = RoomBed::all();
        $meal = RoomMeal::all();




        $services = InvoiceServices::where('invoice_id', $invoice_no)->get();        

        return view('invoice.edit', compact('id','quotation','cdata','idata','services','corporate','tour','bed','meal','room','taxmaster','individual','passengers','hotels', 'flight', 'visa', 'insurance', 'insuranceplan', 'other', 'carhire', 'assist'));
    }



    public function download($id){

        $invoice = Invoice::where('invoice_no', $id)->first();
        $invoiceServices = InvoiceServices::where('invoice_id', $id)->get();
        // return view('invoice', compact('invoice', 'invoiceServices'));

        $pdf = PDF::loadView('invoice.view', ['invoice' => $invoice], ['invoiceServices' => $invoiceServices]);  
        return $pdf->download('pdfview2.pdf'); 
        
        


    }
    

    public function generate($id, $type)
    {
        if($type=="dsr"){
            $invoice_type="DSR";
            
            $dsr = DSR::where('dsr_number', $id)->first();
         $customer_type= $dsr->customer_type;
         $customer_id= $dsr->customer_id;
        }
        else if($type=="mice") {
            $invoice_type="MICE";

            $dsr = Mice::where('mice_id', $id)->first();
         $customer_type= $dsr->customer_type;
         $customer_id= $dsr->customer_id;
        }

        do {
           
            $invoice_no=rand(100000,999999);

            $records=DB::table('invoice')
                   ->where('invoice_no',$invoice_no)
                   ->exists();     
                   
           
         } while ($records ==1);

        //  $dsr = DSR::where('dsr_number', $id)->first();
        //  $customer_type= $dsr->customer_type;

        if($customer_type=="Corporate"){
            $invoice_to= $dsr->select_company_name;


            // $users = DSR::join('customers', 'dsr.select_company_name', '=', 'customers.company_name')
            // ->select('dsr.*', 'customers.phone', 'customers.email')
            // ->where('dsr.id', $id)
            // ->first();
        }
        elseif($customer_type=="Individual") {
            $invoice_to= $dsr->select_individual_name;


            // $users = DSR::join('individual_customer', 'dsr.select_individual_name', '=', 'individual_customer.first_name')
            // ->select('dsr.*', 'individual_customer.phone', 'individual_customer.email')
            // ->where('dsr.id', $id)
            // ->first();

        }  



        

        $hotel=DsrHotelService::where('dsr_number', $id)->get();
        $hotel_price=$hotel->sum('hotel_price');

        // Hotel Services
        foreach ($hotel as $data) {
            $service_type="Hotel";
            $description=$data->hotel_name;
            $quantity=$data->total_days;
            $vat=$data->other_tax;
            $vatAmount=$data->tax_amount;
            $price=$data->hotel_price;
            $amount=$data->total_amount;


            $InvoiceServices = new InvoiceServices();
            $InvoiceServices->invoice_id = $invoice_no;
            $InvoiceServices->service_type = $service_type;
            $InvoiceServices->description = $description;
            $InvoiceServices->quantity = $quantity;
            $InvoiceServices->tax_rate = $vat;
            $InvoiceServices->tax_amount = $vatAmount;
            $InvoiceServices->price = $price;
            $InvoiceServices->amount = $amount;
            $InvoiceServices->save();
        }

        $flight=DsrFlightService::where('dsr_number', $id)->get();
        $flight_price=$flight->sum('fare_price');

        // Hotel Services
        foreach ($flight as $data) {
            $service_type="Flight";
            $description=$data->airline_name;
            $quantity= 1;
            $vat=$data->other_tax;
            $vatAmount=$data->tax_amount;
            $price=$data->fare_price;
            $amount=$data->total_amount;


            $InvoiceServices = new InvoiceServices();
            $InvoiceServices->invoice_id = $invoice_no;
            $InvoiceServices->service_type = $service_type;
            $InvoiceServices->description = $description;
            $InvoiceServices->quantity = $quantity;
            $InvoiceServices->tax_rate = $vat;
            $InvoiceServices->tax_amount = $vatAmount;
            $InvoiceServices->price = $price;
            $InvoiceServices->amount = $amount;
            $InvoiceServices->save();
        }

        $visa=DsrVisaService::where('dsr_number', $id)->get();
        $visa_price=$visa->sum('visa_price');

        // visa Services
        foreach ($visa as $data) {
            $service_type="Visa";
            $description=$data->visa_type;
            $quantity= 1;
            $vat=$data->other_tax;
            $vatAmount=$data->tax_amount;
            $price=$data->visa_price;
            $amount=$data->total_amount;


            $InvoiceServices = new InvoiceServices();
            $InvoiceServices->invoice_id = $invoice_no;
            $InvoiceServices->service_type = $service_type;
            $InvoiceServices->description = $description;
            $InvoiceServices->quantity = $quantity;
            $InvoiceServices->tax_rate = $vat;
            $InvoiceServices->tax_amount = $vatAmount;
            $InvoiceServices->price = $price;
            $InvoiceServices->amount = $amount;
            $InvoiceServices->save();
        }

        $insurance=DsrInsuranceService::where('dsr_number', $id)->get();
        $insurance_price=$insurance->sum('insurance_price');

        // insurance Services
        foreach ($insurance as $data) {
            $service_type="Insurance";
            $description=$data->company_name;
            $quantity= 1;
            $vat=$data->other_tax;
            $vatAmount=$data->tax_amount;
            $price=$data->insurance_price;
            $amount=$data->total_amount;


            $InvoiceServices = new InvoiceServices();
            $InvoiceServices->invoice_id = $invoice_no;
            $InvoiceServices->service_type = $service_type;
            $InvoiceServices->description = $description;
            $InvoiceServices->quantity = $quantity;
            $InvoiceServices->tax_rate = $vat;
            $InvoiceServices->tax_amount = $vatAmount;
            $InvoiceServices->price = $price;
            $InvoiceServices->amount = $amount;
            $InvoiceServices->save();
        }

        $other=DsrOtherService::where('dsr_number', $id)->get();
        $other_price=$other->sum('price');

        // other Services
        foreach ($other as $data) {
            $service_type="Other";
            $description=$data->item_details;
            $quantity=$data->quantity;
            $vat=$data->other_tax;
            $vatAmount=$data->tax_amount;
            $price=$data->price;
            $amount=$data->total_amount;


            $InvoiceServices = new InvoiceServices();
            $InvoiceServices->invoice_id = $invoice_no;
            $InvoiceServices->service_type = $service_type;
            $InvoiceServices->description = $description;
            $InvoiceServices->quantity = $quantity;
            $InvoiceServices->tax_rate = $vat;
            $InvoiceServices->tax_amount = $vatAmount;
            $InvoiceServices->price = $price;
            $InvoiceServices->amount = $amount;
            $InvoiceServices->save();
        }
        
        $carhire=DsrCarhireService::where('dsr_number', $id)->get();
        $carhire_price=$carhire->sum('price');

        // other Services
        foreach ($other as $data) {
            $service_type="Carhire";
            $description=$data->item_details;
            $quantity=$data->quantity;
            $vat=$data->other_tax;
            $vatAmount=$data->tax_amount;
            $price=$data->price;
            $amount=$data->total_amount;


            $InvoiceServices = new InvoiceServices();
            $InvoiceServices->invoice_id = $invoice_no;
            $InvoiceServices->service_type = $service_type;
            $InvoiceServices->description = $description;
            $InvoiceServices->quantity = $quantity;
            $InvoiceServices->tax_rate = $vat;
            $InvoiceServices->tax_amount = $vatAmount;
            $InvoiceServices->price = $price;
            $InvoiceServices->amount = $amount;
            $InvoiceServices->save();
        }
        
        $assist=DsrAssistService::where('dsr_number', $id)->get();
        $assist_price=$assist->sum('price');

        // other Services
        foreach ($other as $data) {
            $service_type="Assist";
            $description=$data->item_details;
            $quantity=$data->quantity;
            $vat=$data->other_tax;
            $vatAmount=$data->tax_amount;
            $price=$data->price;
            $amount=$data->total_amount;


            $InvoiceServices = new InvoiceServices();
            $InvoiceServices->invoice_id = $invoice_no;
            $InvoiceServices->service_type = $service_type;
            $InvoiceServices->description = $description;
            $InvoiceServices->quantity = $quantity;
            $InvoiceServices->tax_rate = $vat;
            $InvoiceServices->tax_amount = $vatAmount;
            $InvoiceServices->price = $price;
            $InvoiceServices->amount = $amount;
            $InvoiceServices->save();
        }
        
        $invoice_total=$hotel_price + $flight_price + $visa_price + $insurance_price + $carhire_price + $assist_price + $other_price;
        
         
        $date = date('Y-m-d'); // Example format: YYYY-MM-DD
        $Invoice = new Invoice;
        $Invoice->invoice_no = $invoice_no;
        $Invoice->dsr_number = $id;
        $Invoice->date = $date;
        $Invoice->invoice_to = $invoice_to;
        $Invoice->customer_type = $customer_type;
        $Invoice->customer_id = $customer_id;
        $Invoice->currency = $dsr->currency;
        $Invoice->total = $invoice_total;
        $Invoice->status = 0;
        $Invoice->type =$invoice_type;
        $Invoice->type_id = $id;
        $Invoice->save();

        if($type=="dsr"){
            $dsr = DSR::where('dsr_number', $id)->first();
         $dsr->invoice_status = 1;
         $dsr->save();
        }
        elseif($type=="mice"){

            $dsr = Mice::where('mice_id', $id)->first();
         $dsr->invoice_status = 1;
         $dsr->save();

        }
        
         
        
        session()->flash('success', 'Invoice Generated Successfully');
        return Redirect::back();
    }
}
