<?php

namespace App\Http\Controllers\Hotel;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Hotel\Hotel;
use App\Models\HotelService\HotelService;
use Illuminate\Support\Facades\Redirect;

class HotelController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $hotel = Hotel::orderBy('id', 'DESC')->get();
        //dd($hotel);
        return view('hotel.index', compact('hotel'))
            ->with('i', ($request->input('page', 1) - 1) * 5);
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('hotel.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        

        $hotel = new Hotel;
        $hotel->hotel_type = $request->input("hotel_type");
        $hotel->hotel_name = $request->input("hotel_name");
        $hotel->address_line_1 = $request->input("address_line_1");
        $hotel->address_line_2 = $request->input("address_line_2");
        $hotel->city_town = $request->input("city_town");
        $hotel->state_province = $request->input("state_province");
        $hotel->country = $request->input("country");
        if($request->input('status')){
            $hotel->status = "Active";
        }
        else{
            $hotel->status = "Inactive";
        }
        
        $hotel->pincode = $request->input("pincode");
        $hotel->save();
        session()->flash('success','You\'ve Created Hotel Successfully');
        
        return redirect()->route('hotel.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $hotel = Hotel::find($id);   
        $hotel_id= $hotel->id;
        $service = HotelService::orderBy('id', 'DESC')->where('hotel_id', $hotel_id)->get();
        
        return view('hotel.show', compact('hotel','service'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function edit($id, Request $request)
    {
        $hotel = Hotel::find($id);   
        $hotel_id= $hotel->id;
        $service = HotelService::orderBy('id', 'DESC')->where('hotel_id', $hotel_id)->get();
        //dd($serv_edit);
        return view('hotel.edit', compact('hotel','service'))->with('i', ($request->input('page', 1) - 1) * 5);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function update($id, Request $request)
    {
        $hotel = Hotel::find($id);
        $hotel->hotel_type = $request->input("hotel_type");
        $hotel->hotel_name = $request->input("hotel_name");
        $hotel->address_line_1 = $request->input("address_line_1");
        $hotel->address_line_2 = $request->input("address_line_2");
        $hotel->city_town = $request->input("city_town");
        $hotel->state_province = $request->input("state_province");
        $hotel->country = $request->input("country");
        $hotel->status = $request->input("status");
        $hotel->pincode = $request->input("pincode");
        $hotel->status = $request->input("status") ? "Active" : "Inactive";
        $hotel->save();
        session()->flash('success', 'You\'ve Updated Hotel Successfully');
        
        return Redirect::back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $customer = Hotel::find($id);
        $customer->delete();
        return Redirect::back();
    }
}
