<?php

namespace App\Http\Controllers\Grn;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\View;

use App\Models\DSR\DSR;
use App\Models\DSR\DsrHotelService;
use App\Models\DSR\DsrTourService;
use App\Models\DSR\DsrFlightService;
use App\Models\DSR\DsrVisaService;
use App\Models\DSR\DsrServicePassenger;
use App\Models\DSR\DsrInsuranceService;
use App\Models\DSR\DsrOtherService;
use App\Models\DSR\CarhireService;
use App\Models\DSR\AssistService;
use App\Models\Passengers\Passengers;
use App\Models\Hotel\Hotel;
use App\Models\Flight\Flight;
use App\Models\Visa\Visa;
use App\Models\Insurance\Insurance;
use App\Models\InsurancePlan\InsurancePlan;
use App\Models\Inventory\Inventory;
use App\Models\HotelService\HotelService;
use App\Models\TourPackage\TourPackage;
use App\Models\HotelServices\RoomBed;
use App\Models\HotelServices\RoomMeal;
use App\Models\Customer\Customer;
use App\Models\Taxmaster\Taxmaster;
use App\Models\Items\Items;
use App\Models\Invoice\Invoice;
use App\Models\Invoice\InvoiceServices;
use App\Models\Proforma\Proforma;
use App\Models\Assist\Assist;
use App\Models\Carhire\Carhire;
use App\Models\Proforma\ProformaServices;
use App\Models\Individual\IndividualCustome;
use App\Models\Supplier\Supplier;
use App\Models\PurchaseOrder\PurchaseOrder;
use Illuminate\Support\Facades\Redirect;

use App\Models\Debitnote\Debitnote;
use App\Models\Grn\Grn;
use App\Models\Grn\ServiceMaster;
use App\Models\Grn\GrnServices;
use App\Models\Grn\GrnProducts;
use App\Models\Bills\Bills;

class GrnController extends Controller
{
    public function index()
    {
        $dsr = Grn::where('approval_status', 1)
        ->orWhere('approval_status', 2)
        ->orderBy('id', 'DESC')
        ->get();
      return view('grn.index', compact('dsr'));
    }

    public function create()
    {
        $id="";
        $taxmaster= Taxmaster::all();
        $other= Taxmaster::all();
        $supplier= Supplier::all();
        $dsr = Debitnote::all();

        $individual = IndividualCustome::where('approval', '=', 1)->select('*')->get();
        $corporate = Customer::where('approval', 1)->get();
        // $passengers = Passengers::all();
        // $hotels = Hotel::all();
        // $tour = TourPackage::all();
        // $room = HotelService::all();
        // $flight = Flight::all();
        // $visa = Visa::all();
        // $insurance = Insurance::all();
        // $carhire = Carhire::all();
        // $assist = Assist::all();
        // $insuranceplan = InsurancePlan::all();
        // $other = Inventory::all();
        // $taxmaster = Taxmaster::all();
        // $bed = RoomBed::all();
        // $meal = RoomMeal::all();
        // $invoice = Invoice::all();
        $other = Inventory::all();
        $purchaseorder = PurchaseOrder::all();

        // return view('grn.create', compact('id','dsr','purchaseorder','supplier','invoice','corporate','tour','bed','meal','room','taxmaster','individual','passengers','hotels', 'flight', 'visa', 'insurance', 'insuranceplan', 'other', 'carhire', 'assist'));
        return view('grn.grn', compact('id','grn','servicemaster','services','products','dsr','purchaseorder','supplier','invoice','taxmaster','individual', 'other'));
    }

    public function grn($id)
    {
        $grn = Grn::where('grn_no', $id)->first();
        $purchaseorder_id = $grn->purchaseorder_id;

        $purchaseorder = PurchaseOrder::where('purchaseorder_id', $purchaseorder_id)->get();
        $services = GrnServices::where('grn_no', $id)->get();
        $products = GrnProducts::where('grn_no', $id)->get();

        $taxmaster= Taxmaster::all();
        $other= Taxmaster::all();
        $supplier= Supplier::all();
        $dsr = Debitnote::all();

        $individual = IndividualCustome::where('approval', '=', 1)->select('*')->get();
        $corporate = Customer::where('approval', 1)->get();
        $servicemaster = ServiceMaster::all();
        // $passengers = Passengers::all();
        // $hotels = Hotel::all();
        // $tour = TourPackage::all();
        // $room = HotelService::all();
        // $flight = Flight::all();
        // $visa = Visa::all();
        // $insurance = Insurance::all();
        // $carhire = Carhire::all();
        // $assist = Assist::all();
        // $insuranceplan = InsurancePlan::all();
        // $other = Inventory::all();
        // $taxmaster = Taxmaster::all();
        // $bed = RoomBed::all();
        // $meal = RoomMeal::all();
        $invoice = Invoice::all();
        $other = Inventory::all();
        $purchaseorder = PurchaseOrder::all();

        // return view('grn.create', compact('id','dsr','purchaseorder','supplier','invoice','corporate','tour','bed','meal','room','taxmaster','individual','passengers','hotels', 'flight', 'visa', 'insurance', 'insuranceplan', 'other', 'carhire', 'assist'));
        return view('grn.grn', compact('id','grn','servicemaster','services','products','dsr','purchaseorder','supplier','invoice','taxmaster','individual', 'other'));
    }

    public function store(Request $request)
    {
        // $maxDsrNumber = Bills::max('bill_id');
        // $lastDsrNumber = (int) substr($maxDsrNumber, -7);
        // $newDsrNumber = $lastDsrNumber + 1;
        // $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);

        // // Build the final Dsr ID with the series
        // $series = 'GRN';
        // $dsr_number = $series . '-' . $paddedDsrNumber;

        do {
           
            $grn_no=rand(100000,999999);

            $records=DB::table('grn')
                   ->where('grn_no',$grn_no)
                   ->exists();     
                   
           
         } while ($records ==1);

         $purchaseorder_id = $request->input("purchaseorder_id");


        $Grn = new Grn;

        $Grn->grn_no = $grn_no;
        $Grn->supplier = $request->input("supplier");
        $Grn->purchaseorder_id = $request->input("purchaseorder_id");
        $Grn->date = $request->input("date");
        $Grn->type = $request->input("type");
        $Grn->currency = $request->input("currency");
        $Grn->description = $request->input("description");
        $Grn->approval_status = 2;
        $Grn->save();

        $products = Items::where('quotation_id', $purchaseorder_id)->get();

        foreach ($products as $product) {
            $GrnProducts = new GrnProducts;
            $GrnProducts->grn_no = $grn_no;
            $GrnProducts->item_details = $product->item_details;
            $GrnProducts->quantity = $product->quantity;
            $GrnProducts->rate = $product->rate;
            $GrnProducts->total = $product->total;
            $GrnProducts->save();
        }
        

        session()->flash('success', 'You\'ve Created GRN successfully.');
        return redirect()->route('OpenGrn', $grn_no); 
        // return $request;               

    }

    public function addServices(Request $request)
    {
        $price = $request->input("price");
        $taxrate = $request->input("tax_rate");
        $tax_amount= $price * $taxrate / 100;
        
        $Grn = new GrnServices;

        $Grn->grn_no = $request->input("grn_no");
        $Grn->supplier = $request->input("supplier");
        $Grn->service_type = $request->input("service_type");
        $Grn->price = $request->input("price");
        $Grn->tax_rate = $request->input("tax_rate");
        $Grn->tax_amount = $tax_amount;
        $Grn->remarks = $request->input("remarks");
        if ($request->file('service_file')) {
            $photo = $request->file('service_file');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $Grn->file = $filename;
        }      

        $Grn->save();

        $maxDsrNumber = Bills::max('bill_id');
        $lastDsrNumber = (int) substr($maxDsrNumber, -7);
        $newDsrNumber = $lastDsrNumber + 1;
        $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);

        // Build the final Dsr ID with the series
        $series = 'DN';
        $dsr_number = $series . '-' . $paddedDsrNumber;

        $Bills = new Bills;

        if ($request->file('service_file')) {
        $Bills->file = $filename;
        }

        $taxrate = $request->input("tax_rate");
        $price = $request->input("price");
        $total = $price + ($price * $taxrate / 100);
        $currentDate = date('Y-m-d');


        $Bills->supplier = $request->input("supplier");
        $Bills->bill_id = $dsr_number;
        $Bills->date = $currentDate;
        $Bills->notes = $request->input("remarks");
        $Bills->subtotal = $request->input("price");
        $Bills->total = $total;
        $Bills->save();

        session()->flash('success', 'You\'ve Created GRN successfully.');
       return redirect()->back(); 
        // return $request;
    }

    public function updateServices(Request $request)
    {
        $id = $request->input("item_id");

        $Grn = GrnServices::find($id);

        $Grn->supplier = $request->input("supplier");
        $Grn->service_type = $request->input("service_type");
        $Grn->price = $request->input("price");
        $Grn->tax_rate = $request->input("tax_rate");
        $Grn->remarks = $request->input("remarks");
        if ($request->file('service_file')) {
            $photo = $request->file('service_file');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $Grn->file = $filename;
        }      

        $Grn->save();

        session()->flash('success', 'You\'ve Updated GRN Services successfully.');
        return redirect()->back(); 
        // return $request;

        
    }
    
    
    public function addProducts(Request $request)
    {
        $type = $request->input('type');

    $id = rand(1, 100);

    if ($type=="hotel") {
        $name ='Hotel Name: '.$request->input('hotel_name') .'Room Name: '.$request->input('room_name_number') .'Bed: '.$request->input('bed') .'Meal: '.$request->input('meal');
        $price = $request->input('hotel_price');
    }
    elseif ($type=="tour") {
        $name ='Package Type: '.$request->input('package_type') .'Destination: '.$request->input('destination') .'Start Date: '.$request->input('start_date') .'End Date: '.$request->input('end_date');
        $price = $request->input('tour_price');
    }
    elseif ($type=="flight") {
        $name ='Date: '.$request->input('travel_date') .'Airline Name: '.$request->input('airline_name').'Ticket No: '.$request->input('ticket_number').'PNR No: '.$request->input('pnr_number');
        $price = $request->input('fare_price');
    }
    elseif ($type=="visa") {
        $name ='Passenger Name: '.$request->input('passenger_name') .'DOB: '.$request->input('dob') .'Country: '.$request->input('country') .'Passport No: '.$request->input('passport_no');
        $price = $request->input('visa_price');
    }
    elseif ($type=="insurance") {
        $name ='Passenger Name: '.$request->input('passenger_name') .'Company Name: '.$request->input('company_name') .'Policy No: '.$request->input('policy_number') .'Issue Date: '.$request->input('issue_date') .'Expiry Date: '.$request->input('expiry_date');
        $price = $request->input('insurance_price');
    }
    elseif ($type=="inventory") {
        $name ='Hotel Name: '.$request->input('hotel_name') .'Room Name: '.$request->input('room_name_number').'Bed: '.$request->input('bed').'Meal: '.$request->input('meal');
        $price = $request->input('inventory_price');
    }
    elseif ($type=="carhire") {
        $name ='Vehicle Type: '.$request->input('vehicle_type') .'Days: '.$request->input('days') .'Pickup Location: '.$request->input('pickup_location') .'Drop Location: '.$request->input('drop_location');
        $price = $request->input('carhire_price');
    }
    elseif ($type=="assist") {
        $name ='Airport Name: '.$request->input('airport') .'Meeting Type: '.$request->input('meeting_type') .'No of Person: '.$request->input('person_count');
        $price = $request->input('assist_price');
    }
    elseif ($type=="other") {
        $name ='Item Name: '.$request->input('other_details');
        $price = $request->input('price');
    }

        $grn_no = $request->input('grn_no');

        $Grn = new GrnProducts;

        $Grn->grn_no = $grn_no;
        $Grn->item_details = $name;
        $Grn->quantity = 1;
        $Grn->rate = $price;
        // $Grn->tax_rate = $tax_rate;
        // $Grn->total = $request->input("total");
        
        $Grn->save();

        session()->flash('success', 'You\'ve Added GRN Products successfully.');
        return redirect()->back(); 
        // return $request;

        
    }

    
    public function updateProducts(Request $request)
    {
        $id = $request->input("item_id");
        $attachment = GrnProducts::find($id);
        $oldfile= $attachment->attachment;

        $Grn = GrnProducts::find($id);

        $Grn->item_details = $request->input("item_details");
        $Grn->quantity = $request->input("po_quantity");
        $Grn->grn_quantity = $request->input("grn_quantity");
        $Grn->rate = $request->input("rate");
        $Grn->tax_rate = $request->input("tax_rate");
        $Grn->total = $request->input("total");
        $Grn->descripency_notes = $request->input("descripency_notes");
        if ($request->file('product_file')) {
            $photo = $request->file('product_file');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $Grn->attachment = $filename;
        }
        else{
            $Grn->attachment = $oldfile;            
        }
      

        $Grn->save();

        session()->flash('success', 'You\'ve Updated GRN Products successfully.');
        return redirect()->back(); 
        // return $request;

        
    }


    public function saveGrn(Request $request)
    {
        $id= $request->input('grn_id');

        $Grn = Grn::find($id);

        $Grn->notes = $request->input("customer_note");
        $Grn->file = $request->input("files");
        $Grn->subtotal = $request->input("subtotal");
        $Grn->total = $request->input("grn_total");
        $Grn->discount = $request->input("discount");
        $Grn->adjustment_charge = $request->input("adjustment_charge");
        $Grn->save();


    //     // Get the products you want to update
    //    $products = GrnProducts::where('grn_no', $grn_no)->get();

    //    // Loop through the products and update each one
    // foreach ($products as $product) {
    //   // Get the updated data from the form
    //   $updatedData = [
    //     'item_details' => $request->input('item_details')[$product->id],
    //     'quantity' => $request->input('po_qty')[$product->id],
    //     'grn_quantity' => $request->input('grn_qty')[$product->id],
    //     'rate' => $request->input('rate')[$product->id],
    //     'tax' => $request->input('tax')[$product->id],
    //     'amount' => $request->input('amount')[$product->id],
    //     'descripency_notes' => $request->input('descripency_notes')[$product->id],
    //     'attachment' => $request->input('attachment')[$product->id],
    //   ];

    //      // Update the product with the new data
    //      $product->update($updatedData);
    // }


        session()->flash('success', 'GRN saved successfully.');
        return redirect()->back(); 
        // return $request;


    }
    
     public function destroyService($id)
    {
        $pass=GrnServices::find($id);
        $pass->delete();
        session()->flash('success', 'GRN Service deleted successfully.');
        return Redirect::back();

    }
    
     public function destroyProduct($id)
    {
        $pass=GrnProducts::find($id);
        $pass->delete();
        session()->flash('success', 'GRN Products deleted successfully.');
        return Redirect::back();

    }


}
