<?php

namespace App\Http\Controllers\Employee;

use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Employee\Employee;
use App\Models\Employee\EmployeeFamily;
use App\Models\Employee\EmployeeBenefits;
use App\Models\Employee\EmployeeEntry;
use App\Models\Employee\EmployeeBankDetails;
use App\Models\Master\Department;
use App\Models\Master\Designation;
use App\Models\Master\Location;
use App\Models\Master\Benefits;
use App\Models\Master\Shift;

use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Storage;



class EmployeeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $user = Auth::user();
        $user_role = $user->roles;
        $employee_id = $user->employee_id;
        if ($user_role=='Super Admin') {
          $udata = Employee::orderBy('id', 'DESC')->get();
        }
        elseif ($user_role=='HR') {
          $udata = Employee::where('hr_manager', $employee_id)->get();
        }
        elseif ($user_role=='Reporting Manager') {
          $udata = Employee::where('reporting_manager', $employee_id)->get();
        }

        $shift = Shift::all();
        return view('employee.table', compact('udata', 'user_role', 'shift'));
    }
    
     public function shiftwiseData($id)
    {
        $user = Auth::user();
        $user_role = $user->roles;
        $employee_id = $user->employee_id;
        if ($user_role=='Super Admin') {
          $data = Employee::orderBy('id', 'DESC')->where('shift_id', $id)->get();
        }
        elseif ($user_role=='HR') {
          $data = Employee::where('hr_manager', $employee_id)->where('shift_id', $id)->get();
        }
        elseif ($user_role=='Reporting Manager') {
          $data = Employee::where('reporting_manager', $employee_id)->where('shift_id', $id)->get();
        }

        return view('employee.table', compact('data', 'user_role'));
    }
    
    public function family($id)
    {
       
        $udata = EmployeeFamily::where('employee_id', $id)->get();
        return view('employee.family', compact('udata'));
    }
    
     public function add_bank(Request $request)
    {
        $EmployeeBankDetails = new EmployeeBankDetails();
        $EmployeeBankDetails->employee_id = $request->input('employee_id');
        $EmployeeBankDetails->bank_name = $request->input('bank_name');
        $EmployeeBankDetails->bank_code = $request->input('bank_code');
        $EmployeeBankDetails->branch_name = $request->input('branch_name');
        $EmployeeBankDetails->swift_code = $request->input('swift_code');
        $EmployeeBankDetails->account_number = $request->input('account_number');
        $EmployeeBankDetails->currency = $request->input('currency');
        $EmployeeBankDetails->save();
            
         return redirect()->back()->with('success', 'Bank Added Successfully');

    }
    
     public function add_family(Request $request)
    {
            $EmployeeFamily = new EmployeeFamily();
            $EmployeeFamily->employee_id = $request->input("employee_id");
            $EmployeeFamily->first_name = $request->input("first_name");
            $EmployeeFamily->last_name = $request->input("last_name");
            $EmployeeFamily->middle_name = $request->input("middle_name");
            $EmployeeFamily->age = $request->input("age");
            $EmployeeFamily->gender = $request->input("gender");
            $EmployeeFamily->relation = $request->input("relation");
            $EmployeeFamily->save();
            
         return redirect()->back()->with('success', 'Added Successfully');

    }
    
    public function add_benefits(Request $request)
    {
            $id = $request->input("employee_id");
            $benefits = $request->input("benefits");
           $count = EmployeeBenefits::where('employee_id', $id)->where('benefits', $benefits)->count();
           
           if($count==1){
             return redirect()->back()->with('success', 'Already Added');
               
           }
           else{
               
            $EmployeeBenefits = new EmployeeBenefits();
            $EmployeeBenefits->employee_id = $request->input("employee_id");
            $EmployeeBenefits->benefits = $request->input("benefits");
            $EmployeeBenefits->save();
            
         return redirect()->back()->with('success', 'Added Successfully');
         
           }

    }
    
    public function benefits($id)
    {
        $benefits = Benefits::all();
       
        $udata = EmployeeBenefits::where('employee_id', $id)->get();
        return view('employee.benefits', compact('id', 'udata', 'benefits'));
    }
    

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
            session()->forget('cart');

        $jsonData = Storage::disk('public')->get('country_code.json');
        $data = json_decode($jsonData, true);

        $department = Department::all();
        $location = Location::all();
        $designation = Designation::all();
        $benefits = Benefits::all();
        $shift = Shift::all();
        
        $hr = Employee::where('job_title', 'HR')->get();
        $reporting_manager = Employee::where('job_title', 'Reporting Manager')->get();
        $user = Auth::user();

        return view('employee.create', compact('data', 'designation', 'department', 'location', 'benefits', 'hr', 'reporting_manager', 'shift', 'user'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function checkmailexists(Request $request){

        if($request->input('from')=="create"){
            $udata = Employee::orderBy('id', 'DESC')->where('email','=',$request->input("email"))->count();
        }
        else{
            // edit
            $udata = Employee::orderBy('id', 'DESC')->where('email','=',$request->input("email"))->where('id','!=',$request->input("id"))->count();
        }
        if($udata>0){
            return "false";
        }
        else{
            return "true";
        }   
    }
    public function store(Request $request)
    {
        $email = $request->input('email');
        $email_count = Employee::where('email', $email)->count();
        
        if($email_count>0){
        return redirect()->back()->with('error', 'Email address already exist');
            
        }


         // Get the current maximum order number from the database
        $maxDsrNumber = Employee::max('employee_id');
        $lastDsrNumber = (int) substr($maxDsrNumber, -7);
        $newDsrNumber = $lastDsrNumber + 1;
        $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);
        $series = 'EMP';
        $employee_id = $series . '-' . $paddedDsrNumber;
        
        // Create a new employee instance
        $employee = new Employee;
        
        // Set the employee attributes
        $employee->first_name = $request->input('first_name');
        $employee->middle_name = $request->input('middle_name');
        $employee->last_name = $request->input('last_name');
        $employee->date_of_birth = $request->input('date_of_birth');
        $employee->gender = $request->input('gender');
        $employee->address = $request->input('address');
        $employee->marital_status = $request->input('marital_status');
        $employee->nationality = $request->input('nationality');
        $employee->social_security_number = $request->input('social_security_number');
        $employee->email = $request->input('email');
        $employee->phone_number = $request->input('phone_number');
        $employee->phone_cc = $request->input('phone_cc');
        $employee->emergency_contact_cc = $request->input('emergency_contact_cc');
        $employee->emergency_contact_name = $request->input('emergency_contact_name');
        $employee->emergency_contact_number = $request->input('emergency_contact_number');
        
        $employee->employee_id = $employee_id;
        $employee->job_title = $request->input('job_title');
        $employee->department = $request->input('department');
        $employee->location = $request->input('location');
        $employee->date_of_joining = $request->input('date_of_joining');
        $employee->employment_type = $request->input('employment_type');
        $employee->reporting_manager = $request->input('reporting_manager');
        $employee->hr_manager = $request->input('hr_manager');
        $employee->shift_id = $request->input('shift_id');
        $employee->salary = $request->input('salary');
        $employee->pay_frequency = $request->input('pay_frequency');
        $employee->tax_number = $request->input('tax_number');
        $employee->tax_issue_date = $request->input('tax_issue_date');
        $employee->tax_expiry_date = $request->input('tax_expiry_date');
        // $employee->tax_attachment = $request->input('tax_attachment');
        $employee->other_tax = $request->input('other_tax');
        // $employee->other_tax_attachment = $request->input('other_tax_attachment');
        $employee->government_id_number = $request->input('government_id_number');
        $employee->government_id_issue_date = $request->input('government_id_issue_date');
        $employee->government_id_expiry_date = $request->input('government_id_expiry_date');
        // $employee->government_id_attachment = $request->input('government_id_attachment');
        $employee->passport_id_number = $request->input('passport_id_number');
        $employee->passport_issue_date = $request->input('passport_issue_date');
        $employee->passport_expiry_date = $request->input('passport_expiry_date');
        // $employee->passport_attachment = $request->input('passport_attachment');
        $employee->driving_license_number = $request->input('driving_license_number');
        $employee->driving_license_issue_date = $request->input('driving_license_issue_date');
        $employee->driving_license_expiry_date = $request->input('driving_license_expiry_date');
        // $employee->driving_license_attachment = $request->input('driving_license_attachment');
        $employee->contract = $request->input('contract');
        $employee->contract_issue_date = $request->input('contract_issue_date');
        $employee->contract_expiry_date = $request->input('contract_expiry_date');
        // $employee->contract_attachment = $request->input('contract_attachment');
        $employee->insurance_company_name = $request->input('insurance_company_name');
        $employee->insurance_policy_number = $request->input('insurance_policy_number');
        $employee->insurance_issue_date = $request->input('insurance_issue_date');
        $employee->insurance_expiry_date = $request->input('insurance_expiry_date');
        // $employee->insurance_attachment = $request->input('insurance_attachment');
        // $employee->other_documents_attachment = $request->input('other_documents_attachment');
        $employee->other_documents_name = $request->input('other_documents_name');
        $employee->address_1 = $request->input('address_1');
        $employee->address_2 = $request->input('address_2');
        $employee->city_town = $request->input('city_town');
        $employee->state_province = $request->input('state_province');
        $employee->pincode = $request->input('pincode');
        $employee->address_type = $request->input('address_type');
        $employee->country = $request->input('country');

        // Upload and profile photo
        if ($request->hasFile('profile_photo')) {
            $photo = $request->file('profile_photo');            
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $employee->photo = $filename;
        }
        
        // Upload and attach resume
        if ($request->hasFile('resume')) {
            $resume = $request->file('resume');            
            $filename = time() . '.' . $resume->getClientOriginalExtension();
            $path = public_path('uploads');
            $resume->move($path, $filename);
            $employee->resume = $filename;
        }
        
        // Upload and attach resume
        if ($request->hasFile('appraisal')) {
            $appraisal = $request->file('appraisal');            
            $filename = time() . '.' . $appraisal->getClientOriginalExtension();
            $path = public_path('uploads');
            $appraisal->move($path, $filename);
            $employee->photo = $filename;
        }
        
        // Upload and attach tax attachment
        if ($request->hasFile('tax_attachment')) {
            $taxAttachment = $request->file('tax_attachment');
            $filename = time() . '.' . $taxAttachment->getClientOriginalExtension();
            $path = public_path('uploads');
            $taxAttachment->move($path, $filename);
            $employee->tax_attachment = $filename;
        }
        
        // Upload and attach other tax attachment
        if ($request->hasFile('other_tax_attachment')) {
            $otherTaxAttachment = $request->file('other_tax_attachment');
            $filename = time() . '.' . $otherTaxAttachment->getClientOriginalExtension();
            $path = public_path('uploads');
            $otherTaxAttachment->move($path, $filename);
            $employee->other_tax_attachment = $filename;
        }
        
        // Upload and attach government ID attachment
        if ($request->hasFile('government_id_attachment')) {
            $governmentIdAttachment = $request->file('government_id_attachment');
            $filename = time() . '.' . $governmentIdAttachment->getClientOriginalExtension();
            $path = public_path('uploads');
            $governmentIdAttachment->move($path, $filename);
            $employee->government_id_attachment = $filename;
        }
        
        // Upload and attach passport attachment
        if ($request->hasFile('passport_attachment')) {
            $passportAttachment = $request->file('passport_attachment');
            $filename = time() . '.' . $passportAttachment->getClientOriginalExtension();
            $path = public_path('uploads');
            $passportAttachment->move($path, $filename);
            $employee->passport_attachment = $filename;
        }
        
        // Upload and attach driving license attachment
        if ($request->hasFile('driving_license_attachment')) {
            $drivingLicenseAttachment = $request->file('driving_license_attachment');
            $filename = time() . '.' . $drivingLicenseAttachment->getClientOriginalExtension();
            $path = public_path('uploads');
            $drivingLicenseAttachment->move($path, $filename);
            $employee->driving_license_attachment = $filename;
        }
        
        // Upload and attach contract attachment
        if ($request->hasFile('contract_attachment')) {
            $contractAttachment = $request->file('contract_attachment');
            $filename = time() . '.' . $contractAttachment->getClientOriginalExtension();
            $path = public_path('uploads');
            $contractAttachment->move($path, $filename);
            $employee->contract_attachment = $filename;
        }
        
        // Upload and attach insurance attachment
        if ($request->hasFile('insurance_attachment')) {
            $insuranceAttachment = $request->file('insurance_attachment');
            $filename = time() . '.' . $insuranceAttachment->getClientOriginalExtension();
            $path = public_path('uploads');
            $insuranceAttachment->move($path, $filename);
            $employee->insurance_attachment = $filename;
        }
        
        // Upload and attach other documents attachment
        if ($request->hasFile('other_documents_attachment')) {
            $otherDocumentsAttachment = $request->file('other_documents_attachment');
            $filename = time() . '.' . $otherDocumentsAttachment->getClientOriginalExtension();
            $path = public_path('uploads');
            $otherDocumentsAttachment->move($path, $filename);
            $employee->other_documents_attachment = $filename;
        }
        
            $active_status = $request->input("status");
            if($active_status=="on"){
                $status=1;
            }
            else
            {
                $status=0;
            }
            // $employee->active_status = $status;
            $employee->active_status = 1;
        // Save the employee record
        $employee->save();
        $employee_id= $employee->id;
        
        $EmployeeBankDetails = new EmployeeBankDetails();
        $EmployeeBankDetails->employee_id = $employee_id;
        $EmployeeBankDetails->bank_name = $request->input('bank_name');
        $EmployeeBankDetails->bank_code = $request->input('bank_code');
        $EmployeeBankDetails->branch_name = $request->input('branch_name');
        $EmployeeBankDetails->swift_code = $request->input('swift_code');
        $EmployeeBankDetails->account_number = $request->input('account_number');
        $EmployeeBankDetails->currency = $request->input('currency');
        $EmployeeBankDetails->save();

        $name = $request->input("f_first_name");
        
        if($name){
            
        foreach($name as $key => $valuez) {
            $id = $request->input("id");
            $EmployeeFamily = new EmployeeFamily();
            $EmployeeFamily->employee_id = $employee_id;
            $EmployeeFamily->first_name = $request->input("f_first_name")[$key];
            $EmployeeFamily->last_name = $request->input("f_last_name")[$key];
            $EmployeeFamily->middle_name = $request->input("f_middle_name")[$key];
            $EmployeeFamily->age = $request->input("age")[$key];
            $EmployeeFamily->gender = $request->input("gender1")[$key];
            $EmployeeFamily->relation = $request->input("relation")[$key];
            $EmployeeFamily->save();
        } 
        
      }
    
       $value = $request->input('benefits');
        if($value){
            
        foreach ($value as $data) {
            $model = new EmployeeBenefits();
            $model->employee_id = $employee_id;
            $model->benefits = $data;
            $model->save();
          }
        }

        // Redirect back with success message
        return redirect()->route('Employee')->with('success', 'You have created an employee successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $data=[];
        $emp = Employee::find($id);
        //dd($emp);
        return view('Employee.view', compact('emp', 'data'));
    }

    public function downloadFIle($id)
{
    $image = EmployeeEntry::findOrFail($id);
$pathToFile = public_path('uploads/' . $image->file);

if ($image->file!='') {
    return response()->download($pathToFile);
} else {
    session()->flash('success', 'File does not exist.');
    return redirect()->back();
}



    // $pathToFile = storage_path('app/public/documents/document.pdf');
    // $headers = [
    //     'Content-Type' => 'application/pdf',
    // ];
    // return response()->download($pathToFile, 'document.pdf', $headers);
}


    public function addEntry(Request $request)
    {
        
        $emp_medical = new EmployeeEntry;
        $emp_medical->employee_id = $request->input("employee_id");
        $emp_medical->date = $request->input("date");
        $emp_medical->type = $request->input("type");
        $emp_medical->history = $request->input("medical");

        if ($request->file('attachment')) {
            $insurance = $request->file('attachment');
            $filename = time() . '.' . $insurance->getClientOriginalExtension();
            $path = public_path('uploads');
            $insurance->move($path, $filename);
            $emp_medical->file = $filename;
        }
        $emp_medical->save();

        session()->flash('success', 'You\'ve added entry successfully.');
        return Redirect::back()->withErrors(['msg' => 'The Message']);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $user = Auth::user();
        $user_role = $user->roles;
        
        $jsonData = Storage::disk('public')->get('country_code.json');
        $data = json_decode($jsonData, true);

        $department = Department::all();
        $location = Location::all();
        $designation = Designation::all();
        $shift = Shift::all();
        
        $hr = Employee::where('job_title', 'HR')->get();
        $reporting_manager = Employee::where('job_title', 'Reporting Manager')->get();

        $employee = Employee::find($id);
        $medical = EmployeeEntry::where('employee_id', $id)->get();
        $family = EmployeeFamily::where('employee_id', $id)->get();
        $bank = EmployeeBankDetails::where('employee_id', $id)->get();
        //dd($emp);
        // return $employee;
        return view('employee.nedit', compact('employee', 'data', 'department', 'location', 'designation', 'hr', 'reporting_manager', 'shift', 'medical', 'user', 'user_role', 'family', 'bank'));
    }

    public function view($id)
    {
        $jsonData = Storage::disk('public')->get('country_code.json');
        $data = json_decode($jsonData, true);

        $department = Department::all();
        $location = Location::all();
        $designation = Designation::all();

        $shift = Shift::all();

        $employee = Employee::find($id);
        $medical = EmployeeEntry::where('employee_id', $id)->get();
        $family = EmployeeFamily::where('employee_id', $id)->get();
        $bank = EmployeeBankDetails::where('employee_id', $id)->get();
        //dd($emp);
        // return $employee;
        return view('employee.view', compact('employee', 'data', 'department', 'location', 'designation', 'shift', 'medical', 'family', 'bank'));
    }
    
    public function manager_view($id)
    {
        $jsonData = Storage::disk('public')->get('country_code.json');
        $data = json_decode($jsonData, true);

        $department = Department::all();
        $location = Location::all();
        $designation = Designation::all();

        $shift = Shift::all();

        $employee = Employee::where('employee_id', $id)->first();
        $employee_id= $employee->id;
        $medical = EmployeeEntry::where('employee_id', $employee_id)->get();
        $family = EmployeeFamily::where('employee_id', $employee_id)->get();
        $bank = EmployeeBankDetails::where('employee_id', $employee_id)->get();
        //dd($emp);
        // return $employee;
        return view('employee.view', compact('employee', 'data', 'department', 'location', 'designation', 'shift', 'medical', 'family', 'bank'));
    }

    /**
     * Update the specified resource in storage.
     *s
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
   public function update(Request $request)
    {
        $id = $request->input('id');

        // Create a new employee instance
        $employee = Employee::find($id);
        
        // Set the employee attributes
        $employee->first_name = $request->input('first_name');
        $employee->middle_name = $request->input('middle_name');
        $employee->last_name = $request->input('last_name');
        $employee->date_of_birth = $request->input('date_of_birth');
        $employee->gender = $request->input('gender');
        $employee->address = $request->input('address');
        $employee->marital_status = $request->input('marital_status');
        $employee->nationality = $request->input('nationality');
        $employee->social_security_number = $request->input('social_security_number');
        $employee->email = $request->input('email');
        $employee->phone_number = $request->input('phone_number');
        $employee->emergency_contact_name = $request->input('emergency_contact_name');
        $employee->emergency_contact_number = $request->input('emergency_contact_number');
        $employee->bank_name = $request->input('bank_name');
        $employee->bank_code = $request->input('bank_code');
        $employee->branch_name = $request->input('branch_name');
        $employee->swift_code = $request->input('swift_code');
        $employee->account_number = $request->input('account_number');
        $employee->currency = $request->input('currency');
        $employee->job_title = $request->input('job_title');
        $employee->department = $request->input('department');
        $employee->location = $request->input('location');
        $employee->date_of_joining = $request->input('date_of_joining');
        $employee->employment_type = $request->input('employment_type');
        $employee->reporting_manager = $request->input('reporting_manager');
        $employee->hr_manager = $request->input('hr_manager');
        $employee->salary = $request->input('salary');
        $employee->pay_frequency = $request->input('pay_frequency');
        $employee->tax_number = $request->input('tax_number');
        $employee->tax_issue_date = $request->input('tax_issue_date');
        $employee->tax_expiry_date = $request->input('tax_expiry_date');
        // $employee->tax_attachment = $request->input('tax_attachment');
        $employee->other_tax = $request->input('other_tax');
        // $employee->other_tax_attachment = $request->input('other_tax_attachment');
        $employee->government_id_number = $request->input('government_id_number');
        $employee->government_id_issue_date = $request->input('government_id_issue_date');
        $employee->government_id_expiry_date = $request->input('government_id_expiry_date');
        // $employee->government_id_attachment = $request->input('government_id_attachment');
        $employee->passport_id_number = $request->input('passport_id_number');
        $employee->passport_issue_date = $request->input('passport_issue_date');
        $employee->passport_expiry_date = $request->input('passport_expiry_date');
        // $employee->passport_attachment = $request->input('passport_attachment');
        $employee->driving_license_number = $request->input('driving_license_number');
        $employee->driving_license_issue_date = $request->input('driving_license_issue_date');
        $employee->driving_license_expiry_date = $request->input('driving_license_expiry_date');
        // $employee->driving_license_attachment = $request->input('driving_license_attachment');
        $employee->contract = $request->input('contract');
        $employee->contract_issue_date = $request->input('contract_issue_date');
        $employee->contract_expiry_date = $request->input('contract_expiry_date');
        // $employee->contract_attachment = $request->input('contract_attachment');
        $employee->insurance_company_name = $request->input('insurance_company_name');
        $employee->insurance_policy_number = $request->input('insurance_policy_number');
        $employee->insurance_issue_date = $request->input('insurance_issue_date');
        $employee->insurance_expiry_date = $request->input('insurance_expiry_date');
        // $employee->insurance_attachment = $request->input('insurance_attachment');
        // $employee->other_documents_attachment = $request->input('other_documents_attachment');
        $employee->other_documents_name = $request->input('other_documents_name');
        $employee->address_1 = $request->input('address_1');
        $employee->address_2 = $request->input('address_2');
        $employee->city_town = $request->input('city_town');
        $employee->state_province = $request->input('state_province');
        $employee->pincode = $request->input('pincode');
        $employee->address_type = $request->input('address_type');
        $employee->country = $request->input('country');

                // Upload and profile photo
        if ($request->hasFile('profile_photo')) {
            $photo = $request->file('profile_photo');            
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $employee->photo = $filename;
        }
        
        // Upload and attach resume
        if ($request->hasFile('resume')) {
            $resume = $request->file('resume');            
            $filename = time() . '.' . $resume->getClientOriginalExtension();
            $path = public_path('uploads');
            $resume->move($path, $filename);
            $employee->resume = $filename;
        }
        
        // Upload and attach resume
        if ($request->hasFile('appraisal')) {
            $appraisal = $request->file('appraisal');            
            $filename = time() . '.' . $appraisal->getClientOriginalExtension();
            $path = public_path('uploads');
            $appraisal->move($path, $filename);
            $employee->photo = $filename;
        }
        
        // Upload and attach tax attachment
        if ($request->hasFile('tax_attachment')) {
            $taxAttachment = $request->file('tax_attachment');
            $filename = time() . '.' . $taxAttachment->getClientOriginalExtension();
            $path = public_path('uploads');
            $taxAttachment->move($path, $filename);
            $employee->tax_attachment = $filename;
        }
        
        // Upload and attach other tax attachment
        if ($request->hasFile('other_tax_attachment')) {
            $otherTaxAttachment = $request->file('other_tax_attachment');
            $filename = time() . '.' . $otherTaxAttachment->getClientOriginalExtension();
            $path = public_path('uploads');
            $otherTaxAttachment->move($path, $filename);
            $employee->other_tax_attachment = $filename;
        }
        
        // Upload and attach government ID attachment
        if ($request->hasFile('government_id_attachment')) {
            $governmentIdAttachment = $request->file('government_id_attachment');
            $filename = time() . '.' . $governmentIdAttachment->getClientOriginalExtension();
            $path = public_path('uploads');
            $governmentIdAttachment->move($path, $filename);
            $employee->government_id_attachment = $filename;
        }
        
        // Upload and attach passport attachment
        if ($request->hasFile('passport_attachment')) {
            $passportAttachment = $request->file('passport_attachment');
            $filename = time() . '.' . $passportAttachment->getClientOriginalExtension();
            $path = public_path('uploads');
            $passportAttachment->move($path, $filename);
            $employee->passport_attachment = $filename;
        }
        
        // Upload and attach driving license attachment
        if ($request->hasFile('driving_license_attachment')) {
            $drivingLicenseAttachment = $request->file('driving_license_attachment');
            $filename = time() . '.' . $drivingLicenseAttachment->getClientOriginalExtension();
            $path = public_path('uploads');
            $drivingLicenseAttachment->move($path, $filename);
            $employee->driving_license_attachment = $filename;
        }
        
        // Upload and attach contract attachment
        if ($request->hasFile('contract_attachment')) {
            $contractAttachment = $request->file('contract_attachment');
            $filename = time() . '.' . $contractAttachment->getClientOriginalExtension();
            $path = public_path('uploads');
            $contractAttachment->move($path, $filename);
            $employee->contract_attachment = $filename;
        }
        
        // Upload and attach insurance attachment
        if ($request->hasFile('insurance_attachment')) {
            $insuranceAttachment = $request->file('insurance_attachment');
            $filename = time() . '.' . $insuranceAttachment->getClientOriginalExtension();
            $path = public_path('uploads');
            $insuranceAttachment->move($path, $filename);
            $employee->insurance_attachment = $filename;
        }
        
        // Upload and attach other documents attachment
        if ($request->hasFile('other_documents_attachment')) {
            $otherDocumentsAttachment = $request->file('other_documents_attachment');
            $filename = time() . '.' . $otherDocumentsAttachment->getClientOriginalExtension();
            $path = public_path('uploads');
            $otherDocumentsAttachment->move($path, $filename);
            $employee->other_documents_attachment = $filename;
        }
        
        $employee->active_status = $request->input("status") ? "1":"0";
        
        // Save the employee record
        $employee->save();

        // Redirect back with success message
        return redirect()->route('Employee')->with('success', 'You have Updated an employee successfully.');
    }

    public function setData(Request $request)
{

 // Generate an auto-increment ID
    $id = count(session('cart', [])) + 1;
    
  
        $first_name =$request->input('first_name');
        $middle_name =$request->input('middle_name');
        $last_name =$request->input('last_name');
        $age = $request->input('age');
        $gender = $request->input('gender');
        $relation = $request->input('relation');
    

    $cart = session()->get('cart', []);
    
   
        $cart[$id] = [
            'id' => $id,
            'first_name' => $first_name,
            'middle_name' => $middle_name,
            'last_name' => $last_name,
            'age' => $age,
            'gender' => $gender,
            'relation' => $relation
        ];
        
    session()->put('cart', $cart);



    return response()->json(['success' => true]);

    // return redirect()->back()->with('success', 'Product added to cart successfully!');
}

public function getData(){
     
    $items= session()->get('cart');
    return view('employee.items', compact('items'))->render();

 }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $emp = Employee::find($id);
        $emp->delete();
        return Redirect::back()->withErrors(['msg' => 'The Message']);
    }
    
     public function delete_family($id)
    {
        $emp = EmployeeFamily::find($id);
        $emp->delete();
        return redirect()->back()->with('success', 'Deleted Successfully');
    }
    
    public function delete_benefits($id)
    {
        $emp = EmployeeBenefits::find($id);
        $emp->delete();
        return redirect()->back()->with('success', 'Deleted Successfully');
    }
    
    public function delete_bank($id)
    {
        $emp = EmployeeBankDetails::find($id);
        $emp->delete();
        return redirect()->back()->with('success', 'Deleted Successfully');
    }

    public function destroyEntry($id)
    {
        $emp = EmployeeEntry::find($id);
        $emp->delete();
        return redirect()->back()->with('success', 'Deleted Successfully');
    }
}
