<?php

namespace App\Http\Controllers\DSR;

use PDF;
use Carbon\Carbon;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use App\Models\DSR\DSR;
use App\Models\Bills\Bills;
use App\Models\Supplier\Supplier;
use App\Models\Supplier\SupplierTransaction;
use App\Models\DSR\DsrHotelService;
use App\Models\DSR\DsrTourService;
use App\Models\DSR\DsrFlightService;
use App\Models\DSR\DsrVisaService;
use App\Models\DSR\DsrServicePassenger;
use App\Models\DSR\DsrInsuranceService;
use App\Models\DSR\DsrOtherService;
use App\Models\DSR\DsrCarhireService;
use App\Models\DSR\DsrAssistService;
use App\Models\Passengers\Passengers;
use App\Models\Hotel\Hotel;
use App\Models\Flight\Flight;
use App\Models\Visa\Visa;
use App\Models\Carhire\Carhire;
use App\Models\Assist\Assist;
use App\Models\Insurance\Insurance;
use App\Models\InsurancePlan\InsurancePlan;
use App\Models\Inventory\Inventory;
use App\Models\HotelService\HotelService;
use App\Models\TourPackage\TourPackage;
use App\Models\HotelServices\RoomBed;
use App\Models\HotelServices\RoomMeal;
use App\Models\Customer\Customer;
use App\Models\Taxmaster\Taxmaster;
use App\Models\Individual\IndividualCustome;
use Illuminate\Support\Facades\Redirect;

class DsrController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $dsr = DSR::orderBy('id', 'DESC')->get();
        return view('dsr.index', compact('dsr'));
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $corporate = Customer::where('approval', '=', 1)->select('*')->get();
        $cdata = Customer::where('approval', '=', 1)->get();
        $individual = IndividualCustome::where('approval', '=', 1)->get();
        $idata = IndividualCustome::where('approval', '=', 1)->get();
        //dd($corporate);
        return view('dsr.create', compact('corporate','individual', 'idata', 'cdata'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
          // Get the current maximum order number from the database
        $maxDsrNumber = Dsr::max('dsr_number');

        // Parse the Dsr number to get the numeric part
        $lastDsrNumber = (int) substr($maxDsrNumber, -6);

        // Increment the Dsr number
        $newDsrNumber = $lastDsrNumber + 1;

        // Pad the Dsr number with leading zeros to get the final Dsr number
        $paddedDsrNumber = str_pad($newDsrNumber, 6, '0', STR_PAD_LEFT);

        // Build the final Dsr ID with the series
        $series = 'NDSR';
        $dsr_number = $series . '-' . $paddedDsrNumber;

        $type=$request->input("customer_type");
        if ($type=="Corporate") {
            $customer_id = $request->input("corporate_id");
        }
        else {
            $customer_id = $request->input("individual_id");
        }

        $dsr = new DSR;
        $dsr->customer_type = $request->input("customer_type");
        $dsr->customer_id = $customer_id;
        $dsr->select_company_name = $request->input("select_company_name");
        $dsr->select_individual_name = $request->input("select_individual_name");
        $dsr->dsr_number = $dsr_number;
        $dsr->currency = $request->input("currency");
        $dsr->save();
        
        $id = $dsr->id; // Get the ID of the newly inserted record

        
        session()->flash('success', 'DSR created successfully.');
        return redirect()->route('Passengers', $id);
    }

    public function guest($type, $id)
    {
        $data = DsrServicePassenger::where('dsr_service_id', $id)->where('dsr_service_type', $type)->get();
        //dd($corporate);
        return view('dsr.guest', compact('data'));
    }
    
    
     public function summary($id)
    {
    
    $dsr = Dsr::where('dsr_number', $id)->first();
    $passengers = Passengers::where('dsr_number', $id)->get();
    $hotels = DsrHotelService::all();
    $tours = DsrTourService::all();
    $flights = DsrFlightService::all();
    $visas = DsrVisaService::all();
    $insurances = DsrInsuranceService::all();
    $others = DsrOtherService::all();
    
        //  $pdf = PDF::loadView('dsr.summary', compact('id','passengers','services'));
         $pdf = PDF::loadView('dsr.summary', compact('id','dsr', 'passengers','hotels', 'tours', 'flights', 'visas', 'insurances', 'others'));

       return $pdf->stream('Summary.pdf');
    }
    
     public function voucher($type, $id)
    {

    if($type=="hotel"){
        
    $hotel = DsrHotelService::where('id', $id)->first();
    $hotel_name = $hotel->hotel_name;
    $hotel_data= Hotel::where('hotel_name', $hotel_name)->first();
    $service_id = $hotel->id;
    $passengers = DsrServicePassenger::where('dsr_service_id', $service_id)->where('dsr_service_type', 'Hotel')->get();
    
    $pdf = PDF::loadView('voucher.hotelvoucher', compact('passengers','hotel', 'hotel_data'));
    return $pdf->stream('Hotel Voucher.pdf');
        
    }
    elseif($type=="flight"){
        
    $flight = DsrFlightService::where('id', $id)->first();
    $service_id = $flight->id;
    $passenger = DsrServicePassenger::where('dsr_service_id', $service_id)->where('dsr_service_type', 'Flight')->get();
    
    $pdf = PDF::loadView('voucher.flightvoucher', compact('passenger','flight'));
    return $pdf->stream('Flight Voucher.pdf');
        
    }
    elseif($type=="visa"){
        
    $visa = DsrVisaService::where('id', $id)->first();
    $pdf = PDF::loadView('voucher.visavoucher', compact('visa'));
    return $pdf->stream('Visa Voucher.pdf');
        
    }
    elseif($type=="insurance"){
    
    $insurance = DsrInsuranceService::where('id', $id)->first();
    $service_id = $insurance->id;
    $passengers = DsrServicePassenger::where('dsr_service_id', $service_id)->where('dsr_service_type', 'Insurance')->get();
    
    $pdf = PDF::loadView('voucher.insurancevoucher', compact('passengers','insurance'));
    return $pdf->stream('Insurance Voucher.pdf');
        
    }
    

         
    }
    
    public function passenger_summary($id)
    {
    
    $passengers = Passengers::where('user_id', $id)->first();
    $dsr_no=$passengers->dsr_number;
    $dsr = Dsr::where('dsr_number', $dsr_no)->first();
    
    $hotels = DsrHotelService::all();
    $tours = DsrTourService::all();
    $flights = DsrFlightService::all();
    $visas = DsrVisaService::all();
    $insurances = DsrInsuranceService::all();
    $others = DsrOtherService::all();
    
        //  $pdf = PDF::loadView('dsr.summary', compact('id','passengers','services'));
         $pdf = PDF::loadView('dsr.pass_summary', compact('id', 'dsr', 'passengers','hotels', 'tours', 'flights', 'visas', 'insurances', 'others'));

       return $pdf->stream('Passenger_Summary.pdf');
    }


    public function storePassengers(Request $request)
    {
        

        do {
           
            $user_id=rand(100000,999999);

            $records=DB::table('passengers')
                   ->where('user_id',$user_id)
                   ->exists();     
                   
            // $user_id=rand(100000,999999);
            // $records= Passengers::where('user_id', $user_id)->get();
           
         } while ($records ==1);
        

        $passengers = new Passengers;
        $passengers->customer_id = $request->input("customer_id");
        $passengers->user_id = $user_id;
        $passengers->dsr_number = $request->input("dsr_number");
        $passengers->name = $request->input("customer_name");
        $passengers->email = $request->input("email");
        $passengers->phone = $request->input("phone");
        $passengers->save();
        
        session()->flash('success', 'You\'ve Added Passenger successfully.');
        return Redirect::back();
    }

    
    
    
    public function editService($type, $id){

        
    

        $individual = IndividualCustome::where('approval', '=', 1)->select('*')->get();
        $corporate = Customer::where('approval', 1)->get();
        $hotels = Hotel::all();
        $tour = TourPackage::all();
        $room = HotelService::all();
        $flight = Flight::all();
        $visa = Visa::all();
        $carhire = Carhire::all();
        $assist = Assist::all();
        $insurance = Insurance::all();
        $insuranceplan = InsurancePlan::all();
        $other = Inventory::all();
        $taxmaster = Taxmaster::where('type', 'Sales')->get();
        $bed = RoomBed::all();
        $meal = RoomMeal::all();
        $supplier = Supplier::all();
        //dd($emp);

        if ($type=="hotel") {
            $services=DsrHotelService::where('id', $id)->first();
            $dsrno= $services->dsr_number;
            $passengers = Passengers::where('dsr_number', $dsrno)->get();
            
            $guest = DsrServicePassenger::where('dsr_service_id', $id)->get();
            // $passengers = DsrServicePassenger::where('dsr_service_id', $id)->pluck('passengers')->toArray();

            return view('dsr.edithotel', compact('services', 'guest', 'supplier', 'corporate','tour','bed','meal','room','taxmaster','individual','passengers','hotels', 'flight', 'visa','carhire', 'assist', 'insurance', 'insuranceplan', 'other'));
        }
        elseif($type=="flight"){
            $services=DsrFlightService::where('id', $id)->first();
            $dsrno= $services->dsr_number;
            $passengers = Passengers::where('dsr_number', $dsrno)->get();
            
            $guest = DsrServicePassenger::where('dsr_service_id', $id)->get();
            
            return view('dsr.editflight', compact('services', 'corporate', 'guest', 'supplier', 'tour','bed','meal','room','taxmaster','individual','passengers','hotels', 'flight', 'visa','carhire', 'assist', 'insurance', 'insuranceplan', 'other'));

        }
        elseif($type=="visa"){
            $services=DsrVisaService::where('id', $id)->first();
            $dsrno= $services->dsr_number;
            $passengers = Passengers::where('dsr_number', $dsrno)->get();


            return view('dsr.editvisa', compact('services', 'corporate', 'supplier', 'tour','bed','meal','room','taxmaster','individual','passengers','hotels', 'flight', 'visa','carhire', 'assist', 'insurance', 'insuranceplan', 'other'));

        }
        elseif($type=="insurance"){
            $services=DsrInsuranceService::where('id', $id)->first();
            $dsrno= $services->dsr_number;
            $passengers = Passengers::where('dsr_number', $dsrno)->get();

            return view('dsr.editinsurance', compact('services', 'corporate', 'supplier', 'tour','bed','meal','room','taxmaster','individual','passengers','hotels', 'flight', 'visa','carhire', 'assist', 'insurance', 'insuranceplan', 'other'));

        }
        elseif($type=="carhire"){
            $services=DsrCarhireService::where('id', $id)->first();
            $dsrno= $services->dsr_number;
            $passengers = Passengers::where('dsr_number', $dsrno)->get();

            return view('dsr.editcarhire', compact('services', 'corporate', 'supplier', 'tour','bed','meal','room','taxmaster','individual','passengers','hotels', 'flight', 'visa','carhire', 'assist', 'insurance', 'insuranceplan', 'other'));

        }
        elseif($type=="assist"){
            $services=DsrAssistService::where('id', $id)->first();
            $dsrno= $services->dsr_number;
            $passengers = Passengers::where('dsr_number', $dsrno)->get();

            return view('dsr.editassist', compact('services','corporate', 'supplier','tour','bed','meal','room','taxmaster','individual','passengers','hotels', 'flight', 'visa','carhire', 'assist', 'insurance', 'insuranceplan', 'other'));

        }
        elseif($type=="other"){
            $services=DsrOtherService::where('id', $id)->first();
            $dsrno= $services->dsr_number;
            $passengers = Passengers::where('dsr_number', $dsrno)->get();

            return view('dsr.editother', compact('services', 'corporate', 'supplier','tour','bed','meal','room','taxmaster','individual','passengers','hotels', 'flight', 'visa','carhire', 'assist', 'insurance', 'insuranceplan', 'other'));

        }


    }
    public function addHotelService(Request $request)
    {
        
        $HotelService = new DsrHotelService;

        if ($request->file('hotel_details')) {
            $photo = $request->file('hotel_details');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $HotelService->hotel_details = $filename;
        }

        $HotelService->user_id = $request->input("user_id");
        $HotelService->dsr_number = $request->input("dsr_number");
        $HotelService->entry_type = $request->input("entry_type");
        $HotelService->hotel_name = $request->input("hotel_name");
        $HotelService->room_name_number = $request->input("room_name_number");
        $HotelService->occupancy = $request->input("occupancy");
        $HotelService->meal = $request->input("meal");
        $HotelService->bed = $request->input("bed");
        $HotelService->booking_date = $request->input("booking_date");
        $HotelService->start_date = $request->input("start_date");
        $HotelService->end_date = $request->input("end_date");
        $HotelService->total_days = $request->input("total_days");
        $HotelService->confirmation_no = $request->input("confirmation_no");
        $HotelService->total_night = $request->input("total_night");
        $HotelService->supplier = $request->input("supplier");
        $HotelService->supplier_service_charge = $request->input("supplier_service_charge");
        $HotelService->hotel_price = $request->input("hotel_price");
        $HotelService->tax_amount = $request->input("tax_amount");
        $HotelService->other_tax = $request->input("other_tax");
        $HotelService->retain = $request->input("retain");
        $HotelService->total_amount = $request->input("total_amount");
        $HotelService->remark = $request->input("remark");
        $HotelService->save();

        $user_id = $request->input("user_id");
        $user_id= $HotelService->id;

        $values = $request->input('guest');
        if($values){
            
        foreach ($values as $value) {
            $model = new DsrServicePassenger();
            $model->dsr_service_id = $user_id;
            $model->dsr_service_type = "Hotel";
            $model->passengers = $value;
            $model->save();
          }
        }
        
     $supplier=  $request->input("supplier");
    
     if($supplier!==0){
        

        do {
           
            $transaction_id=rand(100000,999999);

            $records=DB::table('supplier_transaction')
                   ->where('transaction_id',$transaction_id)
                   ->exists();     
                   
            // $user_id=rand(100000,999999);
            // $records= Passengers::where('user_id', $user_id)->get();
           
         } while ($records ==1);

        $SupplierTransaction = new SupplierTransaction;
        $SupplierTransaction->transaction_id =  $transaction_id;
        $SupplierTransaction->supplier_id = $request->input("supplier");
        $SupplierTransaction->service_type =  'Hotel';
        $SupplierTransaction->service_id =  $HotelService->id;
        $SupplierTransaction->date = Carbon::now();
        $SupplierTransaction->save();
       
        $maxDsrNumber = Bills::max('bill_id');
        $lastDsrNumber = (int) substr($maxDsrNumber, -7);
        $newDsrNumber = $lastDsrNumber + 1;
        $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);

        // Build the final Dsr ID with the series
        $series = 'Bill';
        $dsr_number = $series . '-' . $paddedDsrNumber;

        $Bills = new Bills;
        $Bills->supplier_id = $request->input("supplier");
        $Bills->bill_id = $dsr_number;
        $Bills->date = Carbon::now();
        $Bills->total = $request->input("supplier_service_charge");
        $Bills->save();
        
      }

        session()->flash('success', 'You\'ve Added Services successfully.');
        return Redirect::back();
       

        
    }

    public function editHotelService(Request $request)
    {
        $id = $request->input('hotel_id');
        $HotelService = DsrHotelService::find($id);

        if ($request->file('hotel_details')) {
            $photo = $request->file('hotel_details');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $HotelService->hotel_details = $filename;
        }

        $HotelService->hotel_name = $request->input("hotel_name");
        $HotelService->room_name_number = $request->input("room_name_number");
        $HotelService->occupancy = $request->input("occupancy");
        $HotelService->meal = $request->input("meal");
        $HotelService->bed = $request->input("bed");
        $HotelService->booking_date = $request->input("booking_date");
        $HotelService->start_date = $request->input("start_date");
        $HotelService->end_date = $request->input("end_date");
        $HotelService->total_days = $request->input("total_days");
        $HotelService->confirmation_no = $request->input("confirmation_no");
        $HotelService->total_night = $request->input("total_night");
        $HotelService->supplier = $request->input("supplier");
        $HotelService->supplier_service_charge = $request->input("supplier_service_charge");
        $HotelService->hotel_price = $request->input("hotel_price");
        $HotelService->tax_amount = $request->input("tax_amount");
        $HotelService->other_tax = $request->input("other_tax");
        $HotelService->retain = $request->input("retain");
        $HotelService->total_amount = $request->input("total_amount");
        $HotelService->remark = $request->input("remark");
        $HotelService->save();

        $user_id = $request->input("user_id");
        $user_id= $HotelService->id;

        DsrServicePassenger::where('dsr_service_id', $id)->where('dsr_service_type', 'Hotel')->delete();

        $values = $request->input('guest');
        if($values){
            
        foreach ($values as $value) {
            $model = new DsrServicePassenger();
            $model->dsr_service_id = $user_id;
            $model->dsr_service_type = "Hotel";
            $model->passengers = $value;
            $model->save();
          }
        }
        
        session()->flash('success', 'You\'ve Updated Services successfully.');
        return Redirect::back();
    }

    public function addTourService(Request $request)
    {
        
        $TourService = new DsrTourService;

        if ($request->file('tour_details')) {
            $photo = $request->file('tour_details');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $TourService->tour_details = $filename;
        }

        $TourService->user_id = $request->input("user_id");
        $TourService->dsr_number = $request->input("dsr_number");
        $TourService->entry_type = $request->input("entry_type");
        $TourService->hotel_name = $request->input("hotel_name");
        $TourService->room_name_number = $request->input("room_name_number");
        $TourService->occupancy = $request->input("occupancy");
        $TourService->meal = $request->input("meal");
        $TourService->bed = $request->input("bed");
        $TourService->booking_date = $request->input("booking_date");
        $TourService->start_date = $request->input("start_date");
        $TourService->end_date = $request->input("end_date");
        $TourService->total_days = $request->input("total_days");
        $TourService->total_night = $request->input("total_night");
        $TourService->supplier = $request->input("supplier");
        $TourService->supplier_service_charge = $request->input("supplier_service_charge");
        $TourService->hotel_price = $request->input("hotel_price");
        $TourService->tax_amount = $request->input("tax_amount");
        $TourService->retain = $request->input("retain");
        $TourService->total_amount = $request->input("total_amount");
        $TourService->remark = $request->input("remark");
        $TourService->save();

        $user_id = $request->input("user_id");
        $user_id= $TourService->id;
        $values = $request->input('guest');
        if($values){
            
        foreach ($values as $value) {
            $model = new DsrServicePassenger();
            $model->dsr_service_id = $user_id;
            $model->dsr_service_type = "Tour";
            $model->passengers = $value;
            $model->save();
          }
        }

        do {
           
            $transaction_id=rand(100000,999999);

            $records=DB::table('supplier_transaction')
                   ->where('transaction_id',$transaction_id)
                   ->exists();     
                   
            // $user_id=rand(100000,999999);
            // $records= Passengers::where('user_id', $user_id)->get();
           
         } while ($records ==1);

        $SupplierTransaction = new SupplierTransaction;
        $SupplierTransaction->transaction_id =  $transaction_id;
        $SupplierTransaction->supplier_id = $request->input("supplier");
        $SupplierTransaction->service_type =  'Tour';
        $SupplierTransaction->service_id =  $HotelService->id;
        $SupplierTransaction->date = Carbon::now();
        $SupplierTransaction->save();
       
        $maxDsrNumber = Bills::max('bill_id');
        $lastDsrNumber = (int) substr($maxDsrNumber, -7);
        $newDsrNumber = $lastDsrNumber + 1;
        $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);

        // Build the final Dsr ID with the series
        $series = 'Bill';
        $dsr_number = $series . '-' . $paddedDsrNumber;

        $Bills = new Bills;
        $Bills->supplier_id = $request->input("supplier");
        $Bills->bill_id = $dsr_number;
        $Bills->date = Carbon::now();
        $Bills->total = $request->input("supplier_service_charge");
        $Bills->save();
        
        session()->flash('success', 'You\'ve Added Services successfully.');
        return Redirect::back();
    }

    public function editTourService(Request $request)
    {
        
        $id = $request->file('tour_id');
        $TourService = new DsrTourService;

        if ($request->file('tour_details')) {
            $photo = $request->file('tour_details');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $TourService->tour_details = $filename;
        }

        $TourService->user_id = $request->input("user_id");
        $TourService->dsr_number = $request->input("dsr_number");
        $TourService->hotel_name = $request->input("hotel_name");
        $TourService->room_name_number = $request->input("room_name_number");
        $TourService->occupancy = $request->input("occupancy");
        $TourService->meal = $request->input("meal");
        $TourService->bed = $request->input("bed");
        $TourService->booking_date = $request->input("booking_date");
        $TourService->start_date = $request->input("start_date");
        $TourService->end_date = $request->input("end_date");
        $TourService->total_days = $request->input("total_days");
        $TourService->total_night = $request->input("total_night");
        $TourService->supplier = $request->input("supplier");
        $TourService->supplier_service_charge = $request->input("supplier_service_charge");
        $TourService->hotel_price = $request->input("hotel_price");
        $TourService->tax_amount = $request->input("tax_amount");
        $TourService->retain = $request->input("retain");
        $TourService->total_amount = $request->input("total_amount");
        $TourService->remark = $request->input("remark");
        $TourService->save();

        $user_id = $request->input("user_id");
        $user_id= $TourService->id;
        $values = $request->input('guest');
        if($values){
            
        foreach ($values as $value) {
            $model = new DsrServicePassenger();
            $model->dsr_service_id = $user_id;
            $model->dsr_service_type = "Tour";
            $model->passengers = $value;
            $model->save();
          }
        }
        
        session()->flash('success', 'You\'ve Added Services successfully.');
        return Redirect::back();
    }

    public function addFlightService(Request $request)
    {
        // $trip_code = $request->input("trip_code");
        // if($trip_code==''){
        //     do {
           
        //     $trip_code=rand(100000,999999);

        //     $records=DB::table('dsr_flight_service')
        //           ->where('trip_code',$trip_code)
        //           ->exists();     
                   
        //     // $user_id=rand(100000,999999);
        //     // $records= Passengers::where('user_id', $user_id)->get();
           
        //  } while ($records ==1);
        // }
        
          do {
           
            $trip_code=rand(100000,999999);

            $records=DB::table('dsr_flight_service')
                   ->where('trip_code',$trip_code)
                   ->exists();     
                   
            // $user_id=rand(100000,999999);
            // $records= Passengers::where('user_id', $user_id)->get();
           
         } while ($records ==1);

        $trip_type = $request->input("trip_type");
        
        if($trip_type=="One Way"){
            
            $FlightService = new DsrFlightService;
        $FlightService->user_id = $request->input("user_id");
        $FlightService->dsr_number = $request->input("dsr_number");
        $FlightService->entry_type = $request->input("entry_type");
        $FlightService->airline_name = $request->input("airline_name");
        $FlightService->travel_type = $request->input("travel_type");
        $FlightService->trip_code = $trip_code;
        $FlightService->trip_type = $request->input("trip_type");
        $FlightService->gds_portal = $request->input("gds_portal");
        $FlightService->ticket_number = $request->input("ticket_number");
        $FlightService->pnr_number = $request->input("pnr_number");
        $FlightService->travel_date = $request->input("travel_date");
        $FlightService->from_route = $request->input("from_route");
        $FlightService->to_route = $request->input("to_route");
        $FlightService->supplier = $request->input("supplier");
        $FlightService->supplier_service_charge = $request->input("supplier_service_charge");
        $FlightService->fare_price = $request->input("fare_price");
        $FlightService->ipp = $request->input("ipp");
        $FlightService->tax_amount = $request->input("tax_amount");
        $FlightService->other_tax = $request->input("other_tax");
        $FlightService->retain = $request->input("retain");
        $FlightService->supplier_total = $request->input("supplier_total");
        $FlightService->total_amount = $request->input("total_amount");
        if ($request->file('flight_details')) {
            $photo = $request->file('flight_details');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $FlightService->flight_details = $filename;
        }
        $FlightService->remark = $request->input("remark");
        $FlightService->save();

        $user_id = $request->input("user_id");
        $user_id= $FlightService->id;
        $values = $request->input('passenger_name');
        if($values){
            
        foreach ($values as $value) {
            $model = new DsrServicePassenger();
            $model->dsr_service_id = $user_id;
            $model->dsr_service_type = "Flight";
            $model->passengers = $value;
            $model->save();
          }
        }
            
        }
        else if($trip_type=="Round Trip"){
            
            $FlightService = new DsrFlightService;
        $FlightService->user_id = $request->input("user_id");
        $FlightService->dsr_number = $request->input("dsr_number");
        $FlightService->entry_type = $request->input("entry_type");
        $FlightService->airline_name = $request->input("airline_name");
        $FlightService->travel_type = "Travel";
        $FlightService->trip_code = $trip_code;
        $FlightService->trip_type = $request->input("trip_type");
        $FlightService->gds_portal = $request->input("gds_portal");
        $FlightService->ticket_number = $request->input("ticket_number");
        $FlightService->pnr_number = $request->input("pnr_number");
        $FlightService->travel_date = $request->input("travel_date");
        $FlightService->from_route = $request->input("from_route");
        $FlightService->to_route = $request->input("to_route");
        $FlightService->supplier = $request->input("supplier");
        $FlightService->supplier_service_charge = $request->input("supplier_service_charge");
        $FlightService->fare_price = $request->input("fare_price");
        $FlightService->ipp = $request->input("ipp");
        $FlightService->tax_amount = $request->input("tax_amount");
        $FlightService->other_tax = $request->input("other_tax");
        $FlightService->retain = $request->input("retain");
        $FlightService->supplier_total = $request->input("supplier_total");
        $FlightService->total_amount = $request->input("total_amount");
        if ($request->file('flight_details')) {
            $photo = $request->file('flight_details');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $FlightService->flight_details = $filename;
        }
        $FlightService->remark = $request->input("remark");
        $FlightService->save();

        $user_id = $request->input("user_id");
        $user_id= $FlightService->id;
        $values = $request->input('passenger_name');
        if($values){
            
        foreach ($values as $value) {
            $model = new DsrServicePassenger();
            $model->dsr_service_id = $user_id;
            $model->dsr_service_type = "Flight";
            $model->passengers = $value;
            $model->save();
          }
        }
        
        $FlightService = new DsrFlightService;
        $FlightService->user_id = $request->input("user_id");
        $FlightService->dsr_number = $request->input("dsr_number");
        $FlightService->entry_type = $request->input("entry_type");
        $FlightService->airline_name = $request->input("airline_name");
        $FlightService->travel_type = "Return";
        $FlightService->trip_code = $trip_code;
        $FlightService->trip_type = $request->input("trip_type");
        $FlightService->gds_portal = $request->input("gds_portal");
        $FlightService->ticket_number = $request->input("ticket_number");
        $FlightService->pnr_number = $request->input("pnr_number");
        $FlightService->travel_date = $request->input("return_date");
        $FlightService->from_route = $request->input("from_route1");
        $FlightService->to_route = $request->input("to_route1");
        $FlightService->supplier = $request->input("supplier");
        $FlightService->supplier_service_charge = $request->input("supplier_service_charge");
        $FlightService->fare_price = $request->input("fare_price");
        $FlightService->ipp = $request->input("ipp");
        $FlightService->tax_amount = $request->input("tax_amount");
        $FlightService->other_tax = $request->input("other_tax");
        $FlightService->retain = $request->input("retain");
        $FlightService->supplier_total = $request->input("supplier_total");
        $FlightService->total_amount = $request->input("total_amount");
        if ($request->file('flight_details')) {
            $photo = $request->file('flight_details');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $FlightService->flight_details = $filename;
        }
        $FlightService->remark = $request->input("remark");
        $FlightService->save();

        $user_id = $request->input("user_id");
        $user_id= $FlightService->id;
        $values = $request->input('passenger_name');
        if($values){
            
        foreach ($values as $value) {
            $model = new DsrServicePassenger();
            $model->dsr_service_id = $user_id;
            $model->dsr_service_type = "Flight";
            $model->passengers = $value;
            $model->save();
          }
        }
            
        }
        else if($trip_type=="Multi City"){
          
          $travelDates = $request->input('travel_date');
$fromRoutes = $request->input('from_route');
$toRoutes = $request->input('to_route');

$numberOfTrips = count($travelDates);

for ($i = 0; $i < $numberOfTrips; $i++) {

        $FlightService = new DsrFlightService;
        $FlightService->user_id = $request->input("user_id");
        $FlightService->dsr_number = $request->input("dsr_number");
        $FlightService->entry_type = $request->input("entry_type");
        $FlightService->airline_name = $request->input("airline_name");
        $FlightService->travel_type = "Travel";
        $FlightService->trip_code = $trip_code;
        $FlightService->trip_type = $request->input("trip_type");
        $FlightService->gds_portal = $request->input("gds_portal");
        $FlightService->ticket_number = $request->input("ticket_number");
        $FlightService->pnr_number = $request->input("pnr_number");
        $FlightService->travel_date = $travelDates[$i]; // Use the travel_date for this trip
        $FlightService->from_route = $fromRoutes[$i];   // Use the from_route for this trip
        $FlightService->to_route = $toRoutes[$i]; 
        $FlightService->supplier = $request->input("supplier");
        $FlightService->supplier_service_charge = $request->input("supplier_service_charge");
        $FlightService->fare_price = $request->input("fare_price");
        $FlightService->ipp = $request->input("ipp");
        $FlightService->tax_amount = $request->input("tax_amount");
        $FlightService->other_tax = $request->input("other_tax");
        $FlightService->retain = $request->input("retain");
        $FlightService->supplier_total = $request->input("supplier_total");
        $FlightService->total_amount = $request->input("total_amount");
        if ($request->file('flight_details')) {
            $photo = $request->file('flight_details');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $FlightService->flight_details = $filename;
        }
        $FlightService->remark = $request->input("remark");
        $FlightService->save();

        $user_id = $request->input("user_id");
        $user_id= $FlightService->id;
        $values = $request->input('passenger_name');
        if($values){
            
        foreach ($values as $value) {
            $model = new DsrServicePassenger();
            $model->dsr_service_id = $user_id;
            $model->dsr_service_type = "Flight";
            $model->passengers = $value;
            $model->save();
          }
        }
                
            }
            
        }
        
        
        
    $supplier=  $request->input("supplier");
    
     if($supplier!==0){

        do {
           
            $transaction_id=rand(100000,999999);

            $records=DB::table('supplier_transaction')
                   ->where('transaction_id',$transaction_id)
                   ->exists();     
                   
            // $user_id=rand(100000,999999);
            // $records= Passengers::where('user_id', $user_id)->get();
           
         } while ($records ==1);

        $SupplierTransaction = new SupplierTransaction;
        $SupplierTransaction->transaction_id =  $transaction_id;
        $SupplierTransaction->supplier_id = $request->input("supplier");
        $SupplierTransaction->service_type =  'Flight';
        $SupplierTransaction->service_id =  $FlightService->id;
        $SupplierTransaction->date = Carbon::now();
        $SupplierTransaction->save();
       
        $maxDsrNumber = Bills::max('bill_id');
        $lastDsrNumber = (int) substr($maxDsrNumber, -7);
        $newDsrNumber = $lastDsrNumber + 1;
        $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);

        // Build the final Dsr ID with the series
        $series = 'Bill';
        $dsr_number = $series . '-' . $paddedDsrNumber;

        $Bills = new Bills;
        $Bills->supplier_id = $request->input("supplier");
        $Bills->bill_id = $dsr_number;
        $Bills->date = Carbon::now();
        $Bills->total = $request->input("supplier_service_charge");
        $Bills->save();
        
        
    }


        session()->flash('success', 'You\'ve Added Services successfully.');
        return Redirect::back();
    }

    public function editFlightService(Request $request)
    {
        
        $id = $request->input('flight_id');
        $FlightService = DsrFlightService::find($id);
        $FlightService->airline_name = $request->input("airline_name");
        $FlightService->trip_type = $request->input("trip_type");
        $FlightService->gds_portal = $request->input("gds_portal");
        $FlightService->ticket_number = $request->input("ticket_number");
        $FlightService->pnr_number = $request->input("pnr_number");
        $FlightService->travel_date = $request->input("travel_date");
        $FlightService->route = $request->input("route");
        $FlightService->supplier = $request->input("supplier");
        $FlightService->supplier_service_charge = $request->input("supplier_service_charge");
        $FlightService->fare_price = $request->input("fare_price");
        $FlightService->ipp = $request->input("ipp");
        $FlightService->tax_amount = $request->input("tax_amount");
        $FlightService->other_tax = $request->input("other_tax");
        $FlightService->retain = $request->input("retain");
        $FlightService->supplier_total = $request->input("supplier_total");
        $FlightService->total_amount = $request->input("total_amount");
        if ($request->file('flight_details')) {
            $photo = $request->file('flight_details');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $FlightService->flight_details = $filename;
        }
        $FlightService->remark = $request->input("remark");
        $FlightService->save();

        $user_id = $request->input("user_id");
        $user_id= $FlightService->id;

        DsrServicePassenger::where('dsr_service_id', $id)->where('dsr_service_type', 'Flight')->delete();

        $values = $request->input('passenger_name');
        if($values){
            
        foreach ($values as $value) {
            $model = new DsrServicePassenger();
            $model->dsr_service_id = $user_id;
            $model->dsr_service_type = "Flight";
            $model->passengers = $value;
            $model->save();
          }
        }


        session()->flash('success', 'You\'ve Updated Services successfully.');
        return Redirect::back();
    }

    public function addVisaService(Request $request)
    {
        
        $VisaService = new DsrVisaService;
        $VisaService->user_id = $request->input("user_id");
        $VisaService->dsr_number = $request->input("dsr_number");
        $VisaService->entry_type = $request->input("entry_type");
        $VisaService->passenger_name = $request->input("passenger_name");
        $VisaService->passport_number = $request->input("passport_number");
        $VisaService->dob = $request->input("dob");
        $VisaService->email = $request->input("email");
        $VisaService->visa_number = $request->input("visa_number");
        $VisaService->visa_type = $request->input("visa_type");
        $VisaService->visa_entry_type = $request->input("visa_entry_type");
        $VisaService->country = $request->input("country");
        $VisaService->days = $request->input("days");
        $VisaService->issue_date = $request->input("issue_date");
        $VisaService->expiry_date = $request->input("expiry_date");
        $VisaService->supplier = $request->input("supplier");
        $VisaService->supplier_service_charge = $request->input("supplier_service_charge");
        $VisaService->visa_price = $request->input("visa_price");
        $VisaService->tax_amount = $request->input("tax_amount");
        $VisaService->other_tax = $request->input("other_tax");
        $VisaService->retain = $request->input("retain");
        $VisaService->total_amount = $request->input("total_amount");
        if ($request->file('visa_details')) {
            $photo = $request->file('visa_details');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $VisaService->visa_details = $filename;
        }
        $VisaService->remark = $request->input("remark");
        $VisaService->save();
        
    $supplier=  $request->input("supplier");
    
     if($supplier!==0){

        do {
           
            $transaction_id=rand(100000,999999);

            $records=DB::table('supplier_transaction')
                   ->where('transaction_id',$transaction_id)
                   ->exists();     
                   
            // $user_id=rand(100000,999999);
            // $records= Passengers::where('user_id', $user_id)->get();
           
         } while ($records ==1);

        $SupplierTransaction = new SupplierTransaction;
        $SupplierTransaction->transaction_id =  $transaction_id;
        $SupplierTransaction->supplier_id = $request->input("supplier");
        $SupplierTransaction->service_type =  'Visa';
        $SupplierTransaction->service_id =  $VisaService->id;
        $SupplierTransaction->date = Carbon::now();
        $SupplierTransaction->save();
       
        $maxDsrNumber = Bills::max('bill_id');
        $lastDsrNumber = (int) substr($maxDsrNumber, -7);
        $newDsrNumber = $lastDsrNumber + 1;
        $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);

        // Build the final Dsr ID with the series
        $series = 'Bill';
        $dsr_number = $series . '-' . $paddedDsrNumber;

        $Bills = new Bills;
        $Bills->supplier_id = $request->input("supplier");
        $Bills->bill_id = $dsr_number;
        $Bills->date = Carbon::now();
        $Bills->total = $request->input("supplier_service_charge");
        $Bills->save();
        
        
    }
        
        session()->flash('success', 'You\'ve Added Services successfully.');
        return Redirect::back();
    }

    public function editVisaService(Request $request)
    {
        
        $id = $request->input('visa_id');
        $VisaService = DsrVisaService::find($id);
        $VisaService->passenger_name = $request->input("passenger_name");
        $VisaService->passport_number = $request->input("passport_number");
        $VisaService->dob = $request->input("dob");
        $VisaService->email = $request->input("email");
        $VisaService->visa_number = $request->input("visa_number");
        $VisaService->visa_type = $request->input("visa_type");
        $VisaService->visa_entry_type = $request->input("visa_entry_type");
        $VisaService->country = $request->input("country");
        $VisaService->days = $request->input("days");
        $VisaService->issue_date = $request->input("issue_date");
        $VisaService->expiry_date = $request->input("expiry_date");
        $VisaService->supplier = $request->input("supplier");
        $VisaService->supplier_service_charge = $request->input("supplier_service_charge");
        $VisaService->visa_price = $request->input("visa_price");
        $VisaService->tax_amount = $request->input("tax_amount");
        $VisaService->other_tax = $request->input("other_tax");
        $VisaService->retain = $request->input("retain");
        $VisaService->total_amount = $request->input("total_amount");
        if ($request->file('visa_details')) {
            $photo = $request->file('visa_details');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $VisaService->visa_details = $filename;
        }
        $VisaService->remark = $request->input("remark");
        $VisaService->save();
        
        session()->flash('success', 'You\'ve Updated Services successfully.');
        return Redirect::back();
    }

    public function addInsuranceService(Request $request)
    {
        
        $InsuranceService = new DsrInsuranceService;
        $InsuranceService->user_id = $request->input("user_id");
        $InsuranceService->dsr_number = $request->input("dsr_number");
        $InsuranceService->entry_type = $request->input("entry_type");
        $InsuranceService->passenger_name = $request->input("passenger_name");
        $InsuranceService->company_name = $request->input("company_name");
        $InsuranceService->insurance_plan = $request->input("insurance_plan");
        $InsuranceService->policy_number = $request->input("policy_number");
        $InsuranceService->issue_date = $request->input("issue_date");
        $InsuranceService->expiry_date = $request->input("expiry_date");
        $InsuranceService->supplier = $request->input("supplier");
        $InsuranceService->supplier_service_charge = $request->input("supplier_service_charge");
        $InsuranceService->insurance_price = $request->input("insurance_price");
        $InsuranceService->tax_amount = $request->input("tax_amount");
        $InsuranceService->other_tax = $request->input("other_tax");
        $InsuranceService->retain = $request->input("retain");
        $InsuranceService->total_amount = $request->input("total_amount");
        if ($request->file('insurance_details')) {
            $photo = $request->file('insurance_details');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $InsuranceService->insurance_details = $filename;
        }
        $InsuranceService->remark = $request->input("remark");
        $InsuranceService->save();
        
    $supplier=  $request->input("supplier");
    
     if($supplier!==0){

        do {
           
            $transaction_id=rand(100000,999999);

            $records=DB::table('supplier_transaction')
                   ->where('transaction_id',$transaction_id)
                   ->exists();     
                   
            // $user_id=rand(100000,999999);
            // $records= Passengers::where('user_id', $user_id)->get();
           
         } while ($records ==1);

        $SupplierTransaction = new SupplierTransaction;
        $SupplierTransaction->transaction_id =  $transaction_id;
        $SupplierTransaction->supplier_id = $request->input("supplier");
        $SupplierTransaction->service_type =  'Insurance';
        $SupplierTransaction->service_id =  $InsuranceService->id;
        $SupplierTransaction->date = Carbon::now();
        $SupplierTransaction->save();
       
        $maxDsrNumber = Bills::max('bill_id');
        $lastDsrNumber = (int) substr($maxDsrNumber, -7);
        $newDsrNumber = $lastDsrNumber + 1;
        $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);

        // Build the final Dsr ID with the series
        $series = 'Bill';
        $dsr_number = $series . '-' . $paddedDsrNumber;

        $Bills = new Bills;
        $Bills->supplier_id = $request->input("supplier");
        $Bills->bill_id = $dsr_number;
        $Bills->date = Carbon::now();
        $Bills->total = $request->input("supplier_service_charge");
        $Bills->save();
        
            
    }

        session()->flash('success', 'You\'ve Added Services successfully.');
        return Redirect::back();
    }

    public function editInsuranceService(Request $request)
    {
        
        $id = $request->input('insurance_id');
        $InsuranceService = DsrInsuranceService::find($id);
        $InsuranceService->passenger_name = $request->input("passenger_name");
        $InsuranceService->company_name = $request->input("company_name");
        $InsuranceService->insurance_plan = $request->input("insurance_plan");
        $InsuranceService->policy_number = $request->input("policy_number");
        $InsuranceService->issue_date = $request->input("issue_date");
        $InsuranceService->expiry_date = $request->input("expiry_date");
        $InsuranceService->supplier = $request->input("supplier");
        $InsuranceService->supplier_service_charge = $request->input("supplier_service_charge");
        $InsuranceService->insurance_price = $request->input("insurance_price");
        $InsuranceService->tax_amount = $request->input("tax_amount");
        $InsuranceService->other_tax = $request->input("other_tax");
        $InsuranceService->retain = $request->input("retain");
        $InsuranceService->total_amount = $request->input("total_amount");
        if ($request->file('insurance_details')) {
            $photo = $request->file('insurance_details');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $InsuranceService->insurance_details = $filename;
        }
        $InsuranceService->remark = $request->input("remark");
        $InsuranceService->save();

        session()->flash('success', 'You\'ve Updated Services successfully.');
        return Redirect::back();
    }
    
    public function addCarhireService(Request $request)
    {
        
        $OtherService = new DsrCarhireService;
        $OtherService->user_id = $request->input("user_id");
        $OtherService->dsr_number = $request->input("dsr_number");
        $OtherService->entry_type = $request->input("entry_type");
        $OtherService->vehicle_type = $request->input("vehicle_type");
        $OtherService->days = $request->input("days");
        $OtherService->pickup_location = $request->input("pickup_location");
        $OtherService->drop_location = $request->input("drop_location");
        $OtherService->price = $request->input("price");
        $OtherService->amount = $request->input("amount");
        $OtherService->supplier = $request->input("supplier");
        $OtherService->supplier_service_charge = $request->input("supplier_service_charge");
        $OtherService->tax_amount = $request->input("tax_amount");
        $OtherService->other_tax = $request->input("other_tax");
        $OtherService->retain = $request->input("retain");
        $OtherService->total_amount = $request->input("total_amount");
        if ($request->file('carhire_details')) {
            $photo = $request->file('carhire_details');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $OtherService->carhire_details = $filename;
        }        
        $OtherService->remark = $request->input("remark");
        $OtherService->save();
        
    $supplier=  $request->input("supplier");
    
     if($supplier!==0){

        do {
           
            $transaction_id=rand(100000,999999);

            $records=DB::table('supplier_transaction')
                   ->where('transaction_id',$transaction_id)
                   ->exists();     
                   
            // $user_id=rand(100000,999999);
            // $records= Passengers::where('user_id', $user_id)->get();
           
         } while ($records ==1);

        $SupplierTransaction = new SupplierTransaction;
        $SupplierTransaction->transaction_id =  $transaction_id;
        $SupplierTransaction->supplier_id = $request->input("supplier");
        $SupplierTransaction->service_type =  'Carhire';
        $SupplierTransaction->service_id =  $OtherService->id;
        $SupplierTransaction->date = Carbon::now();
        $SupplierTransaction->save();
       
        $maxDsrNumber = Bills::max('bill_id');
        $lastDsrNumber = (int) substr($maxDsrNumber, -7);
        $newDsrNumber = $lastDsrNumber + 1;
        $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);

        // Build the final Dsr ID with the series
        $series = 'Bill';
        $dsr_number = $series . '-' . $paddedDsrNumber;

        $Bills = new Bills;
        $Bills->supplier_id = $request->input("supplier");
        $Bills->bill_id = $dsr_number;
        $Bills->date = Carbon::now();
        $Bills->total = $request->input("supplier_service_charge");
        $Bills->save();
        
            
    }
        
        session()->flash('success', 'You\'ve Added Services successfully.');
        return Redirect::back();
    }

    public function editCarhireService(Request $request)
    {
        
        $id = $request->input('carhire_id');
        $OtherService = DsrCarhireService::find($id);
        $OtherService->vehicle_type = $request->input("vehicle_type");
        $OtherService->days = $request->input("days");
        $OtherService->pickup_location = $request->input("pickup_location");
        $OtherService->drop_location = $request->input("drop_location");
        $OtherService->price = $request->input("price");
        $OtherService->amount = $request->input("amount");
        $OtherService->supplier = $request->input("supplier");
        $OtherService->supplier_service_charge = $request->input("supplier_service_charge");
        $OtherService->tax_amount = $request->input("tax_amount");
        $OtherService->other_tax = $request->input("other_tax");
        $OtherService->retain = $request->input("retain");
        $OtherService->total_amount = $request->input("total_amount");
        if ($request->file('carhire_details')) {
            $photo = $request->file('carhire_details');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $OtherService->carhire_details = $filename;
        }        
        $OtherService->remark = $request->input("remark");
        $OtherService->save();
        
        session()->flash('success', 'You\'ve Updated Services successfully.');
        return Redirect::back();
    }
    
    public function addAssistService(Request $request)
    {
        
        $OtherService = new DsrAssistService;
        $OtherService->user_id = $request->input("user_id");
        $OtherService->dsr_number = $request->input("dsr_number");
        $OtherService->entry_type = $request->input("entry_type");
        $OtherService->airport = $request->input("airport");
        $OtherService->meeting_type = $request->input("meeting_type");
        $OtherService->person_count = $request->input("person_count");
        $OtherService->price = $request->input("price");
        $OtherService->amount = $request->input("amount");
        $OtherService->supplier = $request->input("supplier");
        $OtherService->supplier_service_charge = $request->input("supplier_service_charge");
        $OtherService->tax_amount = $request->input("tax_amount");
        $OtherService->other_tax = $request->input("other_tax");
        $OtherService->retain = $request->input("retain");
        $OtherService->total_amount = $request->input("total_amount");
        if ($request->file('assist_details')) {
            $photo = $request->file('assist_details');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $OtherService->assist_details = $filename;
        }        
        $OtherService->remark = $request->input("remark");
        $OtherService->save();
        
    $supplier=  $request->input("supplier");
    
     if($supplier!==0){

        do {
           
            $transaction_id=rand(100000,999999);

            $records=DB::table('supplier_transaction')
                   ->where('transaction_id',$transaction_id)
                   ->exists();     
                   
            // $user_id=rand(100000,999999);
            // $records= Passengers::where('user_id', $user_id)->get();
           
         } while ($records ==1);

        $SupplierTransaction = new SupplierTransaction;
        $SupplierTransaction->transaction_id =  $transaction_id;
        $SupplierTransaction->supplier_id = $request->input("supplier");
        $SupplierTransaction->service_type =  'Assist';
        $SupplierTransaction->service_id =  $OtherService->id;
        $SupplierTransaction->date = Carbon::now();
        $SupplierTransaction->save();
       
        $maxDsrNumber = Bills::max('bill_id');
        $lastDsrNumber = (int) substr($maxDsrNumber, -7);
        $newDsrNumber = $lastDsrNumber + 1;
        $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);

        // Build the final Dsr ID with the series
        $series = 'Bill';
        $dsr_number = $series . '-' . $paddedDsrNumber;

        $Bills = new Bills;
        $Bills->supplier_id = $request->input("supplier");
        $Bills->bill_id = $dsr_number;
        $Bills->date = Carbon::now();
        $Bills->total = $request->input("supplier_service_charge");
        $Bills->save();
        
            
    }
        
        session()->flash('success', 'You\'ve Added Services successfully.');
        return Redirect::back();
    }

    public function editAssistService(Request $request)
    {
        
        $id = $request->input('assist_id');
        $OtherService = DsrAssistService::find($id);
        $OtherService->airport = $request->input("airport");
        $OtherService->meeting_type = $request->input("meeting_type");
        $OtherService->person_count = $request->input("person_count");
        $OtherService->price = $request->input("price");
        $OtherService->amount = $request->input("amount");
        $OtherService->supplier = $request->input("supplier");
        $OtherService->supplier_service_charge = $request->input("supplier_service_charge");
        $OtherService->tax_amount = $request->input("tax_amount");
        $OtherService->other_tax = $request->input("other_tax");
        $OtherService->retain = $request->input("retain");
        $OtherService->total_amount = $request->input("total_amount");
        if ($request->file('assist_details')) {
            $photo = $request->file('assist_details');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $OtherService->assist_details = $filename;
        }        
        $OtherService->remark = $request->input("remark");
        $OtherService->save();
        
        session()->flash('success', 'You\'ve Updated Services successfully.');
        return Redirect::back();
    }

    public function addOtherService(Request $request)
    {
        
        $OtherService = new DsrOtherService;
        $OtherService->user_id = $request->input("user_id");
        $OtherService->dsr_number = $request->input("dsr_number");
        $OtherService->entry_type = $request->input("entry_type");
        $OtherService->item_details = $request->input("item_details");
        $OtherService->quantity = $request->input("quantity");
        $OtherService->price = $request->input("price");
        $OtherService->amount = $request->input("amount");
        $OtherService->supplier = $request->input("supplier");
        $OtherService->supplier_service_charge = $request->input("supplier_service_charge");
        $OtherService->tax_amount = $request->input("tax_amount");
        $OtherService->other_tax = $request->input("other_tax");
        $OtherService->retain = $request->input("retain");
        $OtherService->total_amount = $request->input("total_amount");
        if ($request->file('other_details')) {
            $photo = $request->file('other_details');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $OtherService->other_details = $filename;
        }        
        $OtherService->remark = $request->input("remark");
        $OtherService->save();
        
    $supplier=  $request->input("supplier");
    
     if($supplier!==0){

        do {
           
            $transaction_id=rand(100000,999999);

            $records=DB::table('supplier_transaction')
                   ->where('transaction_id',$transaction_id)
                   ->exists();     
                   
            // $user_id=rand(100000,999999);
            // $records= Passengers::where('user_id', $user_id)->get();
           
         } while ($records ==1);

        $SupplierTransaction = new SupplierTransaction;
        $SupplierTransaction->transaction_id =  $transaction_id;
        $SupplierTransaction->supplier_id = $request->input("supplier");
        $SupplierTransaction->service_type =  'Other';
        $SupplierTransaction->service_id =  $OtherService->id;
        $SupplierTransaction->date = Carbon::now();
        $SupplierTransaction->save();
       
        $maxDsrNumber = Bills::max('bill_id');
        $lastDsrNumber = (int) substr($maxDsrNumber, -7);
        $newDsrNumber = $lastDsrNumber + 1;
        $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);

        // Build the final Dsr ID with the series
        $series = 'Bill';
        $dsr_number = $series . '-' . $paddedDsrNumber;

        $Bills = new Bills;
        $Bills->supplier_id = $request->input("supplier");
        $Bills->bill_id = $dsr_number;
        $Bills->date = Carbon::now();
        $Bills->total = $request->input("supplier_service_charge");
        $Bills->save();
        
            
    }
        
        session()->flash('success', 'You\'ve Added Services successfully.');
        return Redirect::back();
    }
    
    public function editOtherService(Request $request)
    {
        
        $id = $request->input('other_id');
        $OtherService = DsrOtherService::find($id);
        $OtherService->item_details = $request->input("item_details");
        $OtherService->quantity = $request->input("quantity");
        $OtherService->price = $request->input("price");
        $OtherService->amount = $request->input("amount");
        $OtherService->supplier = $request->input("supplier");
        $OtherService->supplier_service_charge = $request->input("supplier_service_charge");
        $OtherService->tax_amount = $request->input("tax_amount");
        $OtherService->other_tax = $request->input("other_tax");
        $OtherService->retain = $request->input("retain");
        $OtherService->total_amount = $request->input("total_amount");
        if ($request->file('other_details')) {
            $photo = $request->file('other_details');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $OtherService->other_details = $filename;
        }        
        $OtherService->remark = $request->input("remark");
        $OtherService->save();
        
        session()->flash('success', 'You\'ve Updated Services successfully.');
        return Redirect::back();
    }
    

    /**
     * Display the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        
    }


    public function Passenger($id)
    {

        $pass = DSR::find($id);
        $customer_type= $pass->customer_type;
        $customer_id= $pass->customer_id;

        if($customer_type=="Corporate"){

            $users = DSR::join('customers', 'dsr.customer_id', '=', 'customers.id')
            ->select('dsr.*', 'customers.company_name', 'customers.phone', 'customers.email')
            ->where('dsr.id', $id)
            ->first();
            
            $dsr_cus=  Customer::find($customer_id);

        }
        elseif($customer_type=="Individual") {

            $users = DSR::join('individual_customer', 'dsr.customer_id', '=', 'individual_customer.id')
            ->select('dsr.*', 'individual_customer.first_name', 'individual_customer.last_name', 'individual_customer.phone')
            ->where('dsr.id', $id)
            ->first();

            $dsr_cus=  IndividualCustome::find($customer_id);

        }        

        $dsrno= $pass->dsr_number;

        $individual = IndividualCustome::where('approval', '=', 1)->select('*')->get();
        $corporate = Customer::where('approval', 1)->get();
        $passengers = Passengers::where('dsr_number', $dsrno)->get();
        $hotels = Hotel::all();
        $tour = TourPackage::all();
        $room = HotelService::all();
        $flight = Flight::all();
        $visa = Visa::all();
        $insurance = Insurance::all();
        $insuranceplan = InsurancePlan::all();
        $other = Inventory::all();
        $taxmaster = Taxmaster::all();
        $bed = RoomBed::all();
        $meal = RoomMeal::all();
        //dd($emp);
        return view('dsr.passenger', compact('corporate', 'dsr_cus','tour','bed','meal','room','taxmaster','pass','individual','passengers','users','hotels', 'flight', 'visa', 'insurance', 'insuranceplan', 'other'));
    }

    public function services($id)
{
    
    $pass=Passengers::where('user_id', $id)->first();
    
    $services['hotel'] = DsrHotelService::where('user_id', $id)->get();
    $services['flight'] = DsrFlightService::where('user_id', $id)->get();
    $services['visa'] = DsrVisaService::where('user_id', $id)->get();
    $services['insurance'] = DsrInsuranceService::where('user_id', $id)->get();
    $services['carhire'] = DsrCarhireService::where('user_id', $id)->get();
    $services['assist'] = DsrAssistService::where('user_id', $id)->get();
    $services['other'] = DsrOtherService::where('user_id', $id)->get();
    
    $count['hotel'] = DsrHotelService::where('user_id', $id)->count();
    $count['flight'] = DsrFlightService::where('user_id', $id)->count();
    $count['visa'] = DsrVisaService::where('user_id', $id)->count();
    $count['insurance'] = DsrInsuranceService::where('user_id', $id)->count();
    $count['carhire'] = DsrCarhireService::where('user_id', $id)->count();
    $count['assist'] = DsrAssistService::where('user_id', $id)->count();    $count['other'] = DsrOtherService::where('user_id', $id)->count();
    
    $pass=Passengers::where('user_id', $id)->first();
    $dsrno= $pass->dsr_number;

        $individual = IndividualCustome::where('approval', '=', 1)->select('*')->get();
        $corporate = Customer::where('approval', 1)->get();
        $passengers = Passengers::where('dsr_number', $dsrno)->get();
        $hotels = Hotel::all();
        $tour = TourPackage::all();
        $room = HotelService::all();
        $flight = Flight::all();
        $visa = Visa::all();
        $carhire = Carhire::all();
        $assist = Assist::all();
        $insurance = Insurance::all();
        $insuranceplan = InsurancePlan::all();
        $other = Inventory::all();
        $taxmaster = Taxmaster::where('type', 'Sales')->get();
        $bed = RoomBed::all();
        $meal = RoomMeal::all();
        $supplier = Supplier::all();
        //dd($emp);
        return view('dsr.services', compact('count','services', 'corporate','tour','bed','meal','room','taxmaster','pass','individual','passengers','hotels', 'flight', 'visa','carhire', 'assist', 'insurance', 'insuranceplan', 'other', 'supplier'));


    // return view('dsr.services', compact('count','services', 'pass'));
}


    public function hotelServices($id)
    {

        $services = DsrHotelService::where('user_id', $id)->get();
        return view('dsr.hotelservice', compact('services'));
    }



    public function drop_data(Request $request)
    {
        // Get the selected dropdown value from the request
        $selectedValue = $request->input('selected_value');

        // Query the database to get the data based on the selected value
        $data = IndividualCustome::where('id', $selectedValue)->get();

        // Return the data as a JSON response
        return response()->json(['data' => $data]);
    }

    public function corporate_data(Request $request)
    {
        // Get the selected dropdown value from the request
        $selectedValue = $request->input('selected_value');

        // Query the database to get the data based on the selected value
        $data = Customer::where('id', $selectedValue)->get();

        // Return the data as a JSON response
        return response()->json(['data' => $data]);
    }

    public function roomno_data(Request $request)
    {
        // Get the selected dropdown value from the request
        $selectedValue = $request->input('selected_value');
        $hotel = Hotel::where('hotel_name', $selectedValue)->first();
        $hotel_id=$hotel->id;

        // Query the database to get the data based on the selected value
        $data = HotelService::where('hotel_id', $hotel_id)->get();

        // Return the data as a JSON response
        return response()->json(['data' => $data]);
    }

    public function insurance_data(Request $request)
    {
        // Get the selected dropdown value from the request
        $selectedValue = $request->input('selected_value');
        $insurance = Insurance::where('company_name', $selectedValue)->first();
        $insurance_id=$insurance->id;

        // Query the database to get the data based on the selected value
        $data = InsurancePlan::where('insurance_id', $insurance_id)->get();

        // Return the data as a JSON response
        return response()->json(['data' => $data]);
    }

    public function room_data(Request $request)
    {
        // Get the selected dropdown value from the request
        $selectedValue = $request->input('selected_value');
        $data = HotelService::where('room_name_number', $selectedValue)->first();

        // Return the data as a JSON response
        return response()->json(['data' => $data]);
    }

    public function visa_data(Request $request)
    {
        // Get the selected dropdown value from the request
        $selectedValue = $request->input('selected_value');

        // Query the database to get the data based on the selected value
        $data = IndividualCustome::where('first_name', $selectedValue)->first();

        // Return the data as a JSON response
        return response()->json(['data' => $data]);
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function edit()
    {
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
{
    $Dsr = Dsr::find($id);
    $status = $Dsr->invoice_status;
    if ($status == 0) {
        $dsr_number = $Dsr->dsr_number;

        $Passengers = Passengers::where('dsr_number', $dsr_number)->get();
        foreach ($Passengers as $Passenger) {
            $user_id = $Passenger->user_id;

            $Hotel = DsrHotelService::where('user_id', $user_id)->get();
            foreach ($Hotel as $hotelService) {
                $dsr_service_id = $hotelService->id;
                $ServicePassenger = DsrServicePassenger::where('dsr_service_id', $dsr_service_id)->get();
                foreach ($ServicePassenger as $servicePassenger) {
                    $servicePassenger->delete();
                }
                $hotelService->delete();
            }

            $Flight = DsrFlightService::where('user_id', $user_id)->get();
            foreach ($Flight as $flightService) {
                $dsr_service_id = $flightService->id;
                $ServicePassenger = DsrServicePassenger::where('dsr_service_id', $dsr_service_id)->get();
                foreach ($ServicePassenger as $servicePassenger) {
                    $servicePassenger->delete();
                }
                $flightService->delete();
            }

            $Visa = DsrVisaService::where('user_id', $user_id)->get();
            foreach ($Visa as $visaService) {
                $visaService->delete();
            }

            $Insurance = DsrInsuranceService::where('user_id', $user_id)->get();
            foreach ($Insurance as $insuranceService) {
                $insuranceService->delete();
            }

            $Carhire = DsrCarhireService::where('user_id', $user_id)->get();
            foreach ($Carhire as $carhireService) {
                $carhireService->delete();
            }

            $Assist = DsrAssistService::where('user_id', $user_id)->get();
            foreach ($Assist as $assistService) {
                $assistService->delete();
            }

            $Other = DsrOtherService::where('user_id', $user_id)->get();
            foreach ($Other as $otherService) {
                $otherService->delete();
            }

            $Passenger->delete();
        }

        $Dsr->delete();
        return Redirect::back();
    } else {
        session()->flash('error', 'Invoiced DSR can\'t be deleted.');
        return Redirect::back();
    }
}
    
      public function destroyPassenger($id)
    {
        $Dsr = Dsr::find($id);
        $status= $Dsr->invoice_status;
        if($status==0){
           $Dsr->delete();
           return Redirect::back();    
        }
        else{
        return Redirect::back();
        }
        

    }
    
    public function destroyService($id)
    {
        $pass=Passengers::where('user_id', $id)->first();
        $pass->delete();
        session()->flash('success', 'Passenger removed successfully.');
        return Redirect::back();

    }
    
    public function destroyDsrService($type, $id)
    {
        if($type=="hotel"){
            $Hotel = DsrHotelService::find($id);
                $Hotel->delete();
        }
        if($type=="flight"){
            
             $Flight = DsrFlightService::find($id);
                $Flight->delete();
            
        }
        if($type=="visa"){
            
             $Visa = DsrVisaService::find($id);
                $Visa->delete();

            
        }
        if($type=="insurance"){
            
            $Insurance = DsrInsuranceService::find($id);
                $Insurance->delete();

            
        }
        if($type=="carhire"){
            
            $Carhire = DsrCarhireService::find($id);
                $Carhire->delete();
            
        }
        if($type=="assist"){
            
             $Assist = DsrAssistService::find($id);
                $Assist->delete();
            
        }
        if($type=="other"){
            
            $Other = DsrOtherService::find($id);
                $Other->delete();
            
        }
        
    
        session()->flash('success', 'Service deleted successfully.');
        return Redirect::back();

    }
}
