<?php

namespace App\Http\Controllers\Assist;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Assist\Assist;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Facades\Redirect;


class AssistController extends Controller
{
    public function index(Request $request)
    {
        $assist = Assist::orderBy('id', 'DESC')->get();
        //dd($hotel);
        return view('assist.index', compact('assist'));
    }


    function status_update($id)
    {
        return Redirect::back();
        //get product status with the help of product ID
        $assist = Assist::select('status')
            ->where('id', '=', $id)
            ->first();

        //dd($customer);

        //Check user status
        if ($assist->status == 'Active') {
            $status = 'Inactive';
        } else {
            $status = 'Active';
        }

        //update product status
        $values = array('status' => $status);
        //dd($values);
        Assist::where('id', $id)->update($values);

        session()->flash('success', 'You\'ve Change Status successfully.');
        
        return Redirect::back();
    }


    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        $assist = new Assist;
        $assist->meeting_type = $request->input("meeting_type");
        $assist->airport = $request->input("airport");
        $assist->no_of_person = $request->input("no_of_person");
        $assist->currency = $request->input("currency");
        $assist->price = $request->input("price");
        $assist->description = $request->input("description");
        
        $assist->status = $request->input("status")?"Active":"Inactive";
        $assist->save();
        session()->flash('success', 'You\'ve created an Assist successfully.');
        
        return Redirect::back();
    }

    public function show()
    {
        //
    }


    public function edit($id)
    {
        $assist = Assist::find($id);
        //dd($emp);
        return response()->json([
            'status' => 200,
            'assist' => $assist,
        ]);
    }


    public function update(Request $request)
    {
        $id = $request->input('assist_id');
        $assist = Assist::find($id);
        $assist->meeting_type = $request->input("meeting_type");
        $assist->airport = $request->input("airport");
        $assist->no_of_person = $request->input("no_of_person");
        $assist->currency = $request->input("currency");
        $assist->price = $request->input("price");
        $assist->description = $request->input("description");
        
        $assist->status = $request->input("status")?"Active":"Inactive";
        $assist->update();
        session()->flash('success', 'You\'ve Updated Asssist successfully.');
        
        return Redirect::back();
    }

    public function destroy($id)
    {
        $assist = Assist::find($id);
        $assist->delete();
        session()->flash('success', 'You\'ve Deleted Assist successfully.');
        
        return Redirect::back();
    }
}