<?php $__env->startSection('content'); ?>

<div class="pull-right mt-3 mb-3">
    <a type="button" href="<?php echo e(route('employee.index')); ?>" class="btn btn-primary btn-icon-text mb-2 mb-md-0">
        <i class="btn-icon-prepend" data-feather="arrow-left-circle"></i>
        Back
    </a>
</div>
<?php if($errors->any()): ?>
<h4><?php echo e($errors->first()); ?></h4>
<?php endif; ?>
<?php echo $__env->make('sweetalert::alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<h1>Edit / Show Employee&nbsp;&nbsp;&nbsp;&nbsp;</h1>

<div>
    <nav class="page-breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="#">Forms</a></li>
            <li class="breadcrumb-item active" aria-current="page">Profile & Employees
            </li>
        </ol>
    </nav>

    <!-----------------------corporate customer form start--------------------- -->
    <div>
        <div class="col-md-12 stretch-card">
            <div class="card card-shadow-apply">
                <?php echo Form::model($emp, ['method' => 'PATCH','id'=>'quickForm','enctype'=>'multipart/form-data','route' => ['employee.update', $emp->id]]); ?>

                <div class="card-header">
                    <label class="form-label float-end">
                        Active
                    </label>
                    <div class="form-check form-switch mb-5 float-end">
                        <input name="status" type="checkbox" class="form-check-input" id="formSwitch1" <?php echo e($emp->status == 'Active' ? 'checked' : ''); ?>>
                    </div>
                    <label class="form-label float-end">
                        Inactive&nbsp;&nbsp;
                    </label>
                </div>
                <div class="card-body">
                    <h6 class="card-title">Update Employee</h6>

                    <div class="row">
                        <h3 class="heading">Basic Details</h3>
                        <div class="col-sm-4">
                            <div class="mb-3">

                                <label class="form-label">Employee Name
                                    <span class="required-field">*</span>
                                </label>
                                <input type="text" name="name" value="<?php echo e($emp->name); ?>" class="form-control" disabled>
                            </div>
                        </div><!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">Email
                                    <span class="required-field">*</span>
                                </label>
                                <input type="email" name="email" value="<?php echo e($emp->email); ?>" class="form-control" disabled>
                            </div>
                        </div>
                        <!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3"><label class="form-label" for="DateOfBirth" class="">Date Of
                                    Joining</label><label class="" style="color: red;">*</label>
                                <input name="doj" type="date" class="form-control" value="<?php echo e($emp->doj); ?>" disabled><small style="color: red;"></small>
                            </div>
                        </div><!-- Col -->
                    </div><!-- Row -->
                    <div class="row">
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">Gender
                                    <span class="required-field">*</span>
                                </label>
                                <select name="gender" class="js-example-basic-single form-select" data-width="100%" disabled>
                                    <option Selected value="<?php echo e($emp->gender); ?>"><?php echo e($emp->gender); ?></option>
                                    <option value="Male">Male</option>
                                    <option value="Female">Female</option>
                                    <option value="Others">Others</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">Mobile Number
                                    <span class="required-field">*</span>
                                </label>
                                <input type="number" name="mobile_number" value="<?php echo e($emp->mobile_number); ?>" class="form-control" disabled>
                            </div>
                        </div><!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">Emergency Contact Number</label>
                                <input type="number" name="emergency_contact_number" value="<?php echo e($emp->emergency_contact_number); ?>" class="form-control" disabled>
                            </div>
                        </div><!-- Col -->
                    </div><!-- Row -->
                    <div class="row">
                        <div class="col-sm-4">
                            <div class="mb-3"><label class="form-label" for="DateOfBirth" class="">Date Of
                                    Birth</label><label class="" style="color: red;">*</label>
                                <input name="dob" type="date" class="form-control" value="<?php echo e($emp->dob); ?>" disabled><small style="color: red;"></small>
                            </div>
                        </div><!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">Designation<span class="required-field">*</span>
                                </label>
                                <input type="text" name="designation" class="form-control" value="<?php echo e($emp->designation); ?>" disabled>
                            </div>
                        </div><!-- Col -->
                        <div class="col-sm-4">
                            <div class="mb-3">
                                <label class="form-label">Blood Group
                                    <span class="required-field">*</span>
                                </label>
                                <select name="blood_group" class="js-example-basic-single form-select" data-width="100%" disabled>
                                    <option Selected value="<?php echo e($emp->blood_group); ?>"><?php echo e($emp->blood_group); ?></option>
                                    <option value="A+">A +ve</option>
                                    <option value="A-">A -ve</option>
                                    <option value="B+">B +ve</option>
                                    <option value="B-">B -ve</option>
                                    <option value="AB+">AB +ve</option>
                                    <option value="AB-">AB -ve</option>
                                    <option value="O+">O +ve</option>
                                    <option value="O-">O -ve</option>
                                </select>
                            </div>
                        </div>
                    </div><!-- Row -->
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-12 stretch-card mt-3">
        <div class="card card-shadow-apply">
            <div class="card-body">
                <div class="row">
                    <!-- <h3 class="heading">Address</h3> -->
                    <h3 class="heading">Address Details</h3>
                    <br>
                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">Address Line 1
                                <span class="required-field">*</span>
                            </label>
                            <input type="text" name="address_1" class="form-control" value="<?php echo e($emp->address_line_1); ?>" disabled>
                        </div>
                    </div><!-- Col -->
                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">Address Line
                                2<small>(optional)</small></label>
                            <input type="text" name="address_2" class="form-control" value="<?php echo e($emp->address_line_2); ?>" disabled>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">City/Town
                                <span class="required-field">*</span>
                            </label>
                            <input type="text" name="city_town" class="form-control" value="<?php echo e($emp->city_town); ?>" disabled>
                        </div>
                    </div>
                    <!-- Col -->
                </div><!-- Row -->
                <div class="row">
                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">State/Province
                                <span class="required-field">*</span>
                            </label>
                            <input type="text" name="state_province" class="form-control" value="<?php echo e($emp->state_province); ?>" disabled>
                        </div>
                    </div><!-- Col -->
                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">Country
                                <span class="required-field">*</span>

                            </label>
                            <select name="country" class="js-example-basic-single form-select" data-width="100%" disabled>
                                <option Selected value="<?php echo e($emp->country); ?>"><?php echo e($emp->country); ?></option>
                                <option value="india">India</option>
                                <option value="saudi">Saudi</option>
                                <option value="china">China</option>
                                <option value="afghanistan">Afghanistan</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">Pincode
                                <span class="required-field">*</span>
                            </label>
                            <input name="pincode" type="number" class="form-control" value="<?php echo e($emp->pincode); ?>" disabled>
                        </div>
                    </div><!-- Col -->
                    <div class="col-sm-4">
                        <label class="form-label">Address Type
                            <span class="required-field">*</span>
                        </label>
                        <select name="address_type" class="js-example-basic-single form-select" data-width="100%" disabled>
                            <option Selected value="<?php echo e($emp->address_type); ?>"><?php echo e($emp->address_type); ?></option>
                            <option value="billing">Billing Address</option>
                            <option value="residential">Residential Address</option>
                            <option value="office">Office Address</option>
                            <option value="shipping">Shipping Address</option>
                        </select>
                    </div>
                </div><!-- Row -->
            </div>
        </div>
    </div>
    <div class="col-md-12 stretch-card mt-3">
        <div class="card card-shadow-apply">
            <div class="card-body">
                <h3 class="heading">Bank Details</h3>
                <div class="row">
                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">Bank Name</label>
                            <input type="text" name="bank_name" class="form-control" value="<?php echo e($emp->bank_name); ?>" disabled>
                        </div>
                    </div><!-- Col -->
                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">Account Number</label>
                            <input type="text" name="account_number" class="form-control" value="<?php echo e($emp->account_number); ?>" disabled>
                        </div>
                    </div><!-- Col -->
                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">Bank Code</label>
                            <input type="text" name="bank_code" class="form-control" value="<?php echo e($emp->bank_code); ?>" disabled>
                        </div>
                    </div><!-- Col -->

                </div><!-- Row -->

                <div class="row">
                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">Swift Code</label>
                            <input type="text" name="swift_code" class="form-control" value="<?php echo e($emp->swift_code); ?>" disabled>
                        </div>
                    </div><!-- Col -->

                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">Bank Branch</label>
                            <input name="bank_branch" type="text" class="form-control" value="<?php echo e($emp->bank_branch); ?>" disabled>
                        </div>
                    </div>


                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">Currency</label>
                            <select name="currency" class="js-example-basic-single form-select" data-width="100%" disabled>
                                <option Selected value="<?php echo e($emp->bank_branch); ?>"><?php echo e($emp->bank_branch); ?></option>
                                <option value="DI">Dinar</option>
                                <option value="RS">Rupees</option>
                                <option value="RI">Riyal</option>
                                <option value="AL">Albanian Lak</option>
                                <option value="AF">Afghan Afghani</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="mb-3">
                            <label class="form-label">Iban Number</label>
                            <input name="iban_number" type="text" class="form-control" value="<?php echo e($emp->iban_number); ?>" disabled>
                        </div>
                    </div><!-- Col -->
                </div><!-- Row -->
            </div>
        </div>
    </div>
    <div class="col-md-12 stretch-card mt-3">
        <div class="card card-shadow-apply">
            <div class="card-body">
                <div class="row">
                    <h3 class="heading">Documents</h3>
                    <div class="col-sm-3">
                        <div class="mb-3">

                            <label class="form-label">Passport id

                            </label>
                            <input type="text" name="passport_number" class="form-control" value="<?php echo e($emp->passport_number); ?>" disabled>
                        </div>
                    </div><!-- Col -->
                    <div class="col-sm-3">
                        <div class="mb-3"><label class="form-label" for="DateOfBirth" class="">Issue Date
                            </label><label class="" style="color: red;">*</label><input name="passport_issue_date" type="date" class="form-control" value="<?php echo e($emp->passport_issue_date); ?>" disabled><small style="color: red;"></small>
                        </div>
                    </div><!-- Col -->
                    <div class="col-sm-3">
                        <div class="mb-3"><label class="form-label" for="DateOfBirth" class="">Expiry Date
                            </label><label class="" style="color: red;">*</label><input name="passport_expiry_date" type="date" class="form-control" value="<?php echo e($emp->passport_expiry_date); ?>" disabled><small style="color: red;"></small>
                        </div>
                    </div><!-- Col -->

                    <div class="col-sm-3">
                        <div class="mb-3"><label class="form-label" for="DateOfBirth"><a href="/uploads/<?php echo e($emp->passport); ?>" target="_new"><?php echo e($emp->passport); ?></a>
                            </label><input class="form-control" name="passport" type="file" id="formFile" value="<?php echo e($emp->passport); ?>" disabled>
                        </div>
                    </div><!-- Col -->
                </div><!-- Row -->

                <div class="row">
                    <div class="col-sm-3">
                        <div class="mb-3">
                            <label class="form-label">Government ID
                            </label>
                            <input type="text" name="goverment_id_number" class="form-control" value="<?php echo e($emp->goverment_id_number); ?>" disabled>
                        </div>
                    </div><!-- Col -->
                    <div class="col-sm-3">
                        <div class="mb-3"><label class="form-label" for="DateOfBirth" class="">Issue Date
                            </label><label class="" style="color: red;">*</label><input name="goverment_issue_date" type="date" class="form-control" value="<?php echo e($emp->goverment_issue_date); ?>" disabled><small style="color: red;"></small>
                        </div>
                    </div><!-- Col -->
                    <div class="col-sm-3">
                        <div class="mb-3"><label class="form-label" for="DateOfBirth" class="">Expiry Date
                            </label><label class="" style="color: red;">*</label><input name="goverment_expiry_date" type="date" class="form-control" value="<?php echo e($emp->goverment_expiry_date); ?>" disabled><small style="color: red;"></small>
                        </div>
                    </div><!-- Col -->


                    <div class="col-sm-3">
                        <div class="mb-3"><label class="form-label" for="DateOfBirth"><a href="/uploads/<?php echo e($emp->government_ID); ?>" target="_new"><?php echo e($emp->government_ID); ?></a>
                            </label><input class="form-control" name="government_id" type="file" id="formFile" value="<?php echo e($emp->government_ID); ?>" disabled>
                        </div>
                    </div>

                    <!-- Col -->
                </div>
                <div class="row">
                    <div class="col-sm-3">
                        <div class="mb-3">
                            <label class="form-label">Other Documents <small class="optional-color">(optional)</small>
                            </label>
                            <input type="text" name="other_document_name" class="form-control" value="<?php echo e($emp->other_document_name); ?>" disabled>
                        </div>
                    </div><!-- Col -->


                    <div class="col-sm-3">
                        <div class="mb-3"><label class="form-label" for="DateOfBirth"><a href="/uploads/<?php echo e($emp->other_documents); ?>" target="_new"><?php echo e($emp->other_documents); ?></a>
                            </label><input class="form-control" name="other_documents" type="file" id="formFile" value="<?php echo e($emp->other_Documents); ?>" disabled>
                        </div>
                    </div>

                    <!-- Col -->
                </div>

                <div class="row">
                    <div class="col-sm-12">
                        <div class="mb-3">

                            <label class="form-label">Resume<small class="optional-color">(optional)</small>
                            </label>
                            <div class="col-sm-3">
                                <div class="mb-3"><label class="form-label" for="DateOfBirth"><a href="/uploads/<?php echo e($emp->resume); ?>" target="_new"><?php echo e($emp->resume); ?></a>
                                    </label><input class="form-control" name="resume" type="file" id="formFile" value="<?php echo e($emp->resume); ?>" disabled>
                                </div>
                            </div>
                        </div><!-- Col -->
                        <!-- Col -->
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="card mt-5">
        <div class="card-body">
            <h3 class="heading">Medical History</h3>
            <div class="row">
                <div class="col-sm-12">
                    <div class="mb-3">
                        <label class="form-label">Medical History
                            <small class="optional-color">(optional)</small>
                        </label>
                        <textarea class="form-control" name="medical_history_text" id="exampleFormControlTextarea1" rows="3" disabled><?php echo e($emp->medical_history); ?></textarea>
                    </div>
                </div><!-- Col -->

            </div><!-- Row -->
            <?php echo Form::close(); ?>

        </div>
    </div>
    <?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Arman\Downloads\New Download\Naksha (6)\Naksha\resources\views/Employee/show.blade.php ENDPATH**/ ?>