<?php
 use Carbon\Carbon;
?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <title>Voucher</title>
    <link rel="stylesheet" type="text/css" href="styles.css">
<style>
 @page {
            margin: 0 !important;
        }
    body {
    width: 210mm;
    height: 297mm;
    margin: 0 auto;
    font-family: Arial, sans-serif;
    /*background-color: #f5f5f5;*/
}

.container {
    /*max-width: 100%;*/
    margin: 0 auto;
    padding: 0 30px;
}

#page-wrap {
    background-color: #fff;
    /*padding: 30px;*/
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

.logo-container {
    text-align: center;
    margin-bottom: 20px;
}

.logo-container img {
    max-width: 150px;
}

.hotel-info {
    margin-bottom: 30px;
}

.hotel-info h3 {
    font-size: 18px;
    margin-bottom: 5px;
}

.hotel-info p {
    font-size: 14px;
    margin: 0;
}

.voucher-info h3 {
    font-size: 24px;
    text-align: center;
    margin-bottom: 20px;
    border-bottom: 1px solid #ccc;
    padding-bottom: 10px;
}

.booking-info {
    margin-bottom: 30px;
}

.booking-table {
    width: 100%;
    border-collapse: collapse;
}

.booking-table td {
    padding: 10px;
    border: 1px solid #ccc;
    text-align: center;
}

.booking-table h5 {
    font-size: 16px;
    margin-bottom: 5px;
}

.booking-table p {
    font-size: 14px;
    margin: 0;
}

.room-details {
    margin-top: 10px;
}

.room-details h5 {
    font-size: 16px;
    margin-bottom: 5px;
}

.room-details p {
    font-size: 14px;
    margin: 0;
}

.clear {
    clear: both;
}

</style>
</head>
<body>
    <div class="container">
        <div id="page-wrap">
        <div class="voucher-info">
                <h3>Flight Voucher</h3>
            </div>
            <?php
               $date=$flight->travel_date;
               $date = Carbon::parse($date);
               $travel_date = $date->format('d M Y');
               
            ?>
            
            <div style="width:50%; float:left;" class="hotel-info">
                <h3><?php echo e($flight->airline_name); ?></h3>
                <p>Travel Date: <?php echo e($travel_date); ?></p>
            </div>

           <div style="width:50%; float:left;" class="hotel-info">
                <h3></h3>
                <p>Ticket Number: <?php echo e($flight->ticket_number); ?></p>
                <p>PNR No: <?php echo e($flight->pnr_number); ?></p>
                <p>Route: <?php echo e($flight->route); ?></p>
                <p>Trip Type: <?php echo e($flight->trip_type); ?></p>
            </div>
            
            <div class="clear"></div>
            <div class="booking-info">

                <style>
  .room-details span {
    display: grid;
    grid-template-columns: repeat(5, 20%);
    grid-gap: 5px;
  }
</style>

<div class="room-details">
  <h5>Passenger Information</h5>
  <?php $__currentLoopData = $passenger; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <span><?php echo e($data->passengers); ?></span>
  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  
</div>

                
            </div>
        </div>
    </div>
</body>
</html>
<?php /**PATH E:\Download\Naksha\resources\views/voucher/flightvoucher.blade.php ENDPATH**/ ?>