@extends('layouts.master')

@section('content')



<div class="row">
  <div class="col-lg-12 margin-tb">
    <div class="pull-left">
      <h2>Bed List</h2>
    </div>
    <br>
    <div class="mt-5 mb-3">
      <button type="button" class="btn btn-success btn-icon-text mb-2 mb-md-0" data-bs-toggle="modal" data-bs-target="#AddBed">
                <i class="btn-icon-prepend" data-feather="home"></i>
                Add Bed
      </button>
    </div>
  </div>
</div>

@if ($message = Session::get('success'))
@include('sweetalert::alert')
@endif


<div class="col-md-12 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <div class="table-responsive">
        <table id="dataTableExample" class="table">
          <thead>
            <tr>
              <th>No</th>
              <th>Bed Type</th>
              <th>Price</th>
              <th width="280px">Action</th>
            </tr>
          </thead>
          <tbody>
            @foreach ($bed as $key => $data)
            <tr class="fw-bold fs-5">
              <td>{{ $key+1 }}</td>
              <td>{{ $data->bed }}</td>
              <td>{{ $data->price }}</td>
              <td>
                <a href="hotel/{{$hotel->id}}/delete/"><i class="text-danger btn-icon-prepend" data-feather="trash"></i></a>
              </td>
            </tr>
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>


<!-- Add Service Modal -->
<div class="modal" id="AddBed">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">

            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">Add Beds</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <!-- Modal body -->
            <div class="modal-body">
                <div class="row mt-3">

                <form action="/room/bed/add" method="POST" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="room_id" class="form-control" value="">
                    <div class="row">
                       

                        <!-- Col -->
                    </div><!-- Row -->


                    <div class="row">
                      

                        <div class="col-sm-6">
                            <div class="mb-3">

                                <label class="form-label">Service Type
                                    <span class="required-field">*</span>
                                </label>
                                <input type="text" name="price" class="form-control">
                            </div>
                        </div>
                        


                    </div>


                    <!-- Modal footer -->
                    <div class="modal-footer">
                        <div class="buttons-alignment mt-4">
                            <button type="submit" class="btn btn-primary submit-button-alignment">Submit</button>
                        </div>
                    </div>
                  </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection