@extends('layouts.master')

@section('content')

<link href="//maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" rel="stylesheet" id="bootstrap-css">
<script src="//maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
<!------ Include the above in your HEAD tag ---------->

<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/css/select2.min.css" rel="stylesheet" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/js/select2.min.js"></script>





<div class="row">
  <div class="col-lg-12 margin-tb">
    <div class="pull-left">
      <h2>Assist List</h2>
    </div>
    <br>
    <div class="mt-5 mb-3">
      <button type="button" class="btn btn-success btn-icon-text mb-2 mb-md-0" data-bs-toggle="modal" data-bs-target="#AddAssist">
        <i class="btn-icon-prepend" data-feather="headphones"></i>
        Add Acssist
      </button>
    </div>
  </div>
</div>

@if ($message = Session::get('success'))
@include('sweetalert::alert')
@endif

@include('sweetalert::alert')

<div class="col-md-12 grid-margin stretch-card">
  <div class="card">
    <div class="card-body">
      <div class="table-responsive">
        <table id="dataTableExample" class="table">
          <thead class="text-center">
            <tr>
              <th>No</th>
              <th>Meeting Type</th>
              <th>Airport</th>
              <th>No. of Person</th>
              <th>Price</th>
              <th>status</th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody>
            @foreach ($assist as $key => $assist)
            <tr class="fw-bold fs-5">
              <td>{{ ++$i }}</td>
              <td>{{ $assist->meeting_type}}</td>
              <td>{{ $assist->airport}}</td>
              <td>{{ $assist->no_of_person}}</td>
              <td>{{ $assist->price}}</td>
              <td>
                <?php if ($assist->status == 'Active') { ?>

                  <a href="{{url('/status-update',$assist->id)}}" class="btn btn-success btn-sm">Active</a>

                <?php } else { ?>

                  <a href="{{url('/status-update',$assist->id)}}" class="btn btn-danger btn-sm">Inactive</a>

                <?php } ?>
              </td>
              <td>
                <button type="button" value="{{$assist->id}}" class=" btn btn-white editbtn"><i class="text-success btn-icon-prepend" data-feather="edit"></i></button>
              </td>
            </tr>
            @endforeach
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<!-- The Modal -->
<div class="modal" id="AddAssist">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header AssistHeader">
        <h4 class="modal-title">Add Assist</h4>
        <button type="button" class="btn-close btn-close-Assist" data-bs-dismiss="modal"></button>
      </div>

      <!-- Modal body -->
      <div class="modal-body Assist-modal-body">
        <div class="card-body">
          {!! Form::open(array('route' => 'assist.store','method'=>'POST','id'=>'assist','enctype'=>'multipart/form-data')) !!}
          <div class="row">
            <h3 class="heading">Basic Details</h3>
            <div class="col-sm-6">
              <div class="mb-3">
                <label class="form-label">Meeting Type
                  <span class="required-field">*</span>
                </label>
                <input type="text" name="meeting_type" id="meeting_type" class="form-control">
              </div>
            </div><!-- Col -->
            <div class="col-sm-6">
              <div class="mb-3">
                <label class="form-label">Airport
                  <span class="required-field">*</span>
                </label>
                <input type="text" name="airport" id="airport" class="form-control">
              </div>
            </div><!-- Col -->
          </div><!-- Row -->
          <div class="row">
            <div class="col-sm-6">
              <div class="mb-3">
                <label class="form-label">No of Persons
                  <span class="required-field">*</span>
                </label>
                <input type="text" name="no_of_person" id="no_of_person" class="form-control">
              </div>
            </div><!-- Col -->
            <div class="col-sm-6">
              <div class="mb-3">
                <label class="form-label">Currency
                  <span class="required-field">*</span>
                </label>
                <select id="currency" name="currency" class="js-example-basic-single  form-select select2">
                  <option Selected>select </option>
                  <option value="AFN">Afghan Afghani</option>
                  <option value="ALL">Albanian Lek</option>
                  <option value="DZD">Algerian Dinar</option>
                  <option value="AOA">Angolan Kwanza</option>
                  <option value="ARS">Argentine Peso</option>
                  <option value="AMD">Armenian Dram</option>
                  <option value="AWG">Aruban Florin</option>
                  <option value="AUD">Australian Dollar</option>
                  <option value="AZN">Azerbaijani Manat</option>
                  <option value="BSD">Bahamian Dollar</option>
                  <option value="BHD">Bahraini Dinar</option>
                  <option value="BDT">Bangladeshi Taka</option>
                  <option value="BBD">Barbadian Dollar</option>
                  <option value="BYR">Belarusian Ruble</option>
                  <option value="BEF">Belgian Franc</option>
                  <option value="BZD">Belize Dollar</option>
                  <option value="BMD">Bermudan Dollar</option>
                  <option value="BTN">Bhutanese Ngultrum</option>
                  <option value="BTC">Bitcoin</option>
                  <option value="BOB">Bolivian Boliviano</option>
                  <option value="BWP">Botswanan Pula</option>
                  <option value="BRL">Brazilian Real</option>
                  <option value="GBP">British Pound Sterling</option>
                  <option value="BND">Brunei Dollar</option>
                  <option value="BGN">Bulgarian Lev</option>
                  <option value="BIF">Burundian Franc</option>
                  <option value="KHR">Cambodian Riel</option>
                  <option value="CAD">Canadian Dollar</option>
                  <option value="CVE">Cape Verdean Escudo</option>
                  <option value="KYD">Cayman Islands Dollar</option>
                  <option value="XOF">CFA Franc BCEAO</option>
                  <option value="XAF">CFA Franc BEAC</option>
                  <option value="XPF">CFP Franc</option>
                  <option value="CLP">Chilean Peso</option>
                  <option value="CNY">Chinese Yuan</option>
                  <option value="COP">Colombian Peso</option>
                  <option value="KMF">Comorian Franc</option>
                  <option value="CDF">Congolese Franc</option>
                  <option value="CRC">Costa Rican ColÃ³n</option>
                  <option value="HRK">Croatian Kuna</option>
                  <option value="CUC">Cuban Convertible Peso</option>
                  <option value="CZK">Czech Republic Koruna</option>
                  <option value="DKK">Danish Krone</option>
                  <option value="DJF">Djiboutian Franc</option>
                  <option value="DOP">Dominican Peso</option>
                  <option value="XCD">East Caribbean Dollar</option>
                  <option value="EGP">Egyptian Pound</option>
                  <option value="ERN">Eritrean Nakfa</option>
                  <option value="EEK">Estonian Kroon</option>
                  <option value="ETB">Ethiopian Birr</option>
                  <option value="EUR">Euro</option>
                  <option value="FKP">Falkland Islands Pound</option>
                  <option value="FJD">Fijian Dollar</option>
                  <option value="GMD">Gambian Dalasi</option>
                  <option value="GEL">Georgian Lari</option>
                  <option value="DEM">German Mark</option>
                  <option value="GHS">Ghanaian Cedi</option>
                  <option value="GIP">Gibraltar Pound</option>
                  <option value="GRD">Greek Drachma</option>
                  <option value="GTQ">Guatemalan Quetzal</option>
                  <option value="GNF">Guinean Franc</option>
                  <option value="GYD">Guyanaese Dollar</option>
                  <option value="HTG">Haitian Gourde</option>
                  <option value="HNL">Honduran Lempira</option>
                  <option value="HKD">Hong Kong Dollar</option>
                  <option value="HUF">Hungarian Forint</option>
                  <option value="ISK">Icelandic KrÃ³na</option>
                  <option value="INR">Indian Rupee</option>
                  <option value="IDR">Indonesian Rupiah</option>
                  <option value="IRR">Iranian Rial</option>
                  <option value="IQD">Iraqi Dinar</option>
                  <option value="ILS">Israeli New Sheqel</option>
                  <option value="ITL">Italian Lira</option>
                  <option value="JMD">Jamaican Dollar</option>
                  <option value="JPY">Japanese Yen</option>
                  <option value="JOD">Jordanian Dinar</option>
                  <option value="KZT">Kazakhstani Tenge</option>
                  <option value="KES">Kenyan Shilling</option>
                  <option value="KWD">Kuwaiti Dinar</option>
                  <option value="KGS">Kyrgystani Som</option>
                  <option value="LAK">Laotian Kip</option>
                  <option value="LVL">Latvian Lats</option>
                  <option value="LBP">Lebanese Pound</option>
                  <option value="LSL">Lesotho Loti</option>
                  <option value="LRD">Liberian Dollar</option>
                  <option value="LYD">Libyan Dinar</option>
                  <option value="LTL">Lithuanian Litas</option>
                  <option value="MOP">Macanese Pataca</option>
                  <option value="MKD">Macedonian Denar</option>
                  <option value="MGA">Malagasy Ariary</option>
                  <option value="MWK">Malawian Kwacha</option>
                  <option value="MYR">Malaysian Ringgit</option>
                  <option value="MVR">Maldivian Rufiyaa</option>
                  <option value="MRO">Mauritanian Ouguiya</option>
                  <option value="MUR">Mauritian Rupee</option>
                  <option value="MXN">Mexican Peso</option>
                  <option value="MDL">Moldovan Leu</option>
                  <option value="MNT">Mongolian Tugrik</option>
                  <option value="MAD">Moroccan Dirham</option>
                  <option value="MZM">Mozambican Metical</option>
                  <option value="MMK">Myanmar Kyat</option>
                  <option value="NAD">Namibian Dollar</option>
                  <option value="NPR">Nepalese Rupee</option>
                  <option value="ANG">Netherlands Antillean Guilder</option>
                  <option value="TWD">New Taiwan Dollar</option>
                  <option value="NZD">New Zealand Dollar</option>
                  <option value="NIO">Nicaraguan CÃ³rdoba</option>
                  <option value="NGN">Nigerian Naira</option>
                  <option value="KPW">North Korean Won</option>
                  <option value="NOK">Norwegian Krone</option>
                  <option value="OMR">Omani Rial</option>
                  <option value="PKR">Pakistani Rupee</option>
                  <option value="PAB">Panamanian Balboa</option>
                  <option value="PGK">Papua New Guinean Kina</option>
                  <option value="PYG">Paraguayan Guarani</option>
                  <option value="PEN">Peruvian Nuevo Sol</option>
                  <option value="PHP">Philippine Peso</option>
                  <option value="PLN">Polish Zloty</option>
                  <option value="QAR">Qatari Rial</option>
                  <option value="RON">Romanian Leu</option>
                  <option value="RUB">Russian Ruble</option>
                  <option value="RWF">Rwandan Franc</option>
                  <option value="SVC">Salvadoran ColÃ³n</option>
                  <option value="WST">Samoan Tala</option>
                  <option value="SAR">Saudi Riyal</option>
                  <option value="RSD">Serbian Dinar</option>
                  <option value="SCR">Seychellois Rupee</option>
                  <option value="SLL">Sierra Leonean Leone</option>
                  <option value="SGD">Singapore Dollar</option>
                  <option value="SKK">Slovak Koruna</option>
                  <option value="SBD">Solomon Islands Dollar</option>
                  <option value="SOS">Somali Shilling</option>
                  <option value="ZAR">South African Rand</option>
                  <option value="KRW">South Korean Won</option>
                  <option value="XDR">Special Drawing Rights</option>
                  <option value="LKR">Sri Lankan Rupee</option>
                  <option value="SHP">St. Helena Pound</option>
                  <option value="SDG">Sudanese Pound</option>
                  <option value="SRD">Surinamese Dollar</option>
                  <option value="SZL">Swazi Lilangeni</option>
                  <option value="SEK">Swedish Krona</option>
                  <option value="CHF">Swiss Franc</option>
                  <option value="SYP">Syrian Pound</option>
                  <option value="STD">São Tomé and Príncipe Dobra</option>
                  <option value="TJS">Tajikistani Somoni</option>
                  <option value="TZS">Tanzanian Shilling</option>
                  <option value="THB">Thai Baht</option>
                  <option value="TOP">Tongan pa'anga</option>
                  <option value="TTD">Trinidad & Tobago Dollar</option>
                  <option value="TND">Tunisian Dinar</option>
                  <option value="TRY">Turkish Lira</option>
                  <option value="TMT">Turkmenistani Manat</option>
                  <option value="UGX">Ugandan Shilling</option>
                  <option value="UAH">Ukrainian Hryvnia</option>
                  <option value="AED">United Arab Emirates Dirham</option>
                  <option value="UYU">Uruguayan Peso</option>
                  <option value="USD">US Dollar</option>
                  <option value="UZS">Uzbekistan Som</option>
                  <option value="VUV">Vanuatu Vatu</option>
                  <option value="VEF">Venezuelan BolÃ­var</option>
                  <option value="VND">Vietnamese Dong</option>
                  <option value="YER">Yemeni Rial</option>
                  <option value="ZMK">Zambian Kwacha</option>
                </select>
              </div>
            </div>
          </div><!-- Row -->
          <div class="row">
            <div class="col-sm-12">
              <div class="mb-3">

                <label class="form-label">Price
                  <span class="required-field">*</span>
                </label>
                <input type="text" name="price" class="form-control">
              </div>
            </div><!-- Col -->
            <div class="col-sm-12">
              <div class="mb-3">
                <label class="form-label">Description
                  <small class="optional-color">(optional)</small>
                </label>
                <textarea class="form-control" name="description" id="exampleFormControlTextarea1" rows="3"></textarea>
              </div>
            </div><!-- Col -->
          </div>
          <div class="buttons-alignment mt-4 Assist-submit-button">
            <button type="submit" class="btn btn-primary submit">Submit</button>
          </div>
          {!! Form::close() !!}
        </div>
      </div>
    </div>
  </div>
</div>

<div class="modal" id="EditAssist">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h4 class="modal-title">Update Assist</h4>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <!-- Modal body -->
      <div class="modal-body">
        <div class="card-body">

          <form action="{{url('assist_service_update')}}" method="POST">
            @csrf
            @method('PUT')

            <input type="hidden" name="assist_id" id="assist_id" class="form-control">

            <div class="row">
              <h3 class="heading">Basic Details</h3>
              <div class="col-sm-6">
                <div class="mb-3">
                  <label class="form-label">Meeting Type
                    <span class="required-field">*</span>
                  </label>
                  <input type="text" name="meeting_type" id="meeting_type" class="form-control">
                </div>
              </div><!-- Col -->
              <div class="col-sm-6">
                <div class="mb-3">
                  <label class="form-label">Airport
                    <span class="required-field">*</span>
                  </label>
                  <input type="text" name="airport" id="airport" class="form-control">
                </div>
              </div><!-- Col -->
            </div><!-- Row -->
            <div class="row">
              <div class="col-sm-6">
                <div class="mb-3">
                  <label class="form-label">No of Persons
                    <span class="required-field">*</span>
                  </label>
                  <input type="number" name="no_of_person" id="no_of_person" class="form-control">
                </div>
              </div><!-- Col -->
              <div class="col-sm-6">
                <div class="mb-3">
                  <label class="form-label">Currency
                    <span class="required-field">*</span>
                  </label>
                  <select name="currency" id="currency" class="js-example-basic-single form-select" data-width="100%">
                    <option Selected>Select</option>
                    <option value="India">India</option>
                    <option value="Saudi">Saudi</option>
                    <option value="China">China</option>
                    <option value="Afghanistan">Afghanistan</option>
                  </select>
                </div>
              </div>
            </div><!-- Row -->
            <div class="row">
              <div class="col-sm-12">
                <div class="mb-3">

                  <label class="form-label">Price
                    <span class="required-field">*</span>
                  </label>
                  <input type="number" name="price" id="price" class="form-control">
                </div>
              </div><!-- Col -->
              <div class="col-sm-12">
                <div class="mb-3">
                  <label class="form-label">Description
                    <small class="optional-color">(optional)</small>
                  </label>
                  <textarea class="form-control" name="description" id="description" rows="3"></textarea>
                </div>
              </div><!-- Col -->
            </div>
            <div class="buttons-alignment mt-4">
              <button type="submit" class="btn btn-success">Upadate</button>
            </div>
          </form>
        </div>
      </div>

    </div>
  </div>
</div>

<script>
  $(document).ready(function() {
    $(document).on('click', '.editbtn', function() {
      var assist_id = $(this).val();
      //alert(service_id);
      $('#EditAssist').modal('show');

      $.ajax({
        type: "GET",
        url: "/assist/" + assist_id + "/edit",
        success: function(response) {
          //console.log(response);
          $('#meeting_type').val(response.assist.meeting_type);
          $('#airport').val(response.assist.airport);
          $('#no_of_person').val(response.assist.no_of_person);
          $('#currency').val(response.assist.currency);
          $('#price').val(response.assist.price);
          $('#description').val(response.assist.description);
          $('#assist_id').val(assist_id);
        }
      });
    });
  });



  // validation start
  $(document).ready(function() {
    $("#assist").validate({
      rules: {
        meeting_type: {
          required: true,
          maxlength: 20,
        },
        airport: {
          required: true,
          maxlength: 20,
        },
        no_of_person: {
          required: true,
          maxlength: 20,
        },
        price: {
          required: true,
          maxlength: 20,
        },
      },
      messages: {
        meeting_type: {
          required: "Meeting type is required",
          maxlength: "Meeting type cannot be more than 20 characters",
        },

        airport: {
          required: "Airport is required",
          maxlength: "Airport cannot be more than 20 characters"
        },

        no_of_person: {
          required: "Person is required",
          maxlength: "Person cannot be more than 20 characters",
        },

        price: {
          required: "Price is required",
          maxlength: "Price cannot be more than 20 characters",
        },

      }
    });
  });


  $('.select2').each(function() { 
    $(this).select2({ dropdownParent: $(this).parent()});
})

</script>
@endsection
