<?php

namespace App\Models\Employee;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmployeeFamily extends Model
{
    use HasFactory;

    public $table = 'employee_family';

    protected $fillable = [
        'employee_id',
        'first_name',
        'middle_name',
        'last_name',
        'age',
        'gender',
        'relation',
    ];

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }
}
