<?php

namespace App\Http\Controllers\TourPackage;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\TourPackage\TourPackage;
use App\Models\Itinerary\Itinerary;
use Illuminate\Support\Facades\Redirect;

class TourPackageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index(Request $request)
    {
        $tour = TourPackage::orderBy('id', 'DESC')->paginate(5);
        //dd($hotel);
        return view('tourPackage.index', compact('tour'))
            ->with('i', ($request->input('page', 1) - 1) * 5);
    }


    public function create()
    {
        return view('tourPackage.create');
    }

    public function store(Request $request)
    {
        $tourPack = new TourPackage;
        $tourPack->package_name = $request->input("package_name");
        $tourPack->destination = $request->input("destination");
        $tourPack->days = $request->input("days");
        $tourPack->hotel_type = $request->input("hotel_type");
        $tourPack->meal = $request->input("meal");
        $tourPack->currency = $request->input("currency");
        $tourPack->price_per_person = $request->input("price_per_person");
        $tourPack->other = $request->input("other");
        $tourPack->description = $request->input("description");
        $tourPack->transport = $request->input("transport");
        if ($request->file('photo')) {
            $photo = $request->file('image');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $tourPack->image = $filename;
        }
        $tourPack->save();
        session()->flash('success', 'You\'ve Added Tour Package Successfully');
        return redirect()->route('tour_package.index');
    }

    public function show($id)
    {
        $tourPack = TourPackage::find($id);
        //dd($emp);
        return view('tourPackage.show', compact('tourPack'));
    }


    public function edit($id, Request $request)
    {
        $tourPack = TourPackage::find($id);
        $tourPack_id= $tourPack->id;
        $itinerary = Itinerary::orderBy('id', 'DESC')->where('tour_package_id', $tourPack_id)->get();

        //dd($emp);
        return view('tourPackage.edit', compact('tourPack', 'itinerary'))->with('i', ($request->input('page', 1) - 1) * 5);
    }


    public function update($id, Request $request)
    {
        $tourPack = TourPackage::find($id);
        $tourPack->package_name = $request->input("package_name");
        $tourPack->destination = $request->input("destination");
        $tourPack->days = $request->input("days");
        $tourPack->hotel_type = $request->input("hotel_type");
        $tourPack->meal = $request->input("meal");
        $tourPack->currency = $request->input("currency");
        $tourPack->price_per_person = $request->input("price_per_person");
        $tourPack->other = $request->input("other");
        $tourPack->transport = $request->input("transport");
        $tourPack->description = $request->input("description");
        if ($request->file('photo')) {
            $photo = $request->file('image');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $tourPack->image = $filename;
        }
        $tourPack->status = $request->input("status") ? "Active" : "Inactive";
        $tourPack->save();
        session()->flash('success', 'You\'ve Update Tour Package Successfully');

        return Redirect::back();
    }

    public function destroy($id)
    {
        $tourPack = TourPackage::find($id);
        $tourPack->delete();
        session()->flash('success', 'You\'ve Deleted Tour Package Successfully');

        return Redirect::back();
    }
}
