<?php

namespace App\Http\Controllers\Quotation;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\View;
use PDF;
use App\Models\DSR\DSR;
use App\Models\DSR\DsrHotelService;
use App\Models\DSR\DsrTourService;
use App\Models\DSR\DsrFlightService;
use App\Models\DSR\DsrVisaService;
use App\Models\DSR\DsrServicePassenger;
use App\Models\DSR\DsrInsuranceService;
use App\Models\DSR\DsrOtherService;
use App\Models\DSR\CarhireService;
use App\Models\DSR\AssistService;
use App\Models\Passengers\Passengers;
use App\Models\Hotel\Hotel;
use App\Models\Flight\Flight;
use App\Models\Visa\Visa;
use App\Models\Insurance\Insurance;
use App\Models\InsurancePlan\InsurancePlan;
use App\Models\Inventory\Inventory;
use App\Models\HotelService\HotelService;
use App\Models\TourPackage\TourPackage;
use App\Models\HotelServices\RoomBed;
use App\Models\HotelServices\RoomMeal;
use App\Models\Customer\Customer;
use App\Models\Taxmaster\Taxmaster;
use App\Models\Items\Items;
use App\Models\Invoice\Invoice;
use App\Models\Invoice\InvoiceServices;
use App\Models\Proforma\Proforma;
use App\Models\Assist\Assist;
use App\Models\Carhire\Carhire;
use App\Models\Proforma\ProformaServices;
use App\Models\Individual\IndividualCustome;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Facades\Redirect;

use App\Models\Quotation\Quotation;
// use App\Models\Mice\MiceFamily;


class QuotationController extends Controller
{
    public function index(Request $request)
    {
        $dsr = Quotation::all();
        return view('quotation.index', compact('dsr'));
    }

    

    public function create()
    {
        $dsr = Quotation::all();

        $corporate = Customer::where('approval', '=', 1)->select('*')->get();
        $cdata = Customer::where('approval', '=', 1)->get();
        $individual = IndividualCustome::where('approval', '=', 1)->get();
        $idata = IndividualCustome::where('approval', '=', 1)->get();
        //dd($corporate);
        return view('quotation.create', compact('corporate','individual', 'idata', 'cdata', 'dsr'));
    }


    public function store(Request $request)
    {
          // Get the current maximum order number from the database
        $maxDsrNumber = Quotation::max('quotation_id');

        // Parse the Dsr number to get the numeric part
        $lastDsrNumber = (int) substr($maxDsrNumber, -6);

        // Increment the Dsr number
        $newDsrNumber = $lastDsrNumber + 1;

        // Pad the Dsr number with leading zeros to get the final Dsr number
        $paddedDsrNumber = str_pad($newDsrNumber, 6, '0', STR_PAD_LEFT);

        // Build the final Dsr ID with the series
        $series = 'NQ';
        $dsr_number = $series . '-' . $paddedDsrNumber;

        $type=$request->input("customer_type");
        if ($type=="Corporate") {
            $customer_id = $request->input("corporate_id");
            $customer_name = $request->input("select_company_name");

        }
        elseif ($type=="Individual") {
            $customer_id = $request->input("individual_id");
            $customer_name = $request->input("select_individual_name");
        }
        elseif ($type=="New") {
            $customer_id = 0;
            $customer_name = $request->input("customer_name");
            $email = $request->input("email");
            $phone = $request->input("mobile");
            $address = $request->input("address");

            
        }

        $Quotation = new Quotation;

        if ($request->file('quotation_file')) {
            $photo = $request->file('quotation_file');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $Quotation->file = $filename;
        }

        $Quotation->customer_type = $request->input("customer_type");
        $Quotation->customer_id = $customer_id;
        $Quotation->customer_name = $customer_name;
        $Quotation->package = $request->input("package");
        $Quotation->quotation_id = $dsr_number;
        $Quotation->currency = $request->input("currency");
        $Quotation->quotation_date = $request->input("quotation_date");
        $Quotation->expiry_date = $request->input("expiry_date");
        $Quotation->reference_no = $request->input("reference_no");
        $Quotation->customer_note = $request->input("customer_note");
        $Quotation->terms = $request->input("terms");
        $Quotation->subtotal = $request->input("subtotal");
        $Quotation->shipping_charge = $request->input("shipping_charge");
        $Quotation->adjustment_charge = $request->input("adjustment_charge");
        $Quotation->total = $request->input("quotation_total");
        $Quotation->tax_type = $request->input("tax_type");
        $Quotation->save();

        $quantity = $request->input("quantity");

        foreach($quantity as $key => $value) {
            $Items = new Items();
            $Items->quotation_id = $dsr_number;
            $Items->item_details = $request->input("item_details")[$key];
            $Items->quantity = $request->input("quantity")[$key];
            $Items->rate = $request->input("rate")[$key];
            $Items->discount = $request->input("discount")[$key];
            $Items->tax_rate = $request->input("tax_rate")[$key];
            $Items->tax_amount = $request->input("tax_amount")[$key];
            $Items->total = $request->input("total")[$key];

            // $Items->rate = $request->input("rate");
            $Items->save();
        } 
        
        session()->forget('hotel.items');
        session()->forget('flight.items');
        session()->forget('visa.items');
        session()->forget('insurance.items');
        session()->forget('other.items');

        session()->flash('success', 'You\'ve Added Quotation Successfully');
        return redirect()->route('Quotation');

        // $quantity = $request->input("quantity");

        // foreach($quantity as $key => $value) {
        //     $Items = new Items();
        //     // $Items->item_details = $request->input("tax_rate");
        //     $Items->quantity = $request->input("quantity")[$key];
        //     $Items->rate = "test";

        //     // $Items->rate = $request->input("rate");
        //     $Items->save();
        // } 

    // $quantities = $request->input('quantity');
    // $prices = $request->input('tax');

    // $products = [];
    // foreach ($productNames as $key => $value) {
    //     $product = new Items();
    //     $product->quantity = $quantities[$key];
    //     $product->tax_rate = $prices[$key];
    //     $product->save();

    //     $products[] = $product;
    // }

                

    }

    public function guest($type, $id)
    {
        $data = DsrServicePassenger::where('dsr_service_id', $id)->get();
        //dd($corporate);
        return view('dsr.guest', compact('data'));
    }


    public function storePassengers(Request $request)
    {
        

        do {
           
            $user_id=rand(100000,999999);

            $records=DB::table('passengers')
                   ->where('user_id',$user_id)
                   ->exists();     
                   
            // $user_id=rand(100000,999999);
            // $records= Passengers::where('user_id', $user_id)->get();
           
         } while ($records ==1);
        

        $passengers = new Passengers;
        $passengers->customer_id = $request->input("customer_id");
        $passengers->user_id = $user_id;
        $passengers->dsr_number = $request->input("dsr_number");
        $passengers->name = $request->input("customer_name");
        $passengers->email = $request->input("email");
        $passengers->phone = $request->input("phone");
        $passengers->save();
        
        // Alert::success('Congrats', 'You\'ve Added Passenger Successfully');
        return Redirect::back();
    }

    public function addHotelService(Request $request)
    {
        
        $HotelService = new DsrHotelService;

       
        $HotelService->user_id = $request->input("user_id");
        $HotelService->dsr_number = $request->input("dsr_number");
        $HotelService->hotel_name = $request->input("hotel_name");
        $HotelService->room_name_number = $request->input("room_name_number");
        $HotelService->occupancy = $request->input("occupancy");
        $HotelService->meal = $request->input("meal");
        $HotelService->bed = $request->input("bed");
        $HotelService->booking_date = $request->input("booking_date");
        $HotelService->start_date = $request->input("start_date");
        $HotelService->end_date = $request->input("end_date");
        $HotelService->total_days = $request->input("total_days");
        $HotelService->total_night = $request->input("total_night");
        $HotelService->supplier = $request->input("supplier");
        $HotelService->hotel_price = $request->input("hotel_price");
        $HotelService->tax_amount = $request->input("tax_rate");
        $HotelService->other_tax = $request->input("tax_amount");
       
        $HotelService->save();

        session()->flash('success', 'You\'ve Added Services successfully.');
        return Redirect::back();
    }

    public function addTourService(Request $request)
    {
        
        $TourService = new DsrTourService;

        if ($request->file('tour_details')) {
            $photo = $request->file('tour_details');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $TourService->tour_details = $filename;
        }

        $TourService->user_id = $request->input("user_id");
        $TourService->dsr_number = $request->input("dsr_number");
        $TourService->hotel_name = $request->input("hotel_name");
        $TourService->room_name_number = $request->input("room_name_number");
        $TourService->occupancy = $request->input("occupancy");
        $TourService->meal = $request->input("meal");
        $TourService->bed = $request->input("bed");
        $TourService->booking_date = $request->input("booking_date");
        $TourService->start_date = $request->input("start_date");
        $TourService->end_date = $request->input("end_date");
        $TourService->total_days = $request->input("total_days");
        $TourService->total_night = $request->input("total_night");
        $TourService->supplier = $request->input("supplier");
        $TourService->supplier_service_charge = $request->input("supplier_service_charge");
        $TourService->hotel_price = $request->input("hotel_price");
        $TourService->tax_amount = $request->input("tax_rate");
        $TourService->other_tax = $request->input("tax_amount");
        
        $TourService->save();

        
        
        session()->flash('success', 'You\'ve Added Services successfully.');
        return Redirect::back();
    }

    public function addFlightService(Request $request)
    {
        
        $FlightService = new DsrFlightService;
        $FlightService->user_id = $request->input("user_id");
        $FlightService->dsr_number = $request->input("dsr_number");
        $FlightService->airline_name = $request->input("airline_name");
        $FlightService->trip_type = $request->input("trip_type");
        $FlightService->gds_portal = $request->input("gds_portal");
        $FlightService->ticket_number = $request->input("ticket_number");
        $FlightService->pnr_number = $request->input("pnr_number");
        $FlightService->travel_date = $request->input("travel_date");
        $FlightService->route = $request->input("route");
        $FlightService->supplier = $request->input("supplier");
        $FlightService->fare_price = $request->input("fare_price");
        $FlightService->tax_amount = $request->input("tax_rate");
        $FlightService->other_tax = $request->input("tax_amount");

        $FlightService->save();

        
        session()->flash('success', 'You\'ve Added Services successfully.');
        return Redirect::back();
    }

    public function addVisaService(Request $request)
    {
        
        $VisaService = new DsrVisaService;
        $VisaService->user_id = $request->input("user_id");
        $VisaService->dsr_number = $request->input("dsr_number");
        $VisaService->passenger_name = $request->input("passenger_name");
        $VisaService->passport_number = $request->input("passport_number");
        $VisaService->dob = $request->input("dob");
        $VisaService->email = $request->input("email");
        $VisaService->visa_number = $request->input("visa_number");
        $VisaService->visa_type = $request->input("visa_type");
        $VisaService->country = $request->input("country");
        $VisaService->issue_date = $request->input("issue_date");
        $VisaService->expiry_date = $request->input("expiry_date");
        $VisaService->supplier = $request->input("supplier");
        $VisaService->visa_price = $request->input("visa_price");
        $VisaService->tax_amount = $request->input("tax_rate");
        $VisaService->other_tax = $request->input("tax_amount");
       
        $VisaService->save();

        session()->flash('success', 'You\'ve Added Services successfully.');
        return Redirect::back();
    }

    public function addInsuranceService(Request $request)
    {
        
        $InsuranceService = new DsrInsuranceService;
        $InsuranceService->user_id = $request->input("user_id");
        $InsuranceService->dsr_number = $request->input("dsr_number");
        $InsuranceService->passenger_name = $request->input("passenger_name");
        $InsuranceService->company_name = $request->input("company_name");
        $InsuranceService->policy_number = $request->input("policy_number");
        $InsuranceService->issue_date = $request->input("issue_date");
        $InsuranceService->expiry_date = $request->input("expiry_date");
        $InsuranceService->insurance_price = $request->input("insurance_price");
        $InsuranceService->tax_amount = $request->input("tax_rate");
        $InsuranceService->other_tax = $request->input("tax_amount");
        
        $InsuranceService->save();

        session()->flash('success', 'You\'ve Added Services successfully.');
        return Redirect::back();
    }

    public function addOtherService(Request $request)
    {
        
        $OtherService = new DsrOtherService;
        $OtherService->user_id = $request->input("user_id");
        $OtherService->dsr_number = $request->input("dsr_number");
        $OtherService->item_details = $request->input("item_details");
        $OtherService->quantity = $request->input("quantity");
        $OtherService->price = $request->input("price");
        $OtherService->tax_amount = $request->input("tax_rate");
        $OtherService->other_tax = $request->input("tax_amount");
        
        $OtherService->save();

        session()->flash('success', 'You\'ve Added Services successfully.');
        return Redirect::back();
    }

    public function addCarhireService(Request $request)
    {
        
        $CarhireService = new CarhireService;
        $CarhireService->user_id = $request->input("user_id");
        $CarhireService->dsr_number = $request->input("dsr_number");
        $CarhireService->vehicle_type = $request->input("vehicle_type");
        $CarhireService->days = $request->input("days");
        $CarhireService->price = $request->input("price");
        $CarhireService->pickup_location = $request->input("pickup_location");
        $CarhireService->drop_location = $request->input("drop_location");
        $CarhireService->tax_rate = $request->input("tax_rate");
        $CarhireService->tax_amount = $request->input("tax_amount");
        
        $CarhireService->save();

        session()->flash('success', 'You\'ve Added Services successfully.');
        return Redirect::back();
    }

    public function addAssistService(Request $request)
    {
        
        $AssistService = new AssistService;
        $AssistService->user_id = $request->input("user_id");
        $AssistService->dsr_number = $request->input("dsr_number");
        $AssistService->airport = $request->input("airport");
        $AssistService->meeting_type = $request->input("meeting_type");
        $AssistService->person_count = $request->input("no_person");
        $AssistService->price = $request->input("price");
        $AssistService->tax_rate = $request->input("tax_rate");
        $AssistService->tax_amount = $request->input("tax_amount");
        
        $AssistService->save();

        session()->flash('success', 'You\'ve Added Services successfully.');
        return Redirect::back();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        
    }


    public function CreateQ()
    {
        
        session()->forget('cart');

        
        
          // Get the current maximum order number from the database
          $maxDsrNumber = Quotation::max('quotation_id');

          // Parse the Dsr number to get the numeric part
          $lastDsrNumber = (int) substr($maxDsrNumber, -7);
  
          // Increment the Dsr number
          $newDsrNumber = $lastDsrNumber + 1;
  
          // Pad the Dsr number with leading zeros to get the final Dsr number
          $paddedDsrNumber = str_pad($newDsrNumber, 6, '0', STR_PAD_LEFT);
  
          // Build the final Dsr ID with the series
          $series = 'NQ';
          $id = $series . '-' . $paddedDsrNumber;



        $corporate = Customer::where('approval', '=', 1)->select('*')->get();
        $cdata = Customer::where('approval', '=', 1)->get();
        $individual = IndividualCustome::where('approval', '=', 1)->get();
        $idata = IndividualCustome::where('approval', '=', 1)->get();

        

        $individual = IndividualCustome::where('approval', '=', 1)->select('*')->get();
        $corporate = Customer::where('approval', 1)->get();
        $passengers = Passengers::all();
        $hotels = Hotel::all();
        $tour = TourPackage::all();
        $room = HotelService::all();
        $flight = Flight::all();
        $visa = Visa::all();
        $insurance = Insurance::all();
        $carhire = Carhire::all();
        $assist = Assist::all();
        $insuranceplan = InsurancePlan::all();
        $other = Inventory::all();
        $taxmaster = Taxmaster::where('type', 'Sales')->get();
        $bed = RoomBed::all();
        $meal = RoomMeal::all();


        $services['hotel'] = DsrHotelService::where('dsr_number', $id)->get();
        $services['flight'] = DsrFlightService::where('dsr_number', $id)->get();
        $services['visa'] = DsrVisaService::where('dsr_number', $id)->get();
        $services['insurance'] = DsrInsuranceService::where('dsr_number', $id)->get();
        $services['other'] = DsrOtherService::where('dsr_number', $id)->get();
        //dd($emp);
        return view('quotation.createl', compact('id','cdata','idata','services','corporate','tour','bed','meal','room','taxmaster','individual','passengers','hotels', 'flight', 'visa', 'insurance', 'insuranceplan', 'other', 'carhire', 'assist'));
    }
    
    public function edits($id)
    {
          
        $quotation = Quotation::find($id);
        $quotation_id =$quotation->quotation_id;

        $corporate = Customer::where('approval', '=', 1)->select('*')->get();
        $cdata = Customer::where('approval', '=', 1)->get();
        $individual = IndividualCustome::where('approval', '=', 1)->get();
        $idata = IndividualCustome::where('approval', '=', 1)->get();

        

        $individual = IndividualCustome::where('approval', '=', 1)->select('*')->get();
        $corporate = Customer::where('approval', 1)->get();
        $passengers = Passengers::all();
        $hotels = Hotel::all();
        $tour = TourPackage::all();
        $room = HotelService::all();
        $flight = Flight::all();
        $visa = Visa::all();
        $insurance = Insurance::all();
        $carhire = Carhire::all();
        $assist = Assist::all();
        $insuranceplan = InsurancePlan::all();
        $other = Inventory::all();
        $taxmaster = Taxmaster::where('type', 'Sales')->get();
        $bed = RoomBed::all();
        $meal = RoomMeal::all();




        $services['hotel'] = Items::where('quotation_id', $quotation_id)->get();        $services['flight'] = DsrFlightService::where('dsr_number', $id)->get();
        $services['visa'] = DsrVisaService::where('dsr_number', $id)->get();
        $services['insurance'] = DsrInsuranceService::where('dsr_number', $id)->get();
        $services['other'] = DsrOtherService::where('dsr_number', $id)->get();
        //dd($emp);
        return view('quotation.edit', compact('id','quotation','cdata','idata','services','corporate','tour','bed','meal','room','taxmaster','individual','passengers','hotels', 'flight', 'visa', 'insurance', 'insuranceplan', 'other', 'carhire', 'assist'));
    }
    
     public function view($id)
    {
          
        $quotation = Quotation::find($id);
        $quotation_id =$quotation->quotation_id;


        $services['hotel'] = Items::where('quotation_id', $quotation_id)->get();
                       $taxmaster = Taxmaster::all();

        //dd($emp);
        return view('quotation.download', compact('id','quotation','services', 'taxmaster'));
    }

    public function convertToInvoice($id)
    {
        
        $Quotation = Quotation::where('quotation_id', $id)->first();

        $quotation_id= $Quotation->quotation_id;
        $customer_name= $Quotation->customer_name;
        $subtotal= $Quotation->subtotal;
        $shipping_charge= $Quotation->shipping_charge;
        $adjustment_charge= $Quotation->adjustment_charge;
        $total= $Quotation->total;
        $tax_type= $Quotation->tax_type;

        do {
           
            $invoice_no=rand(100000,999999);

            $records=DB::table('invoice')
                   ->where('invoice_no',$invoice_no)
                   ->exists();     
                   
           
         } while ($records ==1);

        $Invoice = new Invoice;
        $Invoice->invoice_no = $invoice_no;
        $Invoice->dsr_number = $quotation_id;
        $Invoice->invoice_to = $customer_name;
        $Invoice->subtotal = $subtotal;
        $Invoice->shipping_charge = $shipping_charge;
        $Invoice->adjustment_charge = $adjustment_charge;
        $Invoice->total = $total;
        $Invoice->status = 0;
        $Invoice->type = "Regular";
        $Invoice->save();

        $items=Items::where('quotation_id', $id)->get();

        // items Services
        foreach ($items as $data) {
            $description=$data->item_details;
            $quantity=$data->quantity;
            $vat=$data->tax_rate;
            $price=$data->rate;
            $amount=$data->total;


            $InvoiceServices = new InvoiceServices();
            $InvoiceServices->invoice_id = $invoice_no;
            $InvoiceServices->description = $description;
            $InvoiceServices->quantity = $quantity;
            $InvoiceServices->vat = $vat;
            $InvoiceServices->price = $price;
            $InvoiceServices->amount = $amount;
            $InvoiceServices->save();
        }
        
        session()->flash('success', 'Converted to Invoice Successfully');
        return Redirect::back();
    }

    public function convertToProforma($id)
    {
        
        $Quotation = Quotation::where('quotation_id', $id)->first();

        $quotation_id= $Quotation->quotation_id;
        $customer_name= $Quotation->customer_name;
        $subtotal= $Quotation->subtotal;
        $shipping_charge= $Quotation->shipping_charge;
        $adjustment_charge= $Quotation->adjustment_charge;
        $total= $Quotation->total;

        do {
           
            $proforma_no=rand(100000,999999);

            $records=DB::table('invoice')
                   ->where('invoice_no',$proforma_no)
                   ->exists();     
                   
           
         } while ($records ==1);

         $maxDsrNumber = Proforma::max('proforma_id');
         $lastDsrNumber = (int) substr($maxDsrNumber, -7);
         $newDsrNumber = $lastDsrNumber + 1;
         $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);
         $series = 'PFM';
         $proforma_id = $series . '-' . $paddedDsrNumber; 

        $Proforma = new Proforma;
        $Proforma->proforma_no = $proforma_no;
        $Proforma->proforma_id = $proforma_id;
        $Proforma->customer_name = $customer_name;
        $Proforma->subtotal = $subtotal;
        $Proforma->shipping_charge = $shipping_charge;
        $Proforma->adjustment_charge = $adjustment_charge;
        $Proforma->total = $total;
        $Proforma->status = 1;
        $Proforma->save();

        $items=Items::where('quotation_id', $id)->get();

        // items Services
        foreach ($items as $data) {
            $description=$data->item_details;
            $quantity=$data->quantity;
            $vat=$data->tax_rate;
            $tax_amount=$data->tax_amount;
            $discount=$data->discount;
            $price=$data->rate;
            $amount=$data->total;
            
            $ProformaServices = new Items();
            $ProformaServices->quotation_id = $proforma_id;
            $ProformaServices->item_details = $description;
            $ProformaServices->quantity = $quantity;
            $ProformaServices->discount = $discount;
            $ProformaServices->tax_rate = $vat;
            $ProformaServices->tax_amount = $tax_amount;
            $ProformaServices->rate = $price;
            $ProformaServices->total = $amount;
            $ProformaServices->save();


            // $ProformaServices = new ProformaServices();
            // $ProformaServices->proforma_no = $proforma_no;
            // $ProformaServices->item_description = $description;
            // $ProformaServices->quantity = $quantity;
            // $ProformaServices->vat = $vat;
            // $ProformaServices->rate = $price;
            // $ProformaServices->total = $amount;
            // $ProformaServices->save();
        }
        
        session()->flash('success', 'Converted to Proforma Successfully');
        return Redirect::back();
    }


    public function Passenger($id)
    {

        $corporate = Customer::where('approval', '=', 1)->select('*')->get();
        $cdata = Customer::where('approval', '=', 1)->get();
        $individual = IndividualCustome::where('approval', '=', 1)->get();
        $idata = IndividualCustome::where('approval', '=', 1)->get();

        $pass = Quotation::find($id);
        $customer_type= $pass->customer_type;
        $customer_id= $pass->customer_id;

        if($customer_type=="Corporate"){

            $users = Customer::where('id', $customer_id)->first();


            // $users = Mice::join('customers', 'mice.customer_name', '=', 'customers.company_name')
            // ->select('mice.*', 'customers.phone', 'customers.email')
            // ->where('mice.id', $id)
            // ->first();
        }
        elseif($customer_type=="Individual") {

            $users = IndividualCustome::where('id', $customer_id)->first();

            // $users = Mice::join('individual_customer', 'mice.customer_name', '=', 'individual_customer.first_name')
            // ->select('mice.*', 'individual_customer.phone', 'individual_customer.email')
            // ->where('mice.id', $id)
            // ->first();

        }        

        $dsrno= $pass->quotation_id;

        $individual = IndividualCustome::where('approval', '=', 1)->select('*')->get();
        $corporate = Customer::where('approval', 1)->get();
        $passengers = Passengers::all();
        $hotels = Hotel::all();
        $tour = TourPackage::all();
        $room = HotelService::all();
        $flight = Flight::all();
        $visa = Visa::all();
        $insurance = Insurance::all();
        $insuranceplan = InsurancePlan::all();
        $other = Inventory::all();
        $taxmaster = Taxmaster::all();
        $bed = RoomBed::all();
        $meal = RoomMeal::all();


        $services['hotel'] = DsrHotelService::where('dsr_number', $dsrno)->get();
        $services['flight'] = DsrFlightService::where('user_id', $id)->get();
        $services['visa'] = DsrVisaService::where('user_id', $id)->get();
        $services['insurance'] = DsrInsuranceService::where('user_id', $id)->get();
        $services['other'] = DsrOtherService::where('user_id', $id)->get();
        //dd($emp);
        return view('quotation.passenger', compact('cdata','idata','services','corporate','tour','bed','meal','room','taxmaster','pass','individual','passengers','users','hotels', 'flight', 'visa', 'insurance', 'insuranceplan', 'other'));
    }

    public function services($id)
{
    $services['hotel'] = DsrHotelService::where('user_id', $id)->get();
    $services['flight'] = DsrFlightService::where('user_id', $id)->get();
    $services['visa'] = DsrVisaService::where('user_id', $id)->get();
    $services['insurance'] = DsrInsuranceService::where('user_id', $id)->get();
    $services['other'] = DsrOtherService::where('user_id', $id)->get();

    $count['hotel'] = DsrHotelService::where('user_id', $id)->count();
    $count['flight'] = DsrFlightService::where('user_id', $id)->count();
    $count['visa'] = DsrVisaService::where('user_id', $id)->count();
    $count['insurance'] = DsrInsuranceService::where('user_id', $id)->count();
    $count['other'] = DsrOtherService::where('user_id', $id)->count();


    $pass=Passengers::where('user_id', $id)->first();
    $dsrno= $pass->dsr_number;

        $individual = IndividualCustome::where('approval', '=', 1)->select('*')->get();
        $corporate = Customer::where('approval', 1)->get();
        $passengers = Passengers::where('dsr_number', $dsrno)->get();
        $family = MiceFamily::where('user_id', $id)->get();
        $hotels = Hotel::all();
        $tour = TourPackage::all();
        $room = HotelService::all();
        $flight = Flight::all();
        $visa = Visa::all();
        $insurance = Insurance::all();
        $insuranceplan = InsurancePlan::all();
        $other = Inventory::all();
        $taxmaster = Taxmaster::all();
        $bed = RoomBed::all();
        $meal = RoomMeal::all();
        //dd($emp);
        return view('mice.services', compact('family','count','services', 'corporate','tour','bed','meal','room','taxmaster','pass','individual','passengers','hotels', 'flight', 'visa', 'insurance', 'insuranceplan', 'other'));


    // return view('mice.services', ['services' => $services], 'corporate','tour','bed','meal','room','taxmaster','pass','individual','passengers','users','hotels', 'flight', 'visa', 'insurance', 'insuranceplan', 'other');
}






public function download($id){

    $quotation = Quotation::find($id);
        $quotation_id =$quotation->quotation_id;


        $services['hotel'] = Items::where('quotation_id', $quotation_id)->get();
                $taxmaster = Taxmaster::all();

        // return view('quotation.download', compact('id','quotation','services'));
    
    // return view('quotation.download', compact('data', 'passengers', 'hotels', 'flights', 'visas', 'insurances', 'others'));
    
    $pdf = PDF::loadView('quotation.download', compact('id','quotation','services', 'taxmaster'));
    
     // Get the path to the JavaScript file
    $jsFilePath = public_path('assets/custom.js');

    // Attach the JavaScript file to the PDF
    $pdf->getDomPDF()->getOptions()->set('enable_javascript', true);
    $pdf->getDomPDF()->getOptions()->set('javascript_delay', 1000); // Delay execution to allow for rendering
    $pdf->getDomPDF()->getOptions()->set('enable_php', true);
    $pdf->getDomPDF()->getOptions()->set('is_php_enabled', true);
    $pdf->getDomPDF()->getOptions()->set('enable_remote', true);
    $pdf->getDomPDF()->getOptions()->set('pdf_script_url', $jsFilePath);
    
return $pdf->download('quotation.pdf');


    
}

public function summaryd($id){

    // $data="MICE-0000001";
    $passengers = Passengers::where('dsr_number', $id)->get();
    $guests = MiceFamily::all();
    $hotels = DsrHotelService::all();
    $tours = DsrTourService::all();
    $flights = DsrFlightService::all();
    $visas = DsrVisaService::all();
    $insurances = DsrInsuranceService::all();
    $others = DsrOtherService::all();
    
    
    $view = View::make('mice.summ', compact('id', 'passengers', 'guests', 'hotels', 'flights', 'visas', 'insurances', 'others'));
    $html = $view->render();

    // $options = new \Dompdf\Options();
    // $options->set('isRemoteEnabled', true);
    $dompdf = new \Dompdf\Dompdf();

    // Set base path for images
    $base_path = public_path(); // Replace with your base path
    $dompdf->set_base_path($base_path);

    
    // Create PDF
    // $dompdf = new Dompdf();
    $dompdf->loadHtml($html);
    $dompdf->setPaper('A4', 'portrait');
    $dompdf->render();
    // Output PDF to browser
    $dompdf->stream('invoice.pdf');
    // $dompdf->output();

}

public function summary1d($id){

    $passengers = Passengers::where('user_id', $id)->first();
    $guests = MiceFamily::where('user_id', $id)->get();
    $hotels = DsrHotelService::all();
    $tours = DsrTourService::all();
    $flights = DsrFlightService::all();
    $visas = DsrVisaService::all();
    $insurances = DsrInsuranceService::all();
    $others = DsrOtherService::all();
    
    
    $view = View::make('mice.summary1', compact('id','passengers', 'guests', 'hotels', 'flights', 'visas', 'insurances', 'others'));
    $html = $view->render();

    // $options = new \Dompdf\Options();
    // $options->set('isRemoteEnabled', true);
    $dompdf = new \Dompdf\Dompdf();

    // Set base path for images
    $base_path = public_path(); // Replace with your base path
    $dompdf->set_base_path($base_path);

    
    // Create PDF
    // $dompdf = new Dompdf();
    $dompdf->loadHtml($html);
    $dompdf->setPaper('A4', 'portrait');
    $dompdf->render();
    // Output PDF to browser
    $dompdf->stream('invoice.pdf');
    // $dompdf->output();

}


    public function hotelServices($id)
    {

        $services = DsrHotelService::where('user_id', $id)->get();
        return view('dsr.hotelservice', compact('services'));
    }



    public function drop_data(Request $request)
    {
        // Get the selected dropdown value from the request
        $selectedValue = $request->input('selected_value');

        // Query the database to get the data based on the selected value
        $data = IndividualCustome::where('id', $selectedValue)->get();

        // Return the data as a JSON response
        return response()->json(['data' => $data]);
    }

    public function corporate_data(Request $request)
    {
        // Get the selected dropdown value from the request
        $selectedValue = $request->input('selected_value');

        // Query the database to get the data based on the selected value
        $data = Customer::where('id', $selectedValue)->get();

        // Return the data as a JSON response
        return response()->json(['data' => $data]);
    }

    public function roomno_data(Request $request)
    {
        // Get the selected dropdown value from the request
        $selectedValue = $request->input('selected_value');
        $hotel = Hotel::where('hotel_name', $selectedValue)->first();
        $hotel_id=$hotel->id;

        // Query the database to get the data based on the selected value
        $data = HotelService::where('hotel_id', $hotel_id)->get();

        // Return the data as a JSON response
        return response()->json(['data' => $data]);
    }

    public function insurance_data(Request $request)
    {
        // Get the selected dropdown value from the request
        $selectedValue = $request->input('selected_value');
        $insurance = Insurance::where('company_name', $selectedValue)->first();
        $insurance_id=$insurance->id;

        // Query the database to get the data based on the selected value
        $data = InsurancePlan::where('insurance_id', $insurance_id)->get();

        // Return the data as a JSON response
        return response()->json(['data' => $data]);
    }

    public function room_data(Request $request)
    {
        // Get the selected dropdown value from the request
        $selectedValue = $request->input('selected_value');
        $data = HotelService::where('room_name_number', $selectedValue)->first();

        // Return the data as a JSON response
        return response()->json(['data' => $data]);
    }

    public function visa_data(Request $request)
    {
        // Get the selected dropdown value from the request
        $selectedValue = $request->input('selected_value');

        // Query the database to get the data based on the selected value
        $data = IndividualCustome::where('first_name', $selectedValue)->first();

        // Return the data as a JSON response
        return response()->json(['data' => $data]);
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function edit()
    {
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {

        $type=$request->input("customer_type");
        if ($type=="Corporate") {
            $customer_id = $request->input("corporate_id");
            $customer_name = $request->input("select_company_name");

        }
        elseif ($type=="Individual") {
            $customer_id = $request->input("individual_id");
            $customer_name = $request->input("select_individual_name");
        }
        elseif ($type=="New") {
            $customer_id = 0;
            $customer_name = $request->input("customer_name");
            $email = $request->input("email");
            $phone = $request->input("mobile");
            $address = $request->input("address");

            
        }
            $id = $request->input("id");

        $Quotation = Quotation::find($id);

        if ($request->file('quotation_file')) {
            $photo = $request->file('quotation_file');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $Quotation->file = $filename;
        }

        $Quotation->customer_type = $request->input("customer_type");
        $Quotation->customer_id = $customer_id;
        $Quotation->customer_name = $customer_name;
        $Quotation->currency = $request->input("currency");
        $Quotation->quotation_date = $request->input("quotation_date");
        $Quotation->expiry_date = $request->input("expiry_date");
        $Quotation->reference_no = $request->input("reference_no");
        $Quotation->customer_note = $request->input("customer_note");
        $Quotation->terms = $request->input("terms");
        $Quotation->subtotal = $request->input("subtotal");
        $Quotation->shipping_charge = $request->input("shipping_charge");
        $Quotation->adjustment_charge = $request->input("adjustment_charge");
        $Quotation->total = $request->input("quotation_total");
        $Quotation->save();

       $quantity = $request->input("quantity");

foreach($quantity as $key => $value) {
    $id= $request->input("itm-id")[$key];
    $Items = Items::find($id);
    $Items->item_details = $request->input("item_details")[$key];
    $Items->quantity = $request->input("quantity")[$key];
    $Items->rate = $request->input("rate")[$key];
    $Items->discount = $request->input("discount")[$key];
    $Items->tax_rate = $request->input("tax_rate")[$key];
    $Items->tax_amount = $request->input("tax_amount")[$key];
    $Items->total = $request->input("total")[$key];

    $Items->save();
}
        

        session()->flash('success', 'You\'ve Updated Quotation Successfully');
        return redirect()->route('Quotation');
        
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    
     public function deleteItem($type, $id)
     {
        if ($type=="hotel") {

            $item = DsrHotelService::find($id);
            $item->delete();
            return Redirect::back();

        }
        elseif ($type=="flight") {
            $item = DsrFlightService::find($id);
            $item->delete();
            return Redirect::back();
        }
        elseif ($type=="visa") {
            $item = DsrVisaService::find($id);
            $item->delete();
            return Redirect::back();
        }
        elseif ($type=="insurance") {
            $item = DsrInsuranceService::find($id);
            $item->delete();
            return Redirect::back();
        }
        elseif ($type=="other") {
            $item = DsrOtherService::find($id);
            $item->delete();
            return Redirect::back();
        }
         
 
     }

     public function destroy($id)
    {
        $Dsr = Quotation::find($id);
        $item_id= $Dsr->quotation_id;
        
        if($Dsr){
           $Item = Items::where('quotation_id', $item_id)->get();
           foreach($Item as $data){
               $data->delete();
           }
            
        }
        $Dsr->delete();
        
        session()->flash('success', 'Quotation deleted successfully.');  
        return Redirect::back();

    }


}
