<?php

namespace App\Http\Controllers\Master;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Master\Benefits;
use Illuminate\Support\Facades\Redirect;

class BenefitsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //
        $benefits = Benefits::orderBy('id', 'DESC')->get();
        //dd($hotel);
        return view('master.benefits.index', compact('benefits'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $cat = new Benefits;
        $cat->benefits = $request->input("benefits");
        $cat->save();
        session()->flash('success', 'You\'ve Added Benefits successfully.');
        
        return Redirect::back();
    }
    function status_update($id)
    {
        echo "here we are";
        
        //get product status with the help of product ID
        $srvice = Category::select('status')
            ->where('id', '=', $id)
            ->first();

        //dd($customer);

        //Check user status
        if ($srvice->status == 'Active') {
            $status = 'Inactive';
        } else {
            $status = 'Active';
        }

        //update product status
        $values = array('status' => $status);
        //dd($values);
        Category::where('id', $id)->update($values);

        session()->flash('success', 'You\'ve Changed Status successfully.');
        
        return Redirect::back();
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    
     public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $hservice = Benefits::find($id);
        //dd($emp);
        return response()->json([
            'status' => 200,
            'category' => $hservice,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        //
        $id = $request->input('cat_id');
        $cat = Benefits::find($id);
        $cat->category_name = $request->input("cat_name");
        $cat->update();
        session()->flash('success', 'You\'ve Updated Benefits successfully.');
        
        return Redirect::back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $cat = Benefits::find($id);
        $cat->delete();
        session()->flash('success', 'You\'ve Deleted Benefits successfully.');
        
        return Redirect::back();
    }

}
