<?php

namespace App\Http\Controllers\Inventory;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Inventory\Inventory;
use Illuminate\Support\Facades\Redirect;
use App\Models\Taxmaster\Taxmaster;
use App\Models\Account\Account;
use App\Models\Category\Category;

class InventoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if(session('inventoryfilter'))
        {
            $inventory = Inventory::orderBy('id', 'DESC')->where('category','=',session('inventoryfilter'))->get();
            
            $category = Category::select('*')->get();
            return view('inventory.index', compact('inventory','category'))
                ->with('i', ($request->input('page', 1) - 1) * 5);
        }
        else{
            $inventory = Inventory::orderBy('id', 'DESC')->get();
            
            $category = Category::select('*')->get();
            return view('inventory.index', compact('inventory','category'))
                ->with('i', ($request->input('page', 1) - 1) * 5);
        }

    }
    function gettablelist(Request $request){

        $field=$request->input('filtervalue');
        
        session()->flash('inventoryfilter', $field);
        
        return "success";
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $taxmaster = Taxmaster::select('*')->get();
        $parent = Account::select('*')->get();
        //dd($parent);
        $account = Account::all();
        $category = Category::select('*')->get();
        $acc = Account::whereNull('account_id')->get();
        return view('inventory.create',compact('taxmaster','parent','account','category','acc'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $inventory = new Inventory;
        $inventory->item_name = $request->input("item_name");
        $inventory->sku = $request->input("sku");
        $inventory->hsn = $request->input("hsn_code");
        $inventory->unit = $request->input("unit");
        $inventory->display_value = $request->input("display_value");
        $inventory->category = $request->input("category");
        $inventory->initial_quantity = $request->input("initial_quantity");
        $inventory->as_of_date = $request->input("as_of_date");
        $inventory->inventory_asset_account	= $request->input("inventory_asset_account");
        $inventory->description	= $request->input("description");
        $inventory->sales_price = $request->input("sales_price");
        $inventory->income_account = $request->input("income_account");
        $inventory->inclusive_of_tax = $request->input("inclusive_of_tax");
        $inventory->tax = $request->input("tax");
        $inventory->save();
        session()->flash('success', 'You\'ve added Inventory successfully.');
        
        return redirect()->route('inventory.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $inv = Inventory::find($id);
        //dd($emp);
        $taxmaster = Taxmaster::select('*')->get();
        $parent = Account::select('*')->get();
        //dd($parent);
        $account = Account::all();
        $acc = Account::whereNull('account_id')->get();
        $category = Category::select('*')->get();
        return view('inventory.show', compact('inv','taxmaster','parent','account','acc','category'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $inv = Inventory::find($id);
        //dd($emp);
        $taxmaster = Taxmaster::select('*')->get();
        $parent = Account::select('*')->get();
        //dd($parent);
        $account = Account::all();
        $acc = Account::whereNull('account_id')->get();
        $category = Category::select('*')->get();;
        
        return view('inventory.edit', compact('inv','taxmaster','parent','account','acc','category'));
    }
    

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function update($id, Request $request)
    {
        $inventory = Inventory::find($id);
        $inventory->item_name = $request->input("item_name");
        $inventory->sku = $request->input("sku");
        $inventory->hsn = $request->input("hsn_code");
        $inventory->unit = $request->input("unit");
        $inventory->display_value = $request->input("display_value");
        $inventory->category = $request->input("category");
        $inventory->initial_quantity = $request->input("initial_quantity");
        $inventory->as_of_date = $request->input("as_of_date");
        $inventory->inventory_asset_account	= $request->input("inventory_asset_account");
        $inventory->description	= $request->input("description");
        $inventory->sales_price = $request->input("sales_price");
        $inventory->income_account = $request->input("income_account");
        $inventory->inclusive_of_tax = $request->input("inclusive_of_tax");
        $inventory->tax = $request->input("tax");
        $inventory->save();
        session()->flash('success', 'You\'ve updated Inventory successfully.');
        
        return Redirect::back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $emp = Inventory::find($id);
        $emp->delete();
        return Redirect::back()->withErrors(['msg' => 'The Message']);
    }
}
