<?php

namespace App\Http\Controllers\InsurancePlan;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\InsurancePlan\InsurancePlan;
use Illuminate\Support\Facades\Redirect;

class InsurancePlanController extends Controller
{
    public function index(Request $request)
    {
        $insurance = InsurancePlan::orderBy('id', 'DESC')->get();
        //dd($hotel);
        return view('insurance.index', compact('insurance'))
            ->with('i', ($request->input('page', 1) - 1) * 5);
    }


    function status_update($id)
    {
        
        return Redirect::back();
        //get product status with the help of product ID
        $plan = InsurancePlan::select('status')
            ->where('id', '=', $id)
            ->first();

        //dd($customer);

        //Check user status
        if ($plan->status == 'Active') {
            $status = 'Inactive';
        } else {
            $status = 'Active';
        }

        //update product status
        $values = array('status' => $status);
        //dd($values);
        InsurancePlan::where('id', $id)->update($values);

        session()->flash('success', 'You\'ve Change Status Successfully');

        return Redirect::back();
    }


    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        $insuranceplan = new InsurancePlan;
        $insuranceplan->insurance_id = $request->input("insurance_id");
        $insuranceplan->plan_name = $request->input("plan_name");
        $insuranceplan->select_days_years = $request->input("select_days_years");
        $insuranceplan->currency = $request->input("currency");
        $insuranceplan->price = $request->input("price");
        $insuranceplan->description = $request->input("description");
        $insuranceplan->status = $request->input("status") ? "Active" : "Inactive";
        $insuranceplan->save();
        session()->flash('success', 'You\'ve Added Plan Successfully');

        return Redirect::back();
    }

    public function show()
    {
        //
    }


    public function edit($id)
    {
        $insuranceplan = InsurancePlan::find($id);
        //dd($emp);
        return response()->json([
            'status' => 200,
            'insplan' => $insuranceplan,
        ]);
    }


    public function update(Request $request)
    {
        $id = $request->input('insplan_id');
        $insuranceplan = InsurancePlan::find($id);
        $insuranceplan->plan_name = $request->input("plan_name");
        $insuranceplan->select_days_years = $request->input("select_days_years");
        $insuranceplan->currency = $request->input("currency");
        $insuranceplan->price = $request->input("price");
        $insuranceplan->description = $request->input("description");
        $insuranceplan->status = $request->input("status") ? "Active" : "Inactive";
        $insuranceplan->update();
        session()->flash('success', 'You\'ve Updated Plan Successfully');

        return Redirect::back();
    }

    public function destroy($id)
    {
        $insuranceplan = InsurancePlan::find($id);
        $insuranceplan->delete();
        session()->flash('success', 'You\'ve Deleted Plan Successfully');

        return Redirect::back();
    }
}
