<?php

namespace App\Http\Controllers\Flight;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Flight\Flight;
use Illuminate\Support\Facades\Redirect;

class FlightController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $flight = Flight::orderBy('id', 'DESC')->get();
        //dd($hotel);
        return view('flight.index', compact('flight'))
            ->with('i', ($request->input('page', 1) - 1) * 5);
    }


    function status_update($id)
    {
        return Redirect::back();
        //get product status with the help of product ID
        $srvice = Flight::select('status')
            ->where('id', '=', $id)
            ->first();

        //dd($customer);

        //Check user status
        if ($srvice->status == 'Active') {
            $status = 'Inactive';
        } else {
            $status = 'Active';
        }

        //update product status
        $values = array('status' => $status);
        //dd($values);
        Flight::where('id', $id)->update($values);

        session()->flash('success', 'You\'ve Changed Status successfully.');
        
        return Redirect::back();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $flight = new Flight;
        $flight->flight_name = $request->input("flight_name");
        if($request->input('status')){
            $flight->status="Active";

        }
        else{
            $flight->status="Inactive";
            
        }
        $flight->save();
        session()->flash('success', 'You\'ve Added Flight successfully.');
        
        return Redirect::back();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function show()
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $hservice = Flight::find($id);
        //dd($emp);
        return response()->json([
            'status' => 200,
            'flight' => $hservice,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        $id = $request->input('flight_id');
        $flight = Flight::find($id);
        $flight->flight_name = $request->input("flight_name");
        if($request->input('status')){
            $flight->status="Active";

        }
        else{
            $flight->status="Inactive";
            
        }
        $flight->update();
        session()->flash('success', 'You\'ve Updated Flight successfully.');
        
        return Redirect::back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $flight = Flight::find($id);
        $flight->delete();
        session()->flash('success', 'You\'ve Deleted Flight successfully.');
        
        return Redirect::back();
    }
}