<?php

namespace App\Http\Controllers\Expense;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\View;

use App\Models\Account\Account;
use App\Models\DSR\DSR;
use App\Models\DSR\DsrHotelService;
use App\Models\DSR\DsrTourService;
use App\Models\DSR\DsrFlightService;
use App\Models\DSR\DsrVisaService;
use App\Models\DSR\DsrServicePassenger;
use App\Models\DSR\DsrInsuranceService;
use App\Models\DSR\DsrOtherService;
use App\Models\DSR\CarhireService;
use App\Models\DSR\AssistService;
use App\Models\Passengers\Passengers;
use App\Models\Hotel\Hotel;
use App\Models\Flight\Flight;
use App\Models\Visa\Visa;
use App\Models\Insurance\Insurance;
use App\Models\InsurancePlan\InsurancePlan;
use App\Models\Inventory\Inventory;
use App\Models\HotelService\HotelService;
use App\Models\TourPackage\TourPackage;
use App\Models\HotelServices\RoomBed;
use App\Models\HotelServices\RoomMeal;
use App\Models\Customer\Customer;
use App\Models\Taxmaster\Taxmaster;
use App\Models\Items\Items;
use App\Models\Invoice\Invoice;
use App\Models\Invoice\InvoiceServices;
use App\Models\Proforma\Proforma;
use App\Models\Assist\Assist;
use App\Models\Carhire\Carhire;
use App\Models\Supplier\Supplier;
use App\Models\Proforma\ProformaServices;
use App\Models\Individual\IndividualCustome;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Facades\Redirect;
use App\Models\Transaction\Transaction;

use App\Models\Expense\Expense;

class ExpenseController extends Controller
{
    public function index()
    {
        $dsr = Expense::all();
        $account = Account::all();
        return view('expense.index', compact('dsr', 'account'));
    }

    public function create()
    {
        $account = Account::all();
        $supplier = Supplier::all();
        return view('expense.create', compact('account', 'supplier'));
    }
    
    public function view($id)
    {
        $expense = Expense::find($id);
        $account = Account::all();
        $supplier = Supplier::all();
        return view('expense.view', compact('expense', 'account', 'supplier'));
    }

    public function store(Request $request)
    {
          // Get the current maximum order number from the database
        $maxDsrNumber = Expense::max('expense_id');
        // Parse the Dsr number to get the numeric part
        $lastDsrNumber = (int) substr($maxDsrNumber, -7);
        // Increment the Dsr number
        $newDsrNumber = $lastDsrNumber + 1;
        // Pad the Dsr number with leading zeros to get the final Dsr number
        $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);
        // Build the final Dsr ID with the series
        $series = 'Exp';
        $dsr_number = $series . '-' . $paddedDsrNumber;


        $Payments = new Expense;

        // if ($request->file('Payments_file')) {
        //     $photo = $request->file('Payments_file');
        //     $filename = time() . '.' . $photo->getClientOriginalExtension();
        //     $path = public_path('uploads');
        //     $photo->move($path, $filename);
        //     $Payments->file = $filename;
        // }

        $Payments->expense_id = $dsr_number;
        $Payments->expense_account = $request->input("expense_account");
        $Payments->paid_through = $request->input("paid_through");
        // $Payments->customer_type = $request->input("customer_type");
        // $Payments->customer_id = $request->input("customer_id");
        // $Payments->customer_name = $request->input("customer_name");
        $Payments->date = $request->input("payment_date");
        $Payments->invoice = $request->input("invoice");
        $Payments->reference_no = $request->input("invoice");
        $Payments->amount = $request->input("amount");
        $Payments->supplier = $request->input("supplier");
        $Payments->notes = $request->input("notes");
        
        if ($request->file('attachment')) {
            $photo = $request->file('attachment');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $Payments->file = $filename;
        } 
        
        $Payments->save();

        $maxDsrNumber = Transaction::max('transaction_id');
        $lastDsrNumber = (int) substr($maxDsrNumber, -7);
        $newDsrNumber = $lastDsrNumber + 1;
        $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);
        $series = 'Txn';
        $txn_id = $series . '-' . $paddedDsrNumber;
        
        $amount = $request->input("amount");
        $account_id= $request->input("paid_through");
        $date= date('Y-m-d');

        $account = Account::find($account_id);
        $balance= $account->balance;
        $balance= $balance-$amount;
        $account->balance = $balance;
        $account->save();
        
        $transaction = new Transaction;
        $transaction->transaction_id =$txn_id;
        $transaction->date = $date;
        $transaction->account_id = $account_id;
        $transaction->transaction_type = 'Expense';
        $transaction->credit = $amount;
        $transaction->save();
        
        $maxDsrNumber = Transaction::max('transaction_id');
        $lastDsrNumber = (int) substr($maxDsrNumber, -7);
        $newDsrNumber = $lastDsrNumber + 1;
        $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);
        $series = 'Txn';
        $txn_id = $series . '-' . $paddedDsrNumber;
        
        $amount = $request->input("amount");
        $account_id= $request->input("expense_account");
        $date= date('Y-m-d');

        $account = Account::find($account_id);
        $balance= $account->balance;
        $balance= $balance-$amount;
        $account->balance = $balance;
        $account->save();
        
        $transaction = new Transaction;
        $transaction->transaction_id =$txn_id;
        $transaction->date = $date;
        $transaction->account_id = $account_id;
        $transaction->transaction_type = 'Expense';
        $transaction->credit = $amount;
        $transaction->save();
        
        return redirect()->route('Expense');
                
    }

}
