<?php

namespace App\Http\Controllers\Document;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Document\Document;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Facades\Redirect;

class DocumentController extends Controller
{
    public function index()
    {
        return Document::all();
    }


    public function create()
    {
        //
    }



    public function store(Request $request)
    {
        $document = new Document;
        $document->passport_number = $request->input("passport_number");
        $document->passport_issue_date = $request->input("passport_issue_date");
        $document->passport_expiry_date = $request->input("passport_expiry_date");

        if ($request->file('passport')) {
            $passport = $request->file('passport');
            $filename = time() . '.' . $passport->getClientOriginalExtension();
            $path = public_path('uploads');
            $passport->move($path, $filename);
            $document->passport = $filename;
        }

        $document->goverment_id_number = $request->input("goverment_id_number");
        $document->goverment_issue_date = $request->input("goverment_issue_date");
        $document->goverment_expiry_date = $request->input("goverment_expiry_date");

        if ($request->file('government_id')) {
            $government_ID = $request->file('government_id');
            $filename = time() . '.' . $government_ID->getClientOriginalExtension();
            $path = public_path('uploads');
            $government_ID->move($path, $filename);
            $document->government_ID = $filename;
        }

        if ($request->file('resume')) {
            $resume = $request->file('resume');
            $filename = time() . '.' . $resume->getClientOriginalExtension();
            $path = public_path('uploads');
            $resume->move($path, $filename);
            $document->resume = $filename;
        }

        $document->other_document_name = $request->input("other_document_name");

        if ($request->file('other_documents')) {
            $other_Documents = $request->file('other_documents');
            $filename = time() . '.' . $other_Documents->getClientOriginalExtension();
            $path = public_path('uploads');
            $other_Documents->move($path, $filename);
            $document->other_Documents = $filename;
        }

        if (($request->file('other_documents')) !== null) {
            $document->other_Documents = $request->file("other_Documents")->store('uploads');
        }

        $document->save();
        Alert::success('Congrats', 'You\'ve Created Medical history created Successfully');
        return Redirect::back()->withErrors(['msg' => 'The Message']);
    }

    public function show()
    {
        //
    }


    public function edit()
    {
    }


    public function update($id, Request $request)
    {

        $document = Document::find($id);
        $document->passport_number = $request->input("passport_number");
        $document->passport_issue_date = $request->input("passport_issue_date");
        $document->passport_expiry_date = $request->input("passport_expiry_date");
        $document->type = $request->input("type");

        if (($request->file('passport')) !== null) {
            $document->passport = $request->file('passport')->store('uploads');
        }


        $document->goverment_id_number = $request->input("goverment_id_number");
        $document->goverment_issue_date = $request->input("goverment_issue_date");
        $document->goverment_expiry_date = $request->input("goverment_expiry_date");

        if (($request->file('government_id')) !== null) {
            $document->government_ID = $request->file("government_id")->store('uploads');
        }

        if (($request->file('resume')) !== null) {
            $document->resume = $request->file("resume")->store('uploads');
        }

        $document->other_document_name = $request->input("other_document_name");

        if (($request->file('other_documents')) !== null) {
            $document->other_Documents = $request->file("other_Documents")->store('uploads');
        }

        $document->save();
        return $document;
    }

    public function destroy($id)
    {
        $result = Document::where('id', $id)->delete();
        if ($result) {
            return ["result" => "Data has been deleted"];
        }
    }
}
