<?php

namespace App\Http\Controllers\Customer;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use App\Models\Customer\Customer;
use App\Models\BankDetails\BankDetails;
use Illuminate\Support\Facades\Redirect;

class CustomerController extends Controller
{

    public function index(Request $request)
    {
        $customer = Customer::where('approval', 1 )->get();
        return view('customer.index', compact('customer'));
    }


    public function create()
    {
        return view('customer.create');
    }

    public function store(Request $request)
    {
        $email = $request->input('email');
        $phone = $request->input('phone');

        $record = Customer::where('email', '=', $email)->orWhere('phone', '=', $phone)->first();

        if ($record) {
         
         return redirect()->route('customer.index')->with('error', 'Email Or Mobile already exist');;

        } 
        
        else {
            
 
        
        $customer = new Customer;
        $customer->company_name = $request->input("company_name");
        $customer->display_name = $request->input("display_name");
        $customer->email = $request->input("email");
        $customer->phone = $request->input("phone");
        $customer->mobile = $request->input("mobile");
        $customer->other = $request->input("other");
        $customer->website = $request->input("website");
        $customer->registration_type = $request->input("registration_type");
        $customer->registration_number = $request->input("registration_number");
        $customer->contact_person_name = $request->input("contact_person_name");
        $customer->contact_person_number = $request->input("contact_person_number");

        $customer->billing_address_line_1 = $request->input("billing_address_line_1");
        $customer->billing_address_line_2 = $request->input("billing_address_line_2");
        $customer->billing_city_town = $request->input("billing_city_town");
        $customer->billing_state_province = $request->input("billing_state_province");
        $customer->billing_country = $request->input("billing_country");
        $customer->billing_pincode = $request->input("billing_pincode");

        $customer->office_address_line_1 = $request->input("office_address_line_1");
        $customer->office_address_line_2 = $request->input("office_address_line_2");
        $customer->office_city_town = $request->input("office_city_town");
        $customer->office_state_province = $request->input("office_state_province");
        $customer->office_country = $request->input("office_country");
        $customer->office_pincode = $request->input("office_pincode");

        $customer->payment_method = $request->input("payment_method");
        $customer->terms = $request->input("terms");
        $customer->credit_limit = $request->input("credit_limit");
        $customer->payment_currency = $request->input("payment_currency");

        // $customer->bank_name = $request->input("bank_name");
        // $customer->account_number = $request->input("account_number");
        // $customer->iban_number = $request->input("iban_number");
        // $customer->bank_code = $request->input("bank_code");
        // $customer->swift_code = $request->input("swift_code");
        // $customer->currency = $request->input("currency");
        // $customer->bank_branch = $request->input("bank_branch");

        $customer->tax_registration_number = $request->input("tax_registration_number");
        $customer->tax_issue_date = $request->input("tax_issue_date");
        $customer->tax_expiry_date = $request->input("tax_expiry_date");

        if ($request->file('tax_registration_file')) {
            $tax_registration_file = $request->file('tax_registration_file');
            $filename = time() . '.' . $tax_registration_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $tax_registration_file->move($path, $filename);
            $customer->tax_registration_file = $filename;
        }

        $customer->kra_number = $request->input("kra_number");
        $customer->kra_issue_date = $request->input("kra_issue_date");
        $customer->kra_expiry_date = $request->input("kra_expiry_date");

        if ($request->file('kra_file')) {
            $kra_file = $request->file('kra_file');
            $filename = time() . '.' . $kra_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $kra_file->move($path, $filename);
            $customer->kra_file = $filename;
        }

        $customer->other_doc_number = $request->input("other_doc_number");
        $customer->other_doc_issue_date = $request->input("other_doc_issue_date");
        $customer->other_doc_expiry_date = $request->input("other_doc_expiry_date");

        if ($request->file('other_doc_file')) {
            $other_doc_file = $request->file('other_doc_file');
            $filename = time() . '.' . $other_doc_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $other_doc_file->move($path, $filename);
            $customer->other_doc_file = $filename;
        }

        $customer->save();
        
        $customer_id= $customer->id;
        
        $BankDetails = new BankDetails();
        $BankDetails->customer_id = $customer_id;
        $BankDetails->customer_type = "Corporate";
        $BankDetails->bank_name = $request->input("bank_name");
        $BankDetails->account_number = $request->input("account_number");
        $BankDetails->iban_number = $request->input("iban_number");
        $BankDetails->bank_code = $request->input("bank_code");
        $BankDetails->swift_code = $request->input("swift_code");
        $BankDetails->currency = $request->input("currency");
        $BankDetails->bank_branch = $request->input("bank_branch");
        $BankDetails->save();
        
        session()->flash('success', 'You\'ve created an Customer successfully.');
        return redirect()->route('customer.index');
        
        }
    }
    
    public function add_bank(Request $request)
    {

        $customer_id = $request->input("customer_id");
        
        $BankDetails = new BankDetails();
        $BankDetails->customer_id = $customer_id;
        $BankDetails->customer_type = "Corporate";
        $BankDetails->bank_name = $request->input("bank_name");
        $BankDetails->account_number = $request->input("account_number");
        $BankDetails->iban_number = $request->input("iban_number");
        $BankDetails->bank_code = $request->input("bank_code");
        $BankDetails->swift_code = $request->input("swift_code");
        $BankDetails->currency = $request->input("currency");
        $BankDetails->bank_branch = $request->input("bank_branch");
        $BankDetails->save();
            
         return redirect()->back()->with('success', 'Bank Added Successfully');

    }
    
    public function delete_bank($id)
    {
        $bank = BankDetails::find($id);
        $bank->delete();
        return redirect()->back()->with('success', 'Deleted Successfully');
    }

    public function show($id)
    {
        $cust = Customer::find($id);
        $banks = BankDetails::where('customer_id', $id)->where('customer_type', 'Corporate')->get();
        //dd($emp);
        return view('customer.edit', compact('cust', 'banks'));
    }


    public function edit($id)
    {
        $cust = Customer::find($id);
        $banks = BankDetails::where('customer_id', $id)->where('customer_type', 'Corporate')->get();
        //dd($emp);
        return view('customer.edit', compact('cust', 'banks'));
    }


    public function update($id, Request $request)
    {
        $customer = Customer::find($id);
        $customer->company_name = $request->input("company_name");
        $customer->display_name = $request->input("display_name");
        $customer->email = $request->input("email");
        $customer->phone = $request->input("phone");
        $customer->mobile = $request->input("mobile");
        $customer->other = $request->input("other");
        $customer->website = $request->input("website");
        $customer->registration_type = $request->input("registration_type");
        $customer->registration_number = $request->input("registration_number");
        $customer->contact_person_name = $request->input("contact_person_name");
        $customer->contact_person_number = $request->input("contact_person_number");
        $customer->billing_address_line_1 = $request->input("billing_address_line_1");
        $customer->billing_address_line_2 = $request->input("billing_address_line_2");
        $customer->billing_city_town = $request->input("billing_city_town");
        $customer->billing_state_province = $request->input("billing_state_province");
        $customer->billing_country = $request->input("billing_country");
        $customer->billing_pincode = $request->input("billing_pincode");

        $customer->office_address_line_1 = $request->input("office_address_line_1");
        $customer->office_address_line_2 = $request->input("office_address_line_2");
        $customer->office_city_town = $request->input("office_city_town");
        $customer->office_state_province = $request->input("office_state_province");
        $customer->office_country = $request->input("office_country");
        $customer->office_pincode = $request->input("office_pincode");

        $customer->payment_method = $request->input("payment_method");
        $customer->terms = $request->input("terms");
        $customer->credit_limit = $request->input("credit_limit");
        $customer->payment_currency = $request->input("payment_currency");

        $customer->bank_name = $request->input("bank_name");
        $customer->account_number = $request->input("account_number");
        $customer->iban_number = $request->input("iban_number");
        $customer->bank_code = $request->input("bank_code");
        $customer->swift_code = $request->input("swift_code");
        $customer->currency = $request->input("currency");
        $customer->bank_branch = $request->input("bank_branch");

        $customer->tax_registration_number = $request->input("tax_registration_number");
        $customer->tax_issue_date = $request->input("tax_issue_date");
        $customer->tax_expiry_date = $request->input("tax_expiry_date");

        if ($request->file('tax_registration_file')) {
            $tax_registration_file = $request->file('tax_registration_file');
            $filename = time() . '.' . $tax_registration_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $tax_registration_file->move($path, $filename);
            $customer->tax_registration_file = $filename;
        }

        $customer->kra_number = $request->input("kra_number");
        $customer->kra_issue_date = $request->input("kra_issue_date");
        $customer->kra_expiry_date = $request->input("kra_expiry_date");

        if ($request->file('kra_file')) {
            $kra_file = $request->file('kra_file');
            $filename = time() . '.' . $kra_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $kra_file->move($path, $filename);
            $customer->kra_file = $filename;
        }

        $customer->other_doc_number = $request->input("other_doc_number");
        $customer->other_doc_issue_date = $request->input("other_doc_issue_date");
        $customer->other_doc_expiry_date = $request->input("other_doc_expiry_date");

        if ($request->file('other_doc_file')) {
            $other_doc_file = $request->file('other_doc_file');
            $filename = time() . '.' . $other_doc_file->getClientOriginalExtension();
            $path = public_path('uploads');
            $other_doc_file->move($path, $filename);
            $customer->other_doc_file = $filename;
        }

        $customer->status = $request->input("status") ? "Active":"Inactive";

        $customer->save();
        session()->flash('success', 'You\'ve Updated Customer successfully.');
        return Redirect::back()->withErrors(['msg' => 'The Message']);
    }

    public function destroy($id)
    {
        $customer = Customer::find($id);
        $customer->delete();
        return Redirect::back()->withErrors(['msg' => 'The Message']);
    }
}
