<?php

namespace App\Http\Controllers\Creditnote;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\View;

use App\Models\Account\Account;
use App\Models\Transaction\Transaction;
use App\Models\DSR\DSR;
use App\Models\DSR\DsrHotelService;
use App\Models\DSR\DsrTourService;
use App\Models\DSR\DsrFlightService;
use App\Models\DSR\DsrVisaService;
use App\Models\DSR\DsrServicePassenger;
use App\Models\DSR\DsrInsuranceService;
use App\Models\DSR\DsrOtherService;
use App\Models\DSR\CarhireService;
use App\Models\DSR\AssistService;
use App\Models\Passengers\Passengers;
use App\Models\Hotel\Hotel;
use App\Models\Flight\Flight;
use App\Models\Visa\Visa;
use App\Models\Insurance\Insurance;
use App\Models\InsurancePlan\InsurancePlan;
use App\Models\Inventory\Inventory;
use App\Models\HotelService\HotelService;
use App\Models\TourPackage\TourPackage;
use App\Models\HotelServices\RoomBed;
use App\Models\HotelServices\RoomMeal;
use App\Models\Customer\Customer;
use App\Models\Taxmaster\Taxmaster;
use App\Models\Items\Items;
use App\Models\Invoice\Invoice;
use App\Models\Invoice\InvoiceServices;
use App\Models\Proforma\Proforma;
use App\Models\Assist\Assist;
use App\Models\Carhire\Carhire;
use App\Models\Proforma\ProformaServices;
use App\Models\Individual\IndividualCustome;
use Illuminate\Support\Facades\Redirect;

use App\Models\Creditnote\Creditnote;
use App\Models\Creditnote\Refund;


class CreditnoteController extends Controller
{
    public function index(Request $request)
    {
        $account = Account::all();
        $dsr = Creditnote::all();
        return view('creditnote.index', compact('dsr', 'account'));
    }

    public function refund(Request $request){
        
        $Refund = new Refund;
        $Refund->date = $request->input("date");
        $Refund->creditnote_id = $request->input("creditnote_id");
        $Refund->reference = $request->input("reference");        
        $Refund->amount = $request->input("amount");
        $Refund->payment_mode = $request->input("payment_mode");
        $Refund->paid_through = $request->input("paid_through");
        $Refund->description = $request->input("description");
        $Refund->save();
        
        $maxDsrNumber = Transaction::max('transaction_id');
        $lastDsrNumber = (int) substr($maxDsrNumber, -6);
        $newDsrNumber = $lastDsrNumber + 1;
        $paddedDsrNumber = str_pad($newDsrNumber, 6, '0', STR_PAD_LEFT);
        $series = 'Txn';
        $txn_id = $series . '-' . $paddedDsrNumber;
        
        $amount = $request->input("amount");
        $account_id= $request->input("paid_through");
        $date= $request->input("date");

        $account = Account::find($account_id);
        $balance= $account->balance;
        $balance= $balance-$amount;
        $account->balance = $balance;
        $account->save();
        
        $transaction = new Transaction;
        $transaction->transaction_id =$txn_id;
        $transaction->date = $date;
        $transaction->account_id = $account_id;
        $transaction->transaction_type = 'Refund Payment';
        $transaction->credit = $amount;
        $transaction->save();
        
        session()->flash('success', 'Refund created successfully.');
        return redirect()->route('Creditnote');
        
    }


    public function store(Request $request)
    {
          // Get the current maximum order number from the database
        $maxDsrNumber = Creditnote::max('creditnote_id');

        // Parse the Dsr number to get the numeric part
        $lastDsrNumber = (int) substr($maxDsrNumber, -7);

        // Increment the Dsr number
        $newDsrNumber = $lastDsrNumber + 1;

        // Pad the Dsr number with leading zeros to get the final Dsr number
        $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);

        // Build the final Dsr ID with the series
        $series = 'CN';
        $dsr_number = $series . '-' . $paddedDsrNumber;

        $type=$request->input("customer_type");
        if ($type=="Corporate") {
            $customer_id = $request->input("corporate_id");
            $customer_name = $request->input("select_company_name");

        }
        elseif ($type=="Individual") {
            $customer_id = $request->input("individual_id");
            $customer_name = $request->input("select_individual_name");
        }
        elseif ($type=="New") {
            $customer_id = 0;
            $customer_name = $request->input("customer_name");
            $email = $request->input("email");
            $phone = $request->input("mobile");
            $address = $request->input("address");

            
        }

        $Quotation = new Creditnote;

        if ($request->file('quotation_file')) {
            $photo = $request->file('quotation_file');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $Quotation->file = $filename;
        }

        $Quotation->customer_type = $request->input("customer_type");
        // $Quotation->customer_name = $customer_name;
        $Quotation->Creditnote_id = $dsr_number;
        $Quotation->date = date('Y-m-d');
        $Quotation->invoice_id = $request->input("invoice_id");
        $Quotation->customer_name = $request->input("customer_name");
        $Quotation->customer_id = $request->input("customer_id");
        $Quotation->customer_type = $request->input("customer_type");
        $Quotation->reference_no = $request->input("reference_no");
        $Quotation->customer_note = $request->input("customer_note");
        $Quotation->terms = $request->input("terms");
        $Quotation->subtotal = $request->input("subtotal");
        $Quotation->shipping_charge = $request->input("shipping_charge");
        $Quotation->adjustment_charge = $request->input("adjustment_charge");
        $Quotation->total = $request->input("quotation_total");
        $Quotation->save();

        $quantity = $request->input("quantity");

        foreach($quantity as $key => $value) {
            $Items = new Items();
            $Items->quotation_id = $dsr_number;
            $Items->item_details = $request->input("item_details")[$key];
            $Items->quantity = $request->input("quantity")[$key];
            $Items->rate = $request->input("rate")[$key];
            $Items->discount = $request->input("discount")[$key];
            $Items->tax_rate = $request->input("tax_rate")[$key];
            $Items->tax_amount = $request->input("tax_amount")[$key];
            $Items->descripency_notes = $request->input("item_descripency")[$key];
            $Items->total = $request->input("total")[$key];

            // $Items->rate = $request->input("rate");
            $Items->save();
         } 

        session()->flash('success', 'You\'ve Created Credit Note successfully.');
        return redirect()->route('Creditnote');
                

    }

    public function Create()
    {
          // Get the current maximum order number from the database
          $maxDsrNumber = Creditnote::max('creditnote_id');

          // Parse the Dsr number to get the numeric part
          $lastDsrNumber = (int) substr($maxDsrNumber, -7);
  
          // Increment the Dsr number
          $newDsrNumber = $lastDsrNumber + 1;
  
          // Pad the Dsr number with leading zeros to get the final Dsr number
          $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);
  
          // Build the final Dsr ID with the series
          $series = 'QTN';
          $id = $series . '-' . $paddedDsrNumber;



        $corporate = Customer::where('approval', '=', 1)->select('*')->get();
        $cdata = Customer::where('approval', '=', 1)->get();
        $individual = IndividualCustome::where('approval', '=', 1)->get();
        $idata = IndividualCustome::where('approval', '=', 1)->get();

        

        $individual = IndividualCustome::where('approval', '=', 1)->select('*')->get();
        $corporate = Customer::where('approval', 1)->get();
        $passengers = Passengers::all();
        $hotels = Hotel::all();
        $tour = TourPackage::all();
        $room = HotelService::all();
        $flight = Flight::all();
        $visa = Visa::all();
        $insurance = Insurance::all();
        $carhire = Carhire::all();
        $assist = Assist::all();
        $insuranceplan = InsurancePlan::all();
        $other = Inventory::all();
        $taxmaster = Taxmaster::all();
        $bed = RoomBed::all();
        $meal = RoomMeal::all();
        $invoice = Invoice::all();


        $services['hotel'] = InvoiceServices::all();
        $services['flight'] = DsrFlightService::where('dsr_number', $id)->get();
        $services['visa'] = DsrVisaService::where('dsr_number', $id)->get();
        $services['insurance'] = DsrInsuranceService::where('dsr_number', $id)->get();
        $services['other'] = DsrOtherService::where('dsr_number', $id)->get();
        //dd($emp);
        return view('creditnote.create', compact('id','invoice','cdata','idata','services','corporate','tour','bed','meal','room','taxmaster','individual','passengers','hotels', 'flight', 'visa', 'insurance', 'insuranceplan', 'other', 'carhire', 'assist'));
    }

    public function Createn($id)
    {
        
                $invoice = Invoice::where('invoice_no', $id)->first();
                $invoice_id =$invoice->customer_id;


        $corporate = Customer::where('approval', '=', 1)->select('*')->get();
        $cdata = Customer::where('approval', '=', 1)->get();
        $individual = IndividualCustome::where('approval', '=', 1)->get();
        $idata = IndividualCustome::where('approval', '=', 1)->get();

        

        $individual = IndividualCustome::where('approval', '=', 1)->select('*')->get();
        $corporate = Customer::where('approval', 1)->get();
        $passengers = Passengers::all();
        $hotels = Hotel::all();
        $tour = TourPackage::all();
        $room = HotelService::all();
        $flight = Flight::all();
        $visa = Visa::all();
        $insurance = Insurance::all();
        $carhire = Carhire::all();
        $assist = Assist::all();
        $insuranceplan = InsurancePlan::all();
        $other = Inventory::all();
        $taxmaster = Taxmaster::all();
        $bed = RoomBed::all();
        $meal = RoomMeal::all();


        $services['hotel'] = InvoiceServices::where('invoice_id', $id)->get();
        $services['flight'] = DsrFlightService::where('dsr_number', $id)->get();
        $services['visa'] = DsrVisaService::where('dsr_number', $id)->get();
        $services['insurance'] = DsrInsuranceService::where('dsr_number', $id)->get();
        $services['other'] = DsrOtherService::where('dsr_number', $id)->get();
        //dd($emp);
        return view('creditnote.createn', compact('id','invoice','cdata','idata','services','corporate','tour','bed','meal','room','taxmaster','individual','passengers','hotels', 'flight', 'visa', 'insurance', 'insuranceplan', 'other', 'carhire', 'assist'));
    }

}
