<?php

namespace App\Http\Controllers\Bills;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\View;

use App\Models\DSR\DSR;
use App\Models\DSR\DsrHotelService;
use App\Models\DSR\DsrTourService;
use App\Models\DSR\DsrFlightService;
use App\Models\DSR\DsrVisaService;
use App\Models\DSR\DsrServicePassenger;
use App\Models\DSR\DsrInsuranceService;
use App\Models\DSR\DsrOtherService;
use App\Models\DSR\CarhireService;
use App\Models\DSR\AssistService;
use App\Models\Passengers\Passengers;
use App\Models\Hotel\Hotel;
use App\Models\Flight\Flight;
use App\Models\Visa\Visa;
use App\Models\Insurance\Insurance;
use App\Models\InsurancePlan\InsurancePlan;
use App\Models\Inventory\Inventory;
use App\Models\HotelService\HotelService;
use App\Models\TourPackage\TourPackage;
use App\Models\HotelServices\RoomBed;
use App\Models\HotelServices\RoomMeal;
use App\Models\Customer\Customer;
use App\Models\Taxmaster\Taxmaster;
use App\Models\Items\Items;
use App\Models\Invoice\Invoice;
use App\Models\Invoice\InvoiceServices;
use App\Models\Proforma\Proforma;
use App\Models\Assist\Assist;
use App\Models\Carhire\Carhire;
use App\Models\Proforma\ProformaServices;
use App\Models\Individual\IndividualCustome;
use App\Models\Supplier\Supplier;
use Illuminate\Support\Facades\Redirect;

use App\Models\Debitnote\Debitnote;
use App\Models\Bills\Bills;

class BillsController extends Controller
{
    public function index(Request $request)
    {
        $dsr = Bills::all();
        return view('bills.index', compact('dsr'));
    }

    public function create(Request $request)
    {
                 session()->forget('cart');

        $maxDsrNumber = Bills::max('bill_id');
        $lastDsrNumber = (int) substr($maxDsrNumber, -7);
        $newDsrNumber = $lastDsrNumber + 1;
        $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);

        // Build the final Dsr ID with the series
        $series = 'Bill';
        $bill_number = $series . '-' . $paddedDsrNumber;
        
        $id="";
        $taxmaster= Taxmaster::all();
        $other= Taxmaster::all();
        $supplier= Supplier::all();
        $dsr = Debitnote::all();

        $individual = IndividualCustome::where('approval', '=', 1)->select('*')->get();
        $corporate = Customer::where('approval', 1)->get();
        $passengers = Passengers::all();
        $hotels = Hotel::all();
        $tour = TourPackage::all();
        $room = HotelService::all();
        $flight = Flight::all();
        $visa = Visa::all();
        $insurance = Insurance::all();
        $carhire = Carhire::all();
        $assist = Assist::all();
        $insuranceplan = InsurancePlan::all();
        $other = Inventory::all();
        $taxmaster = Taxmaster::all();
        $bed = RoomBed::all();
        $meal = RoomMeal::all();
        $invoice = Invoice::all();

        return view('bills.create', compact('id', 'bill_number','dsr','supplier','invoice','corporate','tour','bed','meal','room','taxmaster','individual','passengers','hotels', 'flight', 'visa', 'insurance', 'insuranceplan', 'other', 'carhire', 'assist'));
    }

    public function store(Request $request)
    {
        $maxDsrNumber = Bills::max('bill_id');
        $lastDsrNumber = (int) substr($maxDsrNumber, -7);
        $newDsrNumber = $lastDsrNumber + 1;
        $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);

        // Build the final Dsr ID with the series
        $series = 'Bill';
        $dsr_number = $series . '-' . $paddedDsrNumber;

    $Bills = new Bills;

        if ($request->file('bills_file')) {
            $photo = $request->file('bills_file');
            $filename = time() . '.' . $photo->getClientOriginalExtension();
            $path = public_path('uploads');
            $photo->move($path, $filename);
            $Bills->file = $filename;
        }

        $Bills->supplier = $request->input("supplier");
        $Bills->bill_id = $dsr_number;
        $Bills->date = $request->input("date");
        $Bills->order_no = $request->input("order_no");
        $Bills->due_date = $request->input("due_date");
        $Bills->notes = $request->input("customer_note");
        $Bills->subtotal = $request->input("subtotal");
        $Bills->discount = $request->input("discount");
        $Bills->adjustment_charge = $request->input("adjustment_charge");
        $Bills->total = $request->input("bills_total");
        $Bills->save();

        // $quantity = $request->input("quantity");

        // foreach($quantity as $key => $value) {
        //     $Items = new Items();
        //     $Items->quotation_id = $dsr_number;
        //     $Items->item_details = $request->input("item_details")[$key];
        //     $Items->quantity = $request->input("quantity")[$key];
        //     $Items->rate = $request->input("rate")[$key];
        //     $Items->total = $request->input("total")[$key];

        //     // $Items->rate = $request->input("rate");
        //     $Items->save();
        //  } 

        session()->flash('success', 'You\'ve Created Bill successfully.');
        return redirect()->route('Bills'); 
        // return $request;               

    }
}
