<?php

namespace App\Http\Controllers\Approvals;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Customer\Customer;
use App\Models\DSR\DSR;
use App\Models\Invoice\Invoice;
use App\Models\Invoice\InvoiceServices;
use App\Models\Proforma\Proforma;
use App\Models\Grn\Grn;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\DB;

class ApprovalController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $customer = Customer::orderBy('id', 'DESC')->get();
        return view('approval.index', compact('customer'));
    }

    public function invoice(Request $request)
    {
        $customer = Invoice::where('status', 0)->get();
        return view('approval.invoice', compact('customer'));
    }

    public function grn()
    {
        $grn = Grn::where('approval_status', 0)->get();
        return view('approval.grn', compact('grn'));
    }

    public function proforma(Request $request)
    {
        $customer = Proforma::where('status', 0)->get();
        return view('approval.proforma', compact('customer'));
    }


    function status_update($id)
    {
        //get product status with the help of product ID
        $customer = Customer::select('approval')
            ->where('id', '=', $id)
            ->first();

            //dd($customer);

        //Check user status
        if ($customer->approval == '1') {
            $status = '0';
        } else {
            $status = '1';
        }

        //update product status
        $values = array('approval' => $status);
        //dd($values);
        Customer::where('id',$id)->update($values);

        session()->flash('msg', 'Product status has been updated successfully.');
        return Redirect::back();
    }

    function invoice_approval($id)
    {

        $maxDsrNumber = Invoice::max('invoice_id');
        $lastDsrNumber = (int) substr($maxDsrNumber, -6);
        $newDsrNumber = $lastDsrNumber + 1;
        $paddedDsrNumber = str_pad($newDsrNumber, 6, '0', STR_PAD_LEFT);
        $series = 'NI';
        $invoice_id = $series . '-' . $paddedDsrNumber;

        //get product status with the help of product ID
        $customer = Invoice::select('status')
            ->where('id', '=', $id)
            ->first();

            //dd($customer);

        //Check user status
        if ($customer->status == '1') {
            $status = '0';
        } else {
            $status = '1';
        }

        //update product status
        $values = array('status' => $status, 'invoice_id' => $invoice_id);
        //dd($values);
        Invoice::where('id',$id)->update($values);

        session()->flash('msg', 'Product status has been updated successfully.');
        return Redirect::back();
    }
    
        function invoice_reject($id){
            
       $invoice = Invoice::find($id);
       $invoice_no = $invoice->invoice_no;
       $type_id = $invoice->type_id;
       
       $dsr =DSR::where('dsr_number', $type_id)->first();
       $dsr->invoice_status = 0;
       $dsr->save();

       
       $invoiceServices = InvoiceServices::where('invoice_id', $invoice_no)->get();

foreach ($invoiceServices as $invoiceService) {
    $invoiceService->delete();
}

       
       $invoice = Invoice::find($id);
       $invoice->delete();
       
       
       
       
       return Redirect::back();
       

            
        }


    function grn_approval($id)
    {

        $maxDsrNumber = Grn::max('grn_id');
        $lastDsrNumber = (int) substr($maxDsrNumber, -7);
        $newDsrNumber = $lastDsrNumber + 1;
        $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);
        $series = 'GRN';
        $grn_id = $series . '-' . $paddedDsrNumber;

        //get product status with the help of product ID
        $customer = Grn::select('approval_status')
            ->where('id', '=', $id)
            ->first();

            //dd($customer);

        //Check user status
        if ($customer->status == '1') {
            $status = '0';
        } else {
            $status = '1';
        }

        //update product status
        $values = array('approval_status' => $status, 'grn_id' => $grn_id);
        //dd($values);
        Grn::where('id',$id)->update($values);

        session()->flash('msg', 'Grn has been approved successfully.');
        return Redirect::back();
    }

    function proforma_approval($id)
    {

        $maxDsrNumber = Proforma::max('proforma_id');
        $lastDsrNumber = (int) substr($maxDsrNumber, -7);
        $newDsrNumber = $lastDsrNumber + 1;
        $paddedDsrNumber = str_pad($newDsrNumber, 7, '0', STR_PAD_LEFT);
        $series = 'PFM';
        $proforma_id = $series . '-' . $paddedDsrNumber;

        //get product status with the help of product ID
        $customer = Proforma::select('status')
            ->where('id', '=', $id)
            ->first();

            //dd($customer);

        //Check user status
        if ($customer->status == '1') {
            $status = '0';
        } else {
            $status = '1';
        }

        //update product status
        $values = array('status' => $status, 'proforma_id' => $proforma_id);
        //dd($values);
        Proforma::where('id',$id)->update($values);

        session()->flash('msg', 'Product status has been updated successfully.');
        return Redirect::back();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function show()
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function edit()
    {
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroy()
    {
    }
}
