<?php

namespace App\Http\Controllers\Employee;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Employee\Employee;
use App\Models\Employee\EmployeeMedical;
use App\Models\address\Address;
use App\Models\BankDetail\BankDetail;
use App\Models\Document\Document;
use App\Models\Medical_history\Medical_history;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Storage;



class EmployeeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $udata = Employee::orderBy('id', 'DESC')->get();
        return view('Employee.table', compact('udata'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $jsonData = Storage::disk('public')->get('country_code.json');
        $data = json_decode($jsonData, true);

        return view('Employee.create', ['data' => $data]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function checkmailexists(Request $request){

        if($request->input('from')=="create"){
            $udata = Employee::orderBy('id', 'DESC')->where('email','=',$request->input("email"))->count();
        }
        else{
            // edit
            $udata = Employee::orderBy('id', 'DESC')->where('email','=',$request->input("email"))->where('id','!=',$request->input("id"))->count();
        }
        if($udata>0){
            return "false";
        }
        else{
            return "true";
        }   
    }
    public function store(Request $request)
    {
        $udata = Employee::orderBy('id', 'DESC')->where('email','=',$request->input("email"))->count();
        if($udata>0){
            session()->flash('error', 'Already registered with this mail.');
            return Redirect::back();
        }
        else{
        

            $emp = new Employee;
            $emp->first_name = $request->input("first_name");
            $emp->last_name = $request->input("last_name");
            $emp->email = $request->input("email");
            $emp->dob = $request->input("dob");
            $emp->gender = $request->input("gender");
            $emp->country_code = $request->input("country_code");
            $emp->mobile_number = $request->input("mobile_number");
            $emp->emergency_contact_number = $request->input("emergency_contact_number");
            $emp->doj = $request->input("doj");
            $emp->designation = $request->input("designation");
            $emp->blood_group = $request->input("blood_group");

            $emp->address_line_1 = $request->input("address_1");
            $emp->address_line_2 = $request->input("address_2");
            $emp->city_town = $request->input("city_town");
            $emp->state_province = $request->input("state_province");
            $emp->country = $request->input("country");
            $emp->pincode = $request->input("pincode");
            $emp->address_type = $request->input("address_type");

            $emp->bank_name = $request->input("bank_name");
            $emp->account_number = $request->input("account_number");
            $emp->iban_number = $request->input("iban_number");
            $emp->bank_code = $request->input("bank_code");
            $emp->swift_code = $request->input("swift_code");
            $emp->currency = $request->input("currency");
            $emp->bank_branch = $request->input("bank_branch");

            $emp->passport_number = $request->input("passport_number");
            $emp->passport_issue_date = $request->input("passport_issue_date");
            $emp->passport_expiry_date = $request->input("passport_expiry_date");

            if ($request->file('passport')) {
                $passport = $request->file('passport');
                $filename = time() . '.' . $passport->getClientOriginalExtension();
                $path = public_path('uploads');
                $passport->move($path, $filename);
                $emp->passport = $filename;
            }

            $emp->goverment_id_number = $request->input("goverment_id_number");
            $emp->goverment_issue_date = $request->input("goverment_issue_date");
            $emp->goverment_expiry_date = $request->input("goverment_expiry_date");

            $emp->driving_licence = $request->input("driving_licence");
            $emp->driving_issue_date = $request->input("driving_issue_date");
            $emp->driving_expiry_date = $request->input("driving_expiry_date");

            $emp->contract = $request->input("contract_note");
            $emp->contract_start_date = $request->input("contract_start_date");
            $emp->contract_expiry_date = $request->input("contract_expiry_date");

            $emp->company_name = $request->input("company_name");
            $emp->policy_number = $request->input("policy_number");
            $emp->insurance_issue_date = $request->input("insurance_issue_date");
            $emp->insurance_expiry_date = $request->input("insurance_expiry_date");

            if ($request->file('government_id')) {
                $government_ID = $request->file('government_id');
                $filename = time() . '.' . $government_ID->getClientOriginalExtension();
                $path = public_path('uploads');
                $government_ID->move($path, $filename);
                $emp->government_ID = $filename;
            }

            if ($request->file('resume')) {
                $resume = $request->file('resume');
                $filename = time() . '.' . $resume->getClientOriginalExtension();
                $path = public_path('uploads');
                $resume->move($path, $filename);
                $emp->resume = $filename;
            }

            if ($request->file('appraisal_file')) {
                $appraisal = $request->file('appraisal_file');
                $filename = time() . '.' . $appraisal->getClientOriginalExtension();
                $path = public_path('uploads');
                $appraisal->move($path, $filename);
                $emp->appraisal_file = $filename;
            }

            if ($request->file('contract_file')) {
                $contract = $request->file('contract_file');
                $filename = time() . '.' . $contract->getClientOriginalExtension();
                $path = public_path('uploads');
                $contract->move($path, $filename);
                $emp->contract_file = $filename;
            }

            if ($request->file('driving_file')) {
                $driving = $request->file('driving_file');
                $filename = time() . '.' . $driving->getClientOriginalExtension();
                $path = public_path('uploads');
                $driving->move($path, $filename);
                $emp->driving_file = $filename;
            }

            if ($request->file('insurance_file')) {
                $insurance = $request->file('insurance_file');
                $filename = time() . '.' . $insurance->getClientOriginalExtension();
                $path = public_path('uploads');
                $insurance->move($path, $filename);
                $emp->insurance_file = $filename;
            }

            $emp->other_document_name = $request->input("other_document_name");

            if ($request->file('other_documents')) {
                $other_documents = $request->file('other_documents');
                $filename = time() . '.' . $other_documents->getClientOriginalExtension();
                $path = public_path('uploads');
                $other_documents->move($path, $filename);
                $emp->other_documents = $filename;
            }

            
            $emp->document_type = $request->input("document_type");

            // $emp->medical_history = $request->input("medical_history_text");

            $emp->status = $request->input("status == Active") ? "Active":"Inactive";
            
            $emp->save();

            


            session()->flash('success', 'You\'ve created an employee successfully.');
            return redirect()->route('employee.index');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $data=[];
        $emp = Employee::find($id);
        //dd($emp);
        return view('Employee.view', compact('emp', 'data'));
    }

    public function downloadFIle($id)
{
    $image = EmployeeMedical::findOrFail($id);
$pathToFile = public_path('uploads/' . $image->file);

if ($image->file!='') {
    return response()->download($pathToFile);
} else {
    session()->flash('success', 'File does not exist.');
    return redirect()->back();
}



    // $pathToFile = storage_path('app/public/documents/document.pdf');
    // $headers = [
    //     'Content-Type' => 'application/pdf',
    // ];
    // return response()->download($pathToFile, 'document.pdf', $headers);
}


    public function addMedical(Request $request)
    {
        
        $emp_medical = new EmployeeMedical;
        $emp_medical->employee_id = $request->input("employee_id");
        $emp_medical->date = $request->input("date");
        $emp_medical->type = $request->input("type");
        $emp_medical->history = $request->input("medical");

        if ($request->file('attachment')) {
            $insurance = $request->file('attachment');
            $filename = time() . '.' . $insurance->getClientOriginalExtension();
            $path = public_path('uploads');
            $insurance->move($path, $filename);
            $emp_medical->file = $filename;
        }
        $emp_medical->save();

        session()->flash('success', 'You\'ve added entry successfully.');
        return Redirect::back()->withErrors(['msg' => 'The Message']);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $jsonData = Storage::disk('public')->get('country_code.json');
        $data = json_decode($jsonData, true);

        $emp = Employee::find($id);
        $medical = EmployeeMedical::where('employee_id', $id)->get();
        //dd($emp);
        return view('Employee.edit', compact('emp', 'medical', 'data'));
    }

    /**
     * Update the specified resource in storage.
     *s
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function update($id, Request $request)
    {
        $udata = Employee::orderBy('id', 'DESC')->where('email','=',$request->input("email"))->where('id','!=',$id)->count();
    
        if($udata>0){
            session()->flash('errror', 'Already registered with this mail.');
            return Redirect::back();
        }
        
        $emp = Employee::find($id);
        $emp->first_name = $request->input("first_name");
        $emp->last_name = $request->input("last_name");
        $emp->email = $request->input("email");
        $emp->dob = $request->input("dob");
        $emp->gender = $request->input("gender");
        $emp->country_code = $request->input("country_code");
        $emp->mobile_number = $request->input("mobile_number");
        $emp->emergency_contact_number = $request->input("emergency_contact_number");
        $emp->doj = $request->input("doj");
        $emp->designation = $request->input("designation");
        $emp->blood_group = $request->input("blood_group");

        $emp->address_line_1 = $request->input("address_1");
        $emp->address_line_2 = $request->input("address_2");
        $emp->city_town = $request->input("city_town");
        $emp->state_province = $request->input("state_province");
        $emp->country = $request->input("country");
        $emp->pincode = $request->input("pincode");
        $emp->address_type = $request->input("address_type");

        $emp->bank_name = $request->input("bank_name");
        $emp->account_number = $request->input("account_number");
        $emp->iban_number = $request->input("iban_number");
        $emp->bank_code = $request->input("bank_code");
        $emp->swift_code = $request->input("swift_code");
        $emp->currency = $request->input("currency");
        $emp->bank_branch = $request->input("bank_branch");

        $emp->passport_number = $request->input("passport_number");
        $emp->passport_issue_date = $request->input("passport_issue_date");
        $emp->passport_expiry_date = $request->input("passport_expiry_date");

        if ($request->file('passport')) {
            $passport = $request->file('passport');
            $filename = time() . '.' . $passport->getClientOriginalExtension();
            $path = public_path('uploads');
            $passport->move($path, $filename);
            $emp->passport = $filename;
        }

        $emp->goverment_id_number = $request->input("goverment_id_number");
        $emp->goverment_issue_date = $request->input("goverment_issue_date");
        $emp->goverment_expiry_date = $request->input("goverment_expiry_date");

        $emp->driving_licence = $request->input("driving_licence");
        $emp->driving_issue_date = $request->input("driving_issue_date");
        $emp->driving_expiry_date = $request->input("driving_expiry_date");

        $emp->contract = $request->input("contract_note");
        $emp->contract_start_date = $request->input("contract_start_date");
        $emp->contract_expiry_date = $request->input("contract_expiry_date");

        $emp->company_name = $request->input("company_name");
        $emp->policy_number = $request->input("policy_number");
        $emp->insurance_issue_date = $request->input("insurance_issue_date");
        $emp->insurance_expiry_date = $request->input("insurance_expiry_date");

        if ($request->file('government_id')) {
            $government_ID = $request->file('government_id');
            $filename = time() . '.' . $government_ID->getClientOriginalExtension();
            $path = public_path('uploads');
            $government_ID->move($path, $filename);
            $emp->government_ID = $filename;
        }

        if ($request->file('resume')) {
            $resume = $request->file('resume');
            $filename = time() . '.' . $resume->getClientOriginalExtension();
            $path = public_path('uploads');
            $resume->move($path, $filename);
            $emp->resume = $filename;
        }

        if ($request->file('appraisal_file')) {
            $appraisal = $request->file('appraisal_file');
            $filename = time() . '.' . $appraisal->getClientOriginalExtension();
            $path = public_path('uploads');
            $appraisal->move($path, $filename);
            $emp->appraisal_file = $filename;
        }

        if ($request->file('contract_file')) {
            $contract = $request->file('contract_file');
            $filename = time() . '.' . $contract->getClientOriginalExtension();
            $path = public_path('uploads');
            $contract->move($path, $filename);
            $emp->contract_file = $filename;
        }

        if ($request->file('driving_file')) {
            $driving = $request->file('driving_file');
            $filename = time() . '.' . $driving->getClientOriginalExtension();
            $path = public_path('uploads');
            $driving->move($path, $filename);
            $emp->driving_file = $filename;
        }

        if ($request->file('insurance_file')) {
            $insurance = $request->file('insurance_file');
            $filename = time() . '.' . $insurance->getClientOriginalExtension();
            $path = public_path('uploads');
            $insurance->move($path, $filename);
            $emp->insurance_file = $filename;
        }

        $emp->other_document_name = $request->input("other_document_name");

        if ($request->file('other_documents')) {
            $other_documents = $request->file('other_documents');
            $filename = time() . '.' . $other_documents->getClientOriginalExtension();
            $path = public_path('uploads');
            $other_documents->move($path, $filename);
            $emp->other_documents = $filename;
        }

        $emp->document_type = $request->input("document_type");

        $emp->medical_history = $request->input("medical_history_text");

        $emp->status = $request->input("status") ? "Active":"Inactive";

        // dd($request->all());

        $emp->save();
        session()->flash('success', 'Employee updated successfully.');
        return Redirect::back()->withErrors(['msg' => 'The Message']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $emp = Employee::find($id);
        $emp->delete();
        return Redirect::back()->withErrors(['msg' => 'The Message']);
    }

    public function destroyEntry($id)
    {
        $emp = EmployeeMedical::find($id);
        $emp->delete();
        return Redirect::back()->withErrors(['msg' => 'The Message']);
    }
}
